/************************************************************************
* Copyright (C) 2004
* Dynamo Middleware Groupc
*
* version 0.8
*
* Authors: Michael Philpott, Shivajit Mohapatra
************************************************************************/
#ifndef _NETWORK_H_
#define _NETWORK_H_

struct dynamo_network 
{
	int connected;
	int wireless;
	int link;
	int signal;
};

/***
* Returns 1 if the device is connected to the network or returns a 0 if 
* there is no network present
**/ 
extern int get_net_is_connected();

/***
* Returns 1 if the device is connected to a wireless network or returns a 0 if 
* there is no wireless network present
*
* need to test when the card is in but not connected
**/ 
extern int get_net_is_wireless();

/***
* Returns the link quality of the wireless network if nothing is present returns
* a -1
**/ 
extern int get_net_link_quality();

/***
* Returns the signal quality of the wireless network if nothing is present returns
* a -1
**/ 
extern int get_net_sig_strength();

extern int get_network_info(struct dynamo_network* network);

#endif //NETWORK

