# extracted from ImageMac.py by Trocca Riccardo (rtrocca@libero.it)
#
# calling sequence (from showImage(), same file):
#
#	imw=ImageMacWin(im.size,title)
#	imw.open()
#	try:
#		imw.Show(im )
#	except MemoryError:
#		imw.close()
#		print "ImageMac.showImage: Insufficient Memory"

from PixMapWrapper import *
import Image
import W
import Carbon.Qd

class ImageMacWin(W.Window):
	
	def __init__(self,size=(300,300),title="ImageMacWin"):
		self.pm=PixMapWrapper()
		self.empty=1
		self.size=size
		W.Window.__init__(self,size,title)
	
	def Show(self,image,resize=0):
		#print "format: ", image.format," size: ",image.size," mode: ",image.mode
		#print "string len :",len(image.tostring())
		self.pm.fromImage(image)
		self.empty=0
		if resize:
			self.size=(image.size[0]*resize,image.size[1]*resize)
			W.Window.do_resize(self,self.size[0],self.size[1],self.wid)
		self.do_drawing()
	
	def do_drawing(self):
		#print "do_drawing"
		self.SetPort()
		Carbon.Qd.RGBForeColor( (0,0,0) )
		Carbon.Qd.RGBBackColor((65535, 65535, 65535))
		Carbon.Qd.EraseRect((0,0,self.size[0],self.size[1]))
		if not self.empty:
			#print "should blit"
			self.pm.blit(0,0,self.size[0],self.size[1])
		
	def do_update(self,macoswindowid,event):
		#print "update"
		self.do_drawing()
