# webimg - convert folder of digicam images to web site
# David Eppstein, UC Irvine, June 2001
#
# class ImageData - collect information about image and make HTML

from os import path
import macfs, time
from abbrevNum import *

class ImagePage:
	
	def __cmp__(self,other):
		diff = self.cdate - other.cdate
		if diff < 0: return -1
		elif diff > 0: return 1
		else: return 0
	
	def makePage(self,outdir,prev,next,up):
		fn = path.join(outdir,self.filename+".html")
		f = open(fn,"w")
		f.write('''<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 3.2//EN">
<html><head>
<title>''')
		f.write(self.title)
		f.write('''</title>
</head>
<body bgcolor="#ffffff" text="#000000">
<div align=center>
<table width="95%" cellspacing=5>
<tr><td align=left width="30%"><a href="''')
		f.write(prev.filename)
		f.write('.html">Prev: ')
		f.write(prev.title)
		f.write('''</a></td>
<td align=center width="30%"><a href="index.html">Up: ''')
		f.write(up)
		f.write('''</a></td>
<td align=right width="30%"><a href="''')
		f.write(next.filename)
		f.write('.html">Next: ')
		f.write(next.title)
		f.write('''</a></td>
</tr></table>
<h2>''')
		f.write(self.title)
		f.write('''</h2>
<img src="''')
		f.write(self.filename)
		f.write('-m.jpg" width=%d height=%d' % self.msize)
		f.write('''
alt="''')
		f.write(self.title)
		f.write('''"><br><br>
''')
		f.write(self.caption)
		f.write('''
<h5>''')
		if self.datetimeorig:
			f.write("Taken ")
		else:
			f.write("File created ")
		f.write(time.strftime("%A, %B %d, %Y, %I:%M:%S%p",\
				time.localtime(self.cdate)))
		f.write('.&nbsp; Original image size: %dx%d' % self.lsize)
		f.write(', ' + abbreviateNumber(self.nbytes,k=1024) + 'b')
		f.write('''<br>
Technical details: ''')
		f.write(self.tech)
		f.write('''</h5>
</div></body></html>
''')
		f.close()
		macfs.FSSpec(fn).SetCreatorType("udog","TEXT")
