# webimg - convert folder of digicam images to web site
# David Eppstein, UC Irvine, June 2001
#
# class ImageProcessor - GUI for collecting image titles/captions and resizing jpegs

import Image, ImageFilter, W, string, macfs
import ImageMacWin
from dircache import listdir
import os.path, sys
import ImagePage, IndexPage, EXIF
from htmlEntities import htmlEntityEncode

class ImageProcessor:

	DLOG_WIDTH = 400
	DLOG_HEIGHT = 300
	WIN_SEP = 50
	BUTTON_HEIGHT = 25

	# target perimeter (not max dimen or anything else) of images
	IMAGE_SIZE = 2240
	PREVIEW_SIZE = 1400
	THUMB_SIZE = 700
	
	JPEG_Q = 85
	
	def __init__(self, srcfolder, destfolder):
		self.dest = destfolder
		self.src = srcfolder
		if not os.path.isdir(srcfolder):
			self.im = Image.open(srcfolder)
			self.fullpath = srcfolder
			self.file = srcfolder
			ext = string.rfind(self.file,'.')
			if ext >= 0:
				self.file = self.file[:ext]	# strip file extension
			self.processImage()
			self.im.save(os.path.join(self.dest,self.file+"-m.jpg"),quality=self.JPEG_Q)
			self.tim.save(os.path.join(self.dest,self.file+"-s.jpg"),quality=self.JPEG_Q)
			sys.exit(0)

		s = map(lambda x, self=self: (self.getcreation(x),x),
			listdir(srcfolder))
		s.sort()
		self.files = map(lambda x: x[1], s)
		self.infs = []
		self.makeDlog()
		self.nextfile()
		
	def getcreation(self,file):
		return macfs.FSSpec(os.path.join(self.src,file)).GetDates()[0]
		
	def nextfile(self):
		try:
			self.imw.close()
		except AttributeError:
			pass

		W.SetCursor("watch")
		while len(self.files) > 0:
			self.file = self.files.pop(0)
			fn = os.path.join(self.src,self.file)
			try:
				self.im = Image.open(fn)
				self.fsize = os.path.getsize(fn)
			except:
				continue

			self.fullpath = fn
			self.cdate = self.getcreation(self.file)
			ext = string.rfind(self.file,'.')
			if ext >= 0:
				self.file = self.file[:ext]	# strip file extension
			self.processImage()
			self.redisplay()
			self.clearDlog()
			W.SetCursor("arrow")
			return

		# here after processing all files, list of info in self.infs
		self.im = self.sim = self.tim = None
		self.w.close()
		self.w = self.imw = None
		W.SetCursor("arrow")
		IndexPage.IndexPage(self.dest, self.infs)
		
	def ok(self):
		self.im.save(os.path.join(self.dest,self.file+"-m.jpg"),quality=self.JPEG_Q)
		self.tim.save(os.path.join(self.dest,self.file+"-s.jpg"),quality=self.JPEG_Q)

		i = ImagePage.ImagePage()
		i.filename = self.file
		i.cdate = self.cdate
		i.title = self.w.imtitle.get()
		if len(i.title) == 0:
			i.title = self.file
		else:
			i.title = htmlEntityEncode(unicode(i.title,'mac_roman'))
		i.caption = htmlEntityEncode(unicode(self.w.notes.get(),'mac_roman'))
		i.lsize = self.origsize
		i.msize = self.im.size
		i.tsize = self.tim.size
		i.nbytes = self.fsize
		i.tech = "None available"
		
		f = open(self.fullpath)
		EXIF.process_file(f,i)
		f.close()
		
		self.infs.append(i)
		self.nextfile()
	
	def makeDlog(self):
		w = W.Dialog((self.DLOG_WIDTH,self.DLOG_HEIGHT),"webimg")
		w.imtlab = W.TextBox((20,23,40,20),text="Title:")
		w.imtitle = W.EditText((70,20,self.DLOG_WIDTH-90,20))
		w.notlab = W.TextBox((20,50,100,20),text="Notes:")
		w.notes = W.EditText((20,70,self.DLOG_WIDTH-40,\
					self.DLOG_HEIGHT-self.BUTTON_HEIGHT-110))
		w.cw = W.Button((20,self.DLOG_HEIGHT-20-self.BUTTON_HEIGHT,95,self.BUTTON_HEIGHT),\
				 "Turn Clockwise", self.clockwise)
		w.ccw = W.Button((135,self.DLOG_HEIGHT-20-self.BUTTON_HEIGHT,140,self.BUTTON_HEIGHT),\
				 "Turn Counterclockwise", self.counterclockwise)
		w.skip = W.Button((295,self.DLOG_HEIGHT-20-self.BUTTON_HEIGHT,35,self.BUTTON_HEIGHT),\
				 "Skip", self.nextfile)
		w.ok = W.Button((350,self.DLOG_HEIGHT-20-self.BUTTON_HEIGHT,30,self.BUTTON_HEIGHT),\
				 "OK", self.ok)
		w.open()
		w.move(self.WIN_SEP,self.WIN_SEP)
		self.w = w
		
	def clearDlog(self):
		self.w.imtitle.set("")
		self.w.notes.set("")

	def redisplay(self):
		try:
			self.imw.settitle(self.file)
			self.imw.Show(self.sim,1)
			self.w.select()		# dlog should always be frontmost
		except AttributeError:
			self.imw = ImageMacWin.ImageMacWin((self.DLOG_WIDTH+2*self.WIN_SEP,\
						self.WIN_SEP,0,0), self.file)
			self.imw.open()
			self.redisplay()

	def transpose(self,rot):
		self.im = self.im.transpose(rot)
		self.sim = self.sim.transpose(rot)
		self.tim = self.tim.transpose(rot)
		self.origsize = (self.origsize[1],self.origsize[0])
		self.redisplay()

	def clockwise(self):
		self.transpose(Image.ROTATE_270)

	def counterclockwise(self):
		self.transpose(Image.ROTATE_90)

	def computeSize(self,targetPerim):
		currentSize = self.origsize
		currentPerim = 2*(currentSize[0]+currentSize[1])
		return ((targetPerim*currentSize[0])/currentPerim,
			(targetPerim*currentSize[1])/currentPerim)
		
	def processImage(self):
		self.origsize = self.im.size
		self.im = self.im.filter(ImageFilter.SMOOTH)
		self.sim = self.im.resize(self.computeSize(self.PREVIEW_SIZE),
					Image.BICUBIC)
		self.tim = self.sim.filter(ImageFilter.SMOOTH).resize(
					 self.computeSize(self.THUMB_SIZE),
					Image.BICUBIC)
		self.im = self.im.resize(self.computeSize(self.IMAGE_SIZE),
					Image.BICUBIC)
