# webimg - convert folder of digicam images to web site
# David Eppstein, UC Irvine, June 2001
#
# class IndexPage -- collect links between individual image pages

import time, W, macfs, sys
from os import path
from htmlEntities import htmlEntityEncode

class ConversionComplete:
	pass

class IndexPage:
	def __init__(self, outdir, infs):
		if len(infs) == 0:
			W.getapplication()._quit()
			return
		self.infs = infs
		self.infs.sort()
		self.dest = outdir
		
		w = W.Dialog((400,170),"webimg")
		w.tlab = W.TextBox((20,23,90,20),text="Index title:")
		w.idxtitle = W.EditText((100,20,280,20))
		w.npix = W.TextBox((20,50,360,20),\
		    text="%d pictures indexed" % len(infs))
		w.adate = W.TextBox((20,70,360,20),\
		    text="Earliest creation date: " + \
			time.ctime(infs[0].cdate))
		w.wdate = W.TextBox((20,90,360,20),\
		    text="Latest creation date: " + \
			time.ctime(infs[-1].cdate))
		w.ok = W.Button((150,120,100,30),\
				 "OK", self.ok)
		w.open()
		self.w = w
	
	def makeTable(self,f,pix,maxwid):
		if len(pix) != self.tableWidth:
			# different number of columns, have to start new table
			if (self.tableWidth > 0):
				f.write('''</table>
''')
			self.tableWidth = len(pix)
			f.write('''<table border=0 cellpadding=10>
''')
		f.write('''<tr align=center valign=middle>
''')
		for pic in pix:
			put_thumb(f,pic,maxwid)
		f.write('''</tr>
''')
	
	def ok(self):
		tit = self.w.idxtitle.get()
		if len(tit) == 0:
			tit = "Index"
		else:
			tit = htmlEntityEncode(unicode(tit,'mac_roman'))

		for i in range(len(self.infs)):
			self.infs[i].makePage(self.dest,self.infs[i-1],\
			    self.infs[(i+1)%len(self.infs)], tit)
		self.w.close()
		self.w = None

		fn = path.join(self.dest,"index.html")
		f = open(fn,"w")
		f.write('''<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 3.2//EN">
<html>
<head><title>''')
		f.write(tit)
		f.write('''</title></head>
<body bgcolor="#ffffff" text="#000000">
<div align=center>
<table width="95%" cellspacing=5>
<tr><td align=left width="30%"><!-- prev: goes here --></td>
<td align=center width="30%"><a href="../">Up: Picture Index</a></td>
<td align=right width="30%"><!-- next: goes here --></td>
</tr></table>
<h1>''')
		f.write(tit)
		f.write('''</h1>
Click on any picture for a larger copy.
''')
		pix = self.infs
		maxwid = max([pic.tsize[0] for pic in pix])
		self.tableWidth = 0
		if len(pix) % 3 == 1:
			self.makeTable(f,pix[:2],maxwid)
			pix = pix[2:]
		while len(pix) > 0:
			self.makeTable(f,pix[:3],maxwid)
			pix = pix[3:]
			
		f.write('''</table>
</div></body></html>
''')
		f.close()
		macfs.FSSpec(fn).SetCreatorType("udog","TEXT")
		W.getapplication()._quit()

def put_thumb(f,pic,maxwid):
	f.write('<td width=%d align=center><a href="' % maxwid)
	f.write(pic.filename)
	f.write('''.html"><img
src="''')
	f.write(pic.filename)
	f.write('''-s.jpg" border=0 width=%d height=%d
alt="''' % pic.tsize)
	f.write(pic.title)
	f.write('''"></a></td>
''')
