import W, Wapplication, FrameWork, macfs, sys
import ImageProcessor, os.path

class MyApp(Wapplication.Application):
        MyCreatorType = '@WmG'	# Creator type of this application
        MyDocumentTypes = []	# List of up to four document types recognised
        preffilepath = ""	# Location of prefs in Preferences Folder

 
        def __init__(self):
                # Standard initialisation.
                Wapplication.Application.__init__(self, self.MyCreatorType)
                
                # All applications should handle these Apple Events,
                #  but you'll need an aete resource.
                import Carbon.AE, Carbon.AppleEvents
                Carbon.AE.AEInstallEventHandler(Carbon.AppleEvents.kCoreEventClass, Carbon.AppleEvents.kAEOpenApplication, 
                                self.ignoreevent)       # We're already open
                Carbon.AE.AEInstallEventHandler(Carbon.AppleEvents.kCoreEventClass, Carbon.AppleEvents.kAEPrintDocuments, 
                                self.ignoreevent)       # No printing in this app
                Carbon.AE.AEInstallEventHandler(Carbon.AppleEvents.kCoreEventClass, Carbon.AppleEvents.kAEOpenDocuments, 
                                self.ignoreevent)
                Carbon.AE.AEInstallEventHandler(Carbon.AppleEvents.kCoreEventClass, Carbon.AppleEvents.kAEQuitApplication, 
                                self.quitevent)

		# set up targets and make initial windows
		if len(sys.argv) > 1:
			srcname = sys.argv[1]
			gotsrc = 1
		else:
			srcspec,gotsrc = macfs.GetDirectory("Select the folder containing images to be converted")
			if gotsrc: srcname = srcspec.as_pathname()
		if not gotsrc: sys.exit(0)
		if not os.path.isdir(srcname):
			destname = os.path.basename(srcname)
		else:
			destspec,gotdest = macfs.GetDirectory("Select the folder where webimg should put its output files")
			if not gotdest: sys.exit(0)
			destname = destspec.as_pathname()
		ImageProcessor.ImageProcessor(srcname, destname)

                # Process some events!
		self.mainloop()

        def makeusermenus(self):
                m = Wapplication.Menu(self.menubar, "File")
                closeitem = FrameWork.MenuItem(m, "Close", "W", 'close')
                quititem = FrameWork.MenuItem(m, "Quit", "Q", 'quit')
		m = Wapplication.Menu(self.menubar, "Edit")
		undoitem = FrameWork.MenuItem(m, "Undo", 'Z', "undo")
                cutitem = FrameWork.MenuItem(m, "Cut", 'X', "cut")
                copyitem = FrameWork.MenuItem(m, "Copy", "C", "copy")
                pasteitem = FrameWork.MenuItem(m, "Paste", "V", "paste")
                clearitem = FrameWork.MenuItem(m, "Clear", None,  "clear")
                selallitem = FrameWork.MenuItem(m, "Select all", "A", "selectall")
                self._menustocheck = [closeitem, undoitem, cutitem, copyitem,
					pasteitem, clearitem, selallitem]

        def checkopenwindowsmenu(self):
                pass

        def ignoreevent(self, theAppleEvent, theReply):
                pass
        
        def quitevent(self, theAppleEvent, theReply):
                import AE
                AE.AEInteractWithUser(50000000)
                self._quit()

        def do_about(self, id, item, window, event):
                pass

        def domenu_open(self, *args):
		pass

        def domenu_new(self, *args):
		pass

        def domenu_quit(self):
                self._quit()

        # Utility routines; the real work starts here
        def opendoc(self, path):
		pass

# Run the app
MyApp()
