/*****************************************************************\
*                                                                *
*  Copyright (C) Regents of University of California, 2003       *
*  This source code is a part of EXPRESSION project and is       *
*  copyrighted by the Regents of the University of California,   *
*  Irvine.                                                       *
*  The authors hereby grant permission to use this description   *
*  and its documentation for educational and non-commercial      *
*  purpose under the BSD license                                 *
*  (http://www.cecs.uci.edu/~express/BSD_License.txt). 	         *
*  The source code comes with no warranty and no author or       *
*  distributor accepts any responsibility for the consequences   *
*  of its use. Permission is granted to distribute this file in  *
*  compiled or executable form under the same conditions that    *
*  apply for source code. Permission is granted	to anyone to     *
*  make or distribute copies of this source code, either as      *
*  received or modified, in any medium, provided that all        *
*  copyright notices, permission and non warranty notices are    *
*  preserved, and that the distributor grants the recipient      *
*  permission for further redistribution as permitted by this    *
*  document. No written agreement, license, or royalty fee is    *
*  required for authorized use of this software.                 *
*                                                                *
*******************************************************************/
//: MetaMCNode.h
//
// File:  		DoubleMCNode.h
// Created:		Thu Feb 22, 2001
// Author:		Radu Cornea
// Email:		radu@ics.uci.edu, ilp@ics.uci.edu
//
// This special meta node is used to hold more normal nodes that 
// that are to be allocated to same registers
// Meta nodes are generated by the register coalescing phase
// 

#ifndef __METAMCNODE__
#define __METAMCNODE__

#include "MCNode.h"
#include "MultiChain.h"

class MetaMCNode : public MCNode {
	MyLinkedList<MultiChain *> _mcList;


public:
	MetaMCNode(MCNode *mcNode) {
		addMCNode(mcNode);
	}
	
	MetaMCNode() {}

	~MetaMCNode() {
	}

	// move the contents of mcNode and the adjacency list to current node
	void addMCNode(MCNode *mcNode) {

		if (mcNode->isMetaMCNode()) {
			
			MyLinkedListIterator<MultiChain *> *mcListIter = ((MetaMCNode *)mcNode)->getMCList().elementsForward();
			while (mcListIter->hasMoreElements()) {
				MultiChain *mc = mcListIter->currentElement();
				
				_mcList.add(mc);
				
				mcListIter->nextElement();
			}
			delete mcListIter;
			
		} else {
			MultiChain *mc = mcNode->getMC();
			_mcList.add(mc);
		}

		MyLinkedListIterator<IGNode *> *mcNodeAdjListIter = mcNode->getAdjNodeList().elementsForward();
		while (mcNodeAdjListIter->hasMoreElements()) {
			IGNode *node = mcNodeAdjListIter->currentElement();

			node->removeAdjNode(mcNode);
			node->addAdjNode(this);
			_adjNodeList.add(node);

			mcNodeAdjListIter->nextElement();
		}
		delete mcNodeAdjListIter;
	}

	MyLinkedList<MultiChain *>& getMCList() { return _mcList; }

	virtual bool isMetaMCNode() { return true; }

	MultiChain * getMC() {
		ASSERT_TRACE(0, "Called getMC() in MetaMCNode");
		return NULL;
	}

	double computeSpillCost() {
		// may have to account for simulaneous double value saves/reloads
		double cost = 0;

		MyLinkedListIterator<MultiChain *> *mcListIter = _mcList.elementsForward();
		while (mcListIter->hasMoreElements()) {
			MultiChain *mc = mcListIter->currentElement();

			cost += mc->getSpillCost();

			mcListIter->nextElement();
		}
		delete mcListIter;

		cost = cost / getNoOfAdjNodes();

		return cost;
	}

	void print(ostream& out);
};




#endif	// __METAMCNODE__