/*****************************************************************\
*                                                                *
*  Copyright (C) Regents of University of California, 2003       *
*  This source code is a part of EXPRESSION project and is       *
*  copyrighted by the Regents of the University of California,   *
*  Irvine.                                                       *
*  The authors hereby grant permission to use this description   *
*  and its documentation for educational and non-commercial      *
*  purpose under the BSD license                                 *
*  (http://www.cecs.uci.edu/~express/BSD_License.txt). 	         *
*  The source code comes with no warranty and no author or       *
*  distributor accepts any responsibility for the consequences   *
*  of its use. Permission is granted to distribute this file in  *
*  compiled or executable form under the same conditions that    *
*  apply for source code. Permission is granted	to anyone to     *
*  make or distribute copies of this source code, either as      *
*  received or modified, in any medium, provided that all        *
*  copyright notices, permission and non warranty notices are    *
*  preserved, and that the distributor grants the recipient      *
*  permission for further redistribution as permitted by this    *
*  document. No written agreement, license, or royalty fee is    *
*  required for authorized use of this software.                 *
*                                                                *
*******************************************************************/
#include "stdafx.h"

#include <assert.h>

#ifndef WIN32
#include <stdio.h>
#include <stdlib.h>
#endif

#define MY_TRACE

#include "TreeBuilding.h"


//START: MFC DEBUG NEW: THIS MUST BE AFTER ALL THE #INCLUDES IN A FILE
#ifdef WIN32
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif
#endif
//END MFC DEBUG NEW: 


static void burm_trace(NODEPTR_TYPE p, int eruleno, int cost, int bestcost) {
#ifdef MY_TRACE
	extern char *burm_string[];

	fprintf(stderr, "0x%p matched %s with cost %d vs. %d\n", p,
		burm_string[eruleno], cost, bestcost);
#endif
}
#include <limits.h>
#include <stdlib.h>
#ifndef STATE_TYPE
#define STATE_TYPE int
#endif
#ifndef ALLOC
#define ALLOC(n) malloc(n)
#endif
#ifndef isel_assert
#define isel_assert(x,y) if (!(x)) { y; abort(); }
#endif

#define isel_def_NT 1
#define isel_reg_NT 2
#define isel_expr_NT 3
#define isel_const_NT 4
#define isel_float_const_NT 5
#define isel_const_label_NT 6
#define isel_rf1_NT 7
#define isel_rf2_NT 8
#define isel_rf3_NT 9
int isel_max_nt = 9;

char *isel_ntname[] = {
	0,
	"def",
	"reg",
	"expr",
	"const",
	"float_const",
	"const_label",
	"rf1",
	"rf2",
	"rf3",
	0
};

struct isel_state {
	int op;
	struct isel_state *left, *right;
	short cost[10];
	struct {
		unsigned isel_def:3;
		unsigned isel_reg:2;
		unsigned isel_expr:8;
		unsigned isel_const:1;
		unsigned isel_float_const:1;
		unsigned isel_const_label:2;
		unsigned isel_rf1:4;
		unsigned isel_rf2:4;
		unsigned isel_rf3:7;
	} rule;
};

static short isel_nts_0[] = { isel_reg_NT, isel_expr_NT, 0 };
static short isel_nts_1[] = { isel_reg_NT, 0 };
static short isel_nts_2[] = { isel_const_NT, 0 };
static short isel_nts_3[] = { 0 };
static short isel_nts_4[] = { isel_def_NT, isel_def_NT, 0 };
static short isel_nts_5[] = { isel_def_NT, 0 };
static short isel_nts_6[] = { isel_def_NT, isel_const_NT, 0 };
static short isel_nts_7[] = { isel_const_label_NT, 0 };
static short isel_nts_8[] = { isel_float_const_NT, 0 };
static short isel_nts_9[] = { isel_const_label_NT, isel_def_NT, 0 };
static short isel_nts_10[] = { isel_rf1_NT, 0 };
static short isel_nts_11[] = { isel_rf2_NT, 0 };
static short isel_nts_12[] = { isel_rf3_NT, 0 };

short *isel_nts[] = {
	0,	/* 0 */
	isel_nts_0,	/* 1 */
	isel_nts_1,	/* 2 */
	isel_nts_2,	/* 3 */
	isel_nts_3,	/* 4 */
	isel_nts_4,	/* 5 */
	isel_nts_4,	/* 6 */
	isel_nts_4,	/* 7 */
	isel_nts_4,	/* 8 */
	isel_nts_5,	/* 9 */
	isel_nts_6,	/* 10 */
	isel_nts_6,	/* 11 */
	isel_nts_4,	/* 12 */
	isel_nts_4,	/* 13 */
	isel_nts_4,	/* 14 */
	isel_nts_7,	/* 15 */
	isel_nts_5,	/* 16 */
	isel_nts_4,	/* 17 */
	isel_nts_4,	/* 18 */
	isel_nts_4,	/* 19 */
	isel_nts_4,	/* 20 */
	isel_nts_5,	/* 21 */
	isel_nts_5,	/* 22 */
	isel_nts_5,	/* 23 */
	isel_nts_7,	/* 24 */
	isel_nts_5,	/* 25 */
	isel_nts_5,	/* 26 */
	isel_nts_4,	/* 27 */
	isel_nts_5,	/* 28 */
	isel_nts_4,	/* 29 */
	isel_nts_4,	/* 30 */
	isel_nts_4,	/* 31 */
	isel_nts_4,	/* 32 */
	isel_nts_5,	/* 33 */
	isel_nts_5,	/* 34 */
	isel_nts_5,	/* 35 */
	isel_nts_4,	/* 36 */
	isel_nts_4,	/* 37 */
	isel_nts_4,	/* 38 */
	isel_nts_4,	/* 39 */
	isel_nts_4,	/* 40 */
	isel_nts_4,	/* 41 */
	isel_nts_4,	/* 42 */
	isel_nts_4,	/* 43 */
	isel_nts_4,	/* 44 */
	isel_nts_4,	/* 45 */
	isel_nts_2,	/* 46 */
	isel_nts_4,	/* 47 */
	isel_nts_4,	/* 48 */
	isel_nts_4,	/* 49 */
	isel_nts_4,	/* 50 */
	isel_nts_7,	/* 51 */
	isel_nts_8,	/* 52 */
	isel_nts_5,	/* 53 */
	isel_nts_4,	/* 54 */
	isel_nts_5,	/* 55 */
	isel_nts_5,	/* 56 */
	isel_nts_8,	/* 57 */
	isel_nts_4,	/* 58 */
	isel_nts_6,	/* 59 */
	isel_nts_6,	/* 60 */
	isel_nts_4,	/* 61 */
	isel_nts_4,	/* 62 */
	isel_nts_5,	/* 63 */
	isel_nts_4,	/* 64 */
	isel_nts_4,	/* 65 */
	isel_nts_4,	/* 66 */
	isel_nts_4,	/* 67 */
	isel_nts_4,	/* 68 */
	isel_nts_4,	/* 69 */
	isel_nts_4,	/* 70 */
	isel_nts_4,	/* 71 */
	isel_nts_4,	/* 72 */
	isel_nts_4,	/* 73 */
	isel_nts_4,	/* 74 */
	isel_nts_4,	/* 75 */
	isel_nts_4,	/* 76 */
	isel_nts_5,	/* 77 */
	isel_nts_4,	/* 78 */
	isel_nts_4,	/* 79 */
	isel_nts_9,	/* 80 */
	isel_nts_9,	/* 81 */
	0,	/* 82 */
	0,	/* 83 */
	0,	/* 84 */
	0,	/* 85 */
	0,	/* 86 */
	0,	/* 87 */
	0,	/* 88 */
	0,	/* 89 */
	0,	/* 90 */
	0,	/* 91 */
	0,	/* 92 */
	0,	/* 93 */
	0,	/* 94 */
	0,	/* 95 */
	0,	/* 96 */
	0,	/* 97 */
	0,	/* 98 */
	0,	/* 99 */
	0,	/* 100 */
	0,	/* 101 */
	0,	/* 102 */
	0,	/* 103 */
	0,	/* 104 */
	0,	/* 105 */
	0,	/* 106 */
	0,	/* 107 */
	0,	/* 108 */
	0,	/* 109 */
	0,	/* 110 */
	0,	/* 111 */
	0,	/* 112 */
	isel_nts_8,	/* 113 */
	isel_nts_10,	/* 114 */
	isel_nts_11,	/* 115 */
	isel_nts_3,	/* 116 */
	isel_nts_3,	/* 117 */
	isel_nts_3,	/* 118 */
	isel_nts_3,	/* 119 */
	isel_nts_3,	/* 120 */
	isel_nts_3,	/* 121 */
	isel_nts_3,	/* 122 */
	isel_nts_3,	/* 123 */
	isel_nts_3,	/* 124 */
	isel_nts_3,	/* 125 */
	isel_nts_3,	/* 126 */
	isel_nts_3,	/* 127 */
	isel_nts_3,	/* 128 */
	isel_nts_3,	/* 129 */
	isel_nts_3,	/* 130 */
	isel_nts_3,	/* 131 */
	isel_nts_3,	/* 132 */
	isel_nts_3,	/* 133 */
	isel_nts_3,	/* 134 */
	isel_nts_3,	/* 135 */
	isel_nts_3,	/* 136 */
	isel_nts_3,	/* 137 */
	isel_nts_3,	/* 138 */
	isel_nts_3,	/* 139 */
	isel_nts_3,	/* 140 */
	isel_nts_3,	/* 141 */
	isel_nts_12,	/* 142 */
	isel_nts_3,	/* 143 */
	isel_nts_3,	/* 144 */
	isel_nts_3,	/* 145 */
	isel_nts_3,	/* 146 */
	isel_nts_3,	/* 147 */
	isel_nts_3,	/* 148 */
	isel_nts_3,	/* 149 */
	isel_nts_3,	/* 150 */
	isel_nts_3,	/* 151 */
	isel_nts_3,	/* 152 */
	isel_nts_3,	/* 153 */
	isel_nts_3,	/* 154 */
	isel_nts_3,	/* 155 */
	isel_nts_3,	/* 156 */
	isel_nts_3,	/* 157 */
	isel_nts_3,	/* 158 */
	isel_nts_3,	/* 159 */
	isel_nts_3,	/* 160 */
	isel_nts_3,	/* 161 */
	isel_nts_3,	/* 162 */
	isel_nts_3,	/* 163 */
	isel_nts_3,	/* 164 */
	isel_nts_3,	/* 165 */
	isel_nts_3,	/* 166 */
	isel_nts_3,	/* 167 */
	isel_nts_3,	/* 168 */
	isel_nts_3,	/* 169 */
	isel_nts_3,	/* 170 */
	isel_nts_3,	/* 171 */
	isel_nts_3,	/* 172 */
	isel_nts_3,	/* 173 */
	isel_nts_3,	/* 174 */
	isel_nts_3,	/* 175 */
	isel_nts_3,	/* 176 */
	isel_nts_3,	/* 177 */
	isel_nts_3,	/* 178 */
	isel_nts_3,	/* 179 */
	isel_nts_3,	/* 180 */
	isel_nts_3,	/* 181 */
	isel_nts_3,	/* 182 */
	isel_nts_3,	/* 183 */
	isel_nts_3,	/* 184 */
	isel_nts_3,	/* 185 */
	isel_nts_3,	/* 186 */
	isel_nts_3,	/* 187 */
	isel_nts_3,	/* 188 */
	isel_nts_3,	/* 189 */
	isel_nts_3,	/* 190 */
	isel_nts_3,	/* 191 */
	isel_nts_3,	/* 192 */
	isel_nts_3,	/* 193 */
	isel_nts_3,	/* 194 */
	isel_nts_3,	/* 195 */
	isel_nts_3,	/* 196 */
	isel_nts_2,	/* 197 */
	isel_nts_3,	/* 198 */
	isel_nts_3,	/* 199 */
	isel_nts_4,	/* 200 */
	isel_nts_4,	/* 201 */
	isel_nts_4,	/* 202 */
	isel_nts_4,	/* 203 */
	isel_nts_5,	/* 204 */
	isel_nts_4,	/* 205 */
	isel_nts_4,	/* 206 */
	isel_nts_4,	/* 207 */
	isel_nts_4,	/* 208 */
	isel_nts_4,	/* 209 */
	isel_nts_5,	/* 210 */
	isel_nts_4,	/* 211 */
	isel_nts_4,	/* 212 */
	isel_nts_4,	/* 213 */
	isel_nts_4,	/* 214 */
	isel_nts_5,	/* 215 */
	isel_nts_5,	/* 216 */
	isel_nts_5,	/* 217 */
	isel_nts_5,	/* 218 */
	isel_nts_4,	/* 219 */
	isel_nts_5,	/* 220 */
	isel_nts_5,	/* 221 */
	isel_nts_4,	/* 222 */
	isel_nts_4,	/* 223 */
	isel_nts_4,	/* 224 */
	isel_nts_4,	/* 225 */
	isel_nts_4,	/* 226 */
	isel_nts_4,	/* 227 */
	isel_nts_4,	/* 228 */
	isel_nts_4,	/* 229 */
	isel_nts_5,	/* 230 */
	isel_nts_5,	/* 231 */
	isel_nts_5,	/* 232 */
	isel_nts_5,	/* 233 */
	isel_nts_5,	/* 234 */
	isel_nts_4,	/* 235 */
	isel_nts_4,	/* 236 */
	isel_nts_5,	/* 237 */
	isel_nts_5,	/* 238 */
	isel_nts_5,	/* 239 */
	isel_nts_4,	/* 240 */
	isel_nts_4,	/* 241 */
	isel_nts_4,	/* 242 */
	isel_nts_4,	/* 243 */
	isel_nts_5,	/* 244 */
	isel_nts_4,	/* 245 */
	isel_nts_4,	/* 246 */
	isel_nts_4,	/* 247 */
	isel_nts_4,	/* 248 */
	isel_nts_5,	/* 249 */
	isel_nts_4,	/* 250 */
	isel_nts_4,	/* 251 */
	isel_nts_4,	/* 252 */
	isel_nts_4,	/* 253 */
	isel_nts_4,	/* 254 */
	isel_nts_4,	/* 255 */
	isel_nts_4,	/* 256 */
	isel_nts_4,	/* 257 */
	isel_nts_4,	/* 258 */
	isel_nts_4,	/* 259 */
	isel_nts_4,	/* 260 */
	isel_nts_4,	/* 261 */
	isel_nts_4,	/* 262 */
	isel_nts_5,	/* 263 */
	isel_nts_4,	/* 264 */
	isel_nts_4,	/* 265 */
	isel_nts_5,	/* 266 */
	isel_nts_4,	/* 267 */
	isel_nts_4,	/* 268 */
	isel_nts_4,	/* 269 */
	isel_nts_4,	/* 270 */
	0,	/* 271 */
	0,	/* 272 */
	0,	/* 273 */
	0,	/* 274 */
	0,	/* 275 */
	0,	/* 276 */
	0,	/* 277 */
	0,	/* 278 */
	0,	/* 279 */
	0,	/* 280 */
	0,	/* 281 */
	0,	/* 282 */
	0,	/* 283 */
	0,	/* 284 */
	0,	/* 285 */
	0,	/* 286 */
	0,	/* 287 */
	0,	/* 288 */
	0,	/* 289 */
	0,	/* 290 */
	0,	/* 291 */
	0,	/* 292 */
	0,	/* 293 */
	0,	/* 294 */
	0,	/* 295 */
	0,	/* 296 */
	0,	/* 297 */
	0,	/* 298 */
	0,	/* 299 */
	isel_nts_8,	/* 300 */
	isel_nts_3,	/* 301 */
};

char isel_arity[] = {
	0,	/* 0 */
	2,	/* 1=IADD */
	2,	/* 2=IGE */
	2,	/* 3=IGT */
	2,	/* 4=ILE */
	2,	/* 5=IASH */
	2,	/* 6=ISUB */
	2,	/* 7=ILSH */
	2,	/* 8=ILT */
	0,	/* 9=NOP */
	1,	/* 10=ICONSTANT */
	1,	/* 11=IASSIGN */
	0,	/* 12=IF */
	0,	/* 13=IGOTO */
	2,	/* 14=IVLOAD */
	2,	/* 15=DVLOAD */
	2,	/* 16=IVSTORE */
	2,	/* 17=DVSTORE */
	1,	/* 18=ASSIGN */
	1,	/* 19=DCONSTANT */
	2,	/* 20=DADD */
	1,	/* 21=FASSIGN */
	2,	/* 22=DMUL */
	2,	/* 23=DSUB */
	1,	/* 24=DMTC1 */
	0,	/* 25=GOTO */
	1,	/* 26=TRUNCID */
	1,	/* 27=MFC1 */
	1,	/* 28=MTC1 */
	1,	/* 29=CVTDI */
	2,	/* 30=ILAND */
	1,	/* 31=DASSIGN */
	2,	/* 32=DGE */
	2,	/* 33=DLT */
	2,	/* 34=DLE */
	2,	/* 35=DGT */
	1,	/* 36=CVTSD */
	1,	/* 37=CVTDS */
	1,	/* 38=DMFC1 */
	2,	/* 39=DDIV */
	2,	/* 40=DEQ */
	2,	/* 41=FADD */
	2,	/* 42=FSUB */
	2,	/* 43=FMUL */
	2,	/* 44=FDIV */
	2,	/* 45=FVLOAD */
	2,	/* 46=FVSTORE */
	0,	/* 47=CALL */
	0,	/* 48=RETURN */
	2,	/* 49=IRASH */
	2,	/* 50=ILASH */
	2,	/* 51=IRLSH */
	2,	/* 52=ILLSH */
	1,	/* 53=FCONSTANT */
	2,	/* 54=INE */
	1,	/* 55=CVTSI */
	1,	/* 56=TRUNCIS */
	0,	/* 57 */
	2,	/* 58=IEQ */
	2,	/* 59=IOR */
	2,	/* 60=IAND */
	2,	/* 61=IXOR */
	2,	/* 62=IMUL */
	1,	/* 63=MFLO */
	2,	/* 64=QIVLOADU */
	2,	/* 65=QIVLOAD */
	2,	/* 66=QIVSTORE */
	2,	/* 67=QIVSTOREU */
	2,	/* 68=HIVLOADU */
	2,	/* 69=HIVLOAD */
	2,	/* 70=HIVSTORE */
	2,	/* 71=HIVSTOREU */
	2,	/* 72=IGEU */
	2,	/* 73=IGTU */
	2,	/* 74=ILEU */
	2,	/* 75=ILTU */
	2,	/* 76=IDIV */
	1,	/* 77=MFHI */
	0,	/* 78 */
	0,	/* 79 */
	0,	/* 80 */
	0,	/* 81 */
	0,	/* 82 */
	0,	/* 83 */
	0,	/* 84 */
	0,	/* 85 */
	0,	/* 86 */
	0,	/* 87 */
	0,	/* 88 */
	0,	/* 89 */
	0,	/* 90 */
	0,	/* 91 */
	0,	/* 92 */
	0,	/* 93 */
	0,	/* 94 */
	0,	/* 95 */
	0,	/* 96 */
	0,	/* 97 */
	0,	/* 98 */
	0,	/* 99 */
	0,	/* 100 */
	0,	/* 101=R0 */
	0,	/* 102=R1 */
	0,	/* 103=R2 */
	0,	/* 104=R3 */
	0,	/* 105=R4 */
	0,	/* 106=R5 */
	0,	/* 107=R6 */
	0,	/* 108=R7 */
	0,	/* 109=R8 */
	0,	/* 110=R9 */
	0,	/* 111=R10 */
	0,	/* 112=R11 */
	0,	/* 113=R12 */
	0,	/* 114=R13 */
	0,	/* 115=R14 */
	0,	/* 116=R15 */
	0,	/* 117=R16 */
	0,	/* 118=R17 */
	0,	/* 119=R18 */
	0,	/* 120=R19 */
	0,	/* 121=R20 */
	0,	/* 122=R21 */
	0,	/* 123=R22 */
	0,	/* 124=R23 */
	0,	/* 125=R24 */
	0,	/* 126=R25 */
	0,	/* 127=sp0 */
	0,	/* 128=cc0 */
	0,	/* 129=f0 */
	0,	/* 130=f1 */
	0,	/* 131=f2 */
	0,	/* 132=f3 */
	0,	/* 133=f4 */
	0,	/* 134=f5 */
	0,	/* 135=f6 */
	0,	/* 136=f7 */
	0,	/* 137=f8 */
	0,	/* 138=f9 */
	0,	/* 139=f10 */
	0,	/* 140=f11 */
	0,	/* 141=f12 */
	0,	/* 142=f13 */
	0,	/* 143=f14 */
	0,	/* 144=f15 */
	0,	/* 145=f16 */
	0,	/* 146=f17 */
	0,	/* 147=f18 */
	0,	/* 148=f19 */
	0,	/* 149=f20 */
	0,	/* 150=f21 */
	0,	/* 151=f22 */
	0,	/* 152=f23 */
	0,	/* 153=f24 */
	0,	/* 154=f25 */
	0,	/* 155=f26 */
	0,	/* 156=f27 */
	0,	/* 157=f28 */
	0,	/* 158=f29 */
	0,	/* 159=f30 */
	0,	/* 160=f31 */
	0,	/* 161=fp0 */
	0,	/* 162=temp0 */
	0,	/* 163=temp1 */
	0,	/* 164=temp2 */
	0,	/* 165=temp3 */
	0,	/* 166=temp4 */
	0,	/* 167=temp5 */
	0,	/* 168=temp6 */
	0,	/* 169=temp7 */
	0,	/* 170=temp8 */
	0,	/* 171=temp9 */
	0,	/* 172=temp10 */
	0,	/* 173=R26 */
	0,	/* 174=R27 */
	0,	/* 175=R28 */
	0,	/* 176=R29 */
	0,	/* 177=R30 */
	0,	/* 178=R31 */
	0,	/* 179=isel_label */
	0,	/* 180=hilo0 */
	0,	/* 181 */
	0,	/* 182 */
	0,	/* 183 */
	0,	/* 184 */
	0,	/* 185 */
	0,	/* 186 */
	0,	/* 187 */
	0,	/* 188 */
	0,	/* 189 */
	0,	/* 190 */
	0,	/* 191 */
	0,	/* 192 */
	0,	/* 193 */
	0,	/* 194 */
	0,	/* 195 */
	0,	/* 196 */
	0,	/* 197 */
	0,	/* 198 */
	0,	/* 199 */
	0,	/* 200 */
	2,	/* 201=DEF */
	0,	/* 202=INT */
	0,	/* 203=IND */
	0,	/* 204=SRC2 */
	0,	/* 205=FLOAT */
	0,	/* 206 */
	0,	/* 207 */
	0,	/* 208 */
	0,	/* 209 */
	0,	/* 210 */
	0,	/* 211 */
	0,	/* 212 */
	0,	/* 213 */
	0,	/* 214 */
	0,	/* 215 */
	0,	/* 216 */
	0,	/* 217 */
	0,	/* 218 */
	0,	/* 219 */
	0,	/* 220 */
	0,	/* 221 */
	0,	/* 222 */
	0,	/* 223 */
	0,	/* 224 */
	0,	/* 225 */
	0,	/* 226 */
	0,	/* 227 */
	0,	/* 228 */
	0,	/* 229 */
	0,	/* 230 */
	0,	/* 231 */
	0,	/* 232 */
	0,	/* 233 */
	0,	/* 234 */
	0,	/* 235 */
	0,	/* 236 */
	0,	/* 237 */
	0,	/* 238 */
	0,	/* 239 */
	0,	/* 240 */
	0,	/* 241 */
	0,	/* 242 */
	0,	/* 243 */
	0,	/* 244 */
	0,	/* 245 */
	0,	/* 246 */
	0,	/* 247 */
	0,	/* 248 */
	0,	/* 249 */
	0,	/* 250 */
	0,	/* 251 */
	0,	/* 252 */
	0,	/* 253 */
	0,	/* 254 */
	0,	/* 255 */
	0,	/* 256 */
	0,	/* 257 */
	0,	/* 258 */
	0,	/* 259 */
	0,	/* 260 */
	0,	/* 261 */
	0,	/* 262 */
	0,	/* 263 */
	0,	/* 264 */
	0,	/* 265 */
	0,	/* 266 */
	0,	/* 267 */
	0,	/* 268 */
	0,	/* 269 */
	0,	/* 270 */
	0,	/* 271 */
	0,	/* 272 */
	0,	/* 273 */
	0,	/* 274 */
	0,	/* 275 */
	0,	/* 276 */
	0,	/* 277 */
	0,	/* 278 */
	0,	/* 279 */
	0,	/* 280 */
	0,	/* 281 */
	0,	/* 282 */
	0,	/* 283 */
	0,	/* 284 */
	0,	/* 285 */
	0,	/* 286 */
	0,	/* 287 */
	0,	/* 288 */
	0,	/* 289 */
	0,	/* 290 */
	0,	/* 291 */
	0,	/* 292 */
	0,	/* 293 */
	0,	/* 294 */
	0,	/* 295 */
	0,	/* 296 */
	0,	/* 297 */
	0,	/* 298 */
	0,	/* 299 */
	0,	/* 300 */
	0,	/* 301 */
	0,	/* 302 */
	0,	/* 303 */
	0,	/* 304 */
	0,	/* 305 */
	0,	/* 306 */
	0,	/* 307 */
	0,	/* 308 */
	0,	/* 309 */
	0,	/* 310 */
	0,	/* 311 */
	0,	/* 312 */
	0,	/* 313 */
	0,	/* 314 */
	0,	/* 315 */
	0,	/* 316 */
	0,	/* 317 */
	0,	/* 318 */
	0,	/* 319 */
	0,	/* 320 */
	0,	/* 321 */
	0,	/* 322 */
	0,	/* 323 */
	0,	/* 324 */
	0,	/* 325 */
	0,	/* 326 */
	0,	/* 327 */
	0,	/* 328 */
	0,	/* 329 */
	0,	/* 330 */
	0,	/* 331 */
	0,	/* 332 */
	0,	/* 333 */
	0,	/* 334 */
	0,	/* 335 */
	0,	/* 336 */
	0,	/* 337 */
	0,	/* 338 */
	0,	/* 339 */
	0,	/* 340 */
	0,	/* 341 */
	0,	/* 342 */
	0,	/* 343 */
	0,	/* 344 */
	0,	/* 345 */
	0,	/* 346 */
	0,	/* 347 */
	0,	/* 348 */
	0,	/* 349 */
	0,	/* 350 */
	0,	/* 351 */
	0,	/* 352 */
	0,	/* 353 */
	0,	/* 354 */
	0,	/* 355 */
	0,	/* 356 */
	0,	/* 357 */
	0,	/* 358 */
	0,	/* 359 */
	0,	/* 360 */
	0,	/* 361 */
	0,	/* 362 */
	0,	/* 363 */
	0,	/* 364 */
	0,	/* 365 */
	0,	/* 366 */
	0,	/* 367 */
	0,	/* 368 */
	0,	/* 369 */
	0,	/* 370 */
	0,	/* 371 */
	0,	/* 372 */
	0,	/* 373 */
	0,	/* 374 */
	0,	/* 375 */
	0,	/* 376 */
	0,	/* 377 */
	0,	/* 378 */
	0,	/* 379 */
	0,	/* 380 */
	0,	/* 381 */
	0,	/* 382 */
	0,	/* 383 */
	0,	/* 384 */
	0,	/* 385 */
	0,	/* 386 */
	0,	/* 387 */
	0,	/* 388 */
	0,	/* 389 */
	0,	/* 390 */
	0,	/* 391 */
	0,	/* 392 */
	0,	/* 393 */
	0,	/* 394 */
	0,	/* 395 */
	0,	/* 396 */
	0,	/* 397 */
	0,	/* 398 */
	0,	/* 399 */
	0,	/* 400=NONE */
	0,	/* 401=ALU1 */
	0,	/* 402=ALU2 */
	0,	/* 403 */
	0,	/* 404 */
	0,	/* 405 */
	0,	/* 406 */
	0,	/* 407 */
	0,	/* 408 */
	0,	/* 409 */
	0,	/* 410 */
	0,	/* 411 */
	0,	/* 412 */
	0,	/* 413 */
	0,	/* 414 */
	0,	/* 415 */
	0,	/* 416 */
	0,	/* 417 */
	0,	/* 418 */
	0,	/* 419 */
	0,	/* 420 */
	0,	/* 421 */
	0,	/* 422 */
	0,	/* 423 */
	0,	/* 424 */
	0,	/* 425 */
	0,	/* 426 */
	0,	/* 427 */
	0,	/* 428 */
	0,	/* 429 */
	0,	/* 430 */
	0,	/* 431 */
	0,	/* 432 */
	0,	/* 433 */
	0,	/* 434 */
	0,	/* 435 */
	0,	/* 436 */
	0,	/* 437 */
	0,	/* 438 */
	0,	/* 439 */
	0,	/* 440 */
	0,	/* 441 */
	0,	/* 442 */
	0,	/* 443 */
	0,	/* 444 */
	0,	/* 445 */
	0,	/* 446 */
	0,	/* 447 */
	0,	/* 448 */
	0,	/* 449 */
	0,	/* 450 */
	0,	/* 451 */
	0,	/* 452 */
	0,	/* 453 */
	0,	/* 454 */
	0,	/* 455 */
	0,	/* 456 */
	0,	/* 457 */
	0,	/* 458 */
	0,	/* 459 */
	0,	/* 460 */
	0,	/* 461 */
	0,	/* 462 */
	0,	/* 463 */
	0,	/* 464 */
	0,	/* 465 */
	0,	/* 466 */
	0,	/* 467 */
	0,	/* 468 */
	0,	/* 469 */
	0,	/* 470 */
	0,	/* 471 */
	0,	/* 472 */
	0,	/* 473 */
	0,	/* 474 */
	0,	/* 475 */
	0,	/* 476 */
	0,	/* 477 */
	0,	/* 478 */
	0,	/* 479 */
	0,	/* 480 */
	0,	/* 481 */
	0,	/* 482 */
	0,	/* 483 */
	0,	/* 484 */
	0,	/* 485 */
	0,	/* 486 */
	0,	/* 487 */
	0,	/* 488 */
	0,	/* 489 */
	0,	/* 490 */
	0,	/* 491 */
	0,	/* 492 */
	0,	/* 493 */
	0,	/* 494 */
	0,	/* 495 */
	0,	/* 496 */
	0,	/* 497 */
	0,	/* 498 */
	0,	/* 499 */
	2,	/* 500=addu */
	2,	/* 501=subu */
	2,	/* 502=lw */
	2,	/* 503=sw */
	1,	/* 504=move */
	2,	/* 505=srl */
	2,	/* 506=sra */
	2,	/* 507=mul_d */
	2,	/* 508=add_d */
	2,	/* 509=sub_d */
	1,	/* 510=la */
	2,	/* 511=sge */
	2,	/* 512=slt */
	2,	/* 513=sle */
	2,	/* 514=sgt */
	1,	/* 515=trunc_w_d */
	1,	/* 516=li */
	1,	/* 517=mtc1 */
	1,	/* 518=cvt_d_w */
	2,	/* 519=and */
	1,	/* 520=cvt_s_d */
	1,	/* 521=cvt_d_s */
	2,	/* 522=div_d */
	2,	/* 523=bnez */
	2,	/* 524=add_s */
	2,	/* 525=sub_s */
	2,	/* 526=mul_s */
	2,	/* 527=div_s */
	2,	/* 528=l_d */
	2,	/* 529=s_d */
	1,	/* 530=jal */
	1,	/* 531=jr */
	1,	/* 532=mov_d */
	1,	/* 533=mfc1 */
	1,	/* 534=li_d */
	2,	/* 535=l_s */
	2,	/* 536=s_s */
	1,	/* 537=cvt_s_w */
	1,	/* 538=trunc_w_s */
	1,	/* 539=li_s */
	2,	/* 540=sne */
	2,	/* 541=seq */
	2,	/* 542=sll */
	2,	/* 543=sla */
	1,	/* 544=j */
	2,	/* 545=ori */
	2,	/* 546=andi */
	2,	/* 547=xori */
	2,	/* 548=mult */
	1,	/* 549=mflo */
	2,	/* 550=lbu */
	2,	/* 551=lb */
	2,	/* 552=sb */
	2,	/* 553=sbu */
	2,	/* 554=lhu */
	2,	/* 555=lh */
	2,	/* 556=sh */
	2,	/* 557=shu */
	2,	/* 558=sgtu */
	2,	/* 559=sltu */
	2,	/* 560=sgeu */
	2,	/* 561=sleu */
	2,	/* 562=div */
	1,	/* 563=mfhi */
	2,	/* 564=or */
	2,	/* 565=la2 */
	1,	/* 566=mov_s */
	2,	/* 567=c_lt_d */
	2,	/* 568=c_le_d */
	2,	/* 569=c_ge_d */
	2,	/* 570=c_gt_d */
};

char *isel_opname[] = {
	/* 0 */	0,
	/* 1 */	"IADD",
	/* 2 */	"IGE",
	/* 3 */	"IGT",
	/* 4 */	"ILE",
	/* 5 */	"IASH",
	/* 6 */	"ISUB",
	/* 7 */	"ILSH",
	/* 8 */	"ILT",
	/* 9 */	"NOP",
	/* 10 */	"ICONSTANT",
	/* 11 */	"IASSIGN",
	/* 12 */	"IF",
	/* 13 */	"IGOTO",
	/* 14 */	"IVLOAD",
	/* 15 */	"DVLOAD",
	/* 16 */	"IVSTORE",
	/* 17 */	"DVSTORE",
	/* 18 */	"ASSIGN",
	/* 19 */	"DCONSTANT",
	/* 20 */	"DADD",
	/* 21 */	"FASSIGN",
	/* 22 */	"DMUL",
	/* 23 */	"DSUB",
	/* 24 */	"DMTC1",
	/* 25 */	"GOTO",
	/* 26 */	"TRUNCID",
	/* 27 */	"MFC1",
	/* 28 */	"MTC1",
	/* 29 */	"CVTDI",
	/* 30 */	"ILAND",
	/* 31 */	"DASSIGN",
	/* 32 */	"DGE",
	/* 33 */	"DLT",
	/* 34 */	"DLE",
	/* 35 */	"DGT",
	/* 36 */	"CVTSD",
	/* 37 */	"CVTDS",
	/* 38 */	"DMFC1",
	/* 39 */	"DDIV",
	/* 40 */	"DEQ",
	/* 41 */	"FADD",
	/* 42 */	"FSUB",
	/* 43 */	"FMUL",
	/* 44 */	"FDIV",
	/* 45 */	"FVLOAD",
	/* 46 */	"FVSTORE",
	/* 47 */	"CALL",
	/* 48 */	"RETURN",
	/* 49 */	"IRASH",
	/* 50 */	"ILASH",
	/* 51 */	"IRLSH",
	/* 52 */	"ILLSH",
	/* 53 */	"FCONSTANT",
	/* 54 */	"INE",
	/* 55 */	"CVTSI",
	/* 56 */	"TRUNCIS",
	/* 57 */	0,
	/* 58 */	"IEQ",
	/* 59 */	"IOR",
	/* 60 */	"IAND",
	/* 61 */	"IXOR",
	/* 62 */	"IMUL",
	/* 63 */	"MFLO",
	/* 64 */	"QIVLOADU",
	/* 65 */	"QIVLOAD",
	/* 66 */	"QIVSTORE",
	/* 67 */	"QIVSTOREU",
	/* 68 */	"HIVLOADU",
	/* 69 */	"HIVLOAD",
	/* 70 */	"HIVSTORE",
	/* 71 */	"HIVSTOREU",
	/* 72 */	"IGEU",
	/* 73 */	"IGTU",
	/* 74 */	"ILEU",
	/* 75 */	"ILTU",
	/* 76 */	"IDIV",
	/* 77 */	"MFHI",
	/* 78 */	0,
	/* 79 */	0,
	/* 80 */	0,
	/* 81 */	0,
	/* 82 */	0,
	/* 83 */	0,
	/* 84 */	0,
	/* 85 */	0,
	/* 86 */	0,
	/* 87 */	0,
	/* 88 */	0,
	/* 89 */	0,
	/* 90 */	0,
	/* 91 */	0,
	/* 92 */	0,
	/* 93 */	0,
	/* 94 */	0,
	/* 95 */	0,
	/* 96 */	0,
	/* 97 */	0,
	/* 98 */	0,
	/* 99 */	0,
	/* 100 */	0,
	/* 101 */	"R0",
	/* 102 */	"R1",
	/* 103 */	"R2",
	/* 104 */	"R3",
	/* 105 */	"R4",
	/* 106 */	"R5",
	/* 107 */	"R6",
	/* 108 */	"R7",
	/* 109 */	"R8",
	/* 110 */	"R9",
	/* 111 */	"R10",
	/* 112 */	"R11",
	/* 113 */	"R12",
	/* 114 */	"R13",
	/* 115 */	"R14",
	/* 116 */	"R15",
	/* 117 */	"R16",
	/* 118 */	"R17",
	/* 119 */	"R18",
	/* 120 */	"R19",
	/* 121 */	"R20",
	/* 122 */	"R21",
	/* 123 */	"R22",
	/* 124 */	"R23",
	/* 125 */	"R24",
	/* 126 */	"R25",
	/* 127 */	"sp0",
	/* 128 */	"cc0",
	/* 129 */	"f0",
	/* 130 */	"f1",
	/* 131 */	"f2",
	/* 132 */	"f3",
	/* 133 */	"f4",
	/* 134 */	"f5",
	/* 135 */	"f6",
	/* 136 */	"f7",
	/* 137 */	"f8",
	/* 138 */	"f9",
	/* 139 */	"f10",
	/* 140 */	"f11",
	/* 141 */	"f12",
	/* 142 */	"f13",
	/* 143 */	"f14",
	/* 144 */	"f15",
	/* 145 */	"f16",
	/* 146 */	"f17",
	/* 147 */	"f18",
	/* 148 */	"f19",
	/* 149 */	"f20",
	/* 150 */	"f21",
	/* 151 */	"f22",
	/* 152 */	"f23",
	/* 153 */	"f24",
	/* 154 */	"f25",
	/* 155 */	"f26",
	/* 156 */	"f27",
	/* 157 */	"f28",
	/* 158 */	"f29",
	/* 159 */	"f30",
	/* 160 */	"f31",
	/* 161 */	"fp0",
	/* 162 */	"temp0",
	/* 163 */	"temp1",
	/* 164 */	"temp2",
	/* 165 */	"temp3",
	/* 166 */	"temp4",
	/* 167 */	"temp5",
	/* 168 */	"temp6",
	/* 169 */	"temp7",
	/* 170 */	"temp8",
	/* 171 */	"temp9",
	/* 172 */	"temp10",
	/* 173 */	"R26",
	/* 174 */	"R27",
	/* 175 */	"R28",
	/* 176 */	"R29",
	/* 177 */	"R30",
	/* 178 */	"R31",
	/* 179 */	"isel_label",
	/* 180 */	"hilo0",
	/* 181 */	0,
	/* 182 */	0,
	/* 183 */	0,
	/* 184 */	0,
	/* 185 */	0,
	/* 186 */	0,
	/* 187 */	0,
	/* 188 */	0,
	/* 189 */	0,
	/* 190 */	0,
	/* 191 */	0,
	/* 192 */	0,
	/* 193 */	0,
	/* 194 */	0,
	/* 195 */	0,
	/* 196 */	0,
	/* 197 */	0,
	/* 198 */	0,
	/* 199 */	0,
	/* 200 */	0,
	/* 201 */	"DEF",
	/* 202 */	"INT",
	/* 203 */	"IND",
	/* 204 */	"SRC2",
	/* 205 */	"FLOAT",
	/* 206 */	0,
	/* 207 */	0,
	/* 208 */	0,
	/* 209 */	0,
	/* 210 */	0,
	/* 211 */	0,
	/* 212 */	0,
	/* 213 */	0,
	/* 214 */	0,
	/* 215 */	0,
	/* 216 */	0,
	/* 217 */	0,
	/* 218 */	0,
	/* 219 */	0,
	/* 220 */	0,
	/* 221 */	0,
	/* 222 */	0,
	/* 223 */	0,
	/* 224 */	0,
	/* 225 */	0,
	/* 226 */	0,
	/* 227 */	0,
	/* 228 */	0,
	/* 229 */	0,
	/* 230 */	0,
	/* 231 */	0,
	/* 232 */	0,
	/* 233 */	0,
	/* 234 */	0,
	/* 235 */	0,
	/* 236 */	0,
	/* 237 */	0,
	/* 238 */	0,
	/* 239 */	0,
	/* 240 */	0,
	/* 241 */	0,
	/* 242 */	0,
	/* 243 */	0,
	/* 244 */	0,
	/* 245 */	0,
	/* 246 */	0,
	/* 247 */	0,
	/* 248 */	0,
	/* 249 */	0,
	/* 250 */	0,
	/* 251 */	0,
	/* 252 */	0,
	/* 253 */	0,
	/* 254 */	0,
	/* 255 */	0,
	/* 256 */	0,
	/* 257 */	0,
	/* 258 */	0,
	/* 259 */	0,
	/* 260 */	0,
	/* 261 */	0,
	/* 262 */	0,
	/* 263 */	0,
	/* 264 */	0,
	/* 265 */	0,
	/* 266 */	0,
	/* 267 */	0,
	/* 268 */	0,
	/* 269 */	0,
	/* 270 */	0,
	/* 271 */	0,
	/* 272 */	0,
	/* 273 */	0,
	/* 274 */	0,
	/* 275 */	0,
	/* 276 */	0,
	/* 277 */	0,
	/* 278 */	0,
	/* 279 */	0,
	/* 280 */	0,
	/* 281 */	0,
	/* 282 */	0,
	/* 283 */	0,
	/* 284 */	0,
	/* 285 */	0,
	/* 286 */	0,
	/* 287 */	0,
	/* 288 */	0,
	/* 289 */	0,
	/* 290 */	0,
	/* 291 */	0,
	/* 292 */	0,
	/* 293 */	0,
	/* 294 */	0,
	/* 295 */	0,
	/* 296 */	0,
	/* 297 */	0,
	/* 298 */	0,
	/* 299 */	0,
	/* 300 */	0,
	/* 301 */	0,
	/* 302 */	0,
	/* 303 */	0,
	/* 304 */	0,
	/* 305 */	0,
	/* 306 */	0,
	/* 307 */	0,
	/* 308 */	0,
	/* 309 */	0,
	/* 310 */	0,
	/* 311 */	0,
	/* 312 */	0,
	/* 313 */	0,
	/* 314 */	0,
	/* 315 */	0,
	/* 316 */	0,
	/* 317 */	0,
	/* 318 */	0,
	/* 319 */	0,
	/* 320 */	0,
	/* 321 */	0,
	/* 322 */	0,
	/* 323 */	0,
	/* 324 */	0,
	/* 325 */	0,
	/* 326 */	0,
	/* 327 */	0,
	/* 328 */	0,
	/* 329 */	0,
	/* 330 */	0,
	/* 331 */	0,
	/* 332 */	0,
	/* 333 */	0,
	/* 334 */	0,
	/* 335 */	0,
	/* 336 */	0,
	/* 337 */	0,
	/* 338 */	0,
	/* 339 */	0,
	/* 340 */	0,
	/* 341 */	0,
	/* 342 */	0,
	/* 343 */	0,
	/* 344 */	0,
	/* 345 */	0,
	/* 346 */	0,
	/* 347 */	0,
	/* 348 */	0,
	/* 349 */	0,
	/* 350 */	0,
	/* 351 */	0,
	/* 352 */	0,
	/* 353 */	0,
	/* 354 */	0,
	/* 355 */	0,
	/* 356 */	0,
	/* 357 */	0,
	/* 358 */	0,
	/* 359 */	0,
	/* 360 */	0,
	/* 361 */	0,
	/* 362 */	0,
	/* 363 */	0,
	/* 364 */	0,
	/* 365 */	0,
	/* 366 */	0,
	/* 367 */	0,
	/* 368 */	0,
	/* 369 */	0,
	/* 370 */	0,
	/* 371 */	0,
	/* 372 */	0,
	/* 373 */	0,
	/* 374 */	0,
	/* 375 */	0,
	/* 376 */	0,
	/* 377 */	0,
	/* 378 */	0,
	/* 379 */	0,
	/* 380 */	0,
	/* 381 */	0,
	/* 382 */	0,
	/* 383 */	0,
	/* 384 */	0,
	/* 385 */	0,
	/* 386 */	0,
	/* 387 */	0,
	/* 388 */	0,
	/* 389 */	0,
	/* 390 */	0,
	/* 391 */	0,
	/* 392 */	0,
	/* 393 */	0,
	/* 394 */	0,
	/* 395 */	0,
	/* 396 */	0,
	/* 397 */	0,
	/* 398 */	0,
	/* 399 */	0,
	/* 400 */	"NONE",
	/* 401 */	"ALU1",
	/* 402 */	"ALU2",
	/* 403 */	0,
	/* 404 */	0,
	/* 405 */	0,
	/* 406 */	0,
	/* 407 */	0,
	/* 408 */	0,
	/* 409 */	0,
	/* 410 */	0,
	/* 411 */	0,
	/* 412 */	0,
	/* 413 */	0,
	/* 414 */	0,
	/* 415 */	0,
	/* 416 */	0,
	/* 417 */	0,
	/* 418 */	0,
	/* 419 */	0,
	/* 420 */	0,
	/* 421 */	0,
	/* 422 */	0,
	/* 423 */	0,
	/* 424 */	0,
	/* 425 */	0,
	/* 426 */	0,
	/* 427 */	0,
	/* 428 */	0,
	/* 429 */	0,
	/* 430 */	0,
	/* 431 */	0,
	/* 432 */	0,
	/* 433 */	0,
	/* 434 */	0,
	/* 435 */	0,
	/* 436 */	0,
	/* 437 */	0,
	/* 438 */	0,
	/* 439 */	0,
	/* 440 */	0,
	/* 441 */	0,
	/* 442 */	0,
	/* 443 */	0,
	/* 444 */	0,
	/* 445 */	0,
	/* 446 */	0,
	/* 447 */	0,
	/* 448 */	0,
	/* 449 */	0,
	/* 450 */	0,
	/* 451 */	0,
	/* 452 */	0,
	/* 453 */	0,
	/* 454 */	0,
	/* 455 */	0,
	/* 456 */	0,
	/* 457 */	0,
	/* 458 */	0,
	/* 459 */	0,
	/* 460 */	0,
	/* 461 */	0,
	/* 462 */	0,
	/* 463 */	0,
	/* 464 */	0,
	/* 465 */	0,
	/* 466 */	0,
	/* 467 */	0,
	/* 468 */	0,
	/* 469 */	0,
	/* 470 */	0,
	/* 471 */	0,
	/* 472 */	0,
	/* 473 */	0,
	/* 474 */	0,
	/* 475 */	0,
	/* 476 */	0,
	/* 477 */	0,
	/* 478 */	0,
	/* 479 */	0,
	/* 480 */	0,
	/* 481 */	0,
	/* 482 */	0,
	/* 483 */	0,
	/* 484 */	0,
	/* 485 */	0,
	/* 486 */	0,
	/* 487 */	0,
	/* 488 */	0,
	/* 489 */	0,
	/* 490 */	0,
	/* 491 */	0,
	/* 492 */	0,
	/* 493 */	0,
	/* 494 */	0,
	/* 495 */	0,
	/* 496 */	0,
	/* 497 */	0,
	/* 498 */	0,
	/* 499 */	0,
	/* 500 */	"addu",
	/* 501 */	"subu",
	/* 502 */	"lw",
	/* 503 */	"sw",
	/* 504 */	"move",
	/* 505 */	"srl",
	/* 506 */	"sra",
	/* 507 */	"mul_d",
	/* 508 */	"add_d",
	/* 509 */	"sub_d",
	/* 510 */	"la",
	/* 511 */	"sge",
	/* 512 */	"slt",
	/* 513 */	"sle",
	/* 514 */	"sgt",
	/* 515 */	"trunc_w_d",
	/* 516 */	"li",
	/* 517 */	"mtc1",
	/* 518 */	"cvt_d_w",
	/* 519 */	"and",
	/* 520 */	"cvt_s_d",
	/* 521 */	"cvt_d_s",
	/* 522 */	"div_d",
	/* 523 */	"bnez",
	/* 524 */	"add_s",
	/* 525 */	"sub_s",
	/* 526 */	"mul_s",
	/* 527 */	"div_s",
	/* 528 */	"l_d",
	/* 529 */	"s_d",
	/* 530 */	"jal",
	/* 531 */	"jr",
	/* 532 */	"mov_d",
	/* 533 */	"mfc1",
	/* 534 */	"li_d",
	/* 535 */	"l_s",
	/* 536 */	"s_s",
	/* 537 */	"cvt_s_w",
	/* 538 */	"trunc_w_s",
	/* 539 */	"li_s",
	/* 540 */	"sne",
	/* 541 */	"seq",
	/* 542 */	"sll",
	/* 543 */	"sla",
	/* 544 */	"j",
	/* 545 */	"ori",
	/* 546 */	"andi",
	/* 547 */	"xori",
	/* 548 */	"mult",
	/* 549 */	"mflo",
	/* 550 */	"lbu",
	/* 551 */	"lb",
	/* 552 */	"sb",
	/* 553 */	"sbu",
	/* 554 */	"lhu",
	/* 555 */	"lh",
	/* 556 */	"sh",
	/* 557 */	"shu",
	/* 558 */	"sgtu",
	/* 559 */	"sltu",
	/* 560 */	"sgeu",
	/* 561 */	"sleu",
	/* 562 */	"div",
	/* 563 */	"mfhi",
	/* 564 */	"or",
	/* 565 */	"la2",
	/* 566 */	"mov_s",
	/* 567 */	"c_lt_d",
	/* 568 */	"c_le_d",
	/* 569 */	"c_ge_d",
	/* 570 */	"c_gt_d",
};

short isel_cost[][4] = {
	{ 0 },	/* 0 */
	{ 0 },	/* 1 = def: DEF(reg,expr) */
	{ 0 },	/* 2 = def: reg */
	{ 0 },	/* 3 = def: const */
	{ 0 },	/* 4 = def: isel_label */
	{ 2 },	/* 5 = expr: IADD(def,def) */
	{ 2 },	/* 6 = expr: ISUB(def,def) */
	{ 2 },	/* 7 = expr: IVLOAD(def,def) */
	{ 2 },	/* 8 = expr: IVSTORE(def,def) */
	{ 1 },	/* 9 = expr: IASSIGN(def) */
	{ 1 },	/* 10 = expr: ILSH(def,const) */
	{ 1 },	/* 11 = expr: IASH(def,const) */
	{ 4 },	/* 12 = expr: DMUL(def,def) */
	{ 3 },	/* 13 = expr: DADD(def,def) */
	{ 3 },	/* 14 = expr: DSUB(def,def) */
	{ 1 },	/* 15 = expr: ICONSTANT(const_label) */
	{ 1 },	/* 16 = expr: ASSIGN(def) */
	{ 1 },	/* 17 = expr: IGE(def,def) */
	{ 1 },	/* 18 = expr: ILT(def,def) */
	{ 1 },	/* 19 = expr: ILE(def,def) */
	{ 1 },	/* 20 = expr: IGT(def,def) */
	{ 1 },	/* 21 = expr: DMTC1(def) */
	{ 1 },	/* 22 = expr: TRUNCID(def) */
	{ 1 },	/* 23 = expr: MFC1(def) */
	{ 1 },	/* 24 = expr: DCONSTANT(const_label) */
	{ 1 },	/* 25 = expr: MTC1(def) */
	{ 1 },	/* 26 = expr: CVTDI(def) */
	{ 1 },	/* 27 = expr: ILAND(def,def) */
	{ 1 },	/* 28 = expr: DASSIGN(def) */
	{ 1 },	/* 29 = expr: DGE(def,def) */
	{ 1 },	/* 30 = expr: DLT(def,def) */
	{ 1 },	/* 31 = expr: DLE(def,def) */
	{ 1 },	/* 32 = expr: DGT(def,def) */
	{ 1 },	/* 33 = expr: CVTSD(def) */
	{ 1 },	/* 34 = expr: CVTDS(def) */
	{ 1 },	/* 35 = expr: DMFC1(def) */
	{ 3 },	/* 36 = expr: DDIV(def,def) */
	{ 2 },	/* 37 = expr: DEQ(def,def) */
	{ 3 },	/* 38 = expr: FADD(def,def) */
	{ 3 },	/* 39 = expr: FSUB(def,def) */
	{ 3 },	/* 40 = expr: FMUL(def,def) */
	{ 3 },	/* 41 = expr: FDIV(def,def) */
	{ 2 },	/* 42 = expr: DVLOAD(def,def) */
	{ 2 },	/* 43 = expr: DVSTORE(def,def) */
	{ 2 },	/* 44 = expr: FVLOAD(def,def) */
	{ 2 },	/* 45 = expr: FVSTORE(def,def) */
	{ 1 },	/* 46 = expr: ICONSTANT(const) */
	{ 2 },	/* 47 = expr: IRASH(def,def) */
	{ 2 },	/* 48 = expr: ILASH(def,def) */
	{ 2 },	/* 49 = expr: IRLSH(def,def) */
	{ 2 },	/* 50 = expr: ILLSH(def,def) */
	{ 2 },	/* 51 = expr: FCONSTANT(const_label) */
	{ 2 },	/* 52 = expr: FCONSTANT(float_const) */
	{ 2 },	/* 53 = expr: FASSIGN(def) */
	{ 2 },	/* 54 = expr: INE(def,def) */
	{ 1 },	/* 55 = expr: TRUNCIS(def) */
	{ 1 },	/* 56 = expr: CVTSI(def) */
	{ 1 },	/* 57 = expr: DCONSTANT(float_const) */
	{ 1 },	/* 58 = expr: IEQ(def,def) */
	{ 1 },	/* 59 = expr: IOR(def,const) */
	{ 1 },	/* 60 = expr: IAND(def,const) */
	{ 1 },	/* 61 = expr: IXOR(def,def) */
	{ 1 },	/* 62 = expr: IMUL(def,def) */
	{ 1 },	/* 63 = expr: MFLO(def) */
	{ 2 },	/* 64 = expr: QIVLOADU(def,def) */
	{ 2 },	/* 65 = expr: QIVLOAD(def,def) */
	{ 2 },	/* 66 = expr: QIVSTORE(def,def) */
	{ 2 },	/* 67 = expr: QIVSTOREU(def,def) */
	{ 2 },	/* 68 = expr: HIVLOADU(def,def) */
	{ 2 },	/* 69 = expr: HIVLOAD(def,def) */
	{ 2 },	/* 70 = expr: HIVSTORE(def,def) */
	{ 2 },	/* 71 = expr: HIVSTOREU(def,def) */
	{ 1 },	/* 72 = expr: IGEU(def,def) */
	{ 1 },	/* 73 = expr: ILTU(def,def) */
	{ 1 },	/* 74 = expr: ILEU(def,def) */
	{ 1 },	/* 75 = expr: IGTU(def,def) */
	{ 1 },	/* 76 = expr: IDIV(def,def) */
	{ 1 },	/* 77 = expr: MFHI(def) */
	{ 1 },	/* 78 = expr: IOR(def,def) */
	{ 1 },	/* 79 = expr: IAND(def,def) */
	{ 2 },	/* 80 = expr: IADD(const_label,def) */
	{ 2 },	/* 81 = expr: ISUB(const_label,def) */
	{ 0 },	/* 82 */
	{ 0 },	/* 83 */
	{ 0 },	/* 84 */
	{ 0 },	/* 85 */
	{ 0 },	/* 86 */
	{ 0 },	/* 87 */
	{ 0 },	/* 88 */
	{ 0 },	/* 89 */
	{ 0 },	/* 90 */
	{ 0 },	/* 91 */
	{ 0 },	/* 92 */
	{ 0 },	/* 93 */
	{ 0 },	/* 94 */
	{ 0 },	/* 95 */
	{ 0 },	/* 96 */
	{ 0 },	/* 97 */
	{ 0 },	/* 98 */
	{ 0 },	/* 99 */
	{ 0 },	/* 100 */
	{ 0 },	/* 101 */
	{ 0 },	/* 102 */
	{ 0 },	/* 103 */
	{ 0 },	/* 104 */
	{ 0 },	/* 105 */
	{ 0 },	/* 106 */
	{ 0 },	/* 107 */
	{ 0 },	/* 108 */
	{ 0 },	/* 109 */
	{ 0 },	/* 110 */
	{ 0 },	/* 111 */
	{ 0 },	/* 112 */
	{ 0 },	/* 113 = const_label: float_const */
	{ 0 },	/* 114 = reg: rf1 */
	{ 0 },	/* 115 = reg: rf2 */
	{ 0 },	/* 116 = rf1: R0 */
	{ 0 },	/* 117 = rf1: R1 */
	{ 0 },	/* 118 = rf1: R2 */
	{ 0 },	/* 119 = rf1: R3 */
	{ 0 },	/* 120 = rf1: R4 */
	{ 0 },	/* 121 = rf1: R5 */
	{ 0 },	/* 122 = rf1: R6 */
	{ 0 },	/* 123 = rf1: R7 */
	{ 0 },	/* 124 = rf2: R8 */
	{ 0 },	/* 125 = rf2: R9 */
	{ 0 },	/* 126 = rf2: R10 */
	{ 0 },	/* 127 = rf2: R11 */
	{ 0 },	/* 128 = rf2: R12 */
	{ 0 },	/* 129 = rf2: R13 */
	{ 0 },	/* 130 = rf2: R14 */
	{ 0 },	/* 131 = rf2: R15 */
	{ 0 },	/* 132 = rf3: R16 */
	{ 0 },	/* 133 = rf3: R17 */
	{ 0 },	/* 134 = rf3: R18 */
	{ 0 },	/* 135 = rf3: R19 */
	{ 0 },	/* 136 = rf3: R20 */
	{ 0 },	/* 137 = rf3: R21 */
	{ 0 },	/* 138 = rf3: R22 */
	{ 0 },	/* 139 = rf3: R23 */
	{ 0 },	/* 140 = rf3: R24 */
	{ 0 },	/* 141 = rf3: R25 */
	{ 0 },	/* 142 = reg: rf3 */
	{ 0 },	/* 143 = rf3: sp0 */
	{ 0 },	/* 144 = rf3: cc0 */
	{ 0 },	/* 145 = rf3: f0 */
	{ 0 },	/* 146 = rf3: f1 */
	{ 0 },	/* 147 = rf3: f2 */
	{ 0 },	/* 148 = rf3: f3 */
	{ 0 },	/* 149 = rf3: f4 */
	{ 0 },	/* 150 = rf3: f5 */
	{ 0 },	/* 151 = rf3: f6 */
	{ 0 },	/* 152 = rf3: f7 */
	{ 0 },	/* 153 = rf3: f8 */
	{ 0 },	/* 154 = rf3: f9 */
	{ 0 },	/* 155 = rf3: f10 */
	{ 0 },	/* 156 = rf3: f11 */
	{ 0 },	/* 157 = rf3: f12 */
	{ 0 },	/* 158 = rf3: f13 */
	{ 0 },	/* 159 = rf3: f14 */
	{ 0 },	/* 160 = rf3: f15 */
	{ 0 },	/* 161 = rf3: f16 */
	{ 0 },	/* 162 = rf3: f17 */
	{ 0 },	/* 163 = rf3: f18 */
	{ 0 },	/* 164 = rf3: f19 */
	{ 0 },	/* 165 = rf3: f20 */
	{ 0 },	/* 166 = rf3: f21 */
	{ 0 },	/* 167 = rf3: f22 */
	{ 0 },	/* 168 = rf3: f23 */
	{ 0 },	/* 169 = rf3: f24 */
	{ 0 },	/* 170 = rf3: f25 */
	{ 0 },	/* 171 = rf3: f26 */
	{ 0 },	/* 172 = rf3: f27 */
	{ 0 },	/* 173 = rf3: f28 */
	{ 0 },	/* 174 = rf3: f29 */
	{ 0 },	/* 175 = rf3: f30 */
	{ 0 },	/* 176 = rf3: f31 */
	{ 0 },	/* 177 = rf3: fp0 */
	{ 0 },	/* 178 = const: INT */
	{ 0 },	/* 179 = rf3: temp0 */
	{ 0 },	/* 180 = rf3: temp1 */
	{ 0 },	/* 181 = rf3: temp2 */
	{ 0 },	/* 182 = rf3: temp3 */
	{ 0 },	/* 183 = rf3: temp4 */
	{ 0 },	/* 184 = rf3: temp5 */
	{ 0 },	/* 185 = rf3: temp6 */
	{ 0 },	/* 186 = rf3: temp7 */
	{ 0 },	/* 187 = rf3: temp8 */
	{ 0 },	/* 188 = rf3: temp9 */
	{ 0 },	/* 189 = rf3: temp10 */
	{ 0 },	/* 190 = rf3: R26 */
	{ 0 },	/* 191 = rf3: R27 */
	{ 0 },	/* 192 = rf3: R28 */
	{ 0 },	/* 193 = rf3: R29 */
	{ 0 },	/* 194 = rf3: R30 */
	{ 0 },	/* 195 = rf3: R31 */
	{ 0 },	/* 196 = rf3: isel_label */
	{ 0 },	/* 197 = const_label: const */
	{ 0 },	/* 198 = const_label: isel_label */
	{ 0 },	/* 199 = float_const: FLOAT */
	{ 2 },	/* 200 = expr: addu(def,def) */
	{ 2 },	/* 201 = expr: subu(def,def) */
	{ 2 },	/* 202 = expr: lw(def,def) */
	{ 2 },	/* 203 = expr: sw(def,def) */
	{ 2 },	/* 204 = expr: move(def) */
	{ 2 },	/* 205 = expr: srl(def,def) */
	{ 2 },	/* 206 = expr: sra(def,def) */
	{ 2 },	/* 207 = expr: mul_d(def,def) */
	{ 2 },	/* 208 = expr: add_d(def,def) */
	{ 2 },	/* 209 = expr: sub_d(def,def) */
	{ 2 },	/* 210 = expr: la(def) */
	{ 2 },	/* 211 = expr: sge(def,def) */
	{ 2 },	/* 212 = expr: slt(def,def) */
	{ 2 },	/* 213 = expr: sle(def,def) */
	{ 2 },	/* 214 = expr: sgt(def,def) */
	{ 2 },	/* 215 = expr: trunc_w_d(def) */
	{ 2 },	/* 216 = expr: li(def) */
	{ 2 },	/* 217 = expr: mtc1(def) */
	{ 2 },	/* 218 = expr: cvt_d_w(def) */
	{ 2 },	/* 219 = expr: and(def,def) */
	{ 2 },	/* 220 = expr: cvt_s_d(def) */
	{ 2 },	/* 221 = expr: cvt_d_s(def) */
	{ 2 },	/* 222 = expr: div_d(def,def) */
	{ 2 },	/* 223 = expr: bnez(def,def) */
	{ 2 },	/* 224 = expr: add_s(def,def) */
	{ 2 },	/* 225 = expr: sub_s(def,def) */
	{ 2 },	/* 226 = expr: mul_s(def,def) */
	{ 2 },	/* 227 = expr: div_s(def,def) */
	{ 2 },	/* 228 = expr: l_d(def,def) */
	{ 2 },	/* 229 = expr: s_d(def,def) */
	{ 2 },	/* 230 = expr: jal(def) */
	{ 2 },	/* 231 = expr: jr(def) */
	{ 2 },	/* 232 = expr: mov_d(def) */
	{ 2 },	/* 233 = expr: mfc1(def) */
	{ 2 },	/* 234 = expr: li_d(def) */
	{ 2 },	/* 235 = expr: l_s(def,def) */
	{ 2 },	/* 236 = expr: s_s(def,def) */
	{ 2 },	/* 237 = expr: cvt_s_w(def) */
	{ 2 },	/* 238 = expr: trunc_w_s(def) */
	{ 2 },	/* 239 = expr: li_s(def) */
	{ 2 },	/* 240 = expr: sne(def,def) */
	{ 2 },	/* 241 = expr: seq(def,def) */
	{ 2 },	/* 242 = expr: sll(def,def) */
	{ 2 },	/* 243 = expr: sla(def,def) */
	{ 2 },	/* 244 = expr: j(def) */
	{ 2 },	/* 245 = expr: ori(def,def) */
	{ 2 },	/* 246 = expr: andi(def,def) */
	{ 2 },	/* 247 = expr: xori(def,def) */
	{ 2 },	/* 248 = expr: mult(def,def) */
	{ 2 },	/* 249 = expr: mflo(def) */
	{ 2 },	/* 250 = expr: lbu(def,def) */
	{ 2 },	/* 251 = expr: lb(def,def) */
	{ 2 },	/* 252 = expr: sb(def,def) */
	{ 2 },	/* 253 = expr: sbu(def,def) */
	{ 2 },	/* 254 = expr: lhu(def,def) */
	{ 2 },	/* 255 = expr: lh(def,def) */
	{ 2 },	/* 256 = expr: sh(def,def) */
	{ 2 },	/* 257 = expr: shu(def,def) */
	{ 2 },	/* 258 = expr: sgeu(def,def) */
	{ 2 },	/* 259 = expr: sltu(def,def) */
	{ 2 },	/* 260 = expr: sleu(def,def) */
	{ 2 },	/* 261 = expr: sgtu(def,def) */
	{ 2 },	/* 262 = expr: div(def,def) */
	{ 2 },	/* 263 = expr: mfhi(def) */
	{ 2 },	/* 264 = expr: or(def,def) */
	{ 2 },	/* 265 = expr: la2(def,def) */
	{ 2 },	/* 266 = expr: mov_s(def) */
	{ 2 },	/* 267 = expr: c_gt_d(def,def) */
	{ 2 },	/* 268 = expr: c_ge_d(def,def) */
	{ 2 },	/* 269 = expr: c_lt_d(def,def) */
	{ 2 },	/* 270 = expr: c_le_d(def,def) */
	{ 0 },	/* 271 */
	{ 0 },	/* 272 */
	{ 0 },	/* 273 */
	{ 0 },	/* 274 */
	{ 0 },	/* 275 */
	{ 0 },	/* 276 */
	{ 0 },	/* 277 */
	{ 0 },	/* 278 */
	{ 0 },	/* 279 */
	{ 0 },	/* 280 */
	{ 0 },	/* 281 */
	{ 0 },	/* 282 */
	{ 0 },	/* 283 */
	{ 0 },	/* 284 */
	{ 0 },	/* 285 */
	{ 0 },	/* 286 */
	{ 0 },	/* 287 */
	{ 0 },	/* 288 */
	{ 0 },	/* 289 */
	{ 0 },	/* 290 */
	{ 0 },	/* 291 */
	{ 0 },	/* 292 */
	{ 0 },	/* 293 */
	{ 0 },	/* 294 */
	{ 0 },	/* 295 */
	{ 0 },	/* 296 */
	{ 0 },	/* 297 */
	{ 0 },	/* 298 */
	{ 0 },	/* 299 */
	{ 0 },	/* 300 = def: float_const */
	{ 0 },	/* 301 = rf3: hilo0 */
};

char *isel_string[] = {
	/* 0 */	0,
	/* 1 */	"def: DEF(reg,expr)",
	/* 2 */	"def: reg",
	/* 3 */	"def: const",
	/* 4 */	"def: isel_label",
	/* 5 */	"expr: IADD(def,def)",
	/* 6 */	"expr: ISUB(def,def)",
	/* 7 */	"expr: IVLOAD(def,def)",
	/* 8 */	"expr: IVSTORE(def,def)",
	/* 9 */	"expr: IASSIGN(def)",
	/* 10 */	"expr: ILSH(def,const)",
	/* 11 */	"expr: IASH(def,const)",
	/* 12 */	"expr: DMUL(def,def)",
	/* 13 */	"expr: DADD(def,def)",
	/* 14 */	"expr: DSUB(def,def)",
	/* 15 */	"expr: ICONSTANT(const_label)",
	/* 16 */	"expr: ASSIGN(def)",
	/* 17 */	"expr: IGE(def,def)",
	/* 18 */	"expr: ILT(def,def)",
	/* 19 */	"expr: ILE(def,def)",
	/* 20 */	"expr: IGT(def,def)",
	/* 21 */	"expr: DMTC1(def)",
	/* 22 */	"expr: TRUNCID(def)",
	/* 23 */	"expr: MFC1(def)",
	/* 24 */	"expr: DCONSTANT(const_label)",
	/* 25 */	"expr: MTC1(def)",
	/* 26 */	"expr: CVTDI(def)",
	/* 27 */	"expr: ILAND(def,def)",
	/* 28 */	"expr: DASSIGN(def)",
	/* 29 */	"expr: DGE(def,def)",
	/* 30 */	"expr: DLT(def,def)",
	/* 31 */	"expr: DLE(def,def)",
	/* 32 */	"expr: DGT(def,def)",
	/* 33 */	"expr: CVTSD(def)",
	/* 34 */	"expr: CVTDS(def)",
	/* 35 */	"expr: DMFC1(def)",
	/* 36 */	"expr: DDIV(def,def)",
	/* 37 */	"expr: DEQ(def,def)",
	/* 38 */	"expr: FADD(def,def)",
	/* 39 */	"expr: FSUB(def,def)",
	/* 40 */	"expr: FMUL(def,def)",
	/* 41 */	"expr: FDIV(def,def)",
	/* 42 */	"expr: DVLOAD(def,def)",
	/* 43 */	"expr: DVSTORE(def,def)",
	/* 44 */	"expr: FVLOAD(def,def)",
	/* 45 */	"expr: FVSTORE(def,def)",
	/* 46 */	"expr: ICONSTANT(const)",
	/* 47 */	"expr: IRASH(def,def)",
	/* 48 */	"expr: ILASH(def,def)",
	/* 49 */	"expr: IRLSH(def,def)",
	/* 50 */	"expr: ILLSH(def,def)",
	/* 51 */	"expr: FCONSTANT(const_label)",
	/* 52 */	"expr: FCONSTANT(float_const)",
	/* 53 */	"expr: FASSIGN(def)",
	/* 54 */	"expr: INE(def,def)",
	/* 55 */	"expr: TRUNCIS(def)",
	/* 56 */	"expr: CVTSI(def)",
	/* 57 */	"expr: DCONSTANT(float_const)",
	/* 58 */	"expr: IEQ(def,def)",
	/* 59 */	"expr: IOR(def,const)",
	/* 60 */	"expr: IAND(def,const)",
	/* 61 */	"expr: IXOR(def,def)",
	/* 62 */	"expr: IMUL(def,def)",
	/* 63 */	"expr: MFLO(def)",
	/* 64 */	"expr: QIVLOADU(def,def)",
	/* 65 */	"expr: QIVLOAD(def,def)",
	/* 66 */	"expr: QIVSTORE(def,def)",
	/* 67 */	"expr: QIVSTOREU(def,def)",
	/* 68 */	"expr: HIVLOADU(def,def)",
	/* 69 */	"expr: HIVLOAD(def,def)",
	/* 70 */	"expr: HIVSTORE(def,def)",
	/* 71 */	"expr: HIVSTOREU(def,def)",
	/* 72 */	"expr: IGEU(def,def)",
	/* 73 */	"expr: ILTU(def,def)",
	/* 74 */	"expr: ILEU(def,def)",
	/* 75 */	"expr: IGTU(def,def)",
	/* 76 */	"expr: IDIV(def,def)",
	/* 77 */	"expr: MFHI(def)",
	/* 78 */	"expr: IOR(def,def)",
	/* 79 */	"expr: IAND(def,def)",
	/* 80 */	"expr: IADD(const_label,def)",
	/* 81 */	"expr: ISUB(const_label,def)",
	/* 82 */	0,
	/* 83 */	0,
	/* 84 */	0,
	/* 85 */	0,
	/* 86 */	0,
	/* 87 */	0,
	/* 88 */	0,
	/* 89 */	0,
	/* 90 */	0,
	/* 91 */	0,
	/* 92 */	0,
	/* 93 */	0,
	/* 94 */	0,
	/* 95 */	0,
	/* 96 */	0,
	/* 97 */	0,
	/* 98 */	0,
	/* 99 */	0,
	/* 100 */	0,
	/* 101 */	0,
	/* 102 */	0,
	/* 103 */	0,
	/* 104 */	0,
	/* 105 */	0,
	/* 106 */	0,
	/* 107 */	0,
	/* 108 */	0,
	/* 109 */	0,
	/* 110 */	0,
	/* 111 */	0,
	/* 112 */	0,
	/* 113 */	"const_label: float_const",
	/* 114 */	"reg: rf1",
	/* 115 */	"reg: rf2",
	/* 116 */	"rf1: R0",
	/* 117 */	"rf1: R1",
	/* 118 */	"rf1: R2",
	/* 119 */	"rf1: R3",
	/* 120 */	"rf1: R4",
	/* 121 */	"rf1: R5",
	/* 122 */	"rf1: R6",
	/* 123 */	"rf1: R7",
	/* 124 */	"rf2: R8",
	/* 125 */	"rf2: R9",
	/* 126 */	"rf2: R10",
	/* 127 */	"rf2: R11",
	/* 128 */	"rf2: R12",
	/* 129 */	"rf2: R13",
	/* 130 */	"rf2: R14",
	/* 131 */	"rf2: R15",
	/* 132 */	"rf3: R16",
	/* 133 */	"rf3: R17",
	/* 134 */	"rf3: R18",
	/* 135 */	"rf3: R19",
	/* 136 */	"rf3: R20",
	/* 137 */	"rf3: R21",
	/* 138 */	"rf3: R22",
	/* 139 */	"rf3: R23",
	/* 140 */	"rf3: R24",
	/* 141 */	"rf3: R25",
	/* 142 */	"reg: rf3",
	/* 143 */	"rf3: sp0",
	/* 144 */	"rf3: cc0",
	/* 145 */	"rf3: f0",
	/* 146 */	"rf3: f1",
	/* 147 */	"rf3: f2",
	/* 148 */	"rf3: f3",
	/* 149 */	"rf3: f4",
	/* 150 */	"rf3: f5",
	/* 151 */	"rf3: f6",
	/* 152 */	"rf3: f7",
	/* 153 */	"rf3: f8",
	/* 154 */	"rf3: f9",
	/* 155 */	"rf3: f10",
	/* 156 */	"rf3: f11",
	/* 157 */	"rf3: f12",
	/* 158 */	"rf3: f13",
	/* 159 */	"rf3: f14",
	/* 160 */	"rf3: f15",
	/* 161 */	"rf3: f16",
	/* 162 */	"rf3: f17",
	/* 163 */	"rf3: f18",
	/* 164 */	"rf3: f19",
	/* 165 */	"rf3: f20",
	/* 166 */	"rf3: f21",
	/* 167 */	"rf3: f22",
	/* 168 */	"rf3: f23",
	/* 169 */	"rf3: f24",
	/* 170 */	"rf3: f25",
	/* 171 */	"rf3: f26",
	/* 172 */	"rf3: f27",
	/* 173 */	"rf3: f28",
	/* 174 */	"rf3: f29",
	/* 175 */	"rf3: f30",
	/* 176 */	"rf3: f31",
	/* 177 */	"rf3: fp0",
	/* 178 */	"const: INT",
	/* 179 */	"rf3: temp0",
	/* 180 */	"rf3: temp1",
	/* 181 */	"rf3: temp2",
	/* 182 */	"rf3: temp3",
	/* 183 */	"rf3: temp4",
	/* 184 */	"rf3: temp5",
	/* 185 */	"rf3: temp6",
	/* 186 */	"rf3: temp7",
	/* 187 */	"rf3: temp8",
	/* 188 */	"rf3: temp9",
	/* 189 */	"rf3: temp10",
	/* 190 */	"rf3: R26",
	/* 191 */	"rf3: R27",
	/* 192 */	"rf3: R28",
	/* 193 */	"rf3: R29",
	/* 194 */	"rf3: R30",
	/* 195 */	"rf3: R31",
	/* 196 */	"rf3: isel_label",
	/* 197 */	"const_label: const",
	/* 198 */	"const_label: isel_label",
	/* 199 */	"float_const: FLOAT",
	/* 200 */	"expr: addu(def,def)",
	/* 201 */	"expr: subu(def,def)",
	/* 202 */	"expr: lw(def,def)",
	/* 203 */	"expr: sw(def,def)",
	/* 204 */	"expr: move(def)",
	/* 205 */	"expr: srl(def,def)",
	/* 206 */	"expr: sra(def,def)",
	/* 207 */	"expr: mul_d(def,def)",
	/* 208 */	"expr: add_d(def,def)",
	/* 209 */	"expr: sub_d(def,def)",
	/* 210 */	"expr: la(def)",
	/* 211 */	"expr: sge(def,def)",
	/* 212 */	"expr: slt(def,def)",
	/* 213 */	"expr: sle(def,def)",
	/* 214 */	"expr: sgt(def,def)",
	/* 215 */	"expr: trunc_w_d(def)",
	/* 216 */	"expr: li(def)",
	/* 217 */	"expr: mtc1(def)",
	/* 218 */	"expr: cvt_d_w(def)",
	/* 219 */	"expr: and(def,def)",
	/* 220 */	"expr: cvt_s_d(def)",
	/* 221 */	"expr: cvt_d_s(def)",
	/* 222 */	"expr: div_d(def,def)",
	/* 223 */	"expr: bnez(def,def)",
	/* 224 */	"expr: add_s(def,def)",
	/* 225 */	"expr: sub_s(def,def)",
	/* 226 */	"expr: mul_s(def,def)",
	/* 227 */	"expr: div_s(def,def)",
	/* 228 */	"expr: l_d(def,def)",
	/* 229 */	"expr: s_d(def,def)",
	/* 230 */	"expr: jal(def)",
	/* 231 */	"expr: jr(def)",
	/* 232 */	"expr: mov_d(def)",
	/* 233 */	"expr: mfc1(def)",
	/* 234 */	"expr: li_d(def)",
	/* 235 */	"expr: l_s(def,def)",
	/* 236 */	"expr: s_s(def,def)",
	/* 237 */	"expr: cvt_s_w(def)",
	/* 238 */	"expr: trunc_w_s(def)",
	/* 239 */	"expr: li_s(def)",
	/* 240 */	"expr: sne(def,def)",
	/* 241 */	"expr: seq(def,def)",
	/* 242 */	"expr: sll(def,def)",
	/* 243 */	"expr: sla(def,def)",
	/* 244 */	"expr: j(def)",
	/* 245 */	"expr: ori(def,def)",
	/* 246 */	"expr: andi(def,def)",
	/* 247 */	"expr: xori(def,def)",
	/* 248 */	"expr: mult(def,def)",
	/* 249 */	"expr: mflo(def)",
	/* 250 */	"expr: lbu(def,def)",
	/* 251 */	"expr: lb(def,def)",
	/* 252 */	"expr: sb(def,def)",
	/* 253 */	"expr: sbu(def,def)",
	/* 254 */	"expr: lhu(def,def)",
	/* 255 */	"expr: lh(def,def)",
	/* 256 */	"expr: sh(def,def)",
	/* 257 */	"expr: shu(def,def)",
	/* 258 */	"expr: sgeu(def,def)",
	/* 259 */	"expr: sltu(def,def)",
	/* 260 */	"expr: sleu(def,def)",
	/* 261 */	"expr: sgtu(def,def)",
	/* 262 */	"expr: div(def,def)",
	/* 263 */	"expr: mfhi(def)",
	/* 264 */	"expr: or(def,def)",
	/* 265 */	"expr: la2(def,def)",
	/* 266 */	"expr: mov_s(def)",
	/* 267 */	"expr: c_gt_d(def,def)",
	/* 268 */	"expr: c_ge_d(def,def)",
	/* 269 */	"expr: c_lt_d(def,def)",
	/* 270 */	"expr: c_le_d(def,def)",
	/* 271 */	0,
	/* 272 */	0,
	/* 273 */	0,
	/* 274 */	0,
	/* 275 */	0,
	/* 276 */	0,
	/* 277 */	0,
	/* 278 */	0,
	/* 279 */	0,
	/* 280 */	0,
	/* 281 */	0,
	/* 282 */	0,
	/* 283 */	0,
	/* 284 */	0,
	/* 285 */	0,
	/* 286 */	0,
	/* 287 */	0,
	/* 288 */	0,
	/* 289 */	0,
	/* 290 */	0,
	/* 291 */	0,
	/* 292 */	0,
	/* 293 */	0,
	/* 294 */	0,
	/* 295 */	0,
	/* 296 */	0,
	/* 297 */	0,
	/* 298 */	0,
	/* 299 */	0,
	/* 300 */	"def: float_const",
	/* 301 */	"rf3: hilo0",
};

static short isel_decode_def[] = {
	0,
	1,
	2,
	3,
	4,
	300,
};

static short isel_decode_reg[] = {
	0,
	114,
	115,
	142,
};

static short isel_decode_expr[] = {
	0,
	5,
	6,
	7,
	8,
	9,
	10,
	11,
	12,
	13,
	14,
	15,
	16,
	17,
	18,
	19,
	20,
	21,
	22,
	23,
	24,
	25,
	26,
	27,
	28,
	29,
	30,
	31,
	32,
	33,
	34,
	35,
	36,
	37,
	38,
	39,
	40,
	41,
	42,
	43,
	44,
	45,
	46,
	47,
	48,
	49,
	50,
	51,
	52,
	53,
	54,
	55,
	56,
	57,
	58,
	59,
	60,
	61,
	62,
	63,
	64,
	65,
	66,
	67,
	68,
	69,
	70,
	71,
	72,
	73,
	74,
	75,
	76,
	77,
	78,
	79,
	80,
	81,
	200,
	201,
	202,
	203,
	204,
	205,
	206,
	207,
	208,
	209,
	210,
	211,
	212,
	213,
	214,
	215,
	216,
	217,
	218,
	219,
	220,
	221,
	222,
	223,
	224,
	225,
	226,
	227,
	228,
	229,
	230,
	231,
	232,
	233,
	234,
	235,
	236,
	237,
	238,
	239,
	240,
	241,
	242,
	243,
	244,
	245,
	246,
	247,
	248,
	249,
	250,
	251,
	252,
	253,
	254,
	255,
	256,
	257,
	258,
	259,
	260,
	261,
	262,
	263,
	264,
	265,
	266,
	267,
	268,
	269,
	270,
};

static short isel_decode_const[] = {
	0,
	178,
};

static short isel_decode_float_const[] = {
	0,
	199,
};

static short isel_decode_const_label[] = {
	0,
	197,
	198,
	113,
};

static short isel_decode_rf1[] = {
	0,
	116,
	117,
	118,
	119,
	120,
	121,
	122,
	123,
};

static short isel_decode_rf2[] = {
	0,
	124,
	125,
	126,
	127,
	128,
	129,
	130,
	131,
};

static short isel_decode_rf3[] = {
	0,
	132,
	133,
	134,
	135,
	136,
	137,
	138,
	139,
	140,
	141,
	190,
	191,
	192,
	193,
	194,
	195,
	196,
	143,
	144,
	145,
	146,
	147,
	148,
	149,
	150,
	151,
	152,
	153,
	154,
	155,
	156,
	157,
	158,
	159,
	160,
	161,
	162,
	163,
	164,
	165,
	166,
	167,
	168,
	169,
	170,
	171,
	172,
	173,
	174,
	175,
	176,
	177,
	301,
	179,
	180,
	181,
	182,
	183,
	184,
	185,
	186,
	187,
	188,
	189,
};

int isel_rule(STATE_TYPE state, int goalnt) {
	isel_assert(goalnt >= 1 && goalnt <= 9, PANIC("Bad goal nonterminal %d in isel_rule\n", goalnt));
	if (!state)
		return 0;
	switch (goalnt) {
	case isel_def_NT:	return isel_decode_def[((struct isel_state *)state)->rule.isel_def];
	case isel_reg_NT:	return isel_decode_reg[((struct isel_state *)state)->rule.isel_reg];
	case isel_expr_NT:	return isel_decode_expr[((struct isel_state *)state)->rule.isel_expr];
	case isel_const_NT:	return isel_decode_const[((struct isel_state *)state)->rule.isel_const];
	case isel_float_const_NT:	return isel_decode_float_const[((struct isel_state *)state)->rule.isel_float_const];
	case isel_const_label_NT:	return isel_decode_const_label[((struct isel_state *)state)->rule.isel_const_label];
	case isel_rf1_NT:	return isel_decode_rf1[((struct isel_state *)state)->rule.isel_rf1];
	case isel_rf2_NT:	return isel_decode_rf2[((struct isel_state *)state)->rule.isel_rf2];
	case isel_rf3_NT:	return isel_decode_rf3[((struct isel_state *)state)->rule.isel_rf3];
	default:
		isel_assert(0, PANIC("Bad goal nonterminal %d in isel_rule\n", goalnt));
	}
	return 0;
}

static void isel_closure_reg(struct isel_state *, int);
static void isel_closure_const(struct isel_state *, int);
static void isel_closure_float_const(struct isel_state *, int);
static void isel_closure_rf1(struct isel_state *, int);
static void isel_closure_rf2(struct isel_state *, int);
static void isel_closure_rf3(struct isel_state *, int);

static void isel_closure_reg(struct isel_state *p, int c) {
	if (c + 0 < p->cost[isel_def_NT]) {
		p->cost[isel_def_NT] = c + 0;
		p->rule.isel_def = 2;
	}
}

static void isel_closure_const(struct isel_state *p, int c) {
	if (c + 0 < p->cost[isel_const_label_NT]) {
		p->cost[isel_const_label_NT] = c + 0;
		p->rule.isel_const_label = 1;
	}
	if (c + 0 < p->cost[isel_def_NT]) {
		p->cost[isel_def_NT] = c + 0;
		p->rule.isel_def = 3;
	}
}

static void isel_closure_float_const(struct isel_state *p, int c) {
	if (c + 0 < p->cost[isel_const_label_NT]) {
		p->cost[isel_const_label_NT] = c + 0;
		p->rule.isel_const_label = 3;
	}
	if (c + 0 < p->cost[isel_def_NT]) {
		p->cost[isel_def_NT] = c + 0;
		p->rule.isel_def = 5;
	}
}

static void isel_closure_rf1(struct isel_state *p, int c) {
	if (c + 0 < p->cost[isel_reg_NT]) {
		p->cost[isel_reg_NT] = c + 0;
		p->rule.isel_reg = 1;
		isel_closure_reg(p, c + 0);
	}
}

static void isel_closure_rf2(struct isel_state *p, int c) {
	if (c + 0 < p->cost[isel_reg_NT]) {
		p->cost[isel_reg_NT] = c + 0;
		p->rule.isel_reg = 2;
		isel_closure_reg(p, c + 0);
	}
}

static void isel_closure_rf3(struct isel_state *p, int c) {
	if (c + 0 < p->cost[isel_reg_NT]) {
		p->cost[isel_reg_NT] = c + 0;
		p->rule.isel_reg = 3;
		isel_closure_reg(p, c + 0);
	}
}

STATE_TYPE isel_state(int op, STATE_TYPE left, STATE_TYPE right) {
	int c;
	struct isel_state *p, *l = (struct isel_state *)left,
		*r = (struct isel_state *)right;

	assert(sizeof (STATE_TYPE) >= sizeof (void *));
	if (isel_arity[op] > 0) {
		p = (struct isel_state *)ALLOC(sizeof *p);
		isel_assert(p, PANIC("ALLOC returned NULL in isel_state\n"));
		p->op = op;
		p->left = l;
		p->right = r;
		p->rule.isel_def = 0;
		p->cost[1] =
		p->cost[2] =
		p->cost[3] =
		p->cost[4] =
		p->cost[5] =
		p->cost[6] =
		p->cost[7] =
		p->cost[8] =
		p->cost[9] =
			32767;
	}
	switch (op) {
	case 1: /* IADD */
		assert(l && r);
		{	/* expr: IADD(const_label,def) */
			c = l->cost[isel_const_label_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 76;
			}
		}
		{	/* expr: IADD(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 1;
			}
		}
		break;
	case 2: /* IGE */
		assert(l && r);
		{	/* expr: IGE(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 1;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 13;
			}
		}
		break;
	case 3: /* IGT */
		assert(l && r);
		{	/* expr: IGT(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 1;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 16;
			}
		}
		break;
	case 4: /* ILE */
		assert(l && r);
		{	/* expr: ILE(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 1;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 15;
			}
		}
		break;
	case 5: /* IASH */
		assert(l && r);
		{	/* expr: IASH(def,const) */
			c = l->cost[isel_def_NT] + r->cost[isel_const_NT] + 1;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 7;
			}
		}
		break;
	case 6: /* ISUB */
		assert(l && r);
		{	/* expr: ISUB(const_label,def) */
			c = l->cost[isel_const_label_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 77;
			}
		}
		{	/* expr: ISUB(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 2;
			}
		}
		break;
	case 7: /* ILSH */
		assert(l && r);
		{	/* expr: ILSH(def,const) */
			c = l->cost[isel_def_NT] + r->cost[isel_const_NT] + 1;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 6;
			}
		}
		break;
	case 8: /* ILT */
		assert(l && r);
		{	/* expr: ILT(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 1;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 14;
			}
		}
		break;
	case 9: /* NOP */
		{
			static struct isel_state z = { 9, 0, 0,
				{	0,
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
				},{
					0,
					0,
					0,
					0,
					0,
					0,
					0,
					0,
					0,
				}
			};
			return (STATE_TYPE)&z;
		}
	case 10: /* ICONSTANT */
		assert(l);
		{	/* expr: ICONSTANT(const) */
			c = l->cost[isel_const_NT] + 1;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 42;
			}
		}
		{	/* expr: ICONSTANT(const_label) */
			c = l->cost[isel_const_label_NT] + 1;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 11;
			}
		}
		break;
	case 11: /* IASSIGN */
		assert(l);
		{	/* expr: IASSIGN(def) */
			c = l->cost[isel_def_NT] + 1;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 5;
			}
		}
		break;
	case 12: /* IF */
		{
			static struct isel_state z = { 12, 0, 0,
				{	0,
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
				},{
					0,
					0,
					0,
					0,
					0,
					0,
					0,
					0,
					0,
				}
			};
			return (STATE_TYPE)&z;
		}
	case 13: /* IGOTO */
		{
			static struct isel_state z = { 13, 0, 0,
				{	0,
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
				},{
					0,
					0,
					0,
					0,
					0,
					0,
					0,
					0,
					0,
				}
			};
			return (STATE_TYPE)&z;
		}
	case 14: /* IVLOAD */
		assert(l && r);
		{	/* expr: IVLOAD(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 3;
			}
		}
		break;
	case 15: /* DVLOAD */
		assert(l && r);
		{	/* expr: DVLOAD(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 38;
			}
		}
		break;
	case 16: /* IVSTORE */
		assert(l && r);
		{	/* expr: IVSTORE(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 4;
			}
		}
		break;
	case 17: /* DVSTORE */
		assert(l && r);
		{	/* expr: DVSTORE(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 39;
			}
		}
		break;
	case 18: /* ASSIGN */
		assert(l);
		{	/* expr: ASSIGN(def) */
			c = l->cost[isel_def_NT] + 1;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 12;
			}
		}
		break;
	case 19: /* DCONSTANT */
		assert(l);
		{	/* expr: DCONSTANT(float_const) */
			c = l->cost[isel_float_const_NT] + 1;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 53;
			}
		}
		{	/* expr: DCONSTANT(const_label) */
			c = l->cost[isel_const_label_NT] + 1;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 20;
			}
		}
		break;
	case 20: /* DADD */
		assert(l && r);
		{	/* expr: DADD(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 3;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 9;
			}
		}
		break;
	case 21: /* FASSIGN */
		assert(l);
		{	/* expr: FASSIGN(def) */
			c = l->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 49;
			}
		}
		break;
	case 22: /* DMUL */
		assert(l && r);
		{	/* expr: DMUL(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 4;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 8;
			}
		}
		break;
	case 23: /* DSUB */
		assert(l && r);
		{	/* expr: DSUB(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 3;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 10;
			}
		}
		break;
	case 24: /* DMTC1 */
		assert(l);
		{	/* expr: DMTC1(def) */
			c = l->cost[isel_def_NT] + 1;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 17;
			}
		}
		break;
	case 25: /* GOTO */
		{
			static struct isel_state z = { 25, 0, 0,
				{	0,
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
				},{
					0,
					0,
					0,
					0,
					0,
					0,
					0,
					0,
					0,
				}
			};
			return (STATE_TYPE)&z;
		}
	case 26: /* TRUNCID */
		assert(l);
		{	/* expr: TRUNCID(def) */
			c = l->cost[isel_def_NT] + 1;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 18;
			}
		}
		break;
	case 27: /* MFC1 */
		assert(l);
		{	/* expr: MFC1(def) */
			c = l->cost[isel_def_NT] + 1;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 19;
			}
		}
		break;
	case 28: /* MTC1 */
		assert(l);
		{	/* expr: MTC1(def) */
			c = l->cost[isel_def_NT] + 1;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 21;
			}
		}
		break;
	case 29: /* CVTDI */
		assert(l);
		{	/* expr: CVTDI(def) */
			c = l->cost[isel_def_NT] + 1;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 22;
			}
		}
		break;
	case 30: /* ILAND */
		assert(l && r);
		{	/* expr: ILAND(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 1;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 23;
			}
		}
		break;
	case 31: /* DASSIGN */
		assert(l);
		{	/* expr: DASSIGN(def) */
			c = l->cost[isel_def_NT] + 1;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 24;
			}
		}
		break;
	case 32: /* DGE */
		assert(l && r);
		{	/* expr: DGE(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 1;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 25;
			}
		}
		break;
	case 33: /* DLT */
		assert(l && r);
		{	/* expr: DLT(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 1;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 26;
			}
		}
		break;
	case 34: /* DLE */
		assert(l && r);
		{	/* expr: DLE(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 1;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 27;
			}
		}
		break;
	case 35: /* DGT */
		assert(l && r);
		{	/* expr: DGT(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 1;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 28;
			}
		}
		break;
	case 36: /* CVTSD */
		assert(l);
		{	/* expr: CVTSD(def) */
			c = l->cost[isel_def_NT] + 1;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 29;
			}
		}
		break;
	case 37: /* CVTDS */
		assert(l);
		{	/* expr: CVTDS(def) */
			c = l->cost[isel_def_NT] + 1;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 30;
			}
		}
		break;
	case 38: /* DMFC1 */
		assert(l);
		{	/* expr: DMFC1(def) */
			c = l->cost[isel_def_NT] + 1;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 31;
			}
		}
		break;
	case 39: /* DDIV */
		assert(l && r);
		{	/* expr: DDIV(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 3;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 32;
			}
		}
		break;
	case 40: /* DEQ */
		assert(l && r);
		{	/* expr: DEQ(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 33;
			}
		}
		break;
	case 41: /* FADD */
		assert(l && r);
		{	/* expr: FADD(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 3;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 34;
			}
		}
		break;
	case 42: /* FSUB */
		assert(l && r);
		{	/* expr: FSUB(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 3;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 35;
			}
		}
		break;
	case 43: /* FMUL */
		assert(l && r);
		{	/* expr: FMUL(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 3;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 36;
			}
		}
		break;
	case 44: /* FDIV */
		assert(l && r);
		{	/* expr: FDIV(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 3;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 37;
			}
		}
		break;
	case 45: /* FVLOAD */
		assert(l && r);
		{	/* expr: FVLOAD(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 40;
			}
		}
		break;
	case 46: /* FVSTORE */
		assert(l && r);
		{	/* expr: FVSTORE(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 41;
			}
		}
		break;
	case 47: /* CALL */
		{
			static struct isel_state z = { 47, 0, 0,
				{	0,
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
				},{
					0,
					0,
					0,
					0,
					0,
					0,
					0,
					0,
					0,
				}
			};
			return (STATE_TYPE)&z;
		}
	case 48: /* RETURN */
		{
			static struct isel_state z = { 48, 0, 0,
				{	0,
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
				},{
					0,
					0,
					0,
					0,
					0,
					0,
					0,
					0,
					0,
				}
			};
			return (STATE_TYPE)&z;
		}
	case 49: /* IRASH */
		assert(l && r);
		{	/* expr: IRASH(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 43;
			}
		}
		break;
	case 50: /* ILASH */
		assert(l && r);
		{	/* expr: ILASH(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 44;
			}
		}
		break;
	case 51: /* IRLSH */
		assert(l && r);
		{	/* expr: IRLSH(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 45;
			}
		}
		break;
	case 52: /* ILLSH */
		assert(l && r);
		{	/* expr: ILLSH(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 46;
			}
		}
		break;
	case 53: /* FCONSTANT */
		assert(l);
		{	/* expr: FCONSTANT(float_const) */
			c = l->cost[isel_float_const_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 48;
			}
		}
		{	/* expr: FCONSTANT(const_label) */
			c = l->cost[isel_const_label_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 47;
			}
		}
		break;
	case 54: /* INE */
		assert(l && r);
		{	/* expr: INE(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 50;
			}
		}
		break;
	case 55: /* CVTSI */
		assert(l);
		{	/* expr: CVTSI(def) */
			c = l->cost[isel_def_NT] + 1;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 52;
			}
		}
		break;
	case 56: /* TRUNCIS */
		assert(l);
		{	/* expr: TRUNCIS(def) */
			c = l->cost[isel_def_NT] + 1;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 51;
			}
		}
		break;
	case 58: /* IEQ */
		assert(l && r);
		{	/* expr: IEQ(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 1;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 54;
			}
		}
		break;
	case 59: /* IOR */
		assert(l && r);
		{	/* expr: IOR(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 1;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 74;
			}
		}
		{	/* expr: IOR(def,const) */
			c = l->cost[isel_def_NT] + r->cost[isel_const_NT] + 1;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 55;
			}
		}
		break;
	case 60: /* IAND */
		assert(l && r);
		{	/* expr: IAND(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 1;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 75;
			}
		}
		{	/* expr: IAND(def,const) */
			c = l->cost[isel_def_NT] + r->cost[isel_const_NT] + 1;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 56;
			}
		}
		break;
	case 61: /* IXOR */
		assert(l && r);
		{	/* expr: IXOR(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 1;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 57;
			}
		}
		break;
	case 62: /* IMUL */
		assert(l && r);
		{	/* expr: IMUL(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 1;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 58;
			}
		}
		break;
	case 63: /* MFLO */
		assert(l);
		{	/* expr: MFLO(def) */
			c = l->cost[isel_def_NT] + 1;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 59;
			}
		}
		break;
	case 64: /* QIVLOADU */
		assert(l && r);
		{	/* expr: QIVLOADU(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 60;
			}
		}
		break;
	case 65: /* QIVLOAD */
		assert(l && r);
		{	/* expr: QIVLOAD(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 61;
			}
		}
		break;
	case 66: /* QIVSTORE */
		assert(l && r);
		{	/* expr: QIVSTORE(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 62;
			}
		}
		break;
	case 67: /* QIVSTOREU */
		assert(l && r);
		{	/* expr: QIVSTOREU(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 63;
			}
		}
		break;
	case 68: /* HIVLOADU */
		assert(l && r);
		{	/* expr: HIVLOADU(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 64;
			}
		}
		break;
	case 69: /* HIVLOAD */
		assert(l && r);
		{	/* expr: HIVLOAD(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 65;
			}
		}
		break;
	case 70: /* HIVSTORE */
		assert(l && r);
		{	/* expr: HIVSTORE(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 66;
			}
		}
		break;
	case 71: /* HIVSTOREU */
		assert(l && r);
		{	/* expr: HIVSTOREU(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 67;
			}
		}
		break;
	case 72: /* IGEU */
		assert(l && r);
		{	/* expr: IGEU(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 1;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 68;
			}
		}
		break;
	case 73: /* IGTU */
		assert(l && r);
		{	/* expr: IGTU(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 1;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 71;
			}
		}
		break;
	case 74: /* ILEU */
		assert(l && r);
		{	/* expr: ILEU(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 1;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 70;
			}
		}
		break;
	case 75: /* ILTU */
		assert(l && r);
		{	/* expr: ILTU(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 1;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 69;
			}
		}
		break;
	case 76: /* IDIV */
		assert(l && r);
		{	/* expr: IDIV(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 1;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 72;
			}
		}
		break;
	case 77: /* MFHI */
		assert(l);
		{	/* expr: MFHI(def) */
			c = l->cost[isel_def_NT] + 1;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 73;
			}
		}
		break;
	case 101: /* R0 */
		{
			static struct isel_state z = { 101, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf1 */
					32767,
					32767,
					32767,
					32767,
					0,	/* rf1: R0 */
					32767,
					32767,
				},{
					2,	/* def: reg */
					1,	/* reg: rf1 */
					0,
					0,
					0,
					0,
					1,	/* rf1: R0 */
					0,
					0,
				}
			};
			return (STATE_TYPE)&z;
		}
	case 102: /* R1 */
		{
			static struct isel_state z = { 102, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf1 */
					32767,
					32767,
					32767,
					32767,
					0,	/* rf1: R1 */
					32767,
					32767,
				},{
					2,	/* def: reg */
					1,	/* reg: rf1 */
					0,
					0,
					0,
					0,
					2,	/* rf1: R1 */
					0,
					0,
				}
			};
			return (STATE_TYPE)&z;
		}
	case 103: /* R2 */
		{
			static struct isel_state z = { 103, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf1 */
					32767,
					32767,
					32767,
					32767,
					0,	/* rf1: R2 */
					32767,
					32767,
				},{
					2,	/* def: reg */
					1,	/* reg: rf1 */
					0,
					0,
					0,
					0,
					3,	/* rf1: R2 */
					0,
					0,
				}
			};
			return (STATE_TYPE)&z;
		}
	case 104: /* R3 */
		{
			static struct isel_state z = { 104, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf1 */
					32767,
					32767,
					32767,
					32767,
					0,	/* rf1: R3 */
					32767,
					32767,
				},{
					2,	/* def: reg */
					1,	/* reg: rf1 */
					0,
					0,
					0,
					0,
					4,	/* rf1: R3 */
					0,
					0,
				}
			};
			return (STATE_TYPE)&z;
		}
	case 105: /* R4 */
		{
			static struct isel_state z = { 105, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf1 */
					32767,
					32767,
					32767,
					32767,
					0,	/* rf1: R4 */
					32767,
					32767,
				},{
					2,	/* def: reg */
					1,	/* reg: rf1 */
					0,
					0,
					0,
					0,
					5,	/* rf1: R4 */
					0,
					0,
				}
			};
			return (STATE_TYPE)&z;
		}
	case 106: /* R5 */
		{
			static struct isel_state z = { 106, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf1 */
					32767,
					32767,
					32767,
					32767,
					0,	/* rf1: R5 */
					32767,
					32767,
				},{
					2,	/* def: reg */
					1,	/* reg: rf1 */
					0,
					0,
					0,
					0,
					6,	/* rf1: R5 */
					0,
					0,
				}
			};
			return (STATE_TYPE)&z;
		}
	case 107: /* R6 */
		{
			static struct isel_state z = { 107, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf1 */
					32767,
					32767,
					32767,
					32767,
					0,	/* rf1: R6 */
					32767,
					32767,
				},{
					2,	/* def: reg */
					1,	/* reg: rf1 */
					0,
					0,
					0,
					0,
					7,	/* rf1: R6 */
					0,
					0,
				}
			};
			return (STATE_TYPE)&z;
		}
	case 108: /* R7 */
		{
			static struct isel_state z = { 108, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf1 */
					32767,
					32767,
					32767,
					32767,
					0,	/* rf1: R7 */
					32767,
					32767,
				},{
					2,	/* def: reg */
					1,	/* reg: rf1 */
					0,
					0,
					0,
					0,
					8,	/* rf1: R7 */
					0,
					0,
				}
			};
			return (STATE_TYPE)&z;
		}
	case 109: /* R8 */
		{
			static struct isel_state z = { 109, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf2 */
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf2: R8 */
					32767,
				},{
					2,	/* def: reg */
					2,	/* reg: rf2 */
					0,
					0,
					0,
					0,
					0,
					1,	/* rf2: R8 */
					0,
				}
			};
			return (STATE_TYPE)&z;
		}
	case 110: /* R9 */
		{
			static struct isel_state z = { 110, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf2 */
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf2: R9 */
					32767,
				},{
					2,	/* def: reg */
					2,	/* reg: rf2 */
					0,
					0,
					0,
					0,
					0,
					2,	/* rf2: R9 */
					0,
				}
			};
			return (STATE_TYPE)&z;
		}
	case 111: /* R10 */
		{
			static struct isel_state z = { 111, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf2 */
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf2: R10 */
					32767,
				},{
					2,	/* def: reg */
					2,	/* reg: rf2 */
					0,
					0,
					0,
					0,
					0,
					3,	/* rf2: R10 */
					0,
				}
			};
			return (STATE_TYPE)&z;
		}
	case 112: /* R11 */
		{
			static struct isel_state z = { 112, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf2 */
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf2: R11 */
					32767,
				},{
					2,	/* def: reg */
					2,	/* reg: rf2 */
					0,
					0,
					0,
					0,
					0,
					4,	/* rf2: R11 */
					0,
				}
			};
			return (STATE_TYPE)&z;
		}
	case 113: /* R12 */
		{
			static struct isel_state z = { 113, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf2 */
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf2: R12 */
					32767,
				},{
					2,	/* def: reg */
					2,	/* reg: rf2 */
					0,
					0,
					0,
					0,
					0,
					5,	/* rf2: R12 */
					0,
				}
			};
			return (STATE_TYPE)&z;
		}
	case 114: /* R13 */
		{
			static struct isel_state z = { 114, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf2 */
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf2: R13 */
					32767,
				},{
					2,	/* def: reg */
					2,	/* reg: rf2 */
					0,
					0,
					0,
					0,
					0,
					6,	/* rf2: R13 */
					0,
				}
			};
			return (STATE_TYPE)&z;
		}
	case 115: /* R14 */
		{
			static struct isel_state z = { 115, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf2 */
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf2: R14 */
					32767,
				},{
					2,	/* def: reg */
					2,	/* reg: rf2 */
					0,
					0,
					0,
					0,
					0,
					7,	/* rf2: R14 */
					0,
				}
			};
			return (STATE_TYPE)&z;
		}
	case 116: /* R15 */
		{
			static struct isel_state z = { 116, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf2 */
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf2: R15 */
					32767,
				},{
					2,	/* def: reg */
					2,	/* reg: rf2 */
					0,
					0,
					0,
					0,
					0,
					8,	/* rf2: R15 */
					0,
				}
			};
			return (STATE_TYPE)&z;
		}
	case 117: /* R16 */
		{
			static struct isel_state z = { 117, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: R16 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					1,	/* rf3: R16 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 118: /* R17 */
		{
			static struct isel_state z = { 118, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: R17 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					2,	/* rf3: R17 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 119: /* R18 */
		{
			static struct isel_state z = { 119, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: R18 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					3,	/* rf3: R18 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 120: /* R19 */
		{
			static struct isel_state z = { 120, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: R19 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					4,	/* rf3: R19 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 121: /* R20 */
		{
			static struct isel_state z = { 121, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: R20 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					5,	/* rf3: R20 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 122: /* R21 */
		{
			static struct isel_state z = { 122, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: R21 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					6,	/* rf3: R21 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 123: /* R22 */
		{
			static struct isel_state z = { 123, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: R22 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					7,	/* rf3: R22 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 124: /* R23 */
		{
			static struct isel_state z = { 124, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: R23 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					8,	/* rf3: R23 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 125: /* R24 */
		{
			static struct isel_state z = { 125, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: R24 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					9,	/* rf3: R24 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 126: /* R25 */
		{
			static struct isel_state z = { 126, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: R25 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					10,	/* rf3: R25 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 127: /* sp0 */
		{
			static struct isel_state z = { 127, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: sp0 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					18,	/* rf3: sp0 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 128: /* cc0 */
		{
			static struct isel_state z = { 128, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: cc0 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					19,	/* rf3: cc0 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 129: /* f0 */
		{
			static struct isel_state z = { 129, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: f0 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					20,	/* rf3: f0 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 130: /* f1 */
		{
			static struct isel_state z = { 130, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: f1 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					21,	/* rf3: f1 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 131: /* f2 */
		{
			static struct isel_state z = { 131, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: f2 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					22,	/* rf3: f2 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 132: /* f3 */
		{
			static struct isel_state z = { 132, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: f3 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					23,	/* rf3: f3 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 133: /* f4 */
		{
			static struct isel_state z = { 133, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: f4 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					24,	/* rf3: f4 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 134: /* f5 */
		{
			static struct isel_state z = { 134, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: f5 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					25,	/* rf3: f5 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 135: /* f6 */
		{
			static struct isel_state z = { 135, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: f6 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					26,	/* rf3: f6 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 136: /* f7 */
		{
			static struct isel_state z = { 136, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: f7 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					27,	/* rf3: f7 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 137: /* f8 */
		{
			static struct isel_state z = { 137, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: f8 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					28,	/* rf3: f8 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 138: /* f9 */
		{
			static struct isel_state z = { 138, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: f9 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					29,	/* rf3: f9 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 139: /* f10 */
		{
			static struct isel_state z = { 139, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: f10 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					30,	/* rf3: f10 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 140: /* f11 */
		{
			static struct isel_state z = { 140, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: f11 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					31,	/* rf3: f11 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 141: /* f12 */
		{
			static struct isel_state z = { 141, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: f12 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					32,	/* rf3: f12 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 142: /* f13 */
		{
			static struct isel_state z = { 142, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: f13 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					33,	/* rf3: f13 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 143: /* f14 */
		{
			static struct isel_state z = { 143, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: f14 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					34,	/* rf3: f14 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 144: /* f15 */
		{
			static struct isel_state z = { 144, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: f15 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					35,	/* rf3: f15 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 145: /* f16 */
		{
			static struct isel_state z = { 145, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: f16 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					36,	/* rf3: f16 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 146: /* f17 */
		{
			static struct isel_state z = { 146, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: f17 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					37,	/* rf3: f17 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 147: /* f18 */
		{
			static struct isel_state z = { 147, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: f18 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					38,	/* rf3: f18 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 148: /* f19 */
		{
			static struct isel_state z = { 148, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: f19 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					39,	/* rf3: f19 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 149: /* f20 */
		{
			static struct isel_state z = { 149, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: f20 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					40,	/* rf3: f20 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 150: /* f21 */
		{
			static struct isel_state z = { 150, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: f21 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					41,	/* rf3: f21 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 151: /* f22 */
		{
			static struct isel_state z = { 151, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: f22 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					42,	/* rf3: f22 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 152: /* f23 */
		{
			static struct isel_state z = { 152, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: f23 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					43,	/* rf3: f23 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 153: /* f24 */
		{
			static struct isel_state z = { 153, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: f24 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					44,	/* rf3: f24 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 154: /* f25 */
		{
			static struct isel_state z = { 154, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: f25 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					45,	/* rf3: f25 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 155: /* f26 */
		{
			static struct isel_state z = { 155, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: f26 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					46,	/* rf3: f26 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 156: /* f27 */
		{
			static struct isel_state z = { 156, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: f27 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					47,	/* rf3: f27 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 157: /* f28 */
		{
			static struct isel_state z = { 157, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: f28 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					48,	/* rf3: f28 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 158: /* f29 */
		{
			static struct isel_state z = { 158, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: f29 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					49,	/* rf3: f29 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 159: /* f30 */
		{
			static struct isel_state z = { 159, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: f30 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					50,	/* rf3: f30 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 160: /* f31 */
		{
			static struct isel_state z = { 160, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: f31 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					51,	/* rf3: f31 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 161: /* fp0 */
		{
			static struct isel_state z = { 161, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: fp0 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					52,	/* rf3: fp0 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 162: /* temp0 */
		{
			static struct isel_state z = { 162, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: temp0 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					54,	/* rf3: temp0 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 163: /* temp1 */
		{
			static struct isel_state z = { 163, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: temp1 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					55,	/* rf3: temp1 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 164: /* temp2 */
		{
			static struct isel_state z = { 164, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: temp2 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					56,	/* rf3: temp2 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 165: /* temp3 */
		{
			static struct isel_state z = { 165, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: temp3 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					57,	/* rf3: temp3 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 166: /* temp4 */
		{
			static struct isel_state z = { 166, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: temp4 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					58,	/* rf3: temp4 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 167: /* temp5 */
		{
			static struct isel_state z = { 167, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: temp5 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					59,	/* rf3: temp5 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 168: /* temp6 */
		{
			static struct isel_state z = { 168, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: temp6 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					60,	/* rf3: temp6 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 169: /* temp7 */
		{
			static struct isel_state z = { 169, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: temp7 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					61,	/* rf3: temp7 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 170: /* temp8 */
		{
			static struct isel_state z = { 170, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: temp8 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					62,	/* rf3: temp8 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 171: /* temp9 */
		{
			static struct isel_state z = { 171, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: temp9 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					63,	/* rf3: temp9 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 172: /* temp10 */
		{
			static struct isel_state z = { 172, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: temp10 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					64,	/* rf3: temp10 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 173: /* R26 */
		{
			static struct isel_state z = { 173, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: R26 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					11,	/* rf3: R26 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 174: /* R27 */
		{
			static struct isel_state z = { 174, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: R27 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					12,	/* rf3: R27 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 175: /* R28 */
		{
			static struct isel_state z = { 175, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: R28 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					13,	/* rf3: R28 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 176: /* R29 */
		{
			static struct isel_state z = { 176, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: R29 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					14,	/* rf3: R29 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 177: /* R30 */
		{
			static struct isel_state z = { 177, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: R30 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					15,	/* rf3: R30 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 178: /* R31 */
		{
			static struct isel_state z = { 178, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: R31 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					16,	/* rf3: R31 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 179: /* isel_label */
		{
			static struct isel_state z = { 179, 0, 0,
				{	0,
					0,	/* def: isel_label */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					0,	/* const_label: isel_label */
					32767,
					32767,
					0,	/* rf3: isel_label */
				},{
					4,	/* def: isel_label */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					2,	/* const_label: isel_label */
					0,
					0,
					17,	/* rf3: isel_label */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 180: /* hilo0 */
		{
			static struct isel_state z = { 180, 0, 0,
				{	0,
					0,	/* def: reg */
					0,	/* reg: rf3 */
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					0,	/* rf3: hilo0 */
				},{
					2,	/* def: reg */
					3,	/* reg: rf3 */
					0,
					0,
					0,
					0,
					0,
					0,
					53,	/* rf3: hilo0 */
				}
			};
			return (STATE_TYPE)&z;
		}
	case 201: /* DEF */
		assert(l && r);
		{	/* def: DEF(reg,expr) */
			c = l->cost[isel_reg_NT] + r->cost[isel_expr_NT] + 0;
			if (c + 0 < p->cost[isel_def_NT]) {
				p->cost[isel_def_NT] = c + 0;
				p->rule.isel_def = 1;
			}
		}
		break;
	case 202: /* INT */
		{
			static struct isel_state z = { 202, 0, 0,
				{	0,
					0,	/* def: const */
					32767,
					32767,
					0,	/* const: INT */
					32767,
					0,	/* const_label: const */
					32767,
					32767,
					32767,
				},{
					3,	/* def: const */
					0,
					0,
					1,	/* const: INT */
					0,
					1,	/* const_label: const */
					0,
					0,
					0,
				}
			};
			return (STATE_TYPE)&z;
		}
	case 203: /* IND */
		{
			static struct isel_state z = { 203, 0, 0,
				{	0,
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
				},{
					0,
					0,
					0,
					0,
					0,
					0,
					0,
					0,
					0,
				}
			};
			return (STATE_TYPE)&z;
		}
	case 204: /* SRC2 */
		{
			static struct isel_state z = { 204, 0, 0,
				{	0,
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
				},{
					0,
					0,
					0,
					0,
					0,
					0,
					0,
					0,
					0,
				}
			};
			return (STATE_TYPE)&z;
		}
	case 205: /* FLOAT */
		{
			static struct isel_state z = { 205, 0, 0,
				{	0,
					0,	/* def: float_const */
					32767,
					32767,
					32767,
					0,	/* float_const: FLOAT */
					0,	/* const_label: float_const */
					32767,
					32767,
					32767,
				},{
					5,	/* def: float_const */
					0,
					0,
					0,
					1,	/* float_const: FLOAT */
					3,	/* const_label: float_const */
					0,
					0,
					0,
				}
			};
			return (STATE_TYPE)&z;
		}
	case 400: /* NONE */
		{
			static struct isel_state z = { 400, 0, 0,
				{	0,
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
				},{
					0,
					0,
					0,
					0,
					0,
					0,
					0,
					0,
					0,
				}
			};
			return (STATE_TYPE)&z;
		}
	case 401: /* ALU1 */
		{
			static struct isel_state z = { 401, 0, 0,
				{	0,
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
				},{
					0,
					0,
					0,
					0,
					0,
					0,
					0,
					0,
					0,
				}
			};
			return (STATE_TYPE)&z;
		}
	case 402: /* ALU2 */
		{
			static struct isel_state z = { 402, 0, 0,
				{	0,
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
					32767,
				},{
					0,
					0,
					0,
					0,
					0,
					0,
					0,
					0,
					0,
				}
			};
			return (STATE_TYPE)&z;
		}
	case 500: /* addu */
		assert(l && r);
		{	/* expr: addu(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 78;
			}
		}
		break;
	case 501: /* subu */
		assert(l && r);
		{	/* expr: subu(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 79;
			}
		}
		break;
	case 502: /* lw */
		assert(l && r);
		{	/* expr: lw(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 80;
			}
		}
		break;
	case 503: /* sw */
		assert(l && r);
		{	/* expr: sw(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 81;
			}
		}
		break;
	case 504: /* move */
		assert(l);
		{	/* expr: move(def) */
			c = l->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 82;
			}
		}
		break;
	case 505: /* srl */
		assert(l && r);
		{	/* expr: srl(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 83;
			}
		}
		break;
	case 506: /* sra */
		assert(l && r);
		{	/* expr: sra(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 84;
			}
		}
		break;
	case 507: /* mul_d */
		assert(l && r);
		{	/* expr: mul_d(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 85;
			}
		}
		break;
	case 508: /* add_d */
		assert(l && r);
		{	/* expr: add_d(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 86;
			}
		}
		break;
	case 509: /* sub_d */
		assert(l && r);
		{	/* expr: sub_d(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 87;
			}
		}
		break;
	case 510: /* la */
		assert(l);
		{	/* expr: la(def) */
			c = l->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 88;
			}
		}
		break;
	case 511: /* sge */
		assert(l && r);
		{	/* expr: sge(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 89;
			}
		}
		break;
	case 512: /* slt */
		assert(l && r);
		{	/* expr: slt(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 90;
			}
		}
		break;
	case 513: /* sle */
		assert(l && r);
		{	/* expr: sle(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 91;
			}
		}
		break;
	case 514: /* sgt */
		assert(l && r);
		{	/* expr: sgt(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 92;
			}
		}
		break;
	case 515: /* trunc_w_d */
		assert(l);
		{	/* expr: trunc_w_d(def) */
			c = l->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 93;
			}
		}
		break;
	case 516: /* li */
		assert(l);
		{	/* expr: li(def) */
			c = l->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 94;
			}
		}
		break;
	case 517: /* mtc1 */
		assert(l);
		{	/* expr: mtc1(def) */
			c = l->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 95;
			}
		}
		break;
	case 518: /* cvt_d_w */
		assert(l);
		{	/* expr: cvt_d_w(def) */
			c = l->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 96;
			}
		}
		break;
	case 519: /* and */
		assert(l && r);
		{	/* expr: and(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 97;
			}
		}
		break;
	case 520: /* cvt_s_d */
		assert(l);
		{	/* expr: cvt_s_d(def) */
			c = l->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 98;
			}
		}
		break;
	case 521: /* cvt_d_s */
		assert(l);
		{	/* expr: cvt_d_s(def) */
			c = l->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 99;
			}
		}
		break;
	case 522: /* div_d */
		assert(l && r);
		{	/* expr: div_d(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 100;
			}
		}
		break;
	case 523: /* bnez */
		assert(l && r);
		{	/* expr: bnez(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 101;
			}
		}
		break;
	case 524: /* add_s */
		assert(l && r);
		{	/* expr: add_s(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 102;
			}
		}
		break;
	case 525: /* sub_s */
		assert(l && r);
		{	/* expr: sub_s(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 103;
			}
		}
		break;
	case 526: /* mul_s */
		assert(l && r);
		{	/* expr: mul_s(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 104;
			}
		}
		break;
	case 527: /* div_s */
		assert(l && r);
		{	/* expr: div_s(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 105;
			}
		}
		break;
	case 528: /* l_d */
		assert(l && r);
		{	/* expr: l_d(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 106;
			}
		}
		break;
	case 529: /* s_d */
		assert(l && r);
		{	/* expr: s_d(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 107;
			}
		}
		break;
	case 530: /* jal */
		assert(l);
		{	/* expr: jal(def) */
			c = l->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 108;
			}
		}
		break;
	case 531: /* jr */
		assert(l);
		{	/* expr: jr(def) */
			c = l->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 109;
			}
		}
		break;
	case 532: /* mov_d */
		assert(l);
		{	/* expr: mov_d(def) */
			c = l->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 110;
			}
		}
		break;
	case 533: /* mfc1 */
		assert(l);
		{	/* expr: mfc1(def) */
			c = l->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 111;
			}
		}
		break;
	case 534: /* li_d */
		assert(l);
		{	/* expr: li_d(def) */
			c = l->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 112;
			}
		}
		break;
	case 535: /* l_s */
		assert(l && r);
		{	/* expr: l_s(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 113;
			}
		}
		break;
	case 536: /* s_s */
		assert(l && r);
		{	/* expr: s_s(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 114;
			}
		}
		break;
	case 537: /* cvt_s_w */
		assert(l);
		{	/* expr: cvt_s_w(def) */
			c = l->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 115;
			}
		}
		break;
	case 538: /* trunc_w_s */
		assert(l);
		{	/* expr: trunc_w_s(def) */
			c = l->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 116;
			}
		}
		break;
	case 539: /* li_s */
		assert(l);
		{	/* expr: li_s(def) */
			c = l->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 117;
			}
		}
		break;
	case 540: /* sne */
		assert(l && r);
		{	/* expr: sne(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 118;
			}
		}
		break;
	case 541: /* seq */
		assert(l && r);
		{	/* expr: seq(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 119;
			}
		}
		break;
	case 542: /* sll */
		assert(l && r);
		{	/* expr: sll(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 120;
			}
		}
		break;
	case 543: /* sla */
		assert(l && r);
		{	/* expr: sla(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 121;
			}
		}
		break;
	case 544: /* j */
		assert(l);
		{	/* expr: j(def) */
			c = l->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 122;
			}
		}
		break;
	case 545: /* ori */
		assert(l && r);
		{	/* expr: ori(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 123;
			}
		}
		break;
	case 546: /* andi */
		assert(l && r);
		{	/* expr: andi(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 124;
			}
		}
		break;
	case 547: /* xori */
		assert(l && r);
		{	/* expr: xori(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 125;
			}
		}
		break;
	case 548: /* mult */
		assert(l && r);
		{	/* expr: mult(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 126;
			}
		}
		break;
	case 549: /* mflo */
		assert(l);
		{	/* expr: mflo(def) */
			c = l->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 127;
			}
		}
		break;
	case 550: /* lbu */
		assert(l && r);
		{	/* expr: lbu(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 128;
			}
		}
		break;
	case 551: /* lb */
		assert(l && r);
		{	/* expr: lb(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 129;
			}
		}
		break;
	case 552: /* sb */
		assert(l && r);
		{	/* expr: sb(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 130;
			}
		}
		break;
	case 553: /* sbu */
		assert(l && r);
		{	/* expr: sbu(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 131;
			}
		}
		break;
	case 554: /* lhu */
		assert(l && r);
		{	/* expr: lhu(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 132;
			}
		}
		break;
	case 555: /* lh */
		assert(l && r);
		{	/* expr: lh(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 133;
			}
		}
		break;
	case 556: /* sh */
		assert(l && r);
		{	/* expr: sh(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 134;
			}
		}
		break;
	case 557: /* shu */
		assert(l && r);
		{	/* expr: shu(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 135;
			}
		}
		break;
	case 558: /* sgtu */
		assert(l && r);
		{	/* expr: sgtu(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 139;
			}
		}
		break;
	case 559: /* sltu */
		assert(l && r);
		{	/* expr: sltu(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 137;
			}
		}
		break;
	case 560: /* sgeu */
		assert(l && r);
		{	/* expr: sgeu(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 136;
			}
		}
		break;
	case 561: /* sleu */
		assert(l && r);
		{	/* expr: sleu(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 138;
			}
		}
		break;
	case 562: /* div */
		assert(l && r);
		{	/* expr: div(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 140;
			}
		}
		break;
	case 563: /* mfhi */
		assert(l);
		{	/* expr: mfhi(def) */
			c = l->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 141;
			}
		}
		break;
	case 564: /* or */
		assert(l && r);
		{	/* expr: or(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 142;
			}
		}
		break;
	case 565: /* la2 */
		assert(l && r);
		{	/* expr: la2(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 143;
			}
		}
		break;
	case 566: /* mov_s */
		assert(l);
		{	/* expr: mov_s(def) */
			c = l->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 144;
			}
		}
		break;
	case 567: /* c_lt_d */
		assert(l && r);
		{	/* expr: c_lt_d(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 147;
			}
		}
		break;
	case 568: /* c_le_d */
		assert(l && r);
		{	/* expr: c_le_d(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 148;
			}
		}
		break;
	case 569: /* c_ge_d */
		assert(l && r);
		{	/* expr: c_ge_d(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 146;
			}
		}
		break;
	case 570: /* c_gt_d */
		assert(l && r);
		{	/* expr: c_gt_d(def,def) */
			c = l->cost[isel_def_NT] + r->cost[isel_def_NT] + 2;
			if (c + 0 < p->cost[isel_expr_NT]) {
				p->cost[isel_expr_NT] = c + 0;
				p->rule.isel_expr = 145;
			}
		}
		break;
	default:
		isel_assert(0, PANIC("Bad operator %d in isel_state\n", op));
	}
	return (STATE_TYPE)p;
}

#ifdef STATE_LABEL
static void isel_label1(NODEPTR_TYPE p) {
	isel_assert(p, PANIC("NULL tree in isel_label\n"));
	switch (isel_arity[OP_LABEL(p)]) {
	case 0:
		STATE_LABEL(p) = isel_state(OP_LABEL(p), 0, 0);
		break;
	case 1:
		isel_label1(LEFT_CHILD(p));
		STATE_LABEL(p) = isel_state(OP_LABEL(p),
			STATE_LABEL(LEFT_CHILD(p)), 0);
		break;
	case 2:
		isel_label1(LEFT_CHILD(p));
		isel_label1(RIGHT_CHILD(p));
		STATE_LABEL(p) = isel_state(OP_LABEL(p),
			STATE_LABEL(LEFT_CHILD(p)),
			STATE_LABEL(RIGHT_CHILD(p)));
		break;
	}
}

STATE_TYPE isel_label(NODEPTR_TYPE p) {
	isel_label1(p);
	return ((struct isel_state *)STATE_LABEL(p))->rule.isel_def ? STATE_LABEL(p) : 0;
}

NODEPTR_TYPE *isel_kids(NODEPTR_TYPE p, int eruleno, NODEPTR_TYPE kids[]) {
	isel_assert(p, PANIC("NULL tree in isel_kids\n"));
	isel_assert(kids, PANIC("NULL kids in isel_kids\n"));
	switch (eruleno) {
	case 270: /* expr: c_le_d(def,def) */
	case 269: /* expr: c_lt_d(def,def) */
	case 268: /* expr: c_ge_d(def,def) */
	case 267: /* expr: c_gt_d(def,def) */
	case 265: /* expr: la2(def,def) */
	case 264: /* expr: or(def,def) */
	case 262: /* expr: div(def,def) */
	case 261: /* expr: sgtu(def,def) */
	case 260: /* expr: sleu(def,def) */
	case 259: /* expr: sltu(def,def) */
	case 258: /* expr: sgeu(def,def) */
	case 257: /* expr: shu(def,def) */
	case 256: /* expr: sh(def,def) */
	case 255: /* expr: lh(def,def) */
	case 254: /* expr: lhu(def,def) */
	case 253: /* expr: sbu(def,def) */
	case 252: /* expr: sb(def,def) */
	case 251: /* expr: lb(def,def) */
	case 250: /* expr: lbu(def,def) */
	case 248: /* expr: mult(def,def) */
	case 247: /* expr: xori(def,def) */
	case 246: /* expr: andi(def,def) */
	case 245: /* expr: ori(def,def) */
	case 243: /* expr: sla(def,def) */
	case 242: /* expr: sll(def,def) */
	case 241: /* expr: seq(def,def) */
	case 240: /* expr: sne(def,def) */
	case 236: /* expr: s_s(def,def) */
	case 235: /* expr: l_s(def,def) */
	case 229: /* expr: s_d(def,def) */
	case 228: /* expr: l_d(def,def) */
	case 227: /* expr: div_s(def,def) */
	case 226: /* expr: mul_s(def,def) */
	case 225: /* expr: sub_s(def,def) */
	case 224: /* expr: add_s(def,def) */
	case 223: /* expr: bnez(def,def) */
	case 222: /* expr: div_d(def,def) */
	case 219: /* expr: and(def,def) */
	case 214: /* expr: sgt(def,def) */
	case 213: /* expr: sle(def,def) */
	case 212: /* expr: slt(def,def) */
	case 211: /* expr: sge(def,def) */
	case 209: /* expr: sub_d(def,def) */
	case 208: /* expr: add_d(def,def) */
	case 207: /* expr: mul_d(def,def) */
	case 206: /* expr: sra(def,def) */
	case 205: /* expr: srl(def,def) */
	case 203: /* expr: sw(def,def) */
	case 202: /* expr: lw(def,def) */
	case 201: /* expr: subu(def,def) */
	case 200: /* expr: addu(def,def) */
	case 81: /* expr: ISUB(const_label,def) */
	case 80: /* expr: IADD(const_label,def) */
	case 79: /* expr: IAND(def,def) */
	case 78: /* expr: IOR(def,def) */
	case 76: /* expr: IDIV(def,def) */
	case 75: /* expr: IGTU(def,def) */
	case 74: /* expr: ILEU(def,def) */
	case 73: /* expr: ILTU(def,def) */
	case 72: /* expr: IGEU(def,def) */
	case 71: /* expr: HIVSTOREU(def,def) */
	case 70: /* expr: HIVSTORE(def,def) */
	case 69: /* expr: HIVLOAD(def,def) */
	case 68: /* expr: HIVLOADU(def,def) */
	case 67: /* expr: QIVSTOREU(def,def) */
	case 66: /* expr: QIVSTORE(def,def) */
	case 65: /* expr: QIVLOAD(def,def) */
	case 64: /* expr: QIVLOADU(def,def) */
	case 62: /* expr: IMUL(def,def) */
	case 61: /* expr: IXOR(def,def) */
	case 60: /* expr: IAND(def,const) */
	case 59: /* expr: IOR(def,const) */
	case 58: /* expr: IEQ(def,def) */
	case 54: /* expr: INE(def,def) */
	case 50: /* expr: ILLSH(def,def) */
	case 49: /* expr: IRLSH(def,def) */
	case 48: /* expr: ILASH(def,def) */
	case 47: /* expr: IRASH(def,def) */
	case 45: /* expr: FVSTORE(def,def) */
	case 44: /* expr: FVLOAD(def,def) */
	case 43: /* expr: DVSTORE(def,def) */
	case 42: /* expr: DVLOAD(def,def) */
	case 41: /* expr: FDIV(def,def) */
	case 40: /* expr: FMUL(def,def) */
	case 39: /* expr: FSUB(def,def) */
	case 38: /* expr: FADD(def,def) */
	case 37: /* expr: DEQ(def,def) */
	case 36: /* expr: DDIV(def,def) */
	case 32: /* expr: DGT(def,def) */
	case 31: /* expr: DLE(def,def) */
	case 30: /* expr: DLT(def,def) */
	case 29: /* expr: DGE(def,def) */
	case 27: /* expr: ILAND(def,def) */
	case 20: /* expr: IGT(def,def) */
	case 19: /* expr: ILE(def,def) */
	case 18: /* expr: ILT(def,def) */
	case 17: /* expr: IGE(def,def) */
	case 14: /* expr: DSUB(def,def) */
	case 13: /* expr: DADD(def,def) */
	case 12: /* expr: DMUL(def,def) */
	case 11: /* expr: IASH(def,const) */
	case 10: /* expr: ILSH(def,const) */
	case 8: /* expr: IVSTORE(def,def) */
	case 7: /* expr: IVLOAD(def,def) */
	case 6: /* expr: ISUB(def,def) */
	case 5: /* expr: IADD(def,def) */
	case 1: /* def: DEF(reg,expr) */
		kids[0] = LEFT_CHILD(p);
		kids[1] = RIGHT_CHILD(p);
		break;
	case 300: /* def: float_const */
	case 197: /* const_label: const */
	case 142: /* reg: rf3 */
	case 115: /* reg: rf2 */
	case 114: /* reg: rf1 */
	case 113: /* const_label: float_const */
	case 3: /* def: const */
	case 2: /* def: reg */
		kids[0] = p;
		break;
	case 301: /* rf3: hilo0 */
	case 199: /* float_const: FLOAT */
	case 198: /* const_label: isel_label */
	case 196: /* rf3: isel_label */
	case 195: /* rf3: R31 */
	case 194: /* rf3: R30 */
	case 193: /* rf3: R29 */
	case 192: /* rf3: R28 */
	case 191: /* rf3: R27 */
	case 190: /* rf3: R26 */
	case 189: /* rf3: temp10 */
	case 188: /* rf3: temp9 */
	case 187: /* rf3: temp8 */
	case 186: /* rf3: temp7 */
	case 185: /* rf3: temp6 */
	case 184: /* rf3: temp5 */
	case 183: /* rf3: temp4 */
	case 182: /* rf3: temp3 */
	case 181: /* rf3: temp2 */
	case 180: /* rf3: temp1 */
	case 179: /* rf3: temp0 */
	case 178: /* const: INT */
	case 177: /* rf3: fp0 */
	case 176: /* rf3: f31 */
	case 175: /* rf3: f30 */
	case 174: /* rf3: f29 */
	case 173: /* rf3: f28 */
	case 172: /* rf3: f27 */
	case 171: /* rf3: f26 */
	case 170: /* rf3: f25 */
	case 169: /* rf3: f24 */
	case 168: /* rf3: f23 */
	case 167: /* rf3: f22 */
	case 166: /* rf3: f21 */
	case 165: /* rf3: f20 */
	case 164: /* rf3: f19 */
	case 163: /* rf3: f18 */
	case 162: /* rf3: f17 */
	case 161: /* rf3: f16 */
	case 160: /* rf3: f15 */
	case 159: /* rf3: f14 */
	case 158: /* rf3: f13 */
	case 157: /* rf3: f12 */
	case 156: /* rf3: f11 */
	case 155: /* rf3: f10 */
	case 154: /* rf3: f9 */
	case 153: /* rf3: f8 */
	case 152: /* rf3: f7 */
	case 151: /* rf3: f6 */
	case 150: /* rf3: f5 */
	case 149: /* rf3: f4 */
	case 148: /* rf3: f3 */
	case 147: /* rf3: f2 */
	case 146: /* rf3: f1 */
	case 145: /* rf3: f0 */
	case 144: /* rf3: cc0 */
	case 143: /* rf3: sp0 */
	case 141: /* rf3: R25 */
	case 140: /* rf3: R24 */
	case 139: /* rf3: R23 */
	case 138: /* rf3: R22 */
	case 137: /* rf3: R21 */
	case 136: /* rf3: R20 */
	case 135: /* rf3: R19 */
	case 134: /* rf3: R18 */
	case 133: /* rf3: R17 */
	case 132: /* rf3: R16 */
	case 131: /* rf2: R15 */
	case 130: /* rf2: R14 */
	case 129: /* rf2: R13 */
	case 128: /* rf2: R12 */
	case 127: /* rf2: R11 */
	case 126: /* rf2: R10 */
	case 125: /* rf2: R9 */
	case 124: /* rf2: R8 */
	case 123: /* rf1: R7 */
	case 122: /* rf1: R6 */
	case 121: /* rf1: R5 */
	case 120: /* rf1: R4 */
	case 119: /* rf1: R3 */
	case 118: /* rf1: R2 */
	case 117: /* rf1: R1 */
	case 116: /* rf1: R0 */
	case 4: /* def: isel_label */
		break;
	case 266: /* expr: mov_s(def) */
	case 263: /* expr: mfhi(def) */
	case 249: /* expr: mflo(def) */
	case 244: /* expr: j(def) */
	case 239: /* expr: li_s(def) */
	case 238: /* expr: trunc_w_s(def) */
	case 237: /* expr: cvt_s_w(def) */
	case 234: /* expr: li_d(def) */
	case 233: /* expr: mfc1(def) */
	case 232: /* expr: mov_d(def) */
	case 231: /* expr: jr(def) */
	case 230: /* expr: jal(def) */
	case 221: /* expr: cvt_d_s(def) */
	case 220: /* expr: cvt_s_d(def) */
	case 218: /* expr: cvt_d_w(def) */
	case 217: /* expr: mtc1(def) */
	case 216: /* expr: li(def) */
	case 215: /* expr: trunc_w_d(def) */
	case 210: /* expr: la(def) */
	case 204: /* expr: move(def) */
	case 77: /* expr: MFHI(def) */
	case 63: /* expr: MFLO(def) */
	case 57: /* expr: DCONSTANT(float_const) */
	case 56: /* expr: CVTSI(def) */
	case 55: /* expr: TRUNCIS(def) */
	case 53: /* expr: FASSIGN(def) */
	case 52: /* expr: FCONSTANT(float_const) */
	case 51: /* expr: FCONSTANT(const_label) */
	case 46: /* expr: ICONSTANT(const) */
	case 35: /* expr: DMFC1(def) */
	case 34: /* expr: CVTDS(def) */
	case 33: /* expr: CVTSD(def) */
	case 28: /* expr: DASSIGN(def) */
	case 26: /* expr: CVTDI(def) */
	case 25: /* expr: MTC1(def) */
	case 24: /* expr: DCONSTANT(const_label) */
	case 23: /* expr: MFC1(def) */
	case 22: /* expr: TRUNCID(def) */
	case 21: /* expr: DMTC1(def) */
	case 16: /* expr: ASSIGN(def) */
	case 15: /* expr: ICONSTANT(const_label) */
	case 9: /* expr: IASSIGN(def) */
		kids[0] = LEFT_CHILD(p);
		break;
	default:
		isel_assert(0, PANIC("Bad external rule number %d in isel_kids\n", eruleno));
	}
	return kids;
}

int isel_op_label(NODEPTR_TYPE p) {
	isel_assert(p, PANIC("NULL tree in isel_op_label\n"));
	return OP_LABEL(p);
}

STATE_TYPE isel_state_label(NODEPTR_TYPE p) {
	isel_assert(p, PANIC("NULL tree in isel_state_label\n"));
	return STATE_LABEL(p);
}

NODEPTR_TYPE isel_child(NODEPTR_TYPE p, int index) {
	isel_assert(p, PANIC("NULL tree in isel_child\n"));
	switch (index) {
	case 0:	return LEFT_CHILD(p);
	case 1:	return RIGHT_CHILD(p);
	}
	isel_assert(0, PANIC("Bad index %d in isel_child\n", index));
	return 0;
}

#endif
