/*
 * Decompiled with CFR 0.152.
 */
package com.oreilly.servlet;

import com.oreilly.servlet.UploadedFile;
import com.oreilly.servlet.multipart.FilePart;
import com.oreilly.servlet.multipart.FileRenamePolicy;
import com.oreilly.servlet.multipart.MultipartParser;
import com.oreilly.servlet.multipart.ParamPart;
import com.oreilly.servlet.multipart.Part;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpUtils;

public class MultipartRequest {
    private static final int DEFAULT_MAX_POST_SIZE = 0x100000;
    protected Hashtable parameters = new Hashtable();
    protected Hashtable files = new Hashtable();

    public MultipartRequest(HttpServletRequest request, String saveDirectory) throws IOException {
        this(request, saveDirectory, 0x100000);
    }

    public MultipartRequest(HttpServletRequest request, String saveDirectory, int maxPostSize) throws IOException {
        this(request, saveDirectory, maxPostSize, null, null);
    }

    public MultipartRequest(HttpServletRequest request, String saveDirectory, String encoding) throws IOException {
        this(request, saveDirectory, 0x100000, encoding, null);
    }

    public MultipartRequest(HttpServletRequest request, String saveDirectory, int maxPostSize, FileRenamePolicy policy) throws IOException {
        this(request, saveDirectory, maxPostSize, null, policy);
    }

    public MultipartRequest(HttpServletRequest request, String saveDirectory, int maxPostSize, String encoding) throws IOException {
        this(request, saveDirectory, maxPostSize, encoding, null);
    }

    public MultipartRequest(HttpServletRequest request, String saveDirectory, int maxPostSize, String encoding, FileRenamePolicy policy) throws IOException {
        Part part;
        Hashtable queryParameters;
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (saveDirectory == null) {
            throw new IllegalArgumentException("saveDirectory cannot be null");
        }
        if (maxPostSize <= 0) {
            throw new IllegalArgumentException("maxPostSize must be positive");
        }
        File dir = new File(saveDirectory);
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + saveDirectory);
        }
        if (!dir.canWrite()) {
            throw new IllegalArgumentException("Not writable: " + saveDirectory);
        }
        MultipartParser parser2 = new MultipartParser(request, maxPostSize, true, true, encoding);
        if (request.getQueryString() != null) {
            queryParameters = HttpUtils.parseQueryString(request.getQueryString());
            Enumeration queryParameterNames = queryParameters.keys();
            while (queryParameterNames.hasMoreElements()) {
                Object paramName = queryParameterNames.nextElement();
                String[] values = (String[])queryParameters.get(paramName);
                Vector<String> newValues = new Vector<String>();
                int i = 0;
                while (i < values.length) {
                    newValues.add(values[i]);
                    ++i;
                }
                this.parameters.put(paramName, newValues);
            }
        }
        while ((part = parser2.readNextPart()) != null) {
            String name = ((Part)((Object)queryParameters)).getName();
            if (((Part)((Object)queryParameters)).isParam()) {
                ParamPart paramPart = (ParamPart)((Object)queryParameters);
                String value = paramPart.getStringValue();
                Vector<String> existingValues = (Vector<String>)this.parameters.get(name);
                if (existingValues == null) {
                    existingValues = new Vector<String>();
                    this.parameters.put(name, existingValues);
                }
                existingValues.addElement(value);
                continue;
            }
            if (!((Part)((Object)queryParameters)).isFile()) continue;
            FilePart filePart = (FilePart)((Object)queryParameters);
            String fileName = filePart.getFileName();
            if (fileName != null) {
                filePart.setRenamePolicy(policy);
                filePart.writeTo(dir);
                this.files.put(name, new UploadedFile(dir.toString(), filePart.getFileName(), fileName, filePart.getContentType()));
                continue;
            }
            this.files.put(name, new UploadedFile(null, null, null, null));
        }
    }

    public MultipartRequest(ServletRequest request, String saveDirectory) throws IOException {
        this((HttpServletRequest)request, saveDirectory);
    }

    public MultipartRequest(ServletRequest request, String saveDirectory, int maxPostSize) throws IOException {
        this((HttpServletRequest)request, saveDirectory, maxPostSize);
    }

    public Enumeration getParameterNames() {
        return this.parameters.keys();
    }

    public Enumeration getFileNames() {
        return this.files.keys();
    }

    public String getParameter(String name) {
        try {
            Vector values = (Vector)this.parameters.get(name);
            if (values == null || values.size() == 0) {
                return null;
            }
            String value = (String)values.elementAt(values.size() - 1);
            return value;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String[] getParameterValues(String name) {
        try {
            Vector values = (Vector)this.parameters.get(name);
            if (values == null || values.size() == 0) {
                return null;
            }
            Object[] valuesArray = new String[values.size()];
            values.copyInto(valuesArray);
            return valuesArray;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getFilesystemName(String name) {
        try {
            UploadedFile file = (UploadedFile)this.files.get(name);
            return file.getFilesystemName();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getOriginalFileName(String name) {
        try {
            UploadedFile file = (UploadedFile)this.files.get(name);
            return file.getOriginalFileName();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getContentType(String name) {
        try {
            UploadedFile file = (UploadedFile)this.files.get(name);
            return file.getContentType();
        }
        catch (Exception e) {
            return null;
        }
    }

    public File getFile(String name) {
        try {
            UploadedFile file = (UploadedFile)this.files.get(name);
            return file.getFile();
        }
        catch (Exception e) {
            return null;
        }
    }
}

