/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.seal.cactus;

import edu.uci.seal.cactus.analysis.dyna.instrumentation.EntryPointBodyTransformer;
import edu.uci.seal.cactus.analysis.dyna.instrumentation.Instrumentor;
import edu.uci.seal.cactus.analysis.dyna.model.TestEntrypoint;
import edu.uci.seal.cactus.analysis.dyna.xposed.EntryPointExtractor;
import edu.uci.seal.cactus.analysis.stat.model.EntrypointWidgetPerm;
import edu.uci.seal.cactus.analysis.stat.model.TestWidget;
import edu.uci.seal.cactus.analysis.stat.perm.AppPermAnalyzer;
import edu.uci.seal.cactus.analysis.stat.test.naive.NaiveTestAnalyzer;
import edu.uci.seal.cactus.generation.TestConfigBuilder;
import edu.uci.seal.cactus.model.Application;
import edu.uci.seal.cactus.model.Input;
import edu.uci.seal.cactus.model.TestApplication;
import edu.uci.seal.cactus.util.Res;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.xml.sax.SAXException;
import org.xmlpull.v1.XmlPullParserException;

public class Main {
    public static final boolean DEBUG = false;
    private static final String PHASE_INSTRUMENT = "instrument";
    private static final String PHASE_INSTRUMENT_XPOSED = "instrument_xposed";
    private static final String PHASE_ANALYSIS_APP = "analysis_app";
    private static final String PHASE_ANALYSIS_TEST = "analysis_test";
    private static final String PHASE_GEN_CONFIG = "gen_config";
    private static String androidJar;

    public static void main(String[] args) {
        DefaultParser parser2 = new DefaultParser();
        Options options = Main.createClOptions();
        try {
            CommandLine line = parser2.parse(options, args);
            androidJar = line.getOptionValue("android");
            String phase = line.getOptionValue("phase");
            String inputJson = line.getOptionValue("input");
            Res.setRoot(line.getOptionValue("res"));
            if (PHASE_INSTRUMENT_XPOSED.equals(phase)) {
                Main.instrumentAppForXposed(inputJson);
            } else {
                Input input = new Input(inputJson);
                input.open(androidJar);
                if (PHASE_INSTRUMENT.equals(phase)) {
                    Main.instrumentApp(input);
                } else if (PHASE_ANALYSIS_APP.equals(phase)) {
                    Main.analyzeApp(input);
                } else if (PHASE_ANALYSIS_TEST.equals(phase)) {
                    Main.analyzeTestApp(input);
                } else if (PHASE_GEN_CONFIG.equals(phase)) {
                    Main.createConfig(input);
                }
                input.close();
            }
        }
        catch (ParseException exp) {
            HelpFormatter formatter = new HelpFormatter();
            System.err.println("Invalid args:" + exp.getMessage());
            formatter.printHelp("Cactus", options);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Options createClOptions() {
        Options options = new Options();
        options.addOption(Option.builder("android").desc("the directory containing android platforms").hasArg().argName("dir_address").required().build());
        options.addOption(Option.builder("input").desc("the json input/out file").hasArg().argName("in_address").required().build());
        options.addOption(Option.builder("phase").desc("the phase of analysis [instrument|analysis_app|analysis_test|gen_config]").hasArg().build());
        options.addOption(Option.builder("res").desc("the resource files directory").hasArg().build());
        return options;
    }

    private static void analyzeApp(Input input) throws SAXException, XmlPullParserException, ParserConfigurationException, IOException {
        TestEntrypoint.extractCommonEntryPoints(input);
        Application app = new Application(input.getApkAddress(), androidJar, input.getApkIpcAddress(), true);
        AppPermAnalyzer permAnalyzer = new AppPermAnalyzer(app, Res.PRM_MAPPING_ROOT);
        permAnalyzer.runAnalysis(TestEntrypoint.getAllEntryPoints(input.getTestDynamicAnalysisResult()));
        EntrypointWidgetPerm.saveResults(input.getAppStaticAnalysisResult(), permAnalyzer.getAnalysisResults());
    }

    private static void analyzeTestApp(Input input) throws SAXException, XmlPullParserException, ParserConfigurationException, IOException {
        Application app = new Application(input.getApkAddress(), androidJar, input.getApkIpcAddress(), false);
        TestApplication testApp = new TestApplication(input.getTestApkAddress(), androidJar, app);
        NaiveTestAnalyzer testAnalyzer = new NaiveTestAnalyzer(testApp);
        testAnalyzer.runAnalysis();
        TestWidget.saveResults(input.getTestStaticAnalysisResult(), testAnalyzer.getWidgetActionPerformers());
    }

    private static void createConfig(Input input) throws FileNotFoundException {
        Set<EntrypointWidgetPerm> entrypointWidgetPerms = EntrypointWidgetPerm.loadAnalysisResults(input.getAppStaticAnalysisResult());
        Set<TestWidget> testWidgets = TestWidget.loadAnalysisResults(input.getTestStaticAnalysisResult());
        Set<TestEntrypoint> testEntryPoints = TestEntrypoint.loadAnalysisResults(input.getTestDynamicAnalysisResult());
        TestConfigBuilder builder = new TestConfigBuilder(testWidgets, testEntryPoints, entrypointWidgetPerms);
        builder.createConfigs(input.getPerms());
        input.updateTestPerms(builder.getTestConfigs(), testEntryPoints);
    }

    private static void instrumentAppForXposed(String apk) throws SAXException, XmlPullParserException, ParserConfigurationException, IOException, TemplateException {
        EntryPointExtractor.createXposedInput(androidJar, Res.TEMPLATE_ROOT, new File(apk));
    }

    private static void instrumentApp(Input input) throws SAXException, XmlPullParserException, ParserConfigurationException, IOException {
        EntryPointBodyTransformer bodyTransformer = new EntryPointBodyTransformer(input.getPackage());
        Instrumentor.instrument(input.getInstrumentationAddress(), bodyTransformer, input.getApkAddress(), androidJar);
    }
}

