/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.seal.cactus.analysis.dyna.instrumentation;

import edu.uci.seal.cactus.analysis.dyna.instrumentation.InstUtil;
import edu.uci.seal.cactus.analysis.dyna.instrumentation.InstrumentationBodyTransformer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import soot.Body;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.internal.JIdentityStmt;

public class EntryPointBodyTransformer
extends InstrumentationBodyTransformer {
    private static String SEPARATOR = "###";

    public EntryPointBodyTransformer(String packageName) {
        super(packageName);
    }

    @Override
    protected boolean injectCode(Unit unit, Body body) {
        if (unit instanceof JIdentityStmt) {
            return false;
        }
        String message = String.format("App_Entry_Point %s %s", SEPARATOR, body.getMethod().getSignature());
        InstUtil.addLogStmt(unit, body, null, message, this.INSTRUMENTATION_TAG, true);
        return true;
    }

    @Override
    protected boolean shouldSkipInstrumentationCriteria(Body body) {
        if (super.shouldSkipInstrumentationCriteria(body)) {
            return true;
        }
        SootMethod thisMethod = body.getMethod();
        ArrayList<SootMethod> otherMethods = new ArrayList<SootMethod>(this.getAllPossibleImplementingMethods(thisMethod.getDeclaringClass()));
        otherMethods.addAll(this.getAllPossibleOverridingMethods(thisMethod.getDeclaringClass()));
        return this.isOverridingMethod(thisMethod, otherMethods);
    }

    private boolean isOverridingMethod(SootMethod thisMethod, List<SootMethod> otherMethods) {
        return otherMethods.isEmpty() || !otherMethods.stream().map(SootMethod::getSubSignature).collect(Collectors.toSet()).contains(thisMethod.getSubSignature());
    }

    private List<SootMethod> getAllPossibleOverridingMethods(SootClass sootClass) {
        LinkedList<SootMethod> implMethods = new LinkedList<SootMethod>();
        for (SootClass superclass = sootClass.getSuperclass(); superclass != null && !superclass.getName().equals("java.lang.Object"); superclass = superclass.getSuperclass()) {
            if (!superclass.getPackageName().startsWith("android.")) continue;
            implMethods.addAll(superclass.getMethods());
        }
        return implMethods;
    }

    private List<SootMethod> getAllPossibleImplementingMethods(SootClass sootClass) {
        LinkedList<SootMethod> implInterfaces = new LinkedList<SootMethod>();
        sootClass.getInterfaces().stream().filter(systemInterface -> systemInterface.getPackageName().startsWith("android.")).map(SootClass::getMethods).forEach(implInterfaces::addAll);
        return implInterfaces;
    }
}

