/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.seal.cactus.analysis.dyna.instrumentation;

import java.util.ArrayList;
import java.util.List;
import soot.Body;
import soot.DoubleType;
import soot.Immediate;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.javaToJimple.LocalGenerator;
import soot.jimple.Jimple;
import soot.jimple.NewExpr;
import soot.jimple.NopStmt;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.StringConstant;
import soot.jimple.VirtualInvokeExpr;

public class InstUtil {
    public static Local appendTwoStrings(Body b, Value s1, Value s2, List<Unit> generated) {
        RefType stringType = Scene.v().getSootClass("java.lang.String").getType();
        SootClass builderClass = Scene.v().getSootClass("java.lang.StringBuilder");
        RefType builderType = builderClass.getType();
        NewExpr newBuilderExpr = Jimple.v().newNewExpr(builderType);
        Local builderLocal = InstUtil.generateNewLocal(b, builderType);
        generated.add(Jimple.v().newAssignStmt(builderLocal, newBuilderExpr));
        Local tmpLocal = InstUtil.generateNewLocal(b, builderType);
        Local resultLocal = InstUtil.generateNewLocal(b, stringType);
        VirtualInvokeExpr appendExpr = Jimple.v().newVirtualInvokeExpr(builderLocal, builderClass.getMethod("java.lang.StringBuilder append(java.lang.String)").makeRef(), InstUtil.toString(s2, generated, b));
        VirtualInvokeExpr toStrExpr = Jimple.v().newVirtualInvokeExpr(builderLocal, builderClass.getMethod("java.lang.String toString()").makeRef());
        generated.add(Jimple.v().newInvokeStmt(Jimple.v().newSpecialInvokeExpr(builderLocal, builderClass.getMethod("void <init>(java.lang.String)").makeRef(), s1)));
        generated.add(Jimple.v().newAssignStmt(tmpLocal, appendExpr));
        generated.add(Jimple.v().newAssignStmt(resultLocal, toStrExpr));
        return resultLocal;
    }

    public static Value toString(Value value, List<Unit> generated, Body b) {
        if (value.getType().equals(Scene.v().getSootClass("java.lang.String").getType())) {
            return value;
        }
        Type type = value.getType();
        if (type.equals(IntType.v()) || type.equals(DoubleType.v()) || type.equals(LongType.v())) {
            SootClass stringClass = Scene.v().getSootClass("java.lang.String");
            Local tmpLocal = InstUtil.generateNewLocal(b, stringClass.getType());
            generated.add(Jimple.v().newAssignStmt(tmpLocal, Jimple.v().newStaticInvokeExpr(stringClass.getMethod("java.lang.String valueOf(" + type.toString() + ")").makeRef(), value)));
            return tmpLocal;
        }
        if (type.equals(Scene.v().getSootClass("android.location.Location").getType())) {
            return value;
        }
        return value;
    }

    public static VirtualInvokeExpr generateStartsWithMethod(Local phoneNumberLocal) {
        SootMethod sm = Scene.v().getMethod("<java.lang.String: boolean startsWith(java.lang.String)>");
        StringConstant value = StringConstant.v("0900");
        VirtualInvokeExpr vinvokeExpr = Jimple.v().newVirtualInvokeExpr(phoneNumberLocal, sm.makeRef(), (Value)value);
        return vinvokeExpr;
    }

    public static Local generateNewLocal(Body body, Type type) {
        LocalGenerator lg = new LocalGenerator(body);
        return lg.generateLocal(type);
    }

    public static NopStmt insertNopStmt(Body body, Unit u) {
        NopStmt nop = Jimple.v().newNopStmt();
        body.getUnits().insertAfter(nop, u);
        return nop;
    }

    public static void removeStatement(Unit u, Body body) {
        body.getUnits().remove(u);
    }

    public static void addLogStmt(Unit u, Body b, Value value, String msg, String tag, boolean insertBefore) {
        ArrayList<Unit> generated = new ArrayList<Unit>();
        StringConstant logMessage = StringConstant.v(msg);
        StringConstant logType = StringConstant.v(tag);
        Immediate logMsg = logMessage;
        if (value != null) {
            logMsg = InstUtil.appendTwoStrings(b, logMessage, value, generated);
        }
        SootMethod sm = Scene.v().getMethod("<android.util.Log: int i(java.lang.String,java.lang.String)>");
        StaticInvokeExpr invokeExpr = Jimple.v().newStaticInvokeExpr(sm.makeRef(), logType, logMsg);
        generated.add(Jimple.v().newInvokeStmt(invokeExpr));
        if (insertBefore) {
            b.getUnits().insertBefore((Unit)((Object)generated), u);
        } else {
            b.getUnits().insertAfter(generated, u);
        }
        b.validate();
    }
}

