/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.seal.cactus.analysis.dyna.instrumentation;

import edu.uci.seal.cactus.analysis.dyna.instrumentation.InstrumentationBodyTransformer;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import soot.PackManager;
import soot.Scene;
import soot.Transform;
import soot.options.Options;

public class Instrumentor {
    public static void instrument(String output, InstrumentationBodyTransformer bodyTransformer, String apk, String androidJAR) {
        File[] files = new File(output).listFiles();
        if (files != null && files.length > 0) {
            Arrays.asList(files).forEach(File::delete);
        }
        Instrumentor.initializeSoot(output, apk, androidJAR);
        PackManager.v().getPack("jtp").add(new Transform("jtp.myAnalysis", bodyTransformer));
        PackManager.v().runPacks();
        PackManager.v().writeOutput();
    }

    private static void initializeSoot(String output, String apk, String androidJAR) {
        Options.v().set_allow_phantom_refs(true);
        Options.v().set_prepend_classpath(true);
        Options.v().set_validate(true);
        Options.v().set_output_format(10);
        Options.v().set_output_dir(output);
        Options.v().set_process_dir(Collections.singletonList(apk));
        Options.v().set_android_jars(androidJAR);
        Options.v().set_src_prec(5);
        Options.v().set_soot_classpath(androidJAR);
        Scene.v().loadNecessaryClasses();
    }
}

