/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.seal.cactus.analysis.dyna.instrumentation;

import edu.uci.seal.cactus.analysis.dyna.instrumentation.InstUtil;
import edu.uci.seal.cactus.analysis.dyna.instrumentation.InstrumentationBodyTransformer;
import edu.uci.seal.cactus.analysis.stat.model.TestWidget;
import edu.uci.seal.cactus.model.TestApplication;
import edu.uci.seal.cactus.util.SootUtil;
import java.util.HashSet;
import java.util.Set;
import soot.Body;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.InvokeExpr;
import soot.jimple.internal.JIdentityStmt;

public class TestMethodBodyTransformer
extends InstrumentationBodyTransformer {
    private Set<TestWidget> mTestWidgetSet;
    private Set<String> visitedMethods;

    public TestMethodBodyTransformer(String packageName, Set<TestWidget> testWidgetSet) {
        super(packageName);
        this.mTestWidgetSet = testWidgetSet;
        this.visitedMethods = new HashSet<String>();
    }

    @Override
    protected boolean injectCode(Unit unit, Body body) {
        InvokeExpr methodCall;
        if (unit instanceof JIdentityStmt) {
            return false;
        }
        SootMethod method = body.getMethod();
        if (TestApplication.hasTestAnnotation(method) && !this.visitedMethods.contains(method.getSignature())) {
            String message = String.format("Test Entry Point :%s", method.getSignature());
            InstUtil.addLogStmt(unit, body, null, message, this.INSTRUMENTATION_TAG, true);
            this.visitedMethods.add(method.getSignature());
        }
        if ((methodCall = SootUtil.getInvokedMethod(unit)) == null) {
            return false;
        }
        this.processMethodCall(unit, body, methodCall);
        return false;
    }

    private void processMethodCall(Unit unit, Body body, InvokeExpr methodCall) {
        if (methodCall.getMethod().getSignature().equals("<android.support.test.espresso.ViewInteraction: android.support.test.espresso.ViewInteraction perform(android.support.test.espresso.ViewAction[])>")) {
            TestWidget testWidget = TestWidget.findByPerformerUnitByCallerDesc(body.getMethod(), unit, this.mTestWidgetSet);
            String message = String.format("Perform: %s", testWidget != null ? testWidget.toString() : "Unknown");
            InstUtil.addLogStmt(unit, body, null, message, this.INSTRUMENTATION_TAG, false);
        }
    }

    @Override
    protected boolean shouldSkipInstrumentationCriteria(Body body) {
        String mainAppPackage = this.packageName.substring(0, this.packageName.lastIndexOf(".test"));
        return !body.getMethod().getDeclaringClass().getPackageName().startsWith(mainAppPackage);
    }
}

