/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.seal.cactus.analysis.dyna.model;

import edu.uci.seal.cactus.model.Input;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonWriter;
import soot.Scene;
import soot.SootMethod;

public class TestEntrypoint {
    private static final String COMMON_TEST_NAME = "commonTest";
    private String testMethod;
    private String entryPoint;

    private TestEntrypoint(String testMethod, String entryPoint) {
        this.testMethod = testMethod;
        this.entryPoint = entryPoint;
    }

    public static Set<TestEntrypoint> loadAnalysisResults(String input) throws FileNotFoundException {
        HashSet<TestEntrypoint> result = new HashSet<TestEntrypoint>();
        JsonReader reader = Json.createReader(new FileReader(input));
        JsonObject jsonObject = reader.readObject();
        Set tests = jsonObject.keySet();
        for (String test : tests) {
            JsonArray entryPoints = jsonObject.getJsonArray(test);
            entryPoints.forEach(entryPoint -> result.add(new TestEntrypoint(test, entryPoint.toString().replaceAll("\"", ""))));
        }
        reader.close();
        return result;
    }

    public static Set<SootMethod> getAllEntryPoints(String input) throws FileNotFoundException {
        HashSet<SootMethod> result = new HashSet<SootMethod>();
        Set<TestEntrypoint> testEntryPoints = TestEntrypoint.loadAnalysisResults(input);
        for (TestEntrypoint entryPoint : testEntryPoints) {
            try {
                SootMethod method = Scene.v().getMethod(entryPoint.entryPoint);
                result.add(method);
            }
            catch (Exception e) {
                System.err.println("Method " + entryPoint.entryPoint + " not found");
            }
        }
        return result;
    }

    public static void extractCommonEntryPoints(Input input) throws IOException {
        Map<String, Set<String>> testEntryPoints = TestEntrypoint.convertAnalysisResults(input.getTestDynamicAnalysisResult());
        Set<String> commonMethods = TestEntrypoint.findCommonMethods(testEntryPoints);
        if (!commonMethods.isEmpty()) {
            for (String test : testEntryPoints.keySet()) {
                if (test.equals(COMMON_TEST_NAME)) continue;
                Set<String> testMethods = testEntryPoints.get(test);
                HashSet uniqueTestMethods = new HashSet();
                uniqueTestMethods.addAll(testMethods.stream().filter(method -> !commonMethods.contains(method)).collect(Collectors.toSet()));
                testEntryPoints.put(test, uniqueTestMethods);
            }
            testEntryPoints.put(COMMON_TEST_NAME, commonMethods);
            TestEntrypoint.saveResults(input.getTestDynamicAnalysisResult(), testEntryPoints);
            input.addTestMethod(COMMON_TEST_NAME);
        }
    }

    private static void saveResults(String output, Map<String, Set<String>> testEntryPoints) throws IOException {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        for (String test : testEntryPoints.keySet()) {
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            testEntryPoints.get(test).forEach(arrayBuilder::add);
            builder.add(test, arrayBuilder);
        }
        HashMap<String, Boolean> properties = new HashMap<String, Boolean>(1);
        properties.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
        JsonWriter jsonWriter = Json.createWriterFactory(properties).createWriter(new FileWriter(output));
        jsonWriter.write(builder.build());
        jsonWriter.close();
    }

    private static Map<String, Set<String>> convertAnalysisResults(String input) throws FileNotFoundException {
        JsonReader reader = Json.createReader(new FileReader(input));
        JsonObject jsonObject = reader.readObject();
        HashMap<String, Set<String>> testEntryPoints = new HashMap<String, Set<String>>();
        Set tests = jsonObject.keySet();
        for (String test : tests) {
            Set testEntryPointSet = jsonObject.getJsonArray(test).stream().map(val -> val.toString().replaceAll("\"", "")).collect(Collectors.toSet());
            testEntryPoints.put(test, testEntryPointSet);
        }
        reader.close();
        return testEntryPoints;
    }

    private static Set<String> findCommonMethods(Map<String, Set<String>> testEntryPoints) {
        HashSet<String> commonMethods = new HashSet<String>();
        HashSet allMethods = new HashSet();
        testEntryPoints.values().forEach(allMethods::addAll);
        for (String method : allMethods) {
            boolean isCommon = true;
            for (String test : testEntryPoints.keySet()) {
                if (testEntryPoints.get(test).contains(method)) continue;
                isCommon = false;
                break;
            }
            if (!isCommon) continue;
            commonMethods.add(method);
        }
        return commonMethods;
    }

    public String getTestMethod() {
        return this.testMethod;
    }

    public boolean isCommonTest() {
        return this.testMethod.equals(COMMON_TEST_NAME);
    }

    public String getEntryPoint() {
        return this.entryPoint;
    }

    public String toString() {
        return String.format("%s | %s", this.testMethod, this.entryPoint);
    }

    private static Set<SootMethod> getAllEntryPoints(String input, Collection<SootMethod> excludedMethods) throws FileNotFoundException {
        return TestEntrypoint.getAllEntryPoints(input).stream().filter(method -> !excludedMethods.contains(method)).collect(Collectors.toSet());
    }
}

