/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.seal.cactus.analysis.dyna.xposed;

import edu.uci.seal.cactus.model.Application;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.Version;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import org.xmlpull.v1.XmlPullParserException;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;

public class EntryPointExtractor {
    private static final String PACKAGE_TAG = "package";
    private static final String ENTRY_POINTS_TAG = "entryPoints";
    private static final String APP_TAG = "apps";
    private static final String CLASS_TAG = "class";
    private static final String METHOD_TAG = "method";
    private static final String PARAMS_TAG = "params";
    private static final String SIG_TAG = "sig";
    private Application mApp;
    private static String androidJar;
    private static Configuration cfg;

    public static void createXposedInput(String jar, String inputDir, String templateDir, String outDir) throws SAXException, XmlPullParserException, ParserConfigurationException, IOException, TemplateException {
        androidJar = jar;
        EntryPointExtractor.setConfigurationInstance(templateDir);
        File rootDri = new File(inputDir);
        HashMap<String, Object> root = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> apps = new ArrayList<Map<String, Object>>();
        for (File apk : rootDri.listFiles()) {
            if (!apk.getName().endsWith(".apk")) continue;
            apps.add(EntryPointExtractor.processApp(apk));
        }
        root.put(APP_TAG, apps);
        EntryPointExtractor.writeOutput(root, outDir);
    }

    public static void createXposedInput(String jar, String templateDir, File apk) throws SAXException, XmlPullParserException, ParserConfigurationException, IOException, TemplateException {
        androidJar = jar;
        EntryPointExtractor.setConfigurationInstance(templateDir);
        HashMap<String, Object> root = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> apps = new ArrayList<Map<String, Object>>();
        apps.add(EntryPointExtractor.processApp(apk));
        root.put(APP_TAG, apps);
        EntryPointExtractor.writeOutput(root, apk.getParentFile().getAbsolutePath());
    }

    private static Map<String, Object> processApp(File apk) {
        HashMap<String, Object> apps = new HashMap<String, Object>();
        try {
            EntryPointExtractor extractor = new EntryPointExtractor(apk.getAbsolutePath(), androidJar);
            if (extractor.mApp.getTargetAndroid() >= 23) {
                apps.put(PACKAGE_TAG, extractor.mApp.getPackageName());
                apps.put(ENTRY_POINTS_TAG, extractor.getEntryPoints());
            }
        }
        catch (Exception e) {
            System.err.println("###" + apk.getName());
        }
        return apps;
    }

    private static void setConfigurationInstance(String templateDir) throws IOException {
        cfg = new Configuration(Configuration.VERSION_2_3_23);
        cfg.setDirectoryForTemplateLoading(new File(templateDir));
        cfg.setDefaultEncoding("UTF-8");
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        cfg.setIncompatibleImprovements(new Version(2, 3, 20));
    }

    private static void writeOutput(Map<String, Object> root, String outputDir) throws IOException, TemplateException {
        Template template = cfg.getTemplate("InputLogger.java");
        FileWriter writer = new FileWriter(new File(outputDir, "InputLogger.java"));
        template.process(root, writer);
    }

    public static Map<String, String> sootMethodToXposedMap(SootMethod sootMethod) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(CLASS_TAG, sootMethod.getDeclaringClass().toString());
        result.put(METHOD_TAG, sootMethod.getName());
        result.put(PARAMS_TAG, sootMethod.getParameterTypes().stream().map(type -> "\"" + type.toString() + "\"").collect(Collectors.joining(",")));
        result.put(SIG_TAG, sootMethod.getSignature());
        return result;
    }

    private EntryPointExtractor(String apkPath, String androidJar) throws SAXException, XmlPullParserException, ParserConfigurationException, IOException {
        this.mApp = new Application(apkPath, androidJar, false, true);
    }

    private List<Map<String, String>> getEntryPoints() {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        for (SootClass clazz : Scene.v().getApplicationClasses()) {
            if (!clazz.getPackageName().startsWith(this.mApp.getPackageName())) continue;
            result.addAll(clazz.getMethods().stream().filter(method -> !method.isAbstract()).filter(method -> method.getName().startsWith("on")).map(EntryPointExtractor::sootMethodToXposedMap).collect(Collectors.toList()));
        }
        return result;
    }
}

