/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.seal.cactus.analysis.stat.app;

import edu.uci.seal.cactus.analysis.stat.model.WidgetActionListener;
import edu.uci.seal.cactus.model.Application;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import soot.PatchingChain;
import soot.RefType;
import soot.SootClass;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.InvokeExpr;
import soot.jimple.internal.JAssignStmt;
import soot.jimple.internal.JVirtualInvokeExpr;

class EventHandlerExtractor {
    private static final String METHOD_FIND_VIEW_BY_ID = "findViewById";
    private static final String METHOD_FIND_PREFERENCE = "findPreference";
    private static final String METHOD_SET_TITLE = "setTitle";
    private static final String TYPE_VIEW = "android.view.View";
    private static final String TYPE_ALERT_DIALOG$BUILDER = "android.app.AlertDialog$Builder";
    private static final String METHOD_SET_ITEMS = "setItems";
    private static final String METHOD_SET_ON_CLICK_LISTENER = "setOnClickListener";

    EventHandlerExtractor() {
    }

    private static Value findWidgetId(PatchingChain<Unit> units, Unit setterPoint, Value widget) {
        Unit pred;
        while ((pred = units.getPredOf(setterPoint)) != null) {
            for (ValueBox defBox : pred.getDefBoxes()) {
                if (!defBox.getValue().equals(widget)) continue;
                for (ValueBox useBox : pred.getUseBoxes()) {
                    if (useBox.getValue() instanceof InvokeExpr) {
                        InvokeExpr invokeExpr = (InvokeExpr)useBox.getValue();
                        if (!invokeExpr.getMethodRef().name().matches("^findViewById$|^findPreference$")) continue;
                        return invokeExpr.getArg(0);
                    }
                    if (!(pred instanceof JAssignStmt)) continue;
                    JAssignStmt stmt = (JAssignStmt)pred;
                    if (!stmt.leftBox.getValue().equals(widget) || !useBox.getValue().getType().toString().equals(TYPE_VIEW)) continue;
                    widget = useBox.getValue();
                }
            }
            for (ValueBox useBox : pred.getUseBoxes()) {
                JVirtualInvokeExpr invokeExpr;
                if (!(useBox.getValue() instanceof JVirtualInvokeExpr) || !(invokeExpr = (JVirtualInvokeExpr)useBox.getValue()).getBase().equals(widget) || !invokeExpr.getMethodRef().name().matches("^setTitle$")) continue;
                return invokeExpr.getArg(0);
            }
            setterPoint = pred;
        }
        return null;
    }

    private static SootMethod findListener(PatchingChain<Unit> units, Unit setterPoint, Value listener, String methodName) {
        Unit pred;
        while ((pred = units.getPredOf(setterPoint)) != null) {
            for (ValueBox defBox : pred.getDefBoxes()) {
                if (!defBox.getValue().equals(listener)) continue;
                for (ValueBox useBox : pred.getUseBoxes()) {
                    Type type = useBox.getValue().getType();
                    if (!(type instanceof RefType)) continue;
                    SootClass sootClass = ((RefType)type).getSootClass();
                    Collection<SootClass> interfaces = sootClass.isInterface() ? Collections.singletonList(sootClass) : sootClass.getInterfaces();
                    for (SootClass inf : interfaces) {
                        String infName;
                        String string = infName = inf.getName().contains("$") ? inf.getName().substring(inf.getName().indexOf("$") + 1) : inf.getName();
                        if (!methodName.equals("set" + infName)) continue;
                        try {
                            String listenerMethodName = String.valueOf(methodName.charAt(3)).toLowerCase() + methodName.substring(4, methodName.length() - 8);
                            SootMethod handlerMethod = null;
                            try {
                                handlerMethod = sootClass.getMethodByName(listenerMethodName);
                            }
                            catch (Exception e) {
                                if (listenerMethodName.endsWith("Change")) {
                                    listenerMethodName = listenerMethodName + "d";
                                }
                                handlerMethod = sootClass.getMethodByName(listenerMethodName);
                            }
                            return handlerMethod;
                        }
                        catch (RuntimeException runtimeException) {
                        }
                    }
                }
            }
            setterPoint = pred;
        }
        return null;
    }

    public static WidgetActionListener findWidgetHandlerAndId(PatchingChain<Unit> units, Unit unit, Application app) {
        List<ValueBox> useBoxes = unit.getUseBoxes();
        for (ValueBox valueBox : useBoxes) {
            Value value = valueBox.getValue();
            if (!(value instanceof JVirtualInvokeExpr)) continue;
            JVirtualInvokeExpr invokeExpr = (JVirtualInvokeExpr)value;
            SootMethodRef methodRef = invokeExpr.getMethodRef();
            String methodName = methodRef.name();
            if (methodName.matches("^setOn.*Listener$")) {
                SootMethod listener = EventHandlerExtractor.findListener(units, unit, invokeExpr.getArg(0), methodName);
                Value widgetId = EventHandlerExtractor.findWidgetId(units, unit, invokeExpr.getBase());
                return new WidgetActionListener(listener, widgetId, methodRef, app);
            }
            if (!invokeExpr.getMethod().getDeclaringClass().getName().equals(TYPE_ALERT_DIALOG$BUILDER) || !methodName.matches("^set.*Button$") && !methodName.equals(METHOD_SET_ITEMS)) continue;
            SootMethod listener = EventHandlerExtractor.findListener(units, unit, invokeExpr.getArg(1), METHOD_SET_ON_CLICK_LISTENER);
            Value widgetId = null;
            if (invokeExpr.getArg(0).getType().toString().equals("int")) {
                widgetId = invokeExpr.getArg(0);
            }
            return new WidgetActionListener(listener, widgetId, methodRef, app);
        }
        return null;
    }
}

