/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.seal.cactus.analysis.stat.model;

import edu.uci.seal.cactus.model.Application;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import soot.SootMethod;

public class EntrypointWidgetPerm {
    private static final Integer UNDEFINED_ID = -1;
    private String entryPoint;
    private Integer widgetId;
    private String widgetName;
    private Set<String> perms;

    private EntrypointWidgetPerm(String entryPoint, Integer widgetId, Set<String> perms, String widgetName) {
        this.entryPoint = entryPoint;
        this.widgetId = widgetId;
        this.perms = perms;
        this.widgetName = widgetName;
    }

    public static Collection<EntrypointWidgetPerm> generateEntryPointPerm(SootMethod entryPoint, Collection<Integer> widgetIds, Set<String> perms, Application app) {
        if (perms.isEmpty()) {
            return Collections.emptySet();
        }
        if (widgetIds == null || widgetIds.isEmpty()) {
            return Collections.singleton(new EntrypointWidgetPerm(entryPoint.getSignature(), UNDEFINED_ID, perms, "N/A"));
        }
        HashSet<EntrypointWidgetPerm> result = new HashSet<EntrypointWidgetPerm>();
        for (Integer widgetId : widgetIds) {
            String widgetName = app.getIdValueNames().get(widgetId);
            if (widgetName == null) {
                result.add(new EntrypointWidgetPerm(entryPoint.getSignature(), UNDEFINED_ID, perms, "N/A"));
                continue;
            }
            result.add(new EntrypointWidgetPerm(entryPoint.getSignature(), widgetId, perms, widgetName));
        }
        return result;
    }

    public String toString() {
        String permsStr = this.perms.stream().collect(Collectors.joining(","));
        return String.format("%s | %s(%d) | %s", this.entryPoint, this.widgetName == null ? "Any" : this.widgetName, this.widgetId, permsStr);
    }

    public static void saveResults(String output, Set<EntrypointWidgetPerm> entrypointWidgetPermSet) throws IOException {
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        for (EntrypointWidgetPerm entrypointWidgetPerm : entrypointWidgetPermSet) {
            arrayBuilder.add(entrypointWidgetPerm.buildJson());
        }
        HashMap<String, Boolean> properties = new HashMap<String, Boolean>(1);
        properties.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
        JsonWriter jsonWriter = Json.createWriterFactory(properties).createWriter(new FileWriter(output));
        jsonWriter.writeArray(arrayBuilder.build());
        jsonWriter.close();
    }

    private JsonObjectBuilder buildJson() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("widgetId", this.widgetId).add("widgetName", this.widgetName).add("entryPoint", this.entryPoint);
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        this.perms.forEach(arrayBuilder::add);
        builder.add("perm", arrayBuilder);
        return builder;
    }

    public static Set<EntrypointWidgetPerm> loadAnalysisResults(String input) throws FileNotFoundException {
        HashSet<EntrypointWidgetPerm> result = new HashSet<EntrypointWidgetPerm>();
        JsonReader jsonReader = Json.createReader(new FileReader(input));
        JsonArray jsonArray = jsonReader.readArray();
        for (JsonValue jsonValue : jsonArray) {
            Set<String> perms = ((JsonObject)jsonValue).getJsonArray("perm").stream().map(JsonValue::toString).map(s -> s.replaceAll("\"", "")).collect(Collectors.toSet());
            result.add(new EntrypointWidgetPerm(((JsonObject)jsonValue).getString("entryPoint"), ((JsonObject)jsonValue).getInt("widgetId"), perms, ((JsonObject)jsonValue).getString("widgetName")));
        }
        return result;
    }

    public String getEntryPoint() {
        return this.entryPoint;
    }

    public Integer getWidgetId() {
        return this.widgetId;
    }

    public String getWidgetName() {
        return this.widgetName;
    }

    public boolean isWidgetIdUndefined() {
        return this.widgetId == UNDEFINED_ID;
    }

    public Set<String> getPerms() {
        return this.perms;
    }
}

