/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.seal.cactus.analysis.stat.model;

import java.io.Serializable;
import soot.SootMethod;
import soot.Value;
import soot.ValueBox;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.infoflow.results.ResultSinkInfo;
import soot.jimple.infoflow.results.ResultSourceInfo;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;
import soot.jimple.internal.JVirtualInvokeExpr;
import soot.jimple.internal.JimpleLocal;

public class TestFlow
implements Serializable {
    FlowType mType;
    ResultSinkInfo mSinkInfo;
    SootMethod mSinkCallSite;
    ResultSourceInfo mSourceInfo;
    SootMethod mSourceCallSite;

    public TestFlow(ResultSinkInfo sinkInfo, ResultSourceInfo sourceInfo, IInfoflowCFG cfg) {
        this.mSinkInfo = sinkInfo;
        this.mSinkCallSite = (SootMethod)cfg.getMethodOf(sinkInfo.getSink());
        this.mSourceInfo = sourceInfo;
        this.mSourceCallSite = (SootMethod)cfg.getMethodOf(sourceInfo.getSource());
        this.mType = this.findType(sinkInfo.getSink());
    }

    private FlowType findType(Stmt sink) {
        InvokeExpr invokeExpr = sink.getInvokeExpr();
        if (invokeExpr == null) {
            return FlowType.INVALID;
        }
        String sinkMethodSignature = invokeExpr.getMethodRef().getSignature();
        if ("<android.support.test.espresso.ViewInteraction: android.support.test.espresso.ViewInteraction perform(android.support.test.espresso.ViewAction[])>".equals(sinkMethodSignature)) {
            return FlowType.ACTION_PERFORMER;
        }
        if ("<android.support.test.espresso.Espresso: android.support.test.espresso.ViewInteraction onView(org.hamcrest.Matcher)>".equals(sinkMethodSignature)) {
            return FlowType.GUI_Finder;
        }
        return FlowType.INVALID;
    }

    public boolean match(TestFlow otherFlow) {
        if (this.mType == otherFlow.mType) {
            return false;
        }
        JimpleLocal viewInteractionLocal = null;
        JimpleLocal contextViewLocal = null;
        if (this.mType == FlowType.GUI_Finder) {
            viewInteractionLocal = this.getTargetViewLocal(this.mSinkInfo.getSink());
            contextViewLocal = this.getContextViewLocal(otherFlow.mSinkInfo.getSink());
        }
        if (this.mType == FlowType.ACTION_PERFORMER) {
            viewInteractionLocal = this.getTargetViewLocal(otherFlow.mSinkInfo.getSink());
            contextViewLocal = this.getContextViewLocal(this.mSinkInfo.getSink());
        }
        return contextViewLocal != null && viewInteractionLocal != null && contextViewLocal.equivTo(viewInteractionLocal);
    }

    private JimpleLocal getTargetViewLocal(Stmt guiStmt) {
        for (ValueBox def : guiStmt.getDefBoxes()) {
            Value local = def.getValue();
            if (!"android.support.test.espresso.ViewInteraction".equals(local.getType().toString()) || !(local instanceof JimpleLocal)) continue;
            return (JimpleLocal)local;
        }
        return null;
    }

    private JimpleLocal getContextViewLocal(Stmt actionStmt) {
        Value base;
        InvokeExpr invokeExpr = actionStmt.getInvokeExpr();
        if (invokeExpr instanceof JVirtualInvokeExpr && "android.support.test.espresso.ViewInteraction".equals((base = ((JVirtualInvokeExpr)invokeExpr).getBase()).getType().toString()) && base instanceof JimpleLocal) {
            return (JimpleLocal)base;
        }
        return null;
    }

    public ResultSinkInfo getSinkInfo() {
        return this.mSinkInfo;
    }

    public SootMethod getSinkCallSite() {
        return this.mSinkCallSite;
    }

    public ResultSourceInfo getSourceInfo() {
        return this.mSourceInfo;
    }

    public SootMethod getSourceCallSite() {
        return this.mSourceCallSite;
    }

    public FlowType getType() {
        return this.mType;
    }

    public static enum FlowType {
        INVALID,
        GUI_Finder,
        ACTION_PERFORMER;

    }
}

