/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.seal.cactus.analysis.stat.model;

import edu.uci.seal.cactus.model.TestApplication;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonWriter;
import soot.SootMethod;
import soot.Unit;
import soot.tagkit.StringTag;
import soot.tagkit.Tag;

public class TestWidget {
    private Integer mWidgetId;
    private String mWidgetName;
    private String mAction;
    private String mTestMethod;
    private StringTag mTag;
    private String mCallerDesc;
    private Boolean mIsTestMethod;

    private TestWidget(Integer widgetId, String widgetName, String action, String testMethod, String callerDesc, Boolean isTestMethod) {
        this.mWidgetId = widgetId;
        this.mWidgetName = widgetName;
        this.mAction = action;
        this.mTestMethod = testMethod;
        this.mCallerDesc = callerDesc;
        this.mIsTestMethod = isTestMethod;
    }

    public TestWidget(Integer widgetId, String widgetName, String testMethod) {
        this(widgetId, widgetName, "N/A", testMethod, "N/A", true);
    }

    public TestWidget(Integer widgetId, String widgetName, String action, String callerDesc, StringTag tag) {
        this(widgetId, widgetName, action, null, callerDesc, false);
        this.mTag = tag;
    }

    public void addTestMethods(SootMethod[] methods) {
        for (SootMethod method : methods) {
            boolean hasTestAnnotation = TestApplication.hasTestAnnotation(method);
            String methodName = method.getDeclaringClass().getName() + "#" + method.getName();
            if (this.mTestMethod == null) {
                this.mTestMethod = methodName;
                this.mIsTestMethod = hasTestAnnotation;
                continue;
            }
            if (this.mIsTestMethod.booleanValue() || !hasTestAnnotation) continue;
            this.mTestMethod = methodName;
            this.mIsTestMethod = true;
        }
    }

    public static TestWidget findByPerformerUnitByTag(Unit performerUnit, Set<TestWidget> performerSet, String tagName) {
        for (TestWidget testWidget : performerSet) {
            for (Tag tag : performerUnit.getTags()) {
                if (!(tag instanceof StringTag) || !((StringTag)tag).getAnalysisType().equals(tagName) || !tag.toString().equals(testWidget.mTag.toString())) continue;
                return testWidget;
            }
        }
        return null;
    }

    public static TestWidget findByPerformerUnitByCallerDesc(SootMethod performerMethod, Unit performerUnit, Set<TestWidget> performerSet) {
        for (TestWidget testWidget : performerSet) {
            String desc = String.format("%s:%s", performerMethod.getSignature(), performerUnit.toString());
            if (!testWidget.mCallerDesc.equals(desc)) continue;
            return testWidget;
        }
        return null;
    }

    public String toString() {
        return String.format("%s | %s(%d) -> %s", this.mTestMethod, this.mWidgetName, this.mWidgetId, this.mAction);
    }

    public String toStringFull() {
        return String.format("%s;%d;%s;%s" + System.lineSeparator(), this.mWidgetName, this.mWidgetId, this.mAction, this.mCallerDesc);
    }

    public Integer getWidgetId() {
        return this.mWidgetId;
    }

    public String getAction() {
        return this.mAction;
    }

    public String getTestMethod() {
        return this.mTestMethod;
    }

    public Boolean isTestMethod() {
        return this.mIsTestMethod;
    }

    public String getWidgetName() {
        return this.mWidgetName;
    }

    public static void saveResults(String output, Set<TestWidget> performerSet) throws IOException {
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        for (TestWidget testWidget : performerSet) {
            arrayBuilder.add(testWidget.buildJson());
        }
        HashMap<String, Boolean> properties = new HashMap<String, Boolean>(1);
        properties.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
        JsonWriter jsonWriter = Json.createWriterFactory(properties).createWriter(new FileWriter(output));
        jsonWriter.writeArray(arrayBuilder.build());
        jsonWriter.close();
    }

    private JsonObjectBuilder buildJson() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("widgetId", this.mWidgetId).add("widgetName", this.mWidgetName).add("action", this.mAction).add("test", this.mTestMethod).add("callerUnit", this.mCallerDesc).add("isTestMethod", this.mIsTestMethod);
        return builder;
    }

    public static Set<TestWidget> loadAnalysisResults(String input) throws FileNotFoundException {
        HashSet<TestWidget> result = new HashSet<TestWidget>();
        File inputFile = new File(input);
        if (!inputFile.exists()) {
            return result;
        }
        JsonReader jsonReader = Json.createReader(new FileReader(inputFile));
        JsonArray jsonArray = jsonReader.readArray();
        result.addAll(jsonArray.stream().map(jsonValue -> new TestWidget(((JsonObject)jsonValue).getInt("widgetId"), ((JsonObject)jsonValue).getString("widgetName"), ((JsonObject)jsonValue).getString("action"), ((JsonObject)jsonValue).getString("test"), ((JsonObject)jsonValue).getString("callerUnit"), ((JsonObject)jsonValue).getBoolean("isTestMethod"))).collect(Collectors.toList()));
        return result;
    }
}

