/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.seal.cactus.analysis.stat.model;

import edu.uci.seal.cactus.model.Application;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Value;
import soot.jimple.IntConstant;

public class WidgetActionListener {
    private static final Pattern LISTENER_PATTERN = Pattern.compile("^on(.*)$");
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SootMethod mListenerMethod;
    private SootMethodRef mRegisterMethod;
    private int mWidgetId;
    private String mWidgetName;
    private String mAction;

    public WidgetActionListener(SootMethod listenerMethod, Value widget, SootMethodRef registerMethod, Application app) {
        Matcher matcher;
        this.mListenerMethod = listenerMethod;
        this.mRegisterMethod = registerMethod;
        if (widget != null && widget instanceof IntConstant) {
            this.mWidgetId = ((IntConstant)widget).value;
            this.mWidgetName = app.getIdValueNames().get(this.mWidgetId);
            if (this.mWidgetName == null) {
                this.logger.error("Could not find the widget Id {} ", (Object)this.mWidgetId);
            }
        }
        if (listenerMethod != null && (matcher = LISTENER_PATTERN.matcher(this.mListenerMethod.getName())).find()) {
            this.mAction = matcher.group(1);
        }
    }

    public String toString() {
        return this.mWidgetName + "->" + this.mAction;
    }

    public Integer getWidgetId() {
        return this.mWidgetId;
    }

    public String getAction() {
        return this.mAction;
    }

    public String getListenerMethodName() {
        if (this.mListenerMethod == null) {
            return null;
        }
        return this.mListenerMethod.getSignature();
    }
}

