/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.seal.cactus.analysis.stat.perm;

import edu.uci.seal.cactus.analysis.stat.model.EntrypointWidgetPerm;
import edu.uci.seal.cactus.analysis.stat.perm.MethodPermAnalyzer;
import edu.uci.seal.cactus.analysis.stat.perm.MethodSummary;
import edu.uci.seal.cactus.analysis.stat.preprocess.IpcHandler;
import edu.uci.seal.cactus.analysis.stat.preprocess.PermMapper;
import edu.uci.seal.cactus.model.Application;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import soot.Scene;
import soot.SootMethod;

public class AppPermAnalyzer {
    Application mApp;
    PermMapper mMapper;
    IpcHandler mIpcHandler;
    Map<String, MethodSummary> mMethodSummaries;
    private MethodPermAnalyzer mPermAnalyzer;
    private Set<EntrypointWidgetPerm> mAnalysisResults;

    public AppPermAnalyzer(Application app, String prmMappingRoot) throws IOException {
        this.mApp = app;
        this.mMethodSummaries = new HashMap<String, MethodSummary>();
        this.mMapper = new PermMapper(prmMappingRoot);
        this.mIpcHandler = new IpcHandler(this.mApp);
        this.mPermAnalyzer = new MethodPermAnalyzer(this);
        this.mAnalysisResults = new HashSet<EntrypointWidgetPerm>();
    }

    public Set<EntrypointWidgetPerm> getAnalysisResults() {
        return this.mAnalysisResults;
    }

    public void runAnalysis(Collection<SootMethod> entryPoints) {
        this.findMethodSummaries();
        for (SootMethod entryPoint : entryPoints) {
            if (entryPoint.getName().equals("onRequestPermissionsResult")) continue;
            this.mAnalysisResults.addAll(this.mPermAnalyzer.analyzeMethod(entryPoint));
        }
    }

    private void findMethodSummaries() {
        for (SootMethod method : this.getAllAppMethods()) {
            MethodSummary methodSummary = this.mPermAnalyzer.summarizeMethod(method);
            if (methodSummary == null) continue;
            this.mMethodSummaries.put(method.getSignature(), methodSummary);
        }
    }

    private Collection<SootMethod> getAllAppMethods() {
        HashSet<SootMethod> result = new HashSet<SootMethod>();
        Scene.v().getApplicationClasses().stream().filter(applicationClass -> !applicationClass.isPhantom() && applicationClass.getPackageName().startsWith(this.mApp.getPackageName())).forEach(applicationClass -> result.addAll(applicationClass.getMethods()));
        return result;
    }
}

