/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.seal.cactus.analysis.stat.perm;

import edu.uci.seal.cactus.analysis.MethodNamesConst;
import edu.uci.seal.cactus.analysis.stat.model.EntrypointWidgetPerm;
import edu.uci.seal.cactus.analysis.stat.perm.AppPermAnalyzer;
import edu.uci.seal.cactus.analysis.stat.perm.MethodSummary;
import edu.uci.seal.cactus.analysis.stat.perm.WidgetConditionFlowAnalysis;
import edu.uci.seal.cactus.util.SootUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import soot.Body;
import soot.PatchingChain;
import soot.RefType;
import soot.SootClass;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Unit;
import soot.Value;
import soot.jimple.InvokeExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.internal.JInvokeStmt;
import soot.jimple.internal.JVirtualInvokeExpr;
import soot.jimple.toolkits.callgraph.Edge;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.scalar.FlowSet;

class MethodPermAnalyzer {
    private AppPermAnalyzer mPermAnalyzer;

    MethodPermAnalyzer(AppPermAnalyzer permAnalyzer) {
        this.mPermAnalyzer = permAnalyzer;
    }

    MethodSummary summarizeMethod(SootMethod method) {
        if (!method.hasActiveBody()) {
            return null;
        }
        MethodSummary summary = new MethodSummary(method);
        Body body = method.retrieveActiveBody();
        PatchingChain<Unit> units = body.getUnits();
        for (Unit unit : units) {
            InvokeExpr invokeExpr = SootUtil.getInvokedMethod(unit);
            if (invokeExpr != null) {
                SootMethod calleeMethod = invokeExpr.getMethod();
                Set<String> perms = this.mPermAnalyzer.mMapper.getApiPerms(calleeMethod.getSignature());
                summary.mRequiredPerm.addAll(perms);
                this.processThreadCalls(invokeExpr, unit, units, summary);
                this.processAsyncTaskExecutor(invokeExpr);
                this.processDialogShow(invokeExpr);
            }
            Iterator<Edge> methodCalls = this.mPermAnalyzer.mApp.getCallGraph().edgesOutOf(unit);
            while (methodCalls.hasNext()) {
                Edge edge = methodCalls.next();
                SootMethod callee = edge.getTgt().method();
                summary.addCalleeSet(callee, this.mPermAnalyzer.mMethodSummaries);
            }
        }
        Set<SootMethod> ipcCalleeMethods = this.mPermAnalyzer.mIpcHandler.getIpcCallee(method.getSignature());
        summary.addCalleeSet(ipcCalleeMethods, this.mPermAnalyzer.mMethodSummaries);
        Set<String> perms = this.mPermAnalyzer.mIpcHandler.getIntentAndContentPerm(method.getSignature(), this.mPermAnalyzer.mMapper);
        summary.mRequiredPerm.addAll(perms);
        return summary;
    }

    Set<EntrypointWidgetPerm> analyzeMethod(SootMethod method) {
        HashSet<EntrypointWidgetPerm> result = new HashSet<EntrypointWidgetPerm>();
        Body body = method.retrieveActiveBody();
        WidgetConditionFlowAnalysis conditionFlowAnalysis = new WidgetConditionFlowAnalysis(new ExceptionalUnitGraph(body));
        PatchingChain<Unit> units = body.getUnits();
        for (Unit unit : units) {
            InvokeExpr invokeExpr = SootUtil.getInvokedMethod(unit);
            FlowSet flowBefore = (FlowSet)conditionFlowAnalysis.getFallFlowAfter(unit);
            if (invokeExpr == null) continue;
            String calleeSig = invokeExpr.getMethodRef().getSignature();
            Set<String> perms = this.mPermAnalyzer.mMapper.getApiPerms(calleeSig);
            result.addAll(EntrypointWidgetPerm.generateEntryPointPerm(method, flowBefore.toList(), perms, this.mPermAnalyzer.mApp));
            perms = this.getPermFromSummaryCallGraph(calleeSig);
            result.addAll(EntrypointWidgetPerm.generateEntryPointPerm(method, flowBefore.toList(), perms, this.mPermAnalyzer.mApp));
        }
        Set<String> perms = this.mPermAnalyzer.mIpcHandler.getIntentAndContentPerm(method.getSignature(), this.mPermAnalyzer.mMapper);
        result.addAll(EntrypointWidgetPerm.generateEntryPointPerm(method, null, perms, this.mPermAnalyzer.mApp));
        return result;
    }

    private Set<String> getPermFromSummaryCallGraph(String methodSig) {
        HashSet<String> requiredPerms = new HashSet<String>();
        HashSet<String> visitedMethods = new HashSet<String>();
        LinkedList<String> toBeVisitedMethods = new LinkedList<String>();
        toBeVisitedMethods.add(methodSig);
        while (!toBeVisitedMethods.isEmpty()) {
            String currentMethodSig = (String)toBeVisitedMethods.remove(0);
            visitedMethods.add(currentMethodSig);
            MethodSummary currentMethodSummary = this.mPermAnalyzer.mMethodSummaries.get(currentMethodSig);
            if (currentMethodSummary == null) continue;
            this.addMethodToBeProcessed(currentMethodSummary.getCalleeSet(), visitedMethods, toBeVisitedMethods);
            requiredPerms.addAll(currentMethodSummary.mRequiredPerm);
        }
        return requiredPerms;
    }

    private void addMethodToBeProcessed(Set<SootMethod> calleeSet, Set<String> visitedMethods, List<String> toBeVisitedMethods) {
        calleeSet.stream().filter(callee -> !callee.isPhantom() && !toBeVisitedMethods.contains(callee.getSignature()) && !visitedMethods.contains(callee.getSignature()) && callee.getDeclaringClass().getPackageName().startsWith(this.mPermAnalyzer.mApp.getPackageName())).map(SootMethod::getSignature).forEach(toBeVisitedMethods::add);
    }

    private void processThreadCalls(InvokeExpr invokeExpr, Unit unit, PatchingChain<Unit> units, MethodSummary summary) {
        try {
            InvokeExpr threadInitInvoke;
            Value runnableVal;
            Unit runnableInit;
            JVirtualInvokeExpr startInvokeExpr;
            Unit threadInit;
            SootMethod calleeMethod = invokeExpr.getMethod();
            if (MethodNamesConst.THREAD_ENTRY_POINTS.contains(calleeMethod.getSignature()) && invokeExpr instanceof JVirtualInvokeExpr && (threadInit = SootUtil.findClosestUsePointBackward(unit, (startInvokeExpr = (JVirtualInvokeExpr)invokeExpr).getBase(), units)) != null && threadInit instanceof JInvokeStmt && (runnableInit = SootUtil.findClosestUsePointBackward(threadInit, runnableVal = ((JInvokeStmt)threadInit).getInvokeExpr().getArg(0), units)) instanceof JInvokeStmt && (threadInitInvoke = ((JInvokeStmt)runnableInit).getInvokeExpr()) instanceof SpecialInvokeExpr) {
                SootClass runnableClass = ((RefType)((SpecialInvokeExpr)threadInitInvoke).getBase().getType()).getSootClass();
                SootMethod runMethod = runnableClass.getMethodByName("run");
                summary.addCalleeSet(runMethod, this.mPermAnalyzer.mMethodSummaries);
            }
        }
        catch (Exception e) {
            System.err.println("Exception in Handling thread call");
        }
    }

    private void processAsyncTaskExecutor(InvokeExpr invokeExpr) {
        try {
            SootMethodRef calleeMethod = invokeExpr.getMethodRef();
            if ("android.os.AsyncTask execute(java.lang.Object[])".equals(calleeMethod.getSubSignature().getString()) && invokeExpr instanceof JVirtualInvokeExpr) {
                JVirtualInvokeExpr startInvokeExpr = (JVirtualInvokeExpr)invokeExpr;
                SootClass taskClass = ((RefType)startInvokeExpr.getBase().getType()).getSootClass();
                MethodSummary summary = this.mPermAnalyzer.mMethodSummaries.get(calleeMethod.getSignature());
                if (summary == null) {
                    summary = new MethodSummary(calleeMethod.getSignature());
                    this.mPermAnalyzer.mMethodSummaries.put(calleeMethod.getSignature(), summary);
                }
                taskClass.getMethods().stream().filter(method -> Arrays.asList("doInBackground", "onPreExecute", "onPostExecute").contains(method.getName())).forEach(summary.getCalleeSet()::add);
            }
        }
        catch (Exception e) {
            System.err.println("Exception in Handling thread call");
        }
    }

    private void processDialogShow(InvokeExpr invokeExpr) {
        try {
            SootMethodRef calleeMethod = invokeExpr.getMethodRef();
            SootClass sootClass = calleeMethod.declaringClass();
            if (SootUtil.isInheritedFromClass(sootClass, "android.support.v4.app.DialogFragment") && "void show(android.support.v4.app.FragmentManager,java.lang.String)".equals(calleeMethod.getSubSignature().getString())) {
                SootMethod createMethod = invokeExpr.getMethodRef().declaringClass().getMethodByName("onCreate");
                MethodSummary summary = this.mPermAnalyzer.mMethodSummaries.get(calleeMethod.getSignature());
                if (summary == null) {
                    summary = new MethodSummary(calleeMethod.getSignature());
                    this.mPermAnalyzer.mMethodSummaries.put(calleeMethod.getSignature(), summary);
                }
                summary.addCalleeSet(createMethod, this.mPermAnalyzer.mMethodSummaries);
            }
        }
        catch (Exception e) {
            System.err.println("Exception in Handling dialog");
        }
    }
}

