/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.seal.cactus.analysis.stat.perm;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import soot.SootMethod;

class MethodSummary {
    String mMethod;
    private Set<SootMethod> mCalleeSet;
    Set<String> mRequiredPerm;
    private Set<String> mCallerSet;

    MethodSummary(String methodSig) {
        this.mMethod = methodSig;
        this.mCalleeSet = new HashSet<SootMethod>();
        this.mRequiredPerm = new HashSet<String>();
        this.mCallerSet = new HashSet<String>();
    }

    MethodSummary(SootMethod method) {
        this(method.getSignature());
    }

    void addCalleeSet(SootMethod callee, Map<String, MethodSummary> methodSummaries) {
        this.mCalleeSet.add(callee);
        MethodSummary calleeSummary = methodSummaries.get(callee.getSignature());
        if (calleeSummary == null) {
            calleeSummary = new MethodSummary(callee.getSignature());
            methodSummaries.put(callee.getSignature(), calleeSummary);
        }
        calleeSummary.mCallerSet.add(this.mMethod);
    }

    void addCalleeSet(Set<SootMethod> calleeMethods, Map<String, MethodSummary> methodSummaries) {
        calleeMethods.forEach(calleeMethod -> this.addCalleeSet((SootMethod)calleeMethod, methodSummaries));
    }

    public Set<SootMethod> getCalleeSet() {
        return this.mCalleeSet;
    }
}

