/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.seal.cactus.analysis.stat.perm;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import soot.Unit;
import soot.Value;
import soot.jimple.IntConstant;
import soot.jimple.internal.JIfStmt;
import soot.jimple.internal.JLookupSwitchStmt;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ArraySparseSet;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.ForwardBranchedFlowAnalysis;

public class WidgetConditionFlowAnalysis
extends ForwardBranchedFlowAnalysis<FlowSet<Integer>> {
    private FlowSet<Integer> emptySet = new ArraySparseSet<Integer>();
    private Map<Unit, Integer> mGeneratedSet;

    public WidgetConditionFlowAnalysis(UnitGraph graph) {
        super(graph);
        this.findConditionalWidgets(graph);
        this.doAnalysis();
    }

    private void findConditionalWidgets(UnitGraph graph) {
        this.mGeneratedSet = new HashMap<Unit, Integer>();
        for (Unit unit : graph) {
            if (unit instanceof JIfStmt) {
                JIfStmt ifStmt = (JIfStmt)unit;
                Value condition = ifStmt.getCondition();
                condition.getUseBoxes().stream().filter(valueBox -> valueBox.getValue() instanceof IntConstant).forEach(valueBox -> this.mGeneratedSet.put(unit, ((IntConstant)valueBox.getValue()).value));
                continue;
            }
            if (!(unit instanceof JLookupSwitchStmt)) continue;
            JLookupSwitchStmt switchStmt = (JLookupSwitchStmt)unit;
            List<IntConstant> lookupValues = switchStmt.getLookupValues();
            for (int i = 0; i < lookupValues.size(); ++i) {
                this.mGeneratedSet.put(switchStmt.getTarget(i), lookupValues.get((int)i).value);
            }
        }
    }

    @Override
    protected void flowThrough(FlowSet<Integer> in, Unit unit, List<FlowSet<Integer>> outFallList, List<FlowSet<Integer>> outBranchList) {
        for (FlowSet<Integer> outFall : outFallList) {
            this.copy(in, outFall);
            Integer widgetId = this.mGeneratedSet.get(unit);
            if (widgetId == null) continue;
            outFall.add(widgetId);
        }
        for (FlowSet<Integer> outBranch : outBranchList) {
            this.copy(in, outBranch);
        }
    }

    @Override
    protected FlowSet<Integer> newInitialFlow() {
        return this.emptySet.clone();
    }

    @Override
    protected void merge(FlowSet<Integer> in1, FlowSet<Integer> in2, FlowSet<Integer> out) {
        in1.intersection(in2, out);
    }

    @Override
    protected void copy(FlowSet<Integer> source, FlowSet<Integer> dest) {
        source.copy(dest);
    }
}

