/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.seal.cactus.analysis.stat.preprocess;

import edu.psu.cse.siis.ic3.Ic3Data;
import edu.uci.seal.cactus.analysis.stat.preprocess.PermMapper;
import edu.uci.seal.cactus.model.Application;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;

public class IpcHandler {
    private Set<Ic3Data.Application.Component> mIpcComponents;
    private Application mApp;

    public IpcHandler(Application app) throws IOException {
        this.mApp = app;
        this.mIpcComponents = new HashSet<Ic3Data.Application.Component>();
        File ipcResults = new File(this.mApp.getIpcProtoBuf());
        if (ipcResults.exists()) {
            FileInputStream stream = new FileInputStream(this.mApp.getIpcProtoBuf());
            Ic3Data.Application application = Ic3Data.Application.parseFrom(stream);
            this.mIpcComponents.addAll(application.getComponentsList());
        }
    }

    public Set<String> getIntentAndContentPerm(String callerMethod, PermMapper mapper) {
        HashSet<String> results = new HashSet<String>();
        for (Ic3Data.Application.Component component : this.mIpcComponents) {
            component.getExitPointsList().stream().filter(exitPoint -> exitPoint.getInstruction().getMethod().equals(callerMethod)).forEach(exitPoint -> {
                results.addAll(mapper.getIntentPerms(this.getIntentAction((Ic3Data.Application.Component.ExitPoint)exitPoint)));
                results.addAll(mapper.getProviderPerms(this.getContentURI((Ic3Data.Application.Component.ExitPoint)exitPoint)));
            });
        }
        return results;
    }

    private String getContentURI(Ic3Data.Application.Component.ExitPoint exitPoint) {
        for (Ic3Data.Application.Component.ExitPoint.Uri uri : exitPoint.getUrisList()) {
            for (Ic3Data.Attribute attribute : uri.getAttributesList()) {
                if (!attribute.hasKind() || attribute.getKind() != Ic3Data.AttributeKind.URI) continue;
                return attribute.getValue(0);
            }
        }
        return null;
    }

    private String getIntentAction(Ic3Data.Application.Component.ExitPoint exitPoint) {
        for (Ic3Data.Application.Component.ExitPoint.Intent intent : exitPoint.getIntentsList()) {
            for (Ic3Data.Attribute attribute : intent.getAttributesList()) {
                if (!attribute.hasKind() || attribute.getKind() != Ic3Data.AttributeKind.ACTION) continue;
                return attribute.getValue(0);
            }
        }
        return null;
    }

    public Set<SootMethod> getIpcCallee(String callerMethod) {
        HashSet<SootMethod> results = new HashSet<SootMethod>();
        for (Ic3Data.Application.Component component : this.mIpcComponents) {
            component.getExitPointsList().stream().filter(exitPoint -> exitPoint.getInstruction().getMethod().equals(callerMethod)).forEach(exitPoint -> {
                SootMethod calleeMethod = this.getCalleeMethod(component, (Ic3Data.Application.Component.ExitPoint)exitPoint);
                if (calleeMethod != null) {
                    results.add(calleeMethod);
                }
            });
        }
        return results;
    }

    private SootMethod getCalleeMethod(Ic3Data.Application.Component component, Ic3Data.Application.Component.ExitPoint exitPoint) {
        String callerStatement = exitPoint.getInstruction().getStatement();
        for (Ic3Data.Application.Component.ExitPoint.Intent intent : exitPoint.getIntentsList()) {
            String entryPoint;
            SootClass targetClass;
            String target = IpcHandler.getIntentTarget(intent);
            if (target == null || target.isEmpty() || !(targetClass = Scene.v().loadClassAndSupport(target)).getPackageName().equals(this.mApp.getPackageName()) || (entryPoint = IpcHandler.getIpcEntryPoint(component.getKind(), callerStatement)) == null) continue;
            SootMethod sootMethod = targetClass.getMethodByNameUnsafe(entryPoint);
            SootClass superclass = targetClass;
            while ((superclass = superclass.getSuperclass()) != null && sootMethod == null) {
                sootMethod = superclass.getMethodByNameUnsafe(entryPoint);
            }
            return sootMethod;
        }
        return null;
    }

    private static String getIntentTarget(Ic3Data.Application.Component.ExitPoint.Intent intent) {
        for (Ic3Data.Attribute attribute : intent.getAttributesList()) {
            if (!attribute.hasKind() || attribute.getKind() != Ic3Data.AttributeKind.CLASS) continue;
            return attribute.getValue(0).replaceAll("/", ".");
        }
        return null;
    }

    private static String getIpcEntryPoint(Ic3Data.Application.Component.ComponentKind kind, String callerStatement) {
        switch (kind) {
            case ACTIVITY: {
                if (callerStatement.contains("startActivity")) {
                    return "onCreate";
                }
            }
            case SERVICE: {
                if (callerStatement.contains("startService")) {
                    return "onStartCommand";
                }
                if (callerStatement.contains("bindService")) {
                    return "onBind";
                }
            }
            case RECEIVER: {
                break;
            }
            case DYNAMIC_RECEIVER: {
                break;
            }
        }
        return null;
    }
}

