/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.seal.cactus.analysis.stat.preprocess;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javassist.bytecode.Descriptor;

public class PermMapper {
    private static final String API_PRM_MAPPING = "jellybean_allmappings.txt";
    private static final String INTENT_PRM_MAPPING = "jellybean_intentpermissions.txt";
    private static final String PROVIDER_PRM_MAPPING = "jellybean_contentproviderpermission.txt";
    private Map<String, Set<String>> mApiPrmMap = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> mIntentPrmMap = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> mProviderPrmMap = new HashMap<String, Set<String>>();

    public PermMapper(String mappingRoot) {
        this.processAPIMappingFileText(new File(mappingRoot, API_PRM_MAPPING));
        this.processIntentMappingFile(new File(mappingRoot, INTENT_PRM_MAPPING));
        this.processProviderMappingFile(new File(mappingRoot, PROVIDER_PRM_MAPPING));
    }

    private static void addPrmToMap(Map<String, Set<String>> map, String prm, String key) {
        Set<String> perms = map.get(key);
        if (perms == null) {
            perms = new HashSet<String>();
        }
        perms.add(prm);
        map.put(key, perms);
    }

    private void processProviderMappingFile(File mappingFile) {
        try (BufferedReader reader = new BufferedReader(new FileReader(mappingFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] segments = line.split(" ");
                if (segments.length != 3) continue;
                String content = segments[0];
                String prm = segments[2];
                if (!prm.startsWith("android.permission.") || !content.startsWith("content://")) continue;
                prm = prm.substring(prm.lastIndexOf(".") + 1);
                PermMapper.addPrmToMap(this.mProviderPrmMap, prm, content);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void processIntentMappingFile(File mappingFile) {
        try (BufferedReader reader = new BufferedReader(new FileReader(mappingFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                String prm;
                String[] segments = line.split(" ");
                if (segments.length != 3 || !(prm = segments[1]).startsWith("android.permission.")) continue;
                prm = prm.substring(prm.lastIndexOf(".") + 1);
                String intent = segments[0];
                PermMapper.addPrmToMap(this.mIntentPrmMap, prm, intent);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void processAPIMappingFileText(File mappingFile) {
        String prm = null;
        try (BufferedReader reader = new BufferedReader(new FileReader(mappingFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("Permission")) {
                    prm = line.split(":")[1];
                    prm = prm.substring(prm.lastIndexOf(".") + 1);
                    continue;
                }
                if (prm == null || !line.startsWith("<")) continue;
                String signature = line.substring(line.indexOf("<"), line.lastIndexOf(">") + 1);
                PermMapper.addPrmToMap(this.mApiPrmMap, prm, signature);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void processMappingFileCsv(String mappingFile) {
        Pattern descPattern = Pattern.compile("^(\\(.*\\))(.*)");
        try (BufferedReader reader = new BufferedReader(new FileReader(mappingFile));){
            String line = reader.readLine();
            while ((line = reader.readLine()) != null) {
                String[] elements = line.split(",");
                String prm = elements[3];
                String signature = this.genSootMethod(elements[0], elements[1], elements[2], descPattern);
                Set<String> perms = this.mApiPrmMap.get(signature);
                if (perms == null) {
                    perms = new HashSet<String>();
                }
                perms.add(prm);
                this.mApiPrmMap.put(signature, perms);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String genSootMethod(String className, String methodName, String methodDesc, Pattern descPattern) {
        Matcher matcher = descPattern.matcher(methodDesc);
        if (matcher.find()) {
            String paramTypes = Descriptor.toString(matcher.group(1));
            String returnType = Descriptor.toString(matcher.group(2));
            return String.format("<%s: %s %s%s>", className.replaceAll("/", "."), returnType, methodName, paramTypes);
        }
        System.err.format("Method is invalid %s", methodDesc);
        return null;
    }

    public Set<String> getApiPerms(String action) {
        Set<String> perms = this.mApiPrmMap.get(action);
        if (perms == null) {
            return Collections.emptySet();
        }
        return perms;
    }

    Set<String> getIntentPerms(String action) {
        Set<String> perms = this.mIntentPrmMap.get(action);
        if (perms == null) {
            return Collections.emptySet();
        }
        return perms;
    }

    Set<String> getProviderPerms(String uri) {
        if (uri == null) {
            return Collections.emptySet();
        }
        HashSet<String> perms = new HashSet<String>();
        for (String content : this.mProviderPrmMap.keySet()) {
            if (!uri.startsWith(content)) continue;
            perms.addAll((Collection<String>)this.mProviderPrmMap.get(content));
        }
        return perms;
    }
}

