/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.seal.cactus.analysis.stat.test.dataflow;

import edu.uci.seal.cactus.util.Res;
import java.io.IOException;
import java.util.Set;
import org.xmlpull.v1.XmlPullParserException;
import soot.jimple.infoflow.android.InfoflowAndroidConfiguration;
import soot.jimple.infoflow.android.SetupApplication;
import soot.jimple.infoflow.android.data.AndroidMethod;
import soot.jimple.infoflow.handlers.ResultsAvailableHandler;
import soot.jimple.infoflow.results.InfoflowResults;
import soot.jimple.infoflow.taintWrappers.EasyTaintWrapper;

public class FlowAnalyzer {
    public static InfoflowResults runAnalysis(SetupApplication app, ResultsAvailableHandler handler, String sourceSinkFile) {
        return FlowAnalyzer.runAnalysis(app, handler, sourceSinkFile, null, null);
    }

    public static InfoflowResults runAnalysis(SetupApplication app, ResultsAvailableHandler handler, Set<AndroidMethod> sources, Set<AndroidMethod> sinks) {
        return FlowAnalyzer.runAnalysis(app, handler, null, sources, sinks);
    }

    private static InfoflowResults runAnalysis(SetupApplication app, ResultsAvailableHandler handler, String sourceSinkFile, Set<AndroidMethod> sources, Set<AndroidMethod> sinks) {
        try {
            long beforeRun = System.nanoTime();
            InfoflowAndroidConfiguration config = new InfoflowAndroidConfiguration();
            app.setConfig(config);
            EasyTaintWrapper easyTaintWrapper = new EasyTaintWrapper(Res.TAINT_WRAPPER);
            easyTaintWrapper.setAggressiveMode(false);
            app.setTaintWrapper(easyTaintWrapper);
            if (sourceSinkFile != null) {
                app.calculateSourcesSinksEntrypoints(sourceSinkFile);
            } else {
                app.calculateSourcesSinksEntrypoints(sources, sinks);
            }
            System.out.println("Running data flow analysis...");
            InfoflowResults res = app.runInfoflow(handler);
            System.out.println("Analysis has run for " + (double)(System.nanoTime() - beforeRun) / 1.0E9 + " seconds");
            return res;
        }
        catch (IOException ex) {
            System.err.println("Could not read file: " + ex.getMessage());
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
        catch (XmlPullParserException ex) {
            System.err.println("Could not read Android manifest file: " + ex.getMessage());
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
    }
}

