/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.seal.cactus.analysis.stat.test.dataflow;

import edu.uci.seal.cactus.analysis.stat.model.TestFlow;
import edu.uci.seal.cactus.analysis.stat.model.TestWidget;
import edu.uci.seal.cactus.analysis.stat.test.BaseTestAnalyzer;
import edu.uci.seal.cactus.analysis.stat.test.ITestAnalyzer;
import edu.uci.seal.cactus.analysis.stat.test.dataflow.BaseResultsAvailableHandler;
import edu.uci.seal.cactus.analysis.stat.test.dataflow.FlowAnalyzer;
import edu.uci.seal.cactus.analysis.stat.test.dataflow.SetupTestApplication;
import edu.uci.seal.cactus.analysis.stat.test.naive.EspressoTestWidgetCreator;
import edu.uci.seal.cactus.model.TestApplication;
import edu.uci.seal.cactus.util.Res;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import soot.SootMethod;
import soot.jimple.Stmt;
import soot.jimple.infoflow.handlers.ResultsAvailableHandler;
import soot.jimple.infoflow.results.InfoflowResults;
import soot.jimple.infoflow.results.ResultSinkInfo;
import soot.jimple.infoflow.results.ResultSourceInfo;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;
import soot.tagkit.StringTag;
import soot.util.MultiMap;

public class FlowBasedTestAnalyzer
extends BaseTestAnalyzer
implements ITestAnalyzer {
    private Set<TestFlow> mGuiFinderFlows = new HashSet<TestFlow>();
    private Set<TestFlow> mActionPerformerFlows = new HashSet<TestFlow>();
    private static final String TAG_NAME = "widget_tag";

    public FlowBasedTestAnalyzer(TestApplication testApp) {
        super(testApp);
    }

    @Override
    public void runAnalysis() {
        EspressoResultsAvailableHandler handler = new EspressoResultsAvailableHandler(this);
        SetupTestApplication app = new SetupTestApplication(this.mTestApp.getAndroidJar(), this.mTestApp);
        FlowAnalyzer.runAnalysis(app, handler, Res.SOURCE_SINK_TEST_FILE);
    }

    private void processFlowResults(MultiMap<ResultSinkInfo, ResultSourceInfo> flowResults, IInfoflowCFG cfg) {
        for (ResultSinkInfo sinkInfo : flowResults.keySet()) {
            for (ResultSourceInfo sourceInfo : flowResults.get(sinkInfo)) {
                TestFlow testFlow = new TestFlow(sinkInfo, sourceInfo, cfg);
                switch (testFlow.getType()) {
                    case GUI_Finder: {
                        this.mGuiFinderFlows.add(testFlow);
                        break;
                    }
                    case ACTION_PERFORMER: {
                        this.mActionPerformerFlows.add(testFlow);
                    }
                }
            }
        }
        for (TestFlow guiFlow : this.mGuiFinderFlows) {
            this.mActionPerformerFlows.stream().filter(guiFlow::match).forEach(actionFlow -> this.addTestWidget(guiFlow, (TestFlow)actionFlow));
        }
    }

    private void addTestWidget(TestFlow guiFlow, TestFlow actionFlow) {
        Integer widgetId = EspressoTestWidgetCreator.retrieveWidgetId(guiFlow.getSourceInfo().getSource().getInvokeExpr());
        if (widgetId == null) {
            return;
        }
        String widgetName = this.mTestApp.getIdValueNames().get(widgetId);
        String action = this.extractActionType(actionFlow.getSourceInfo().getSource());
        StringTag tag = new StringTag(String.valueOf(ThreadLocalRandom.current().nextInt(10000000)), TAG_NAME);
        Stmt sink = actionFlow.getSinkInfo().getSink();
        sink.addTag(tag);
        String callerDesc = sink.toString();
        TestWidget widget = new TestWidget(widgetId, widgetName != null ? widgetName : "N/A", action, callerDesc, tag);
        widget.addTestMethods(new SootMethod[]{guiFlow.getSinkCallSite(), guiFlow.getSourceCallSite(), actionFlow.getSinkCallSite(), actionFlow.getSourceCallSite()});
    }

    private String extractActionType(Stmt actionStmt) {
        return actionStmt.getInvokeExpr().getMethod().getName();
    }

    private static final class EspressoResultsAvailableHandler
    extends BaseResultsAvailableHandler
    implements ResultsAvailableHandler {
        FlowBasedTestAnalyzer mFlowBasedTestAnalyzer;

        public EspressoResultsAvailableHandler(FlowBasedTestAnalyzer flowBasedTestAnalyzer) {
            this.mFlowBasedTestAnalyzer = flowBasedTestAnalyzer;
        }

        @Override
        protected void processFlowResults(IInfoflowCFG cfg, InfoflowResults results) {
            this.mFlowBasedTestAnalyzer.processFlowResults(results.getResults(), cfg);
        }
    }
}

