/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.seal.cactus.analysis.stat.test.dataflow;

import edu.uci.seal.cactus.model.TestApplication;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import soot.Local;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.javaToJimple.LocalGenerator;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.infoflow.entryPointCreators.BaseEntryPointCreator;
import soot.jimple.infoflow.entryPointCreators.IEntryPointCreator;
import soot.jimple.toolkits.scalar.NopEliminator;
import soot.options.Options;

class TestEntryPointCreator
extends BaseEntryPointCreator
implements IEntryPointCreator {
    private static final boolean DEBUG = false;
    private Map<String, List<SootMethod>> mEntryPoints = new HashMap<String, List<SootMethod>>();

    TestEntryPointCreator(TestApplication testApp) {
        for (String testClassName : testApp.getTestClasses().keySet()) {
            ArrayList entryPoints = new ArrayList();
            entryPoints.addAll(testApp.getSetupMethods().get(testClassName));
            entryPoints.addAll(testApp.getTestMethods().get(testClassName));
            this.mEntryPoints.put(testClassName, entryPoints);
        }
    }

    @Override
    protected SootMethod createDummyMainInternal(SootMethod emptySootMethod) {
        JimpleBody body = (JimpleBody)emptySootMethod.getActiveBody();
        LocalGenerator generator = new LocalGenerator(body);
        for (String testClassName : this.mEntryPoints.keySet()) {
            SootClass testClass = Scene.v().getSootClass(testClassName);
            Local localVal = this.generateClassConstructor(testClass, body);
            this.localVarsForClasses.put(testClass.getName(), localVal);
            List<SootMethod> testMethods = this.mEntryPoints.get(testClassName);
            for (SootMethod testMethod : testMethods) {
                this.buildMethodCall(testMethod, body, localVal, generator);
            }
        }
        body.getUnits().add(Jimple.v().newReturnVoidStmt());
        NopEliminator.v().transform(body);
        if (Options.v().validate()) {
            emptySootMethod.getActiveBody().validate();
        }
        this.logger.info("Generated main method:\n{}", (Object)body);
        return emptySootMethod;
    }

    @Override
    public Collection<String> getRequiredClasses() {
        return this.mEntryPoints.keySet();
    }
}

