/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.seal.cactus.analysis.stat.test.naive;

import edu.uci.seal.cactus.analysis.stat.model.TestWidget;
import edu.uci.seal.cactus.analysis.stat.test.BaseTestAnalyzer;
import edu.uci.seal.cactus.analysis.stat.test.ITestAnalyzer;
import edu.uci.seal.cactus.analysis.stat.test.naive.BaseTestWidgetCreator;
import edu.uci.seal.cactus.analysis.stat.test.naive.EspressoTestWidgetCreator;
import edu.uci.seal.cactus.analysis.stat.test.naive.RobotiumTestWidgetCreator;
import edu.uci.seal.cactus.model.TestApplication;
import java.util.List;
import soot.Body;
import soot.SootMethod;
import soot.ValueBox;
import soot.jimple.InvokeExpr;

public class NaiveTestAnalyzer
extends BaseTestAnalyzer
implements ITestAnalyzer {
    public NaiveTestAnalyzer(TestApplication testApplication) {
        super(testApplication);
    }

    @Override
    public void runAnalysis() {
        for (String testClassName : this.mTestApp.getTestMethods().keySet()) {
            TestApplication.TestFramework testFramework = this.mTestApp.getTestClasses().get(testClassName);
            List<SootMethod> testMethods = this.mTestApp.getTestMethods().get(testClassName);
            for (SootMethod testMethod : testMethods) {
                this.processTestMethod(testMethod, testFramework);
            }
        }
    }

    private void processTestMethod(SootMethod testMethod, TestApplication.TestFramework testFramework) {
        BaseTestWidgetCreator testWidgetCreator;
        Body body = testMethod.retrieveActiveBody();
        if (testFramework == TestApplication.TestFramework.ESPRESSO) {
            testWidgetCreator = new EspressoTestWidgetCreator(testMethod, this.mTestApp);
        } else if (testFramework == TestApplication.TestFramework.ROBOTIUM) {
            testWidgetCreator = new RobotiumTestWidgetCreator(testMethod, this.mTestApp);
        } else {
            return;
        }
        for (ValueBox valueBox : body.getUseBoxes()) {
            TestWidget testWidget;
            if (!(valueBox.getValue() instanceof InvokeExpr) || (testWidget = testWidgetCreator.createTestWidget((InvokeExpr)valueBox.getValue())) == null) continue;
            this.mTestWidgets.add(testWidget);
        }
    }
}

