/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.seal.cactus.generation;

import edu.uci.seal.cactus.analysis.dyna.model.TestEntrypoint;
import edu.uci.seal.cactus.analysis.stat.model.EntrypointWidgetPerm;
import edu.uci.seal.cactus.analysis.stat.model.TestWidget;
import edu.uci.seal.cactus.generation.TestConfig;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class TestConfigBuilder {
    private Collection<TestWidget> twSet;
    private Collection<TestEntrypoint> teSet;
    private Collection<EntrypointWidgetPerm> ewpSet;
    private Collection<TestConfig> mTestConfigs;

    public TestConfigBuilder(Collection<TestWidget> testWidgets, Collection<TestEntrypoint> testEntryPoints, Collection<EntrypointWidgetPerm> entrypointWidgetPerms) {
        this.twSet = testWidgets;
        this.teSet = testEntryPoints;
        this.ewpSet = entrypointWidgetPerms;
        this.mTestConfigs = new HashSet<TestConfig>();
    }

    public void createConfigs(Set<String> perms) {
        for (EntrypointWidgetPerm ewp : this.ewpSet) {
            for (TestEntrypoint te : this.teSet) {
                if (te.isCommonTest() && ewp.getEntryPoint().equals(te.getEntryPoint())) {
                    this.mTestConfigs.add(new TestConfig(te.getTestMethod(), ewp.getPerms()));
                }
                if (!ewp.getEntryPoint().equals(te.getEntryPoint())) continue;
                if (this.twSet.isEmpty()) {
                    this.mTestConfigs.add(new TestConfig(te.getTestMethod(), ewp.getPerms()));
                }
                for (TestWidget tw : this.twSet) {
                    if (ewp.isWidgetIdUndefined()) {
                        this.mTestConfigs.add(new TestConfig(te.getTestMethod(), ewp.getPerms()));
                        continue;
                    }
                    if (!ewp.getWidgetId().equals(tw.getWidgetId()) && !ewp.getWidgetName().equals(tw.getWidgetName())) continue;
                    if (tw.isTestMethod().booleanValue()) {
                        if (!tw.getTestMethod().equals(te.getTestMethod())) continue;
                        this.mTestConfigs.add(new TestConfig(te.getTestMethod(), ewp.getPerms()));
                        continue;
                    }
                    this.mTestConfigs.add(new TestConfig(te.getTestMethod(), ewp.getPerms()));
                }
            }
        }
        this.combineTestConfigs(perms);
    }

    public Collection<TestConfig> getTestConfigs() {
        return this.mTestConfigs;
    }

    private void combineTestConfigs(Set<String> appPerms) {
        HashMap result = new HashMap();
        for (TestConfig currentTestConfig : this.mTestConfigs) {
            String methodName2 = currentTestConfig.getTestMethod();
            HashSet perms = (HashSet)result.get(methodName2);
            if (perms == null) {
                perms = new HashSet();
            }
            perms.addAll(currentTestConfig.getPermissions().stream().filter(appPerms::contains).collect(Collectors.toSet()));
            result.put(methodName2, perms);
        }
        this.mTestConfigs = new HashSet<TestConfig>();
        this.mTestConfigs.addAll(result.keySet().stream().map(methodName -> new TestConfig((String)methodName, (Set)result.get(methodName))).collect(Collectors.toList()));
    }
}

