/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.seal.cactus.model;

import edu.uci.seal.cactus.util.Res;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import org.xmlpull.v1.XmlPullParserException;
import soot.G;
import soot.PackManager;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.jimple.infoflow.android.SetupApplication;
import soot.jimple.infoflow.android.axml.AXmlNode;
import soot.jimple.infoflow.android.manifest.ProcessManifest;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.options.Options;
import soot.tagkit.IntegerConstantValueTag;

public class Application {
    private final String mApk;
    private String mAndroidJar;
    private ProcessManifest mManifest;
    private Map<Integer, String> mIdValueNames;
    private CallGraph mCallGraph;
    private String mIpcProtoBuf;

    public Application(String apkFile, String androidJar, String ipcProto, boolean genCallGraph) throws SAXException, IOException, ParserConfigurationException, XmlPullParserException {
        this(apkFile, androidJar, genCallGraph, true);
        this.mIpcProtoBuf = ipcProto;
    }

    public Application(String apkFile, String androidJar, boolean genCallGraph, boolean reset) throws SAXException, IOException, ParserConfigurationException, XmlPullParserException {
        this.mApk = apkFile;
        this.mManifest = new ProcessManifest(this.mApk);
        this.mAndroidJar = androidJar;
        if (genCallGraph) {
            this.generateCallGraph();
        } else {
            this.initializeSoot(reset, false);
        }
        this.mIdValueNames = this.findIdValueNames();
    }

    public Set<SootMethod> getLauncherClasses() {
        HashSet<SootMethod> result = new HashSet<SootMethod>();
        List<String> entryPointMethods = Arrays.asList("onCreate", "onResume");
        Set<AXmlNode> launchableActivities = this.mManifest.getLaunchableActivities();
        for (AXmlNode launchableActivity : launchableActivities) {
            String className = (String)launchableActivity.getAttribute("name").getValue();
            try {
                SootClass sootClass = Scene.v().loadClassAndSupport(className);
                result.addAll(entryPointMethods.stream().map(sootClass::getMethodByName).collect(Collectors.toList()));
            }
            catch (Exception e) {
                System.err.println("Cannot find entry method for class " + className);
            }
        }
        return result;
    }

    public int getTargetAndroid() {
        return this.mManifest.targetSdkVersion();
    }

    public String getPackageName() {
        return this.mManifest.getPackageName();
    }

    public Map<Integer, String> getIdValueNames() {
        return this.mIdValueNames;
    }

    public String getAndroidJar() {
        return this.mAndroidJar;
    }

    public CallGraph getCallGraph() {
        return this.mCallGraph;
    }

    public String getIpcProtoBuf() {
        return this.mIpcProtoBuf;
    }

    private void initializeSoot(boolean reset, boolean genCallGraph) {
        if (reset) {
            G.reset();
        }
        Options.v().set_src_prec(5);
        Options.v().set_output_format(12);
        Options.v().set_android_jars(this.mAndroidJar);
        Options.v().set_allow_phantom_refs(true);
        Options.v().set_no_bodies_for_excluded(true);
        if (genCallGraph) {
            Options.v().set_whole_program(true);
            Options.v().setPhaseOption("cg.spark", "on");
            Options.v().setPhaseOption("cg.spark", "rta:true");
            Options.v().setPhaseOption("cg.spark", "on-fly-cg:false");
        } else {
            Options.v().set_whole_program(false);
        }
        Options.v().set_process_dir(Collections.singletonList(this.mApk));
        Scene.v().loadNecessaryClasses();
        PackManager.v().runPacks();
    }

    public String getApk() {
        return this.mApk;
    }

    private Map<Integer, String> findIdValueNames() {
        HashMap<Integer, String> staticFields = new HashMap<Integer, String>();
        SootClass rClass = this.findGeneratedIdClass();
        if (rClass == null) {
            return staticFields;
        }
        for (SootField field : rClass.getFields()) {
            field.getTags().stream().filter(tag -> tag instanceof IntegerConstantValueTag).forEach(tag -> staticFields.put(((IntegerConstantValueTag)tag).getIntValue(), field.getName()));
        }
        return staticFields;
    }

    private SootClass findGeneratedIdClass() {
        for (SootClass clazz : Scene.v().getClasses()) {
            if (!clazz.getPackageName().equals(this.mManifest.getPackageName()) || !clazz.getShortName().equals("R$id")) continue;
            return clazz;
        }
        return null;
    }

    private void generateCallGraph() throws IOException, XmlPullParserException {
        SetupApplication app = new SetupApplication(this.mAndroidJar, this.mApk);
        app.setCallbackFile(Res.CALL_BACK_FILE);
        app.calculateSourcesSinksEntrypoints(Res.SOURCE_SINK_FILE);
        this.initializeSoot(true, true);
        Scene.v().loadNecessaryClasses();
        SootMethod entryPoint = app.getEntryPointCreator().createDummyMain();
        Options.v().set_main_class(entryPoint.getSignature());
        Scene.v().setEntryPoints(Collections.singletonList(entryPoint));
        PackManager.v().runPacks();
        this.mCallGraph = Scene.v().getCallGraph();
        System.out.println(Scene.v().getCallGraph().size());
    }
}

