/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.seal.cactus.model;

import edu.uci.seal.cactus.analysis.dyna.model.TestEntrypoint;
import edu.uci.seal.cactus.generation.TestConfig;
import edu.uci.seal.cactus.model.TestApplication;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import org.xmlpull.v1.XmlPullParserException;
import soot.SootMethod;
import soot.jimple.infoflow.android.manifest.ProcessManifest;

public class Input {
    private static final String INSTRUMENTED_DIR = "instrumented";
    private static final String ANALYSIS_DIR = "analysis";
    private static final String APP_STATIC_ANALYSIS_RESULT = "EWP.json";
    private static final String TEST_STATIC_ANALYSIS_RESULT = "TW.json";
    private static final String TEST_DYNAMIC_ANALYSIS_RESULT = "TE.json";
    private static final String IC3_RESULT_PATTERN = "%s_%s.dat";
    private String jsonFileAddress;
    private String outputDir;
    private String pkg;
    private String pkgTest;
    private String apk;
    private String apkIpc;
    private String apkTest;
    private Set<String> perms;
    private Map<String, Set<String>> testsPerms;
    private boolean needsUpdate;

    public Input(String jsonFileAddress) {
        this.jsonFileAddress = jsonFileAddress;
        File jsonFile = new File(jsonFileAddress);
        File parentFile = jsonFile.getParentFile();
        File rootAnalysisFile = new File(parentFile, jsonFile.getName().substring(0, jsonFile.getName().lastIndexOf(".")));
        if (!rootAnalysisFile.exists()) {
            rootAnalysisFile.mkdir();
        }
        this.outputDir = rootAnalysisFile.getAbsolutePath();
    }

    public void open(String androidJar) throws IOException, XmlPullParserException, ParserConfigurationException, SAXException {
        JsonReader reader = Json.createReader(new FileReader(this.jsonFileAddress));
        JsonObject jsonObject = reader.readObject();
        this.apk = jsonObject.getString("apk");
        if (jsonObject.containsKey("test_apk")) {
            this.apkTest = jsonObject.getString("test_apk");
        }
        if (jsonObject.containsKey("package")) {
            this.pkg = jsonObject.getString("package");
            this.perms = jsonObject.getJsonArray("perms").stream().map(JsonValue::toString).map(s -> s.replaceAll("\"", "")).collect(Collectors.toSet());
            this.apkIpc = jsonObject.getString("apk_ipc");
        } else {
            this.updateBasicInfo();
        }
        if (jsonObject.containsKey("tests") && jsonObject.containsKey("test_package")) {
            this.testsPerms = new LinkedHashMap<String, Set<String>>();
            this.pkgTest = jsonObject.getString("test_package");
            JsonObject testItems = jsonObject.getJsonObject("tests");
            Set tests = testItems.keySet();
            for (String test : tests) {
                this.testsPerms.put(test, new HashSet());
            }
        } else if (this.apkTest != null) {
            this.updateTestMethods(androidJar);
        }
        reader.close();
    }

    public void close() throws IOException {
        if (this.needsUpdate) {
            this.save();
        }
    }

    private void updateBasicInfo() throws IOException, XmlPullParserException {
        ProcessManifest processManifest = new ProcessManifest(this.getApkAddress());
        this.pkg = processManifest.getPackageName();
        this.perms = new HashSet<String>();
        this.perms.addAll(processManifest.getPermissions().stream().map(perm -> perm.substring(perm.lastIndexOf(".") + 1)).collect(Collectors.toList()));
        this.apkIpc = String.format(IC3_RESULT_PATTERN, this.pkg, processManifest.getVersionCode());
        this.needsUpdate = true;
    }

    private void updateTestMethods(String androidJar) throws SAXException, XmlPullParserException, ParserConfigurationException, IOException {
        this.testsPerms = new HashMap<String, Set<String>>();
        TestApplication testApp = new TestApplication(this.getTestApkAddress(), androidJar);
        this.pkgTest = testApp.getPackageName();
        Map<String, List<SootMethod>> testMethods = testApp.getTestMethods();
        for (String testClass : testMethods.keySet()) {
            for (SootMethod sootMethod : testMethods.get(testClass)) {
                String testName = testClass + "#" + sootMethod.getName();
                this.testsPerms.put(testName, new HashSet());
            }
        }
        this.needsUpdate = true;
    }

    public void addTestMethod(String testMethodName) {
        if (this.testsPerms == null) {
            this.testsPerms = new HashMap<String, Set<String>>();
        }
        this.testsPerms.put(testMethodName, new HashSet());
        this.needsUpdate = true;
    }

    public void updateTestPerms(Collection<TestConfig> testConfigs, Set<TestEntrypoint> testEntryPoints) {
        if (this.apkTest == null) {
            if (this.testsPerms == null) {
                this.testsPerms = new HashMap<String, Set<String>>();
            }
            for (TestEntrypoint te : testEntryPoints) {
                this.testsPerms.put(te.getTestMethod(), new HashSet());
            }
        }
        for (TestConfig testConfig : testConfigs) {
            this.testsPerms.get(testConfig.getTestMethod()).addAll(testConfig.getPermissions());
        }
        this.needsUpdate = true;
    }

    private void save() throws IOException {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("package", this.pkg);
        if (this.apkTest != null) {
            builder.add("test_apk", this.apkTest);
            builder.add("test_package", this.pkgTest);
        }
        builder.add("apk", this.apk);
        builder.add("apk_ipc", this.apkIpc);
        if (this.perms != null) {
            JsonArrayBuilder permBuilder = Json.createArrayBuilder();
            this.perms.forEach(permBuilder::add);
            builder.add("perms", permBuilder);
        }
        if (this.testsPerms != null) {
            JsonObjectBuilder testBuilder = Json.createObjectBuilder();
            for (String test : this.testsPerms.keySet()) {
                Set<String> testPerms = this.testsPerms.get(test);
                if (testPerms == null) continue;
                JsonArrayBuilder testPermBuilder = Json.createArrayBuilder();
                testPerms.forEach(testPermBuilder::add);
                testBuilder.add(test, testPermBuilder);
            }
            builder.add("tests", testBuilder);
        }
        HashMap<String, Boolean> properties = new HashMap<String, Boolean>(1);
        properties.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
        JsonWriter jsonWriter = Json.createWriterFactory(properties).createWriter(new FileWriter(this.jsonFileAddress));
        jsonWriter.writeObject(builder.build());
        jsonWriter.close();
    }

    public Set<String> getPerms() {
        return this.perms;
    }

    public String getApkAddress() {
        return this.apk;
    }

    public String getTestApkAddress() {
        return this.apkTest;
    }

    public String getApkIpcAddress() {
        return new File(this.outputDir, this.apkIpc).getAbsolutePath();
    }

    public String getInstrumentationAddress() {
        return new File(this.outputDir, INSTRUMENTED_DIR).getAbsolutePath();
    }

    public String getAppStaticAnalysisResult() {
        return new File(new File(this.outputDir, ANALYSIS_DIR), APP_STATIC_ANALYSIS_RESULT).getAbsolutePath();
    }

    public String getTestStaticAnalysisResult() {
        return new File(new File(this.outputDir, ANALYSIS_DIR), TEST_STATIC_ANALYSIS_RESULT).getAbsolutePath();
    }

    public String getTestDynamicAnalysisResult() {
        return new File(new File(this.outputDir, ANALYSIS_DIR), TEST_DYNAMIC_ANALYSIS_RESULT).getAbsolutePath();
    }

    public String getPackage() {
        return this.pkg;
    }
}

