/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.seal.cactus.model;

import edu.uci.seal.cactus.model.Application;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import org.xmlpull.v1.XmlPullParserException;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.tagkit.Tag;
import soot.tagkit.VisibilityAnnotationTag;
import soot.util.Chain;

public class TestApplication
extends Application {
    private Application mMainApp;
    private Map<String, TestFramework> mTestClasses = new HashMap<String, TestFramework>();
    private Map<String, List<SootMethod>> mTestMethods = new HashMap<String, List<SootMethod>>();
    private Map<String, List<SootMethod>> mSetupMethods = new HashMap<String, List<SootMethod>>();

    public TestApplication(String apkFile, String androidJar) throws SAXException, IOException, ParserConfigurationException, XmlPullParserException {
        this(apkFile, androidJar, null);
    }

    public TestApplication(String apkFile, String androidJar, Application mainApp) throws SAXException, IOException, ParserConfigurationException, XmlPullParserException {
        super(apkFile, androidJar, false, true);
        this.findTestClasses();
        this.findTestMethods();
        this.mMainApp = mainApp;
    }

    private void findTestMethods() {
        this.mTestClasses.keySet().forEach(this::findTestMethods);
    }

    @Override
    public Map<Integer, String> getIdValueNames() {
        if (this.mMainApp == null) {
            return super.getIdValueNames();
        }
        return this.mMainApp.getIdValueNames();
    }

    private void findTestMethods(String testClassName) {
        SootClass testClass = Scene.v().getSootClass(testClassName);
        this.mTestMethods.put(testClassName, new ArrayList());
        this.mSetupMethods.put(testClassName, new ArrayList());
        TestFramework testFramework = this.mTestClasses.get(testClassName);
        for (SootMethod method : testClass.getMethods()) {
            if (testFramework == TestFramework.ESPRESSO) {
                if (TestApplication.hasTestAnnotation(method)) {
                    this.mTestMethods.get(testClassName).add(method);
                    continue;
                }
                if (!TestApplication.hasAnnotation(method, "Lorg/junit/Before;")) continue;
                this.mSetupMethods.get(testClassName).add(method);
                continue;
            }
            if (testFramework != TestFramework.ROBOTIUM || !method.getName().startsWith("test")) continue;
            this.mTestMethods.get(testClassName).add(method);
        }
    }

    private void findTestClasses() {
        Chain<SootClass> applicationClasses = Scene.v().getApplicationClasses();
        for (SootClass applicationClass : applicationClasses) {
            TestFramework testFramework = this.findTestFramework(applicationClass);
            if (testFramework == null) continue;
            this.mTestClasses.put(applicationClass.getName(), testFramework);
        }
    }

    private TestFramework findTestFramework(SootClass applicationClass) {
        Boolean[] isEspressoTest = new Boolean[]{false};
        applicationClass.getTags().stream().filter(tag -> tag instanceof VisibilityAnnotationTag).forEach(tag -> {
            VisibilityAnnotationTag annotationTag = (VisibilityAnnotationTag)tag;
            boolean hasTestTag = annotationTag.getAnnotations().stream().anyMatch(annotationTag1 -> annotationTag1.getType().equals("Lorg/junit/runner/RunWith;"));
            if (hasTestTag) {
                isEspressoTest[0] = true;
            }
        });
        if (isEspressoTest[0].booleanValue()) {
            return TestFramework.ESPRESSO;
        }
        SootClass superClass = applicationClass;
        while (superClass.hasSuperclass()) {
            if (!(superClass = superClass.getSuperclass()).getName().equals("android.test.InstrumentationTestCase")) continue;
            return TestFramework.ROBOTIUM;
        }
        return null;
    }

    public static boolean hasTestAnnotation(SootMethod method) {
        return TestApplication.hasAnnotation(method, "Lorg/junit/Test;");
    }

    private static boolean hasAnnotation(SootMethod method, String annotationName) {
        for (Tag tag : method.getTags()) {
            if (!(tag instanceof VisibilityAnnotationTag)) continue;
            VisibilityAnnotationTag annotationTag = (VisibilityAnnotationTag)tag;
            return annotationTag.getAnnotations().stream().anyMatch(annotationTag1 -> annotationTag1.getType().equals(annotationName));
        }
        return false;
    }

    public Map<String, List<SootMethod>> getTestMethods() {
        return this.mTestMethods;
    }

    public Map<String, List<SootMethod>> getSetupMethods() {
        return this.mSetupMethods;
    }

    public Map<String, TestFramework> getTestClasses() {
        return this.mTestClasses;
    }

    public static enum TestFramework {
        ESPRESSO,
        ROBOTIUM;

    }
}

