/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.seal.cactus.util.crawler;

import edu.uci.ics.crawler4j.crawler.Page;
import edu.uci.ics.crawler4j.crawler.WebCrawler;
import edu.uci.ics.crawler4j.parser.HtmlParseData;
import edu.uci.ics.crawler4j.url.WebURL;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

class FDroidCrawler
extends WebCrawler {
    private static final Pattern FILTERS = Pattern.compile(".*(\\.(css|js|gif|jpg|png|mp3|mp3|zip|gz))$");
    static Set<String> apkLinks = new HashSet<String>();

    FDroidCrawler() {
    }

    public boolean shouldVisit(Page referringPage, WebURL url) {
        String href = url.getURL().toLowerCase();
        return !FILTERS.matcher(href).matches() && href.startsWith("https://f-droid.org/repository/browse/");
    }

    public void visit(Page page) {
        if (page.getParseData() instanceof HtmlParseData) {
            HtmlParseData htmlParseData = (HtmlParseData)page.getParseData();
            Set links = htmlParseData.getOutgoingUrls();
            apkLinks.addAll(links.stream().filter(link -> link.getURL().endsWith(".apk") && link.getPath().startsWith("/repo/")).map(WebURL::getURL).collect(Collectors.toList()));
        }
    }
}

