/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.seal.cactus.util.crawler;

import edu.uci.ics.crawler4j.crawler.CrawlConfig;
import edu.uci.ics.crawler4j.crawler.CrawlController;
import edu.uci.ics.crawler4j.fetcher.PageFetcher;
import edu.uci.ics.crawler4j.robotstxt.RobotstxtConfig;
import edu.uci.ics.crawler4j.robotstxt.RobotstxtServer;
import edu.uci.seal.cactus.util.crawler.FDroidCrawler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class FDroidDownloader {
    private static final String CRAWL_STORAGE_FOLDER = "/Users/alireza/PhD/Projects/Cactus/apps/_Crawler";
    private static final String DOWNLOAD_FOLDER = "/Users/alireza/PhD/Projects/Cactus/apps/_ALL";
    private static final int NUMBER_OF_CRAWLERS = 7;
    private static final String DOWNLOAD_LINK_PATTERN = "https://f-droid.org/repo/%s_%s.apk";
    private static final Pattern DL_LINK = Pattern.compile("https://f-droid\\.org/repo/(.*)_(\\d*)\\.apk$");

    public static void main(String[] args) throws Exception {
        CrawlConfig config = new CrawlConfig();
        config.setCrawlStorageFolder(CRAWL_STORAGE_FOLDER);
        config.setPolitenessDelay(100);
        config.setMaxPagesToFetch(1000);
        config.setIncludeBinaryContentInCrawling(false);
        config.setResumableCrawling(false);
        PageFetcher pageFetcher = new PageFetcher(config);
        RobotstxtServer robotstxtServer = new RobotstxtServer(new RobotstxtConfig(), new PageFetcher(config));
        CrawlController controller = new CrawlController(config, pageFetcher, robotstxtServer);
        controller.addSeed("https://f-droid.org/repository/browse/");
        controller.start(FDroidCrawler.class, 7);
        Set<String> apkLinks = FDroidCrawler.apkLinks;
        Map<String, Integer> latestVersions = FDroidDownloader.getLatestVersion(apkLinks);
        ((Stream)latestVersions.keySet().stream().parallel()).forEach(pkg -> FDroidDownloader.downloadLink(pkg, latestVersions));
    }

    private static Map<String, Integer> getLatestVersion(Set<String> apkLinks) {
        HashMap<String, Integer> appVersion = new HashMap<String, Integer>();
        for (String apkLink : apkLinks) {
            Matcher matcher = DL_LINK.matcher(apkLink);
            if (!matcher.find()) continue;
            String pkg = matcher.group(1);
            Integer version2 = Integer.parseInt(matcher.group(2));
            Integer currentVersion = (Integer)appVersion.get(pkg);
            if (currentVersion != null && currentVersion >= version2) continue;
            appVersion.put(pkg, version2);
        }
        return appVersion;
    }

    private static void downloadLink(String pkg, Map<String, Integer> latestVersions) {
        Integer version2 = latestVersions.get(pkg);
        String downloadUrl = String.format(DOWNLOAD_LINK_PATTERN, pkg, version2);
        System.out.println("downloading " + downloadUrl);
        try {
            URL url = new URL(downloadUrl);
            ReadableByteChannel rbc = Channels.newChannel(url.openStream());
            FileOutputStream fos = new FileOutputStream(new File(DOWNLOAD_FOLDER, String.format("%s_%s.apk", pkg, version2)));
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
        }
        catch (IOException e) {
            System.err.println("error in downloading " + downloadUrl);
        }
    }
}

