/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.cache.CacheStorage;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MruCacheStorage;
import freemarker.cache.SoftCacheStorage;
import freemarker.cache.TemplateCache;
import freemarker.cache.TemplateLoader;
import freemarker.cache.TemplateLookupStrategy;
import freemarker.cache.TemplateNameFormat;
import freemarker.core.BugException;
import freemarker.core.Configurable;
import freemarker.core.Environment;
import freemarker.core._ConcurrentMapFactory;
import freemarker.core._CoreAPI;
import freemarker.core._ObjectBuilderSettingEvaluator;
import freemarker.core._SettingEvaluationEnvironment;
import freemarker.core._SortedArraySet;
import freemarker.core._UnmodifiableCompositeSet;
import freemarker.log.Logger;
import freemarker.template.DefaultObjectWrapperBuilder;
import freemarker.template.MalformedTemplateNameException;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateNotFoundException;
import freemarker.template.TemplateScalarModel;
import freemarker.template.Version;
import freemarker.template._TemplateAPI;
import freemarker.template.utility.CaptureOutput;
import freemarker.template.utility.ClassUtil;
import freemarker.template.utility.HtmlEscape;
import freemarker.template.utility.NormalizeNewlines;
import freemarker.template.utility.NullArgumentException;
import freemarker.template.utility.SecurityUtilities;
import freemarker.template.utility.StandardCompress;
import freemarker.template.utility.StringUtil;
import freemarker.template.utility.XmlEscape;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class Configuration
extends Configurable
implements Cloneable {
    private static final Logger CACHE_LOG;
    private static final String VERSION_PROPERTIES_PATH = "freemarker/version.properties";
    public static final String DEFAULT_ENCODING_KEY_SNAKE_CASE = "default_encoding";
    public static final String DEFAULT_ENCODING_KEY_CAMEL_CASE = "defaultEncoding";
    public static final String DEFAULT_ENCODING_KEY = "default_encoding";
    public static final String LOCALIZED_LOOKUP_KEY_SNAKE_CASE = "localized_lookup";
    public static final String LOCALIZED_LOOKUP_KEY_CAMEL_CASE = "localizedLookup";
    public static final String LOCALIZED_LOOKUP_KEY = "localized_lookup";
    public static final String STRICT_SYNTAX_KEY_SNAKE_CASE = "strict_syntax";
    public static final String STRICT_SYNTAX_KEY_CAMEL_CASE = "strictSyntax";
    public static final String STRICT_SYNTAX_KEY = "strict_syntax";
    public static final String WHITESPACE_STRIPPING_KEY_SNAKE_CASE = "whitespace_stripping";
    public static final String WHITESPACE_STRIPPING_KEY_CAMEL_CASE = "whitespaceStripping";
    public static final String WHITESPACE_STRIPPING_KEY = "whitespace_stripping";
    public static final String CACHE_STORAGE_KEY_SNAKE_CASE = "cache_storage";
    public static final String CACHE_STORAGE_KEY_CAMEL_CASE = "cacheStorage";
    public static final String CACHE_STORAGE_KEY = "cache_storage";
    public static final String TEMPLATE_UPDATE_DELAY_KEY_SNAKE_CASE = "template_update_delay";
    public static final String TEMPLATE_UPDATE_DELAY_KEY_CAMEL_CASE = "templateUpdateDelay";
    public static final String TEMPLATE_UPDATE_DELAY_KEY = "template_update_delay";
    public static final String AUTO_IMPORT_KEY_SNAKE_CASE = "auto_import";
    public static final String AUTO_IMPORT_KEY_CAMEL_CASE = "autoImport";
    public static final String AUTO_IMPORT_KEY = "auto_import";
    public static final String AUTO_INCLUDE_KEY_SNAKE_CASE = "auto_include";
    public static final String AUTO_INCLUDE_KEY_CAMEL_CASE = "autoInclude";
    public static final String AUTO_INCLUDE_KEY = "auto_include";
    public static final String TAG_SYNTAX_KEY_SNAKE_CASE = "tag_syntax";
    public static final String TAG_SYNTAX_KEY_CAMEL_CASE = "tagSyntax";
    public static final String TAG_SYNTAX_KEY = "tag_syntax";
    public static final String NAMING_CONVENTION_KEY_SNAKE_CASE = "naming_convention";
    public static final String NAMING_CONVENTION_KEY_CAMEL_CASE = "namingConvention";
    public static final String NAMING_CONVENTION_KEY = "naming_convention";
    public static final String TEMPLATE_LOADER_KEY_SNAKE_CASE = "template_loader";
    public static final String TEMPLATE_LOADER_KEY_CAMEL_CASE = "templateLoader";
    public static final String TEMPLATE_LOADER_KEY = "template_loader";
    public static final String TEMPLATE_LOOKUP_STRATEGY_KEY_SNAKE_CASE = "template_lookup_strategy";
    public static final String TEMPLATE_LOOKUP_STRATEGY_KEY_CAMEL_CASE = "templateLookupStrategy";
    public static final String TEMPLATE_LOOKUP_STRATEGY_KEY = "template_lookup_strategy";
    public static final String TEMPLATE_NAME_FORMAT_KEY_SNAKE_CASE = "template_name_format";
    public static final String TEMPLATE_NAME_FORMAT_KEY_CAMEL_CASE = "templateNameFormat";
    public static final String TEMPLATE_NAME_FORMAT_KEY = "template_name_format";
    public static final String INCOMPATIBLE_IMPROVEMENTS_KEY_SNAKE_CASE = "incompatible_improvements";
    public static final String INCOMPATIBLE_IMPROVEMENTS_KEY_CAMEL_CASE = "incompatibleImprovements";
    public static final String INCOMPATIBLE_IMPROVEMENTS_KEY = "incompatible_improvements";
    public static final String INCOMPATIBLE_IMPROVEMENTS = "incompatible_improvements";
    public static final String INCOMPATIBLE_ENHANCEMENTS = "incompatible_enhancements";
    private static final String[] SETTING_NAMES_SNAKE_CASE;
    private static final String[] SETTING_NAMES_CAMEL_CASE;
    public static final int AUTO_DETECT_TAG_SYNTAX = 0;
    public static final int ANGLE_BRACKET_TAG_SYNTAX = 1;
    public static final int SQUARE_BRACKET_TAG_SYNTAX = 2;
    public static final int AUTO_DETECT_NAMING_CONVENTION = 10;
    public static final int LEGACY_NAMING_CONVENTION = 11;
    public static final int CAMEL_CASE_NAMING_CONVENTION = 12;
    public static final Version VERSION_2_3_0;
    public static final Version VERSION_2_3_19;
    public static final Version VERSION_2_3_20;
    public static final Version VERSION_2_3_21;
    public static final Version VERSION_2_3_22;
    public static final Version VERSION_2_3_23;
    public static final Version DEFAULT_INCOMPATIBLE_IMPROVEMENTS;
    public static final String DEFAULT_INCOMPATIBLE_ENHANCEMENTS;
    public static final int PARSED_DEFAULT_INCOMPATIBLE_ENHANCEMENTS;
    private static final String DEFAULT = "default";
    private static final Version VERSION;
    private static final String FM_24_DETECTION_CLASS_NAME = "freemarker.core._2_4_OrLaterMarker";
    private static final boolean FM_24_DETECTED;
    private static final Object defaultConfigLock;
    private static Configuration defaultConfig;
    private boolean strictSyntax = true;
    private volatile boolean localizedLookup = true;
    private boolean whitespaceStripping = true;
    private Version incompatibleImprovements;
    private int tagSyntax = 1;
    private int namingConvention = 10;
    private TemplateCache cache;
    private boolean templateLoaderExplicitlySet;
    private boolean templateLookupStrategyExplicitlySet;
    private boolean templateNameFormatExplicitlySet;
    private boolean cacheStorageExplicitlySet;
    private boolean objectWrapperExplicitlySet;
    private boolean templateExceptionHandlerExplicitlySet;
    private boolean logTemplateExceptionsExplicitlySet;
    private HashMap sharedVariables = new HashMap();
    private HashMap rewrappableSharedVariables = null;
    private String defaultEncoding = SecurityUtilities.getSystemProperty("file.encoding", "utf-8");
    private Map localeToCharsetMap = _ConcurrentMapFactory.newThreadSafeMap();
    private ArrayList autoImports = new ArrayList();
    private ArrayList autoIncludes = new ArrayList();
    private Map autoImportNsToTmpMap = new HashMap();

    public Configuration() {
        this(DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
    }

    public Configuration(Version incompatibleImprovements) {
        super(incompatibleImprovements);
        Configuration.checkFreeMarkerVersionClash();
        NullArgumentException.check(INCOMPATIBLE_IMPROVEMENTS_KEY_CAMEL_CASE, incompatibleImprovements);
        this.incompatibleImprovements = incompatibleImprovements;
        this.createTemplateCache();
        this.loadBuiltInSharedVariables();
    }

    private static void checkFreeMarkerVersionClash() {
        if (FM_24_DETECTED) {
            throw new RuntimeException("Clashing FreeMarker versions (" + VERSION + " and some post-2.3.x) detected: " + "found post-2.3.x class " + FM_24_DETECTION_CLASS_NAME + ". You probably have two different " + "freemarker.jar-s in the classpath.");
        }
    }

    private void createTemplateCache() {
        this.cache = new TemplateCache(this.getDefaultTemplateLoader(), this.getDefaultCacheStorage(), this.getDefaultTemplateLookupStrategy(), this.getDefaultTemplateNameFormat(), this);
        this.cache.clear();
        this.cache.setDelay(5000L);
    }

    private void recreateTemplateCacheWith(TemplateLoader loader, CacheStorage storage, TemplateLookupStrategy templateLookupStrategy, TemplateNameFormat templateNameFormat) {
        TemplateCache oldCache = this.cache;
        this.cache = new TemplateCache(loader, storage, templateLookupStrategy, templateNameFormat, this);
        this.cache.clear();
        this.cache.setDelay(oldCache.getDelay());
        this.cache.setLocalizedLookup(this.localizedLookup);
    }

    private TemplateLoader getDefaultTemplateLoader() {
        return Configuration.createDefaultTemplateLoader(this.getIncompatibleImprovements(), this.getTemplateLoader());
    }

    static TemplateLoader createDefaultTemplateLoader(Version incompatibleImprovements) {
        return Configuration.createDefaultTemplateLoader(incompatibleImprovements, null);
    }

    private static TemplateLoader createDefaultTemplateLoader(Version incompatibleImprovements, TemplateLoader existingTemplateLoader) {
        if (incompatibleImprovements.intValue() < _TemplateAPI.VERSION_INT_2_3_21) {
            if (existingTemplateLoader instanceof LegacyDefaultFileTemplateLoader) {
                return existingTemplateLoader;
            }
            try {
                return new LegacyDefaultFileTemplateLoader();
            }
            catch (Exception e) {
                CACHE_LOG.warn("Couldn't create legacy default TemplateLoader which accesses the current directory. (Use new Configuration(Configuration.VERSION_2_3_21) or higher to avoid this.)", e);
                return null;
            }
        }
        return null;
    }

    private TemplateLookupStrategy getDefaultTemplateLookupStrategy() {
        return Configuration.getDefaultTemplateLookupStrategy(this.getIncompatibleImprovements());
    }

    static TemplateLookupStrategy getDefaultTemplateLookupStrategy(Version incompatibleImprovements) {
        return TemplateLookupStrategy.DEFAULT_2_3_0;
    }

    private TemplateNameFormat getDefaultTemplateNameFormat() {
        return Configuration.getDefaultTemplateNameFormat(this.getIncompatibleImprovements());
    }

    static TemplateNameFormat getDefaultTemplateNameFormat(Version incompatibleImprovements) {
        return TemplateNameFormat.DEFAULT_2_3_0;
    }

    private CacheStorage getDefaultCacheStorage() {
        return Configuration.createDefaultCacheStorage(this.getIncompatibleImprovements(), this.getCacheStorage());
    }

    static CacheStorage createDefaultCacheStorage(Version incompatibleImprovements, CacheStorage existingCacheStorage) {
        if (existingCacheStorage instanceof DefaultSoftCacheStorage) {
            return existingCacheStorage;
        }
        return new DefaultSoftCacheStorage();
    }

    static CacheStorage createDefaultCacheStorage(Version incompatibleImprovements) {
        return Configuration.createDefaultCacheStorage(incompatibleImprovements, null);
    }

    private TemplateExceptionHandler getDefaultTemplateExceptionHandler() {
        return Configuration.getDefaultTemplateExceptionHandler(this.getIncompatibleImprovements());
    }

    private boolean getDefaultLogTemplateExceptions() {
        return Configuration.getDefaultLogTemplateExceptions(this.getIncompatibleImprovements());
    }

    private ObjectWrapper getDefaultObjectWrapper() {
        return Configuration.getDefaultObjectWrapper(this.getIncompatibleImprovements());
    }

    static final TemplateExceptionHandler getDefaultTemplateExceptionHandler(Version incompatibleImprovements) {
        return TemplateExceptionHandler.DEBUG_HANDLER;
    }

    static final boolean getDefaultLogTemplateExceptions(Version incompatibleImprovements) {
        return true;
    }

    public Object clone() {
        try {
            Configuration copy = (Configuration)super.clone();
            copy.sharedVariables = new HashMap(this.sharedVariables);
            copy.localeToCharsetMap = new HashMap(this.localeToCharsetMap);
            copy.autoImportNsToTmpMap = new HashMap(this.autoImportNsToTmpMap);
            copy.autoImports = (ArrayList)this.autoImports.clone();
            copy.autoIncludes = (ArrayList)this.autoIncludes.clone();
            copy.recreateTemplateCacheWith(this.cache.getTemplateLoader(), this.cache.getCacheStorage(), this.cache.getTemplateLookupStrategy(), this.cache.getTemplateNameFormat());
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new BugException(e.getMessage());
        }
    }

    private void loadBuiltInSharedVariables() {
        this.sharedVariables.put("capture_output", new CaptureOutput());
        this.sharedVariables.put("compress", StandardCompress.INSTANCE);
        this.sharedVariables.put("html_escape", new HtmlEscape());
        this.sharedVariables.put("normalize_newlines", new NormalizeNewlines());
        this.sharedVariables.put("xml_escape", new XmlEscape());
    }

    public void loadBuiltInEncodingMap() {
        this.localeToCharsetMap.clear();
        this.localeToCharsetMap.put("ar", "ISO-8859-6");
        this.localeToCharsetMap.put("be", "ISO-8859-5");
        this.localeToCharsetMap.put("bg", "ISO-8859-5");
        this.localeToCharsetMap.put("ca", "ISO-8859-1");
        this.localeToCharsetMap.put("cs", "ISO-8859-2");
        this.localeToCharsetMap.put("da", "ISO-8859-1");
        this.localeToCharsetMap.put("de", "ISO-8859-1");
        this.localeToCharsetMap.put("el", "ISO-8859-7");
        this.localeToCharsetMap.put("en", "ISO-8859-1");
        this.localeToCharsetMap.put("es", "ISO-8859-1");
        this.localeToCharsetMap.put("et", "ISO-8859-1");
        this.localeToCharsetMap.put("fi", "ISO-8859-1");
        this.localeToCharsetMap.put("fr", "ISO-8859-1");
        this.localeToCharsetMap.put("hr", "ISO-8859-2");
        this.localeToCharsetMap.put("hu", "ISO-8859-2");
        this.localeToCharsetMap.put("is", "ISO-8859-1");
        this.localeToCharsetMap.put("it", "ISO-8859-1");
        this.localeToCharsetMap.put("iw", "ISO-8859-8");
        this.localeToCharsetMap.put("ja", "Shift_JIS");
        this.localeToCharsetMap.put("ko", "EUC-KR");
        this.localeToCharsetMap.put("lt", "ISO-8859-2");
        this.localeToCharsetMap.put("lv", "ISO-8859-2");
        this.localeToCharsetMap.put("mk", "ISO-8859-5");
        this.localeToCharsetMap.put("nl", "ISO-8859-1");
        this.localeToCharsetMap.put("no", "ISO-8859-1");
        this.localeToCharsetMap.put("pl", "ISO-8859-2");
        this.localeToCharsetMap.put("pt", "ISO-8859-1");
        this.localeToCharsetMap.put("ro", "ISO-8859-2");
        this.localeToCharsetMap.put("ru", "ISO-8859-5");
        this.localeToCharsetMap.put("sh", "ISO-8859-5");
        this.localeToCharsetMap.put("sk", "ISO-8859-2");
        this.localeToCharsetMap.put("sl", "ISO-8859-2");
        this.localeToCharsetMap.put("sq", "ISO-8859-2");
        this.localeToCharsetMap.put("sr", "ISO-8859-5");
        this.localeToCharsetMap.put("sv", "ISO-8859-1");
        this.localeToCharsetMap.put("tr", "ISO-8859-9");
        this.localeToCharsetMap.put("uk", "ISO-8859-5");
        this.localeToCharsetMap.put("zh", "GB2312");
        this.localeToCharsetMap.put("zh_TW", "Big5");
    }

    public void clearEncodingMap() {
        this.localeToCharsetMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Configuration getDefaultConfiguration() {
        Object object = defaultConfigLock;
        synchronized (object) {
            if (defaultConfig == null) {
                defaultConfig = new Configuration();
            }
            return defaultConfig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultConfiguration(Configuration config) {
        Object object = defaultConfigLock;
        synchronized (object) {
            defaultConfig = config;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTemplateLoader(TemplateLoader templateLoader) {
        Configuration configuration = this;
        synchronized (configuration) {
            if (this.cache.getTemplateLoader() != templateLoader) {
                this.recreateTemplateCacheWith(templateLoader, this.cache.getCacheStorage(), this.cache.getTemplateLookupStrategy(), this.cache.getTemplateNameFormat());
            }
            this.templateLoaderExplicitlySet = true;
        }
    }

    public void unsetTemplateLoader() {
        if (this.templateLoaderExplicitlySet) {
            this.setTemplateLoader(this.getDefaultTemplateLoader());
            this.templateLoaderExplicitlySet = false;
        }
    }

    public boolean isTemplateLoaderExplicitlySet() {
        return this.templateLoaderExplicitlySet;
    }

    public TemplateLoader getTemplateLoader() {
        if (this.cache == null) {
            return null;
        }
        return this.cache.getTemplateLoader();
    }

    public void setTemplateLookupStrategy(TemplateLookupStrategy templateLookupStrategy) {
        if (this.cache.getTemplateLookupStrategy() != templateLookupStrategy) {
            this.recreateTemplateCacheWith(this.cache.getTemplateLoader(), this.cache.getCacheStorage(), templateLookupStrategy, this.cache.getTemplateNameFormat());
        }
        this.templateLookupStrategyExplicitlySet = true;
    }

    public void unsetTemplateLookupStrategy() {
        if (this.templateLookupStrategyExplicitlySet) {
            this.setTemplateLookupStrategy(this.getDefaultTemplateLookupStrategy());
            this.templateLookupStrategyExplicitlySet = false;
        }
    }

    public boolean isTemplateLookupStrategyExplicitlySet() {
        return this.templateLookupStrategyExplicitlySet;
    }

    public TemplateLookupStrategy getTemplateLookupStrategy() {
        if (this.cache == null) {
            return null;
        }
        return this.cache.getTemplateLookupStrategy();
    }

    public void setTemplateNameFormat(TemplateNameFormat templateNameFormat) {
        if (this.cache.getTemplateNameFormat() != templateNameFormat) {
            this.recreateTemplateCacheWith(this.cache.getTemplateLoader(), this.cache.getCacheStorage(), this.cache.getTemplateLookupStrategy(), templateNameFormat);
        }
        this.templateNameFormatExplicitlySet = true;
    }

    public void unsetTemplateNameFormat() {
        if (this.templateNameFormatExplicitlySet) {
            this.setTemplateNameFormat(this.getDefaultTemplateNameFormat());
            this.templateNameFormatExplicitlySet = false;
        }
    }

    public boolean isTemplateNameFormatExplicitlySet() {
        return this.templateNameFormatExplicitlySet;
    }

    public TemplateNameFormat getTemplateNameFormat() {
        if (this.cache == null) {
            return null;
        }
        return this.cache.getTemplateNameFormat();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCacheStorage(CacheStorage cacheStorage) {
        Configuration configuration = this;
        synchronized (configuration) {
            if (this.getCacheStorage() != cacheStorage) {
                this.recreateTemplateCacheWith(this.cache.getTemplateLoader(), cacheStorage, this.cache.getTemplateLookupStrategy(), this.cache.getTemplateNameFormat());
            }
            this.cacheStorageExplicitlySet = true;
        }
    }

    public void unsetCacheStorage() {
        if (this.cacheStorageExplicitlySet) {
            this.setCacheStorage(this.getDefaultCacheStorage());
            this.cacheStorageExplicitlySet = false;
        }
    }

    public boolean isCacheStorageExplicitlySet() {
        return this.cacheStorageExplicitlySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheStorage getCacheStorage() {
        Configuration configuration = this;
        synchronized (configuration) {
            if (this.cache == null) {
                return null;
            }
            return this.cache.getCacheStorage();
        }
    }

    public void setDirectoryForTemplateLoading(File dir) throws IOException {
        String path;
        TemplateLoader tl = this.getTemplateLoader();
        if (tl instanceof FileTemplateLoader && (path = ((FileTemplateLoader)tl).baseDir.getCanonicalPath()).equals(dir.getCanonicalPath())) {
            return;
        }
        this.setTemplateLoader(new FileTemplateLoader(dir));
    }

    public void setServletContextForTemplateLoading(Object servletContext, String path) {
        try {
            Object[] constructorParams;
            Class[] constructorParamTypes;
            Class webappTemplateLoaderClass = ClassUtil.forName("freemarker.cache.WebappTemplateLoader");
            Class servletContextClass = ClassUtil.forName("javax.servlet.ServletContext");
            if (path == null) {
                constructorParamTypes = new Class[]{servletContextClass};
                constructorParams = new Object[]{servletContext};
            } else {
                constructorParamTypes = new Class[]{servletContextClass, String.class};
                constructorParams = new Object[]{servletContext, path};
            }
            this.setTemplateLoader((TemplateLoader)webappTemplateLoaderClass.getConstructor(constructorParamTypes).newInstance(constructorParams));
        }
        catch (Exception e) {
            throw new BugException(e);
        }
    }

    public void setClassForTemplateLoading(Class resourceLoaderClass, String basePackagePath) {
        this.setTemplateLoader(new ClassTemplateLoader(resourceLoaderClass, basePackagePath));
    }

    public void setClassLoaderForTemplateLoading(ClassLoader classLoader, String basePackagePath) {
        this.setTemplateLoader(new ClassTemplateLoader(classLoader, basePackagePath));
    }

    public void setTemplateUpdateDelay(int seconds) {
        this.cache.setDelay(1000L * (long)seconds);
    }

    public void setTemplateUpdateDelayMilliseconds(long millis) {
        this.cache.setDelay(millis);
    }

    public long getTemplateUpdateDelayMilliseconds() {
        return this.cache.getDelay();
    }

    public void setStrictSyntaxMode(boolean b) {
        this.strictSyntax = b;
    }

    public void setObjectWrapper(ObjectWrapper objectWrapper) {
        ObjectWrapper prevObjectWrapper = this.getObjectWrapper();
        super.setObjectWrapper(objectWrapper);
        this.objectWrapperExplicitlySet = true;
        if (objectWrapper != prevObjectWrapper) {
            try {
                this.setSharedVariablesFromRewrappableSharedVariables();
            }
            catch (TemplateModelException e) {
                throw new RuntimeException("Failed to re-wrap earliearly set shared variables with the newly set object wrapper", e);
            }
        }
    }

    public void unsetObjectWrapper() {
        if (this.objectWrapperExplicitlySet) {
            this.setObjectWrapper(this.getDefaultObjectWrapper());
            this.objectWrapperExplicitlySet = false;
        }
    }

    public boolean isObjectWrapperExplicitlySet() {
        return this.objectWrapperExplicitlySet;
    }

    public void setTemplateExceptionHandler(TemplateExceptionHandler templateExceptionHandler) {
        super.setTemplateExceptionHandler(templateExceptionHandler);
        this.templateExceptionHandlerExplicitlySet = true;
    }

    public void unsetTemplateExceptionHandler() {
        if (this.templateExceptionHandlerExplicitlySet) {
            this.setTemplateExceptionHandler(this.getDefaultTemplateExceptionHandler());
            this.templateExceptionHandlerExplicitlySet = false;
        }
    }

    public boolean isTemplateExceptionHandlerExplicitlySet() {
        return this.templateExceptionHandlerExplicitlySet;
    }

    public void setLogTemplateExceptions(boolean value) {
        super.setLogTemplateExceptions(value);
        this.logTemplateExceptionsExplicitlySet = true;
    }

    public void unsetLogTemplateExceptions() {
        if (this.logTemplateExceptionsExplicitlySet) {
            this.setLogTemplateExceptions(this.getDefaultLogTemplateExceptions());
            this.logTemplateExceptionsExplicitlySet = false;
        }
    }

    public boolean isLogTemplateExceptionsExplicitlySet() {
        return this.logTemplateExceptionsExplicitlySet;
    }

    public boolean getStrictSyntaxMode() {
        return this.strictSyntax;
    }

    public void setIncompatibleImprovements(Version incompatibleImprovements) {
        _TemplateAPI.checkVersionNotNullAndSupported(incompatibleImprovements);
        if (!this.incompatibleImprovements.equals(incompatibleImprovements)) {
            this.incompatibleImprovements = incompatibleImprovements;
            if (!this.templateLoaderExplicitlySet) {
                this.templateLoaderExplicitlySet = true;
                this.unsetTemplateLoader();
            }
            if (!this.templateLookupStrategyExplicitlySet) {
                this.templateLookupStrategyExplicitlySet = true;
                this.unsetTemplateLookupStrategy();
            }
            if (!this.templateNameFormatExplicitlySet) {
                this.templateNameFormatExplicitlySet = true;
                this.unsetTemplateNameFormat();
            }
            if (!this.cacheStorageExplicitlySet) {
                this.cacheStorageExplicitlySet = true;
                this.unsetCacheStorage();
            }
            if (!this.templateExceptionHandlerExplicitlySet) {
                this.templateExceptionHandlerExplicitlySet = true;
                this.unsetTemplateExceptionHandler();
            }
            if (!this.logTemplateExceptionsExplicitlySet) {
                this.logTemplateExceptionsExplicitlySet = true;
                this.unsetLogTemplateExceptions();
            }
            if (!this.objectWrapperExplicitlySet) {
                this.objectWrapperExplicitlySet = true;
                this.unsetObjectWrapper();
            }
        }
    }

    public Version getIncompatibleImprovements() {
        return this.incompatibleImprovements;
    }

    public void setIncompatibleEnhancements(String version2) {
        this.setIncompatibleImprovements(new Version(version2));
    }

    public String getIncompatibleEnhancements() {
        return this.incompatibleImprovements.toString();
    }

    public int getParsedIncompatibleEnhancements() {
        return this.getIncompatibleImprovements().intValue();
    }

    public void setWhitespaceStripping(boolean b) {
        this.whitespaceStripping = b;
    }

    public boolean getWhitespaceStripping() {
        return this.whitespaceStripping;
    }

    public void setTagSyntax(int tagSyntax) {
        if (tagSyntax != 0 && tagSyntax != 2 && tagSyntax != 1) {
            throw new IllegalArgumentException("\"tag_syntax\" can only be set to one of these: Configuration.AUTO_DETECT_TAG_SYNTAX, Configuration.ANGLE_BRACKET_SYNTAX, or Configuration.SQAUARE_BRACKET_SYNTAX");
        }
        this.tagSyntax = tagSyntax;
    }

    public int getTagSyntax() {
        return this.tagSyntax;
    }

    public void setNamingConvention(int namingConvention) {
        if (namingConvention != 10 && namingConvention != 11 && namingConvention != 12) {
            throw new IllegalArgumentException("\"naming_convention\" can only be set to one of these: Configuration.AUTO_DETECT_NAMING_CONVENTION, or Configuration.LEGACY_NAMING_CONVENTIONor Configuration.CAMEL_CASE_NAMING_CONVENTION");
        }
        this.namingConvention = namingConvention;
    }

    public int getNamingConvention() {
        return this.namingConvention;
    }

    public Template getTemplate(String name) throws TemplateNotFoundException, MalformedTemplateNameException, freemarker.core.ParseException, IOException {
        return this.getTemplate(name, null, null, null, true, false);
    }

    public Template getTemplate(String name, Locale locale) throws TemplateNotFoundException, MalformedTemplateNameException, freemarker.core.ParseException, IOException {
        return this.getTemplate(name, locale, null, null, true, false);
    }

    public Template getTemplate(String name, String encoding) throws TemplateNotFoundException, MalformedTemplateNameException, freemarker.core.ParseException, IOException {
        return this.getTemplate(name, null, null, encoding, true, false);
    }

    public Template getTemplate(String name, Locale locale, String encoding) throws TemplateNotFoundException, MalformedTemplateNameException, freemarker.core.ParseException, IOException {
        return this.getTemplate(name, locale, null, encoding, true, false);
    }

    public Template getTemplate(String name, Locale locale, String encoding, boolean parseAsFTL) throws TemplateNotFoundException, MalformedTemplateNameException, freemarker.core.ParseException, IOException {
        return this.getTemplate(name, locale, null, encoding, parseAsFTL, false);
    }

    public Template getTemplate(String name, Locale locale, String encoding, boolean parseAsFTL, boolean ignoreMissing) throws TemplateNotFoundException, MalformedTemplateNameException, freemarker.core.ParseException, IOException {
        return this.getTemplate(name, locale, null, encoding, parseAsFTL, ignoreMissing);
    }

    public Template getTemplate(String name, Locale locale, Object customLookupCondition, String encoding, boolean parseAsFTL, boolean ignoreMissing) throws TemplateNotFoundException, MalformedTemplateNameException, freemarker.core.ParseException, IOException {
        TemplateCache.MaybeMissingTemplate maybeTemp;
        Template temp;
        if (locale == null) {
            locale = this.getLocale();
        }
        if (encoding == null) {
            encoding = this.getEncoding(locale);
        }
        if ((temp = (maybeTemp = this.cache.getTemplate(name, locale, customLookupCondition, encoding, parseAsFTL)).getTemplate()) == null) {
            String msg;
            if (ignoreMissing) {
                return null;
            }
            TemplateLoader tl = this.getTemplateLoader();
            if (tl == null) {
                msg = "Don't know where to load template " + StringUtil.jQuote(name) + " from because the \"template_loader\" FreeMarker " + "setting wasn't set (Configuration.setTemplateLoader), so it's null.";
            } else {
                String missingTempNormName = maybeTemp.getMissingTemplateNormalizedName();
                String missingTempReason = maybeTemp.getMissingTemplateReason();
                TemplateLookupStrategy templateLookupStrategy = this.getTemplateLookupStrategy();
                msg = "Template not found for name " + StringUtil.jQuote(name) + (missingTempNormName != null && name != null && !this.removeInitialSlash(name).equals(missingTempNormName) ? " (normalized: " + StringUtil.jQuote(missingTempNormName) + ")" : "") + (customLookupCondition != null ? " and custom lookup condition " + StringUtil.jQuote(customLookupCondition) : "") + "." + (missingTempReason != null ? "\nReason given: " + this.ensureSentenceIsClosed(missingTempReason) : "") + "\nThe name was interpreted by this TemplateLoader: " + StringUtil.tryToString(tl) + "." + (!this.isKnownNonConfusingLookupStrategy(templateLookupStrategy) ? "\n(Before that, the name was possibly changed by this lookup strategy: " + StringUtil.tryToString(templateLookupStrategy) + ".)" : "") + (!this.templateLoaderExplicitlySet ? "\nWarning: The \"template_loader\" FreeMarker setting wasn't set (Configuration.setTemplateLoader), and using the default value is most certainly not intended and dangerous, and can be the cause of this error." : "") + (missingTempReason == null && name.indexOf(92) != -1 ? "\nWarning: The name contains backslash (\"\\\") instead of slash (\"/\"); template names should use slash only." : "");
            }
            String normName = maybeTemp.getMissingTemplateNormalizedName();
            throw new TemplateNotFoundException(normName != null ? normName : name, customLookupCondition, msg);
        }
        return temp;
    }

    private boolean isKnownNonConfusingLookupStrategy(TemplateLookupStrategy templateLookupStrategy) {
        return templateLookupStrategy == TemplateLookupStrategy.DEFAULT_2_3_0;
    }

    private String removeInitialSlash(String name) {
        return name.startsWith("/") ? name.substring(1) : name;
    }

    private String ensureSentenceIsClosed(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        char lastChar = s.charAt(s.length() - 1);
        return lastChar == '.' || lastChar == '!' || lastChar == '?' ? s : s + ".";
    }

    public void setDefaultEncoding(String encoding) {
        this.defaultEncoding = encoding;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public String getEncoding(Locale locale) {
        if (this.localeToCharsetMap.isEmpty()) {
            return this.defaultEncoding;
        }
        String charset = (String)this.localeToCharsetMap.get(locale.toString());
        if (charset == null) {
            Locale l;
            if (locale.getVariant().length() > 0 && (charset = (String)this.localeToCharsetMap.get((l = new Locale(locale.getLanguage(), locale.getCountry())).toString())) != null) {
                this.localeToCharsetMap.put(locale.toString(), charset);
            }
            if ((charset = (String)this.localeToCharsetMap.get(locale.getLanguage())) != null) {
                this.localeToCharsetMap.put(locale.toString(), charset);
            }
        }
        return charset != null ? charset : this.defaultEncoding;
    }

    public void setEncoding(Locale locale, String encoding) {
        this.localeToCharsetMap.put(locale.toString(), encoding);
    }

    public void setSharedVariable(String name, TemplateModel tm) {
        TemplateModel replaced = this.sharedVariables.put(name, tm);
        if (replaced != null && this.rewrappableSharedVariables != null) {
            this.rewrappableSharedVariables.remove(name);
        }
    }

    public Set getSharedVariableNames() {
        return new HashSet(this.sharedVariables.keySet());
    }

    public void setSharedVariable(String name, Object value) throws TemplateModelException {
        this.setSharedVariable(name, this.getObjectWrapper().wrap(value));
    }

    public void setSharedVaribles(Map map) throws TemplateModelException {
        this.rewrappableSharedVariables = new HashMap(map);
        this.sharedVariables.clear();
        this.setSharedVariablesFromRewrappableSharedVariables();
    }

    private void setSharedVariablesFromRewrappableSharedVariables() throws TemplateModelException {
        if (this.rewrappableSharedVariables == null) {
            return;
        }
        Iterator it = this.rewrappableSharedVariables.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry ent = it.next();
            String name = (String)ent.getKey();
            Object value = ent.getValue();
            TemplateModel valueAsTM = value instanceof TemplateModel ? (TemplateModel)value : this.getObjectWrapper().wrap(value);
            this.sharedVariables.put(name, valueAsTM);
        }
    }

    public void setAllSharedVariables(TemplateHashModelEx hash) throws TemplateModelException {
        TemplateModelIterator keys = hash.keys().iterator();
        TemplateModelIterator values = hash.values().iterator();
        while (keys.hasNext()) {
            this.setSharedVariable(((TemplateScalarModel)keys.next()).getAsString(), values.next());
        }
    }

    public TemplateModel getSharedVariable(String name) {
        return (TemplateModel)this.sharedVariables.get(name);
    }

    public void clearSharedVariables() {
        this.sharedVariables.clear();
        this.loadBuiltInSharedVariables();
    }

    public void clearTemplateCache() {
        this.cache.clear();
    }

    public void removeTemplateFromCache(String name) throws IOException {
        Locale loc = this.getLocale();
        this.removeTemplateFromCache(name, loc, this.getEncoding(loc), true);
    }

    public void removeTemplateFromCache(String name, Locale locale) throws IOException {
        this.removeTemplateFromCache(name, locale, this.getEncoding(locale), true);
    }

    public void removeTemplateFromCache(String name, String encoding) throws IOException {
        this.removeTemplateFromCache(name, this.getLocale(), encoding, true);
    }

    public void removeTemplateFromCache(String name, Locale locale, String encoding) throws IOException {
        this.removeTemplateFromCache(name, locale, encoding, true);
    }

    public void removeTemplateFromCache(String name, Locale locale, String encoding, boolean parse) throws IOException {
        this.cache.removeTemplate(name, locale, encoding, parse);
    }

    public boolean getLocalizedLookup() {
        return this.cache.getLocalizedLookup();
    }

    public void setLocalizedLookup(boolean localizedLookup) {
        this.localizedLookup = localizedLookup;
        this.cache.setLocalizedLookup(localizedLookup);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSetting(String name, String value) throws TemplateException {
        boolean unknown;
        block61: {
            unknown = false;
            try {
                if ("TemplateUpdateInterval".equalsIgnoreCase(name)) {
                    name = "template_update_delay";
                } else if ("DefaultEncoding".equalsIgnoreCase(name)) {
                    name = "default_encoding";
                }
                if ("default_encoding".equals(name) || DEFAULT_ENCODING_KEY_CAMEL_CASE.equals(name)) {
                    this.setDefaultEncoding(value);
                    break block61;
                }
                if ("localized_lookup".equals(name) || LOCALIZED_LOOKUP_KEY_CAMEL_CASE.equals(name)) {
                    this.setLocalizedLookup(StringUtil.getYesNo(value));
                    break block61;
                }
                if ("strict_syntax".equals(name) || STRICT_SYNTAX_KEY_CAMEL_CASE.equals(name)) {
                    this.setStrictSyntaxMode(StringUtil.getYesNo(value));
                    break block61;
                }
                if ("whitespace_stripping".equals(name) || WHITESPACE_STRIPPING_KEY_CAMEL_CASE.equals(name)) {
                    this.setWhitespaceStripping(StringUtil.getYesNo(value));
                    break block61;
                }
                if ("cache_storage".equals(name) || CACHE_STORAGE_KEY_CAMEL_CASE.equals(name)) {
                    if (value.equalsIgnoreCase(DEFAULT)) {
                        this.unsetCacheStorage();
                    }
                    if (value.indexOf(46) == -1) {
                        int strongSize = 0;
                        int softSize = 0;
                        Map map = StringUtil.parseNameValuePairList(value, String.valueOf(Integer.MAX_VALUE));
                        Iterator it = map.entrySet().iterator();
                        while (it.hasNext()) {
                            int pvalue;
                            Map.Entry ent = it.next();
                            String pname = (String)ent.getKey();
                            try {
                                pvalue = Integer.parseInt((String)ent.getValue());
                            }
                            catch (NumberFormatException e) {
                                throw this.invalidSettingValueException(name, value);
                            }
                            if ("soft".equalsIgnoreCase(pname)) {
                                softSize = pvalue;
                                continue;
                            }
                            if (!"strong".equalsIgnoreCase(pname)) throw this.invalidSettingValueException(name, value);
                            strongSize = pvalue;
                        }
                        if (softSize == 0 && strongSize == 0) {
                            throw this.invalidSettingValueException(name, value);
                        }
                        this.setCacheStorage(new MruCacheStorage(strongSize, softSize));
                        break block61;
                    }
                    this.setCacheStorage((CacheStorage)_ObjectBuilderSettingEvaluator.eval(value, CacheStorage.class, _SettingEvaluationEnvironment.getCurrent()));
                    break block61;
                }
                if ("template_update_delay".equals(name) || TEMPLATE_UPDATE_DELAY_KEY_CAMEL_CASE.equals(name)) {
                    String valueWithoutUnit;
                    long multipier;
                    if (value.endsWith("ms")) {
                        multipier = 1L;
                        valueWithoutUnit = this.rightTrim(value.substring(0, value.length() - 2));
                    } else if (value.endsWith("s")) {
                        multipier = 1000L;
                        valueWithoutUnit = this.rightTrim(value.substring(0, value.length() - 1));
                    } else if (value.endsWith("m")) {
                        multipier = 60000L;
                        valueWithoutUnit = this.rightTrim(value.substring(0, value.length() - 1));
                    } else if (value.endsWith("h")) {
                        multipier = 3600000L;
                        valueWithoutUnit = this.rightTrim(value.substring(0, value.length() - 1));
                    } else {
                        multipier = 1000L;
                        valueWithoutUnit = value;
                    }
                    this.setTemplateUpdateDelayMilliseconds((long)Integer.parseInt(valueWithoutUnit) * multipier);
                } else if ("auto_include".equals(name) || AUTO_INCLUDE_KEY_CAMEL_CASE.equals(name)) {
                    this.setAutoIncludes(this.parseAsList(value));
                } else if ("auto_import".equals(name) || AUTO_IMPORT_KEY_CAMEL_CASE.equals(name)) {
                    this.setAutoImports(this.parseAsImportList(value));
                } else if ("tag_syntax".equals(name) || TAG_SYNTAX_KEY_CAMEL_CASE.equals(name)) {
                    if ("auto_detect".equals(value) || "autoDetect".equals(value)) {
                        this.setTagSyntax(0);
                    } else if ("angle_bracket".equals(value) || "angleBracket".equals(value)) {
                        this.setTagSyntax(1);
                    } else {
                        if (!"square_bracket".equals(value) && !"squareBracket".equals(value)) throw this.invalidSettingValueException(name, value);
                        this.setTagSyntax(2);
                    }
                } else if ("naming_convention".equals(name) || NAMING_CONVENTION_KEY_CAMEL_CASE.equals(name)) {
                    if ("auto_detect".equals(value) || "autoDetect".equals(value)) {
                        this.setNamingConvention(10);
                    } else if ("legacy".equals(value)) {
                        this.setNamingConvention(11);
                    } else {
                        if (!"camel_case".equals(value) && !"camelCase".equals(value)) throw this.invalidSettingValueException(name, value);
                        this.setNamingConvention(12);
                    }
                } else if ("incompatible_improvements".equals(name) || INCOMPATIBLE_IMPROVEMENTS_KEY_CAMEL_CASE.equals(name)) {
                    this.setIncompatibleImprovements(new Version(value));
                } else if (INCOMPATIBLE_ENHANCEMENTS.equals(name)) {
                    this.setIncompatibleEnhancements(value);
                } else if ("template_loader".equals(name) || TEMPLATE_LOADER_KEY_CAMEL_CASE.equals(name)) {
                    if (value.equalsIgnoreCase(DEFAULT)) {
                        this.unsetTemplateLoader();
                    } else {
                        this.setTemplateLoader((TemplateLoader)_ObjectBuilderSettingEvaluator.eval(value, TemplateLoader.class, _SettingEvaluationEnvironment.getCurrent()));
                    }
                } else if ("template_lookup_strategy".equals(name) || TEMPLATE_LOOKUP_STRATEGY_KEY_CAMEL_CASE.equals(name)) {
                    if (value.equalsIgnoreCase(DEFAULT)) {
                        this.unsetTemplateLookupStrategy();
                    } else {
                        this.setTemplateLookupStrategy((TemplateLookupStrategy)_ObjectBuilderSettingEvaluator.eval(value, TemplateLookupStrategy.class, _SettingEvaluationEnvironment.getCurrent()));
                    }
                } else if ("template_name_format".equals(name) || TEMPLATE_NAME_FORMAT_KEY_CAMEL_CASE.equals(name)) {
                    if (value.equalsIgnoreCase(DEFAULT)) {
                        this.unsetTemplateNameFormat();
                    } else if (value.equalsIgnoreCase("default_2_3_0")) {
                        this.setTemplateNameFormat(TemplateNameFormat.DEFAULT_2_3_0);
                    } else {
                        if (!value.equalsIgnoreCase("default_2_4_0")) throw this.invalidSettingValueException(name, value);
                        this.setTemplateNameFormat(TemplateNameFormat.DEFAULT_2_4_0);
                    }
                } else {
                    unknown = true;
                }
            }
            catch (Exception e) {
                throw this.settingValueAssignmentException(name, value, e);
            }
        }
        if (!unknown) return;
        super.setSetting(name, value);
    }

    private String rightTrim(String s) {
        int ln;
        for (ln = s.length(); ln > 0 && Character.isWhitespace(s.charAt(ln - 1)); --ln) {
        }
        return s.substring(0, ln);
    }

    Set getSettingNames(boolean camelCase) {
        return new _UnmodifiableCompositeSet(_CoreAPI.getConfigurableSettingNames(this, camelCase), new _SortedArraySet(camelCase ? SETTING_NAMES_CAMEL_CASE : SETTING_NAMES_SNAKE_CASE));
    }

    protected String getCorrectedNameForUnknownSetting(String name) {
        if ("encoding".equals(name) || "charset".equals(name) || "default_charset".equals(name)) {
            return "default_encoding";
        }
        if ("defaultCharset".equals(name)) {
            return DEFAULT_ENCODING_KEY_CAMEL_CASE;
        }
        return super.getCorrectedNameForUnknownSetting(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAutoImport(String namespaceVarName, String templateName) {
        Configuration configuration = this;
        synchronized (configuration) {
            this.autoImports.remove(namespaceVarName);
            this.autoImports.add(namespaceVarName);
            this.autoImportNsToTmpMap.put(namespaceVarName, templateName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAutoImport(String namespaceVarName) {
        Configuration configuration = this;
        synchronized (configuration) {
            this.autoImports.remove(namespaceVarName);
            this.autoImportNsToTmpMap.remove(namespaceVarName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoImports(Map map) {
        Configuration configuration = this;
        synchronized (configuration) {
            this.autoImports = new ArrayList(map.keySet());
            this.autoImportNsToTmpMap = map instanceof HashMap ? (Map)((HashMap)map).clone() : (map instanceof SortedMap ? new TreeMap(map) : new HashMap(map));
        }
    }

    protected void doAutoImportsAndIncludes(Environment env) throws TemplateException, IOException {
        int i;
        for (i = 0; i < this.autoImports.size(); ++i) {
            String namespace = (String)this.autoImports.get(i);
            String templateName = (String)this.autoImportNsToTmpMap.get(namespace);
            env.importLib(templateName, namespace);
        }
        for (i = 0; i < this.autoIncludes.size(); ++i) {
            String templateName = (String)this.autoIncludes.get(i);
            Template template = this.getTemplate(templateName, env.getLocale());
            env.include(template);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAutoInclude(String templateName) {
        Configuration configuration = this;
        synchronized (configuration) {
            this.autoIncludes.remove(templateName);
            this.autoIncludes.add(templateName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoIncludes(List templateNames) {
        Configuration configuration = this;
        synchronized (configuration) {
            this.autoIncludes.clear();
            Iterator it = templateNames.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof String)) {
                    throw new IllegalArgumentException("List items must be String-s.");
                }
                this.autoIncludes.add(o);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAutoInclude(String templateName) {
        Configuration configuration = this;
        synchronized (configuration) {
            this.autoIncludes.remove(templateName);
        }
    }

    public static String getVersionNumber() {
        return VERSION.toString();
    }

    public static Version getVersion() {
        return VERSION;
    }

    public static ObjectWrapper getDefaultObjectWrapper(Version incompatibleImprovements) {
        if (incompatibleImprovements.intValue() < _TemplateAPI.VERSION_INT_2_3_21) {
            return ObjectWrapper.DEFAULT_WRAPPER;
        }
        return new DefaultObjectWrapperBuilder(incompatibleImprovements).build();
    }

    public Set getSupportedBuiltInNames() {
        return _CoreAPI.getSupportedBuiltInNames();
    }

    public Set getSupportedBuiltInDirectiveNames() {
        return _CoreAPI.BUILT_IN_DIRECTIVE_NAMES;
    }

    private static String getRequiredVersionProperty(Properties vp, String properyName) {
        String s = vp.getProperty(properyName);
        if (s == null) {
            throw new RuntimeException("Version file is corrupt: \"" + properyName + "\" property is missing.");
        }
        return s;
    }

    static {
        boolean fm24detected;
        CACHE_LOG = Logger.getLogger("freemarker.cache");
        SETTING_NAMES_SNAKE_CASE = new String[]{"auto_import", "auto_include", "cache_storage", "default_encoding", "incompatible_improvements", "localized_lookup", "naming_convention", "strict_syntax", "tag_syntax", "template_loader", "template_lookup_strategy", "template_name_format", "template_update_delay", "whitespace_stripping"};
        SETTING_NAMES_CAMEL_CASE = new String[]{AUTO_IMPORT_KEY_CAMEL_CASE, AUTO_INCLUDE_KEY_CAMEL_CASE, CACHE_STORAGE_KEY_CAMEL_CASE, DEFAULT_ENCODING_KEY_CAMEL_CASE, INCOMPATIBLE_IMPROVEMENTS_KEY_CAMEL_CASE, LOCALIZED_LOOKUP_KEY_CAMEL_CASE, NAMING_CONVENTION_KEY_CAMEL_CASE, STRICT_SYNTAX_KEY_CAMEL_CASE, TAG_SYNTAX_KEY_CAMEL_CASE, TEMPLATE_LOADER_KEY_CAMEL_CASE, TEMPLATE_LOOKUP_STRATEGY_KEY_CAMEL_CASE, TEMPLATE_NAME_FORMAT_KEY_CAMEL_CASE, TEMPLATE_UPDATE_DELAY_KEY_CAMEL_CASE, WHITESPACE_STRIPPING_KEY_CAMEL_CASE};
        VERSION_2_3_0 = new Version(2, 3, 0);
        VERSION_2_3_19 = new Version(2, 3, 19);
        VERSION_2_3_20 = new Version(2, 3, 20);
        VERSION_2_3_21 = new Version(2, 3, 21);
        VERSION_2_3_22 = new Version(2, 3, 22);
        VERSION_2_3_23 = new Version(2, 3, 23);
        DEFAULT_INCOMPATIBLE_IMPROVEMENTS = VERSION_2_3_0;
        DEFAULT_INCOMPATIBLE_ENHANCEMENTS = DEFAULT_INCOMPATIBLE_IMPROVEMENTS.toString();
        PARSED_DEFAULT_INCOMPATIBLE_ENHANCEMENTS = DEFAULT_INCOMPATIBLE_IMPROVEMENTS.intValue();
        try {
            Date buildDate;
            Properties vp = new Properties();
            InputStream ins = Configuration.class.getClassLoader().getResourceAsStream(VERSION_PROPERTIES_PATH);
            if (ins == null) {
                throw new RuntimeException("Version file is missing.");
            }
            try {
                vp.load(ins);
            }
            finally {
                ins.close();
            }
            String versionString = Configuration.getRequiredVersionProperty(vp, "version");
            String buildDateStr = Configuration.getRequiredVersionProperty(vp, "buildTimestamp");
            if (buildDateStr.endsWith("Z")) {
                buildDateStr = buildDateStr.substring(0, buildDateStr.length() - 1) + "+0000";
            }
            try {
                buildDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US).parse(buildDateStr);
            }
            catch (ParseException e) {
                buildDate = null;
            }
            Boolean gaeCompliant = Boolean.valueOf(Configuration.getRequiredVersionProperty(vp, "isGAECompliant"));
            VERSION = new Version(versionString, gaeCompliant, buildDate);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load and parse freemarker/version.properties", e);
        }
        try {
            Class.forName(FM_24_DETECTION_CLASS_NAME);
            fm24detected = true;
        }
        catch (ClassNotFoundException e) {
            fm24detected = false;
        }
        catch (LinkageError e) {
            fm24detected = true;
        }
        catch (Throwable e) {
            fm24detected = false;
        }
        FM_24_DETECTED = fm24detected;
        defaultConfigLock = new Object();
    }

    private static class DefaultSoftCacheStorage
    extends SoftCacheStorage {
        private DefaultSoftCacheStorage() {
        }
    }

    private static class LegacyDefaultFileTemplateLoader
    extends FileTemplateLoader {
    }
}

