/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import com.sun.activation.registries.MailcapFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.activation.CommandInfo;
import javax.activation.CommandMap;
import javax.activation.DataContentHandler;

public class MailcapCommandMap
extends CommandMap {
    private static MailcapFile defDB = null;
    private MailcapFile[] DB;
    private static final int PROG = 0;
    private static final int HOME = 1;
    private static final int SYS = 2;
    private static final int JAR = 3;
    private static final int DEF = 4;
    private static boolean debug = false;
    static /* synthetic */ Class class$javax$activation$MailcapCommandMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MailcapCommandMap() {
        this.DB = new MailcapFile[5];
        if (debug) {
            System.out.println("MailcapCommandMap: load HOME");
        }
        try {
            String user_home = System.getProperty("user.home");
            if (user_home != null) {
                String path = user_home + File.separator + ".mailcap";
                this.DB[1] = this.loadFile(path);
            }
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        if (debug) {
            System.out.println("MailcapCommandMap: load SYS");
        }
        try {
            String system_mailcap = System.getProperty("java.home") + File.separator + "lib" + File.separator + "mailcap";
            this.DB[2] = this.loadFile(system_mailcap);
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        if (debug) {
            System.out.println("MailcapCommandMap: load JAR");
        }
        this.DB[3] = this.loadResource("/META-INF/mailcap");
        if (debug) {
            System.out.println("MailcapCommandMap: load DEF");
        }
        Class clazz = class$javax$activation$MailcapCommandMap == null ? (class$javax$activation$MailcapCommandMap = MailcapCommandMap.class$("javax.activation.MailcapCommandMap")) : class$javax$activation$MailcapCommandMap;
        synchronized (clazz) {
            if (defDB == null) {
                defDB = this.loadResource("/META-INF/mailcap.default");
            }
        }
        this.DB[4] = defDB;
    }

    private MailcapFile loadResource(String name) {
        try {
            InputStream clis = this.getClass().getResourceAsStream(name);
            if (clis != null) {
                return new MailcapFile(clis);
            }
        }
        catch (IOException e) {}
        return null;
    }

    private MailcapFile loadFile(String name) {
        MailcapFile mtf = null;
        try {
            mtf = new MailcapFile(name);
        }
        catch (IOException e) {}
        return mtf;
    }

    public MailcapCommandMap(String fileName) throws IOException {
        this();
        if (debug) {
            System.out.println("MailcapCommandMap: load PROG from " + fileName);
        }
        if (this.DB[0] == null) {
            this.DB[0] = new MailcapFile(fileName);
        }
    }

    public MailcapCommandMap(InputStream is) {
        block3: {
            this();
            if (debug) {
                System.out.println("MailcapCommandMap: load PROG");
            }
            if (this.DB[0] != null) break block3;
            try {
                this.DB[0] = new MailcapFile(is);
            }
            catch (IOException ex) {}
        }
    }

    public synchronized CommandInfo[] getPreferredCommands(String mimeType) {
        Vector cmdVector = new Vector();
        int i = 0;
        while (i < this.DB.length) {
            Hashtable cmdList;
            if (this.DB[i] != null && (cmdList = this.DB[i].getMailcapList(mimeType)) != null) {
                this.appendPrefCmdsToVector(cmdList, cmdVector);
            }
            ++i;
        }
        Object[] cmdInfos = new CommandInfo[cmdVector.size()];
        cmdVector.copyInto(cmdInfos);
        return cmdInfos;
    }

    private void appendPrefCmdsToVector(Hashtable typeHash, Vector cmdList) {
        Enumeration verb_enum = typeHash.keys();
        while (verb_enum.hasMoreElements()) {
            String verb = (String)verb_enum.nextElement();
            if (this.checkForVerb(cmdList, verb)) continue;
            Vector cmdVector = (Vector)typeHash.get(verb);
            String className = (String)cmdVector.firstElement();
            cmdList.addElement(new CommandInfo(verb, className));
        }
    }

    private boolean checkForVerb(Vector cmdVector, String verb) {
        Enumeration enumeration = cmdVector.elements();
        while (enumeration.hasMoreElements()) {
            String enum_verb = ((CommandInfo)enumeration.nextElement()).getCommandName();
            if (!enum_verb.equals(verb)) continue;
            return true;
        }
        return false;
    }

    public synchronized CommandInfo[] getAllCommands(String mimeType) {
        Vector cmdVector = new Vector();
        int i = 0;
        while (i < this.DB.length) {
            Hashtable cmdList;
            if (this.DB[i] != null && (cmdList = this.DB[i].getMailcapList(mimeType)) != null) {
                this.appendCmdsToVector(cmdList, cmdVector);
            }
            ++i;
        }
        Object[] cmdInfos = new CommandInfo[cmdVector.size()];
        cmdVector.copyInto(cmdInfos);
        return cmdInfos;
    }

    private void appendCmdsToVector(Hashtable typeHash, Vector cmdList) {
        Enumeration verb_enum = typeHash.keys();
        while (verb_enum.hasMoreElements()) {
            String verb = (String)verb_enum.nextElement();
            Vector cmdVector = (Vector)typeHash.get(verb);
            Enumeration cmd_enum = cmdVector.elements();
            while (cmd_enum.hasMoreElements()) {
                String cmd = (String)cmd_enum.nextElement();
                cmdList.insertElementAt(new CommandInfo(verb, cmd), 0);
            }
        }
    }

    public synchronized CommandInfo getCommand(String mimeType, String cmdName) {
        int i = 0;
        while (i < this.DB.length) {
            String cmdClassName;
            Vector v;
            Hashtable cmdList;
            if (this.DB[i] != null && (cmdList = this.DB[i].getMailcapList(mimeType)) != null && (v = (Vector)cmdList.get(cmdName)) != null && (cmdClassName = (String)v.firstElement()) != null) {
                return new CommandInfo(cmdName, cmdClassName);
            }
            ++i;
        }
        return null;
    }

    public synchronized void addMailcap(String mail_cap) {
        if (debug) {
            System.out.println("MailcapCommandMap: add to PROG");
        }
        if (this.DB[0] == null) {
            this.DB[0] = new MailcapFile();
        }
        this.DB[0].appendToMailcap(mail_cap);
    }

    public synchronized DataContentHandler createDataContentHandler(String mimeType) {
        if (debug) {
            System.out.println("MailcapCommandMap: createDataContentHandler for " + mimeType);
        }
        int i = 0;
        while (i < this.DB.length) {
            if (this.DB[i] != null) {
                Vector v;
                Hashtable cmdList;
                if (debug) {
                    System.out.println("  search DB #" + i);
                }
                if ((cmdList = this.DB[i].getMailcapList(mimeType)) != null && (v = (Vector)cmdList.get("content-handler")) != null) {
                    if (debug) {
                        System.out.println("    got content-handler");
                    }
                    try {
                        if (debug) {
                            System.out.println("      class " + (String)v.firstElement());
                        }
                        return (DataContentHandler)Class.forName((String)v.firstElement()).newInstance();
                    }
                    catch (IllegalAccessException e) {
                    }
                    catch (ClassNotFoundException e) {
                    }
                    catch (InstantiationException e) {
                        // empty catch block
                    }
                }
            }
            ++i;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            debug = Boolean.getBoolean("javax.activation.debug");
        }
        catch (Throwable t) {}
    }
}

