/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import com.sun.activation.registries.MimeTypeFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.activation.FileTypeMap;

public class MimetypesFileTypeMap
extends FileTypeMap {
    private static MimeTypeFile defDB = null;
    private MimeTypeFile[] DB = new MimeTypeFile[5];
    private static final int PROG = 0;
    private static final int HOME = 1;
    private static final int SYS = 2;
    private static final int JAR = 3;
    private static final int DEF = 4;
    private static String defaultType = "application/octet-stream";
    static /* synthetic */ Class class$javax$activation$MimetypesFileTypeMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MimetypesFileTypeMap() {
        try {
            String user_home = System.getProperty("user.home");
            if (user_home != null) {
                String path = user_home + File.separator + ".mime.types";
                this.DB[1] = this.loadFile(path);
            }
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        try {
            String system_mimetypes = System.getProperty("java.home") + File.separator + "lib" + File.separator + "mime.types";
            this.DB[2] = this.loadFile(system_mimetypes);
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        this.DB[3] = this.loadResource("/META-INF/mime.types");
        Class clazz = class$javax$activation$MimetypesFileTypeMap == null ? (class$javax$activation$MimetypesFileTypeMap = MimetypesFileTypeMap.class$("javax.activation.MimetypesFileTypeMap")) : class$javax$activation$MimetypesFileTypeMap;
        synchronized (clazz) {
            if (defDB == null) {
                defDB = this.loadResource("/META-INF/mimetypes.default");
            }
        }
        this.DB[4] = defDB;
    }

    private MimeTypeFile loadResource(String name) {
        try {
            InputStream clis = this.getClass().getResourceAsStream(name);
            if (clis != null) {
                return new MimeTypeFile(clis);
            }
        }
        catch (IOException e) {}
        return null;
    }

    private MimeTypeFile loadFile(String name) {
        MimeTypeFile mtf = null;
        try {
            mtf = new MimeTypeFile(name);
        }
        catch (IOException e) {}
        return mtf;
    }

    public MimetypesFileTypeMap(String mimeTypeFileName) throws IOException {
        this();
        this.DB[0] = new MimeTypeFile(mimeTypeFileName);
    }

    public MimetypesFileTypeMap(InputStream is) {
        this();
        try {
            this.DB[0] = new MimeTypeFile(is);
        }
        catch (IOException ex) {}
    }

    public synchronized void addMimeTypes(String mime_types) {
        if (this.DB[0] == null) {
            this.DB[0] = new MimeTypeFile();
        }
        this.DB[0].appendToRegistry(mime_types);
    }

    public String getContentType(File f) {
        return this.getContentType(f.getName());
    }

    public synchronized String getContentType(String filename) {
        int dot_pos = filename.lastIndexOf(".");
        if (dot_pos < 0) {
            return defaultType;
        }
        String file_ext = filename.substring(dot_pos + 1);
        if (file_ext.length() == 0) {
            return defaultType;
        }
        int i = 0;
        while (i < this.DB.length) {
            String result;
            if (this.DB[i] != null && (result = this.DB[i].getMIMETypeString(file_ext)) != null) {
                return result;
            }
            ++i;
        }
        return defaultType;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

