/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Service;
import javax.mail.Session;
import javax.mail.URLName;
import javax.mail.event.TransportEvent;
import javax.mail.event.TransportListener;

public abstract class Transport
extends Service {
    private Vector transportListeners = null;

    public Transport(Session session, URLName urlname) {
        super(session, urlname);
    }

    public static void send(Message msg) throws MessagingException {
        msg.saveChanges();
        Transport.send0(msg, msg.getAllRecipients());
    }

    public static void send(Message msg, Address[] addresses) throws MessagingException {
        msg.saveChanges();
        Transport.send0(msg, addresses);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void send0(Message msg, Address[] addresses) throws MessagingException {
        if (addresses == null || addresses.length == 0) {
            throw new SendFailedException("No recipient addresses");
        }
        Hashtable protocols = new Hashtable();
        Vector<Object> invalid = new Vector<Object>();
        Vector<Address> validSent = new Vector<Address>();
        Vector<Address> validUnsent = new Vector<Address>();
        int i = 0;
        while (true) {
            if (i >= addresses.length) {
                int dsize = protocols.size();
                if (dsize != 0) break;
                throw new SendFailedException("No recipient addresses");
            }
            if (protocols.containsKey(addresses[i].getType())) {
                Vector v = (Vector)protocols.get(addresses[i].getType());
                v.addElement(addresses[i]);
            } else {
                Vector<Address> w = new Vector<Address>();
                w.addElement(addresses[i]);
                protocols.put(addresses[i].getType(), w);
            }
            ++i;
        }
        Session s = msg.session != null ? msg.session : Session.getDefaultInstance(System.getProperties(), null);
        Object var10_10 = null;
        boolean sendFailed = false;
        Enumeration e = protocols.elements();
        block6: while (true) {
            Object var22_28;
            void var10_11;
            if (!e.hasMoreElements()) {
                if (!sendFailed && invalid.size() == 0 && validUnsent.size() == 0) {
                    return;
                }
                Object[] a = null;
                Object[] b = null;
                Object[] c = null;
                if (validSent.size() > 0) {
                    a = new Address[validSent.size()];
                    validSent.copyInto(a);
                }
                if (validUnsent.size() > 0) {
                    b = new Address[validUnsent.size()];
                    validUnsent.copyInto(b);
                }
                if (invalid.size() > 0) {
                    c = new Address[invalid.size()];
                    invalid.copyInto(c);
                }
                throw new SendFailedException("Sending failed", (Exception)var10_11, (Address[])a, (Address[])b, (Address[])c);
            }
            Vector v = (Vector)e.nextElement();
            Object[] protaddresses = new Address[v.size()];
            v.copyInto(protaddresses);
            Transport transport = s.getTransport((Address)protaddresses[0]);
            if (transport == null) {
                int j = 0;
                while (true) {
                    if (j >= protaddresses.length) continue block6;
                    invalid.addElement(protaddresses[j]);
                    ++j;
                }
            }
            try {
                Address[] c;
                Address[] a;
                SendFailedException sex2;
                block28: {
                    int j;
                    try {
                        transport.connect();
                        transport.sendMessage(msg, (Address[])protaddresses);
                    }
                    catch (SendFailedException sex2) {
                        sendFailed = true;
                        if (var10_11 == null) {
                            SendFailedException sendFailedException = sex2;
                        } else {
                            var10_11.setNextException(sex2);
                        }
                        a = sex2.getInvalidAddresses();
                        if (a == null) break block28;
                        j = 0;
                    }
                    while (j < a.length) {
                        invalid.addElement(a[j]);
                        ++j;
                    }
                }
                if ((a = sex2.getValidSentAddresses()) != null) {
                    int k = 0;
                    while (k < a.length) {
                        validSent.addElement(a[k]);
                        ++k;
                    }
                }
                if ((c = sex2.getValidUnsentAddresses()) != null) {
                    int l = 0;
                    while (true) {
                        if (l >= c.length) {
                            break;
                        }
                        validUnsent.addElement(c[l]);
                        ++l;
                    }
                }
                var22_28 = null;
                transport.close();
                continue;
                catch (MessagingException mex) {
                    sendFailed = true;
                    if (var10_11 == null) {
                        MessagingException messagingException = mex;
                    } else {
                        var10_11.setNextException(mex);
                    }
                    var22_28 = null;
                    transport.close();
                    continue;
                }
                var22_28 = null;
            }
            catch (Throwable throwable) {
                var22_28 = null;
                transport.close();
                throw throwable;
            }
            transport.close();
        }
    }

    public abstract void sendMessage(Message var1, Address[] var2) throws MessagingException;

    public synchronized void addTransportListener(TransportListener l) {
        if (this.transportListeners == null) {
            this.transportListeners = new Vector();
        }
        this.transportListeners.addElement(l);
    }

    public synchronized void removeTransportListener(TransportListener l) {
        if (this.transportListeners != null) {
            this.transportListeners.removeElement(l);
        }
    }

    protected void notifyTransportListeners(int type, Address[] validSent, Address[] validUnsent, Address[] invalid, Message msg) {
        if (this.transportListeners == null) {
            return;
        }
        TransportEvent e = new TransportEvent(this, type, validSent, validUnsent, invalid, msg);
        this.queueEvent(e, this.transportListeners);
    }
}

