/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import com.sun.mail.util.LineInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.mail.MessagingException;
import javax.mail.internet.hdr;
import javax.mail.internet.matchEnum;

public class InternetHeaders {
    private Vector headers = new Vector();

    public InternetHeaders() {
        this.headers.addElement(new hdr("Return-Path", null));
        this.headers.addElement(new hdr("Received", null));
        this.headers.addElement(new hdr("Message-Id", null));
        this.headers.addElement(new hdr("Resent-Date", null));
        this.headers.addElement(new hdr("Date", null));
        this.headers.addElement(new hdr("Resent-From", null));
        this.headers.addElement(new hdr("From", null));
        this.headers.addElement(new hdr("Reply-To", null));
        this.headers.addElement(new hdr("Sender", null));
        this.headers.addElement(new hdr("To", null));
        this.headers.addElement(new hdr("Subject", null));
        this.headers.addElement(new hdr("Cc", null));
        this.headers.addElement(new hdr("In-Reply-To", null));
        this.headers.addElement(new hdr("Resent-Message-Id", null));
        this.headers.addElement(new hdr("Errors-To", null));
        this.headers.addElement(new hdr("Mime-Version", null));
        this.headers.addElement(new hdr("Content-Type", null));
        this.headers.addElement(new hdr("Content-Transfer-Encoding", null));
        this.headers.addElement(new hdr("Content-MD5", null));
        this.headers.addElement(new hdr(":", null));
        this.headers.addElement(new hdr("Content-Length", null));
        this.headers.addElement(new hdr("Status", null));
    }

    public InternetHeaders(InputStream is) throws MessagingException {
        this.load(is);
    }

    public void load(InputStream is) throws MessagingException {
        LineInputStream lis = new LineInputStream(is);
        String prevline = null;
        StringBuffer lineBuffer = new StringBuffer();
        try {
            String line;
            do {
                if ((line = lis.readLine()) != null && (line.startsWith(" ") || line.startsWith("\t"))) {
                    if (prevline != null) {
                        lineBuffer.append(prevline);
                        prevline = null;
                    }
                    lineBuffer.append("\r\n");
                    lineBuffer.append(line);
                    continue;
                }
                if (prevline != null) {
                    this.addHeaderLine(prevline);
                } else if (lineBuffer.length() > 0) {
                    this.addHeaderLine(lineBuffer.toString());
                    lineBuffer.setLength(0);
                }
                prevline = line;
            } while (line != null && line.length() > 0);
        }
        catch (IOException ioex) {
            throw new MessagingException("Error in input stream", ioex);
        }
    }

    public String[] getHeader(String name) {
        Enumeration e = this.headers.elements();
        Vector<String> v = new Vector<String>();
        while (e.hasMoreElements()) {
            hdr h = (hdr)e.nextElement();
            if (!name.equalsIgnoreCase(h.name) || h.line == null) continue;
            v.addElement(h.getValue());
        }
        if (v.size() == 0) {
            return null;
        }
        Object[] r = new String[v.size()];
        v.copyInto(r);
        return r;
    }

    public String getHeader(String name, String delimiter) {
        String[] s = this.getHeader(name);
        if (s == null) {
            return null;
        }
        if (s.length == 1 || delimiter == null) {
            return s[0];
        }
        StringBuffer r = new StringBuffer(s[0]);
        int i = 1;
        while (i < s.length) {
            r.append(delimiter);
            r.append(s[i]);
            ++i;
        }
        return r.toString();
    }

    public void setHeader(String name, String value) {
        boolean found = false;
        int i = 0;
        while (i < this.headers.size()) {
            hdr h = (hdr)this.headers.elementAt(i);
            if (name.equalsIgnoreCase(h.name)) {
                if (!found) {
                    int j;
                    h.line = h.line != null && (j = h.line.indexOf(58)) >= 0 ? h.line.substring(0, j + 1) + " " + value : name + ": " + value;
                    found = true;
                } else {
                    this.headers.removeElementAt(i);
                    --i;
                }
            }
            ++i;
        }
        if (!found) {
            this.addHeader(name, value);
        }
    }

    public void addHeader(String name, String value) {
        int pos = this.headers.size();
        boolean isReceived = name.equalsIgnoreCase("Received");
        if (isReceived) {
            pos = 0;
        }
        int i = this.headers.size() - 1;
        while (i >= 0) {
            hdr h = (hdr)this.headers.elementAt(i);
            if (name.equalsIgnoreCase(h.name)) {
                if (isReceived) {
                    pos = i;
                } else {
                    this.headers.insertElementAt(new hdr(name, value), i + 1);
                    return;
                }
            }
            if (h.name.equals(":")) {
                pos = i;
            }
            --i;
        }
        this.headers.insertElementAt(new hdr(name, value), pos);
    }

    public void removeHeader(String name) {
        int i = 0;
        while (i < this.headers.size()) {
            hdr h = (hdr)this.headers.elementAt(i);
            if (name.equalsIgnoreCase(h.name)) {
                h.line = null;
            }
            ++i;
        }
    }

    public Enumeration getAllHeaders() {
        return new matchEnum(this.headers, null, false, false);
    }

    public Enumeration getMatchingHeaders(String[] names) {
        return new matchEnum(this.headers, names, true, false);
    }

    public Enumeration getNonMatchingHeaders(String[] names) {
        return new matchEnum(this.headers, names, false, false);
    }

    public void addHeaderLine(String line) {
        try {
            char c = line.charAt(0);
            if (c == ' ' || c == '\t') {
                hdr h = (hdr)this.headers.lastElement();
                h.line = h.line + "\r\n" + line;
            } else {
                this.headers.addElement(new hdr(line));
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            return;
        }
        catch (NoSuchElementException e) {
        }
    }

    public Enumeration getAllHeaderLines() {
        return this.getNonMatchingHeaderLines(null);
    }

    public Enumeration getMatchingHeaderLines(String[] names) {
        return new matchEnum(this.headers, names, true, true);
    }

    public Enumeration getNonMatchingHeaderLines(String[] names) {
        return new matchEnum(this.headers, names, false, true);
    }
}

