/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Map;
import java.util.WeakHashMap;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;

public class MBeanInfo
implements Cloneable,
Serializable {
    static final long serialVersionUID = -6451021435135161911L;
    private final String description;
    private final String className;
    private final MBeanAttributeInfo[] attributes;
    private final MBeanOperationInfo[] operations;
    private final MBeanConstructorInfo[] constructors;
    private final MBeanNotificationInfo[] notifications;
    private transient int hashCode;
    private final transient boolean immutable;
    private static final Map immutability = new WeakHashMap();
    static /* synthetic */ Class class$javax$management$MBeanInfo;

    public MBeanInfo(String string, String string2, MBeanAttributeInfo[] mBeanAttributeInfoArray, MBeanConstructorInfo[] mBeanConstructorInfoArray, MBeanOperationInfo[] mBeanOperationInfoArray, MBeanNotificationInfo[] mBeanNotificationInfoArray) throws IllegalArgumentException {
        MBeanInfo.mustBeValidMBeanTypeName(string);
        this.className = string;
        this.description = string2;
        if (mBeanAttributeInfoArray == null || mBeanAttributeInfoArray.length == 0) {
            mBeanAttributeInfoArray = MBeanAttributeInfo.NO_ATTRIBUTES;
        }
        this.attributes = mBeanAttributeInfoArray;
        if (mBeanOperationInfoArray == null || mBeanOperationInfoArray.length == 0) {
            mBeanOperationInfoArray = MBeanOperationInfo.NO_OPERATIONS;
        }
        this.operations = mBeanOperationInfoArray;
        if (mBeanConstructorInfoArray == null || mBeanConstructorInfoArray.length == 0) {
            mBeanConstructorInfoArray = MBeanConstructorInfo.NO_CONSTRUCTORS;
        }
        this.constructors = mBeanConstructorInfoArray;
        if (mBeanNotificationInfoArray == null || mBeanNotificationInfoArray.length == 0) {
            mBeanNotificationInfoArray = MBeanNotificationInfo.NO_NOTIFICATIONS;
        }
        this.notifications = mBeanNotificationInfoArray;
        this.immutable = MBeanInfo.isImmutableClass(this.getClass(), class$javax$management$MBeanInfo == null ? (class$javax$management$MBeanInfo = MBeanInfo.class$("javax.management.MBeanInfo")) : class$javax$management$MBeanInfo);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String getClassName() {
        return this.className;
    }

    public String getDescription() {
        return this.description;
    }

    public MBeanAttributeInfo[] getAttributes() {
        if (this.attributes.length == 0) {
            return this.attributes;
        }
        return (MBeanAttributeInfo[])this.attributes.clone();
    }

    private MBeanAttributeInfo[] fastGetAttributes() {
        if (this.immutable) {
            return this.attributes;
        }
        return this.getAttributes();
    }

    public MBeanOperationInfo[] getOperations() {
        if (this.operations.length == 0) {
            return this.operations;
        }
        return (MBeanOperationInfo[])this.operations.clone();
    }

    private MBeanOperationInfo[] fastGetOperations() {
        if (this.immutable) {
            return this.operations;
        }
        return this.getOperations();
    }

    public MBeanConstructorInfo[] getConstructors() {
        if (this.constructors.length == 0) {
            return this.constructors;
        }
        return (MBeanConstructorInfo[])this.constructors.clone();
    }

    private MBeanConstructorInfo[] fastGetConstructors() {
        if (this.immutable) {
            return this.constructors;
        }
        return this.getConstructors();
    }

    public MBeanNotificationInfo[] getNotifications() {
        if (this.notifications.length == 0) {
            return this.notifications;
        }
        return (MBeanNotificationInfo[])this.notifications.clone();
    }

    private MBeanNotificationInfo[] fastGetNotifications() {
        if (this.immutable) {
            return this.notifications;
        }
        return this.getNotifications();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MBeanInfo)) {
            return false;
        }
        MBeanInfo mBeanInfo = (MBeanInfo)object;
        if (!mBeanInfo.getClassName().equals(this.getClassName()) || !mBeanInfo.getDescription().equals(this.getDescription())) {
            return false;
        }
        return Arrays.equals(mBeanInfo.fastGetAttributes(), this.fastGetAttributes()) && Arrays.equals(mBeanInfo.fastGetOperations(), this.fastGetOperations()) && Arrays.equals(mBeanInfo.fastGetConstructors(), this.fastGetConstructors()) && Arrays.equals(mBeanInfo.fastGetNotifications(), this.fastGetNotifications());
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        this.hashCode = this.getClassName().hashCode() ^ MBeanInfo.arrayHashCode(this.fastGetAttributes()) ^ MBeanInfo.arrayHashCode(this.fastGetOperations()) ^ MBeanInfo.arrayHashCode(this.fastGetConstructors()) ^ MBeanInfo.arrayHashCode(this.fastGetNotifications());
        return this.hashCode;
    }

    private static int arrayHashCode(Object[] objectArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < objectArray.length) {
            n ^= objectArray[n2].hashCode();
            ++n2;
        }
        return n;
    }

    static boolean isValidJavaIdentifier(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (n == 0 || !Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        int n2 = 1;
        while (n2 < n) {
            if (!Character.isJavaIdentifierPart(string.charAt(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    static boolean isValidJavaTypeName(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (string.charAt(n2) != '[') break;
            ++n2;
        }
        if (n2 == n) {
            return false;
        }
        if (n2 == 0) {
            return MBeanInfo.isValidJavaTypeIdentifier(string);
        }
        char c = string.charAt(n2);
        switch (c) {
            case 'L': {
                if (n2 < n - 1 && string.charAt(n - 1) == ';') {
                    return MBeanInfo.isValidJavaTypeIdentifier(string.substring(n2, n - 1));
                }
                return false;
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return n2 == n - 1;
            }
        }
        return false;
    }

    static boolean isValidJavaTypeIdentifier(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        boolean bl = true;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (bl) {
                if (!Character.isJavaIdentifierStart(c)) {
                    return false;
                }
                bl = false;
            } else if (c == '.') {
                bl = true;
            } else if (!Character.isJavaIdentifierPart(c)) {
                return false;
            }
            ++n2;
        }
        return !bl;
    }

    static void mustBeValidMBeanTypeName(String string) throws IllegalArgumentException {
        if (!MBeanInfo.isValidJavaTypeIdentifier(string)) {
            throw new IllegalArgumentException("Not a valid Java MBean type name: " + string);
        }
    }

    static void mustBeValidJavaTypeName(String string) throws IllegalArgumentException {
        if (!MBeanInfo.isValidJavaTypeName(string)) {
            throw new IllegalArgumentException("Not a valid Java type name: " + string);
        }
    }

    static void mustBeValidJavaIdentifier(String string) throws IllegalArgumentException {
        if (!MBeanInfo.isValidJavaIdentifier(string)) {
            throw new IllegalArgumentException("Not a valid Java identifier: " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isImmutableClass(Class clazz, Class clazz2) {
        if (clazz == clazz2) {
            return true;
        }
        Map map = immutability;
        synchronized (map) {
            Boolean bl = (Boolean)immutability.get(clazz);
            if (bl == null) {
                try {
                    ImmutabilityAction immutabilityAction = new ImmutabilityAction(clazz, clazz2);
                    bl = (Boolean)AccessController.doPrivileged(immutabilityAction);
                }
                catch (Exception exception) {
                    bl = Boolean.FALSE;
                }
                immutability.put(clazz, bl);
            }
            return bl;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ImmutabilityAction
    implements PrivilegedAction {
        private final Class subclass;
        private final Class immutableClass;

        ImmutabilityAction(Class clazz, Class clazz2) {
            this.subclass = clazz;
            this.immutableClass = clazz2;
        }

        public Object run() {
            Method[] methodArray = this.immutableClass.getMethods();
            int n = 0;
            while (n < methodArray.length) {
                Method method = methodArray[n];
                String string = method.getName();
                if (string.startsWith("get") || string.startsWith("is")) {
                    Class<?>[] classArray = method.getParameterTypes();
                    try {
                        Method method2 = this.subclass.getMethod(string, classArray);
                        if (!method2.equals(method)) {
                            return Boolean.FALSE;
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        return Boolean.FALSE;
                    }
                }
                ++n;
            }
            return Boolean.TRUE;
        }
    }
}

