/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.Permission;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class MBeanPermission
extends Permission {
    private static final long serialVersionUID = -2416928705275160661L;
    private static final int AddNotificationListener = 1;
    private static final int GetAttribute = 2;
    private static final int GetClassLoader = 4;
    private static final int GetClassLoaderFor = 8;
    private static final int GetClassLoaderRepository = 16;
    private static final int GetDomains = 32;
    private static final int GetMBeanInfo = 64;
    private static final int GetObjectInstance = 128;
    private static final int Instantiate = 256;
    private static final int Invoke = 512;
    private static final int IsInstanceOf = 1024;
    private static final int QueryMBeans = 2048;
    private static final int QueryNames = 4096;
    private static final int RegisterMBean = 8192;
    private static final int RemoveNotificationListener = 16384;
    private static final int SetAttribute = 32768;
    private static final int UnregisterMBean = 65536;
    private static final int NONE = 0;
    private static final int ALL = 131071;
    private static final ObjectName allObjectNames;
    private String actions;
    private transient int mask;
    private transient String classNamePrefix;
    private transient boolean classNameExactMatch;
    private transient String member;
    private transient ObjectName objectName;

    private void parseActions() {
        if (this.actions == null) {
            throw new IllegalArgumentException("MBeanPermission: actions can't be null");
        }
        if (this.actions.equals("")) {
            throw new IllegalArgumentException("MBeanPermission: actions can't be empty");
        }
        int n = MBeanPermission.getMask(this.actions);
        if ((n & 0x1FFFF) != n) {
            throw new IllegalArgumentException("Invalid actions mask");
        }
        if (n == 0) {
            throw new IllegalArgumentException("Invalid actions mask");
        }
        this.mask = n;
    }

    private void parseName() {
        String string = this.getName();
        if (string.equals("")) {
            throw new IllegalArgumentException("MBeanPermission name cannot be empty");
        }
        int n = string.indexOf("[");
        if (n == -1) {
            this.objectName = allObjectNames;
        } else {
            if (!string.endsWith("]")) {
                throw new IllegalArgumentException("MBeanPermission: The ObjectName in the target name must be included in square brackets");
            }
            try {
                String string2 = string.substring(n + 1, string.length() - 1);
                this.objectName = string2.equals("") ? allObjectNames : (string2.equals("-") ? null : new ObjectName(string2));
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                throw new IllegalArgumentException("MBeanPermission: The target name does not specify a valid ObjectName");
            }
            string = string.substring(0, n);
        }
        int n2 = string.indexOf("#");
        if (n2 == -1) {
            this.setMember("*");
        } else {
            String string3 = string.substring(n2 + 1);
            this.setMember(string3);
            string = string.substring(0, n2);
        }
        this.setClassName(string);
    }

    private void initName(String string, String string2, ObjectName objectName) {
        this.setClassName(string);
        this.setMember(string2);
        this.objectName = objectName;
    }

    private void setClassName(String string) {
        if (string == null || string.equals("-")) {
            this.classNamePrefix = null;
            this.classNameExactMatch = false;
        } else if (string.equals("") || string.equals("*")) {
            this.classNamePrefix = "";
            this.classNameExactMatch = false;
        } else if (string.endsWith(".*")) {
            this.classNamePrefix = string.substring(0, string.length() - 1);
            this.classNameExactMatch = false;
        } else {
            this.classNamePrefix = string;
            this.classNameExactMatch = true;
        }
    }

    private void setMember(String string) {
        this.member = string == null || string.equals("-") ? null : (string.equals("") ? "*" : string);
    }

    public MBeanPermission(String string, String string2) {
        super(string);
        this.parseName();
        this.actions = string2;
        this.parseActions();
    }

    public MBeanPermission(String string, String string2, ObjectName objectName, String string3) {
        super(MBeanPermission.makeName(string, string2, objectName));
        this.initName(string, string2, objectName);
        this.actions = string3;
        this.parseActions();
    }

    private static String makeName(String string, String string2, ObjectName objectName) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string == null) {
            string = "-";
        }
        stringBuffer.append(string);
        if (string2 == null) {
            string2 = "-";
        }
        stringBuffer.append("#" + string2);
        if (objectName == null) {
            stringBuffer.append("[-]");
        } else {
            stringBuffer.append("[").append(objectName.getCanonicalName()).append("]");
        }
        if (stringBuffer.length() == 0) {
            return "*";
        }
        return stringBuffer.toString();
    }

    public String getActions() {
        if (this.actions == null) {
            this.actions = MBeanPermission.getActions(this.mask);
        }
        return this.actions;
    }

    private static String getActions(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if ((n & 1) == 1) {
            bl = true;
            stringBuffer.append("addNotificationListener");
        }
        if ((n & 2) == 2) {
            if (bl) {
                stringBuffer.append(',');
            } else {
                bl = true;
            }
            stringBuffer.append("getAttribute");
        }
        if ((n & 4) == 4) {
            if (bl) {
                stringBuffer.append(',');
            } else {
                bl = true;
            }
            stringBuffer.append("getClassLoader");
        }
        if ((n & 8) == 8) {
            if (bl) {
                stringBuffer.append(',');
            } else {
                bl = true;
            }
            stringBuffer.append("getClassLoaderFor");
        }
        if ((n & 0x10) == 16) {
            if (bl) {
                stringBuffer.append(',');
            } else {
                bl = true;
            }
            stringBuffer.append("getClassLoaderRepository");
        }
        if ((n & 0x20) == 32) {
            if (bl) {
                stringBuffer.append(',');
            } else {
                bl = true;
            }
            stringBuffer.append("getDomains");
        }
        if ((n & 0x40) == 64) {
            if (bl) {
                stringBuffer.append(',');
            } else {
                bl = true;
            }
            stringBuffer.append("getMBeanInfo");
        }
        if ((n & 0x80) == 128) {
            if (bl) {
                stringBuffer.append(',');
            } else {
                bl = true;
            }
            stringBuffer.append("getObjectInstance");
        }
        if ((n & 0x100) == 256) {
            if (bl) {
                stringBuffer.append(',');
            } else {
                bl = true;
            }
            stringBuffer.append("instantiate");
        }
        if ((n & 0x200) == 512) {
            if (bl) {
                stringBuffer.append(',');
            } else {
                bl = true;
            }
            stringBuffer.append("invoke");
        }
        if ((n & 0x400) == 1024) {
            if (bl) {
                stringBuffer.append(',');
            } else {
                bl = true;
            }
            stringBuffer.append("isInstanceOf");
        }
        if ((n & 0x800) == 2048) {
            if (bl) {
                stringBuffer.append(',');
            } else {
                bl = true;
            }
            stringBuffer.append("queryMBeans");
        }
        if ((n & 0x1000) == 4096) {
            if (bl) {
                stringBuffer.append(',');
            } else {
                bl = true;
            }
            stringBuffer.append("queryNames");
        }
        if ((n & 0x2000) == 8192) {
            if (bl) {
                stringBuffer.append(',');
            } else {
                bl = true;
            }
            stringBuffer.append("registerMBean");
        }
        if ((n & 0x4000) == 16384) {
            if (bl) {
                stringBuffer.append(',');
            } else {
                bl = true;
            }
            stringBuffer.append("removeNotificationListener");
        }
        if ((n & 0x8000) == 32768) {
            if (bl) {
                stringBuffer.append(',');
            } else {
                bl = true;
            }
            stringBuffer.append("setAttribute");
        }
        if ((n & 0x10000) == 65536) {
            if (bl) {
                stringBuffer.append(',');
            } else {
                bl = true;
            }
            stringBuffer.append("unregisterMBean");
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        return this.getName().hashCode() + this.getActions().hashCode();
    }

    /*
     * Unable to fully structure code
     */
    private static int getMask(String var0) {
        var1_1 = 0;
        if (var0 == null) {
            return var1_1;
        }
        if (var0.equals("*")) {
            return 131071;
        }
        var2_2 = var0.toCharArray();
        var3_3 = var2_2.length - 1;
        if (var3_3 >= 0) ** GOTO lbl94
        return var1_1;
        {
            --var3_3;
            do {
                if (var3_3 != -1 && ((var4_4 = var2_2[var3_3]) == ' ' || var4_4 == '\r' || var4_4 == '\n' || var4_4 == '\f' || var4_4 == '\t')) continue block4;
                if (var3_3 >= 25 && var2_2[var3_3 - 25] == 'r' && var2_2[var3_3 - 24] == 'e' && var2_2[var3_3 - 23] == 'm' && var2_2[var3_3 - 22] == 'o' && var2_2[var3_3 - 21] == 'v' && var2_2[var3_3 - 20] == 'e' && var2_2[var3_3 - 19] == 'N' && var2_2[var3_3 - 18] == 'o' && var2_2[var3_3 - 17] == 't' && var2_2[var3_3 - 16] == 'i' && var2_2[var3_3 - 15] == 'f' && var2_2[var3_3 - 14] == 'i' && var2_2[var3_3 - 13] == 'c' && var2_2[var3_3 - 12] == 'a' && var2_2[var3_3 - 11] == 't' && var2_2[var3_3 - 10] == 'i' && var2_2[var3_3 - 9] == 'o' && var2_2[var3_3 - 8] == 'n' && var2_2[var3_3 - 7] == 'L' && var2_2[var3_3 - 6] == 'i' && var2_2[var3_3 - 5] == 's' && var2_2[var3_3 - 4] == 't' && var2_2[var3_3 - 3] == 'e' && var2_2[var3_3 - 2] == 'n' && var2_2[var3_3 - 1] == 'e' && var2_2[var3_3] == 'r') {
                    var5_5 = 26;
                    var1_1 |= 16384;
                } else if (var3_3 >= 23 && var2_2[var3_3 - 23] == 'g' && var2_2[var3_3 - 22] == 'e' && var2_2[var3_3 - 21] == 't' && var2_2[var3_3 - 20] == 'C' && var2_2[var3_3 - 19] == 'l' && var2_2[var3_3 - 18] == 'a' && var2_2[var3_3 - 17] == 's' && var2_2[var3_3 - 16] == 's' && var2_2[var3_3 - 15] == 'L' && var2_2[var3_3 - 14] == 'o' && var2_2[var3_3 - 13] == 'a' && var2_2[var3_3 - 12] == 'd' && var2_2[var3_3 - 11] == 'e' && var2_2[var3_3 - 10] == 'r' && var2_2[var3_3 - 9] == 'R' && var2_2[var3_3 - 8] == 'e' && var2_2[var3_3 - 7] == 'p' && var2_2[var3_3 - 6] == 'o' && var2_2[var3_3 - 5] == 's' && var2_2[var3_3 - 4] == 'i' && var2_2[var3_3 - 3] == 't' && var2_2[var3_3 - 2] == 'o' && var2_2[var3_3 - 1] == 'r' && var2_2[var3_3] == 'y') {
                    var5_5 = 24;
                    var1_1 |= 16;
                } else if (var3_3 >= 22 && var2_2[var3_3 - 22] == 'a' && var2_2[var3_3 - 21] == 'd' && var2_2[var3_3 - 20] == 'd' && var2_2[var3_3 - 19] == 'N' && var2_2[var3_3 - 18] == 'o' && var2_2[var3_3 - 17] == 't' && var2_2[var3_3 - 16] == 'i' && var2_2[var3_3 - 15] == 'f' && var2_2[var3_3 - 14] == 'i' && var2_2[var3_3 - 13] == 'c' && var2_2[var3_3 - 12] == 'a' && var2_2[var3_3 - 11] == 't' && var2_2[var3_3 - 10] == 'i' && var2_2[var3_3 - 9] == 'o' && var2_2[var3_3 - 8] == 'n' && var2_2[var3_3 - 7] == 'L' && var2_2[var3_3 - 6] == 'i' && var2_2[var3_3 - 5] == 's' && var2_2[var3_3 - 4] == 't' && var2_2[var3_3 - 3] == 'e' && var2_2[var3_3 - 2] == 'n' && var2_2[var3_3 - 1] == 'e' && var2_2[var3_3] == 'r') {
                    var5_5 = 23;
                    var1_1 |= 1;
                } else if (var3_3 >= 16 && var2_2[var3_3 - 16] == 'g' && var2_2[var3_3 - 15] == 'e' && var2_2[var3_3 - 14] == 't' && var2_2[var3_3 - 13] == 'C' && var2_2[var3_3 - 12] == 'l' && var2_2[var3_3 - 11] == 'a' && var2_2[var3_3 - 10] == 's' && var2_2[var3_3 - 9] == 's' && var2_2[var3_3 - 8] == 'L' && var2_2[var3_3 - 7] == 'o' && var2_2[var3_3 - 6] == 'a' && var2_2[var3_3 - 5] == 'd' && var2_2[var3_3 - 4] == 'e' && var2_2[var3_3 - 3] == 'r' && var2_2[var3_3 - 2] == 'F' && var2_2[var3_3 - 1] == 'o' && var2_2[var3_3] == 'r') {
                    var5_5 = 17;
                    var1_1 |= 8;
                } else if (var3_3 >= 16 && var2_2[var3_3 - 16] == 'g' && var2_2[var3_3 - 15] == 'e' && var2_2[var3_3 - 14] == 't' && var2_2[var3_3 - 13] == 'O' && var2_2[var3_3 - 12] == 'b' && var2_2[var3_3 - 11] == 'j' && var2_2[var3_3 - 10] == 'e' && var2_2[var3_3 - 9] == 'c' && var2_2[var3_3 - 8] == 't' && var2_2[var3_3 - 7] == 'I' && var2_2[var3_3 - 6] == 'n' && var2_2[var3_3 - 5] == 's' && var2_2[var3_3 - 4] == 't' && var2_2[var3_3 - 3] == 'a' && var2_2[var3_3 - 2] == 'n' && var2_2[var3_3 - 1] == 'c' && var2_2[var3_3] == 'e') {
                    var5_5 = 17;
                    var1_1 |= 128;
                } else if (var3_3 >= 14 && var2_2[var3_3 - 14] == 'u' && var2_2[var3_3 - 13] == 'n' && var2_2[var3_3 - 12] == 'r' && var2_2[var3_3 - 11] == 'e' && var2_2[var3_3 - 10] == 'g' && var2_2[var3_3 - 9] == 'i' && var2_2[var3_3 - 8] == 's' && var2_2[var3_3 - 7] == 't' && var2_2[var3_3 - 6] == 'e' && var2_2[var3_3 - 5] == 'r' && var2_2[var3_3 - 4] == 'M' && var2_2[var3_3 - 3] == 'B' && var2_2[var3_3 - 2] == 'e' && var2_2[var3_3 - 1] == 'a' && var2_2[var3_3] == 'n') {
                    var5_5 = 15;
                    var1_1 |= 65536;
                } else if (var3_3 >= 13 && var2_2[var3_3 - 13] == 'g' && var2_2[var3_3 - 12] == 'e' && var2_2[var3_3 - 11] == 't' && var2_2[var3_3 - 10] == 'C' && var2_2[var3_3 - 9] == 'l' && var2_2[var3_3 - 8] == 'a' && var2_2[var3_3 - 7] == 's' && var2_2[var3_3 - 6] == 's' && var2_2[var3_3 - 5] == 'L' && var2_2[var3_3 - 4] == 'o' && var2_2[var3_3 - 3] == 'a' && var2_2[var3_3 - 2] == 'd' && var2_2[var3_3 - 1] == 'e' && var2_2[var3_3] == 'r') {
                    var5_5 = 14;
                    var1_1 |= 4;
                } else if (var3_3 >= 12 && var2_2[var3_3 - 12] == 'r' && var2_2[var3_3 - 11] == 'e' && var2_2[var3_3 - 10] == 'g' && var2_2[var3_3 - 9] == 'i' && var2_2[var3_3 - 8] == 's' && var2_2[var3_3 - 7] == 't' && var2_2[var3_3 - 6] == 'e' && var2_2[var3_3 - 5] == 'r' && var2_2[var3_3 - 4] == 'M' && var2_2[var3_3 - 3] == 'B' && var2_2[var3_3 - 2] == 'e' && var2_2[var3_3 - 1] == 'a' && var2_2[var3_3] == 'n') {
                    var5_5 = 13;
                    var1_1 |= 8192;
                } else if (var3_3 >= 11 && var2_2[var3_3 - 11] == 'g' && var2_2[var3_3 - 10] == 'e' && var2_2[var3_3 - 9] == 't' && var2_2[var3_3 - 8] == 'A' && var2_2[var3_3 - 7] == 't' && var2_2[var3_3 - 6] == 't' && var2_2[var3_3 - 5] == 'r' && var2_2[var3_3 - 4] == 'i' && var2_2[var3_3 - 3] == 'b' && var2_2[var3_3 - 2] == 'u' && var2_2[var3_3 - 1] == 't' && var2_2[var3_3] == 'e') {
                    var5_5 = 12;
                    var1_1 |= 2;
                } else if (var3_3 >= 11 && var2_2[var3_3 - 11] == 'g' && var2_2[var3_3 - 10] == 'e' && var2_2[var3_3 - 9] == 't' && var2_2[var3_3 - 8] == 'M' && var2_2[var3_3 - 7] == 'B' && var2_2[var3_3 - 6] == 'e' && var2_2[var3_3 - 5] == 'a' && var2_2[var3_3 - 4] == 'n' && var2_2[var3_3 - 3] == 'I' && var2_2[var3_3 - 2] == 'n' && var2_2[var3_3 - 1] == 'f' && var2_2[var3_3] == 'o') {
                    var5_5 = 12;
                    var1_1 |= 64;
                } else if (var3_3 >= 11 && var2_2[var3_3 - 11] == 'i' && var2_2[var3_3 - 10] == 's' && var2_2[var3_3 - 9] == 'I' && var2_2[var3_3 - 8] == 'n' && var2_2[var3_3 - 7] == 's' && var2_2[var3_3 - 6] == 't' && var2_2[var3_3 - 5] == 'a' && var2_2[var3_3 - 4] == 'n' && var2_2[var3_3 - 3] == 'c' && var2_2[var3_3 - 2] == 'e' && var2_2[var3_3 - 1] == 'O' && var2_2[var3_3] == 'f') {
                    var5_5 = 12;
                    var1_1 |= 1024;
                } else if (var3_3 >= 11 && var2_2[var3_3 - 11] == 's' && var2_2[var3_3 - 10] == 'e' && var2_2[var3_3 - 9] == 't' && var2_2[var3_3 - 8] == 'A' && var2_2[var3_3 - 7] == 't' && var2_2[var3_3 - 6] == 't' && var2_2[var3_3 - 5] == 'r' && var2_2[var3_3 - 4] == 'i' && var2_2[var3_3 - 3] == 'b' && var2_2[var3_3 - 2] == 'u' && var2_2[var3_3 - 1] == 't' && var2_2[var3_3] == 'e') {
                    var5_5 = 12;
                    var1_1 |= 32768;
                } else if (var3_3 >= 10 && var2_2[var3_3 - 10] == 'i' && var2_2[var3_3 - 9] == 'n' && var2_2[var3_3 - 8] == 's' && var2_2[var3_3 - 7] == 't' && var2_2[var3_3 - 6] == 'a' && var2_2[var3_3 - 5] == 'n' && var2_2[var3_3 - 4] == 't' && var2_2[var3_3 - 3] == 'i' && var2_2[var3_3 - 2] == 'a' && var2_2[var3_3 - 1] == 't' && var2_2[var3_3] == 'e') {
                    var5_5 = 11;
                    var1_1 |= 256;
                } else if (var3_3 >= 10 && var2_2[var3_3 - 10] == 'q' && var2_2[var3_3 - 9] == 'u' && var2_2[var3_3 - 8] == 'e' && var2_2[var3_3 - 7] == 'r' && var2_2[var3_3 - 6] == 'y' && var2_2[var3_3 - 5] == 'M' && var2_2[var3_3 - 4] == 'B' && var2_2[var3_3 - 3] == 'e' && var2_2[var3_3 - 2] == 'a' && var2_2[var3_3 - 1] == 'n' && var2_2[var3_3] == 's') {
                    var5_5 = 11;
                    var1_1 |= 2048;
                } else if (var3_3 >= 9 && var2_2[var3_3 - 9] == 'g' && var2_2[var3_3 - 8] == 'e' && var2_2[var3_3 - 7] == 't' && var2_2[var3_3 - 6] == 'D' && var2_2[var3_3 - 5] == 'o' && var2_2[var3_3 - 4] == 'm' && var2_2[var3_3 - 3] == 'a' && var2_2[var3_3 - 2] == 'i' && var2_2[var3_3 - 1] == 'n' && var2_2[var3_3] == 's') {
                    var5_5 = 10;
                    var1_1 |= 32;
                } else if (var3_3 >= 9 && var2_2[var3_3 - 9] == 'q' && var2_2[var3_3 - 8] == 'u' && var2_2[var3_3 - 7] == 'e' && var2_2[var3_3 - 6] == 'r' && var2_2[var3_3 - 5] == 'y' && var2_2[var3_3 - 4] == 'N' && var2_2[var3_3 - 3] == 'a' && var2_2[var3_3 - 2] == 'm' && var2_2[var3_3 - 1] == 'e' && var2_2[var3_3] == 's') {
                    var5_5 = 10;
                    var1_1 |= 4096;
                } else if (var3_3 >= 5 && var2_2[var3_3 - 5] == 'i' && var2_2[var3_3 - 4] == 'n' && var2_2[var3_3 - 3] == 'v' && var2_2[var3_3 - 2] == 'o' && var2_2[var3_3 - 1] == 'k' && var2_2[var3_3] == 'e') {
                    var5_5 = 6;
                    var1_1 |= 512;
                } else {
                    throw new IllegalArgumentException("Invalid permission: " + var0);
                }
                var6_6 = false;
                while (var3_3 >= var5_5 && !var6_6) {
                    switch (var2_2[var3_3 - var5_5]) {
                        case ',': {
                            var6_6 = true;
                        }
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Invalid permission: " + var0);
                        }
                    }
                    --var3_3;
                }
                var3_3 -= var5_5;
lbl94:
                // 2 sources

            } while (var3_3 != -1);
        }
        return var1_1;
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof MBeanPermission)) {
            return false;
        }
        MBeanPermission mBeanPermission = (MBeanPermission)permission;
        if ((this.mask & 0x800) == 2048 ? ((this.mask | 0x1000) & mBeanPermission.mask) != mBeanPermission.mask : (this.mask & mBeanPermission.mask) != mBeanPermission.mask) {
            return false;
        }
        if (mBeanPermission.classNamePrefix != null) {
            if (this.classNamePrefix == null) {
                return false;
            }
            if (this.classNameExactMatch) {
                if (!mBeanPermission.classNameExactMatch) {
                    return false;
                }
                if (!mBeanPermission.classNamePrefix.equals(this.classNamePrefix)) {
                    return false;
                }
            } else if (!mBeanPermission.classNamePrefix.startsWith(this.classNamePrefix)) {
                return false;
            }
        }
        if (mBeanPermission.member != null) {
            if (this.member == null) {
                return false;
            }
            if (!this.member.equals("*") && !this.member.equals(mBeanPermission.member)) {
                return false;
            }
        }
        if (mBeanPermission.objectName != null) {
            if (this.objectName == null) {
                return false;
            }
            if (!this.objectName.apply(mBeanPermission.objectName) && !this.objectName.equals(mBeanPermission.objectName)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MBeanPermission)) {
            return false;
        }
        MBeanPermission mBeanPermission = (MBeanPermission)object;
        return this.mask == mBeanPermission.mask && this.getName().equals(mBeanPermission.getName());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.parseName();
        this.parseActions();
    }

    static {
        try {
            allObjectNames = new ObjectName("*:*");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new IllegalArgumentException("can't happen");
        }
    }
}

