/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import com.sun.jmx.trace.Trace;
import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.monitor.MonitorMBean;
import javax.management.monitor.MonitorNotification;

public abstract class Monitor
extends NotificationBroadcasterSupport
implements MonitorMBean,
MBeanRegistration {
    private List observedObjects = new ArrayList();
    private String observedAttribute = null;
    private long granularityPeriod = 10000L;
    protected static final int capacityIncrement = 16;
    protected int elementCount = 0;
    protected int alreadyNotified = 0;
    protected int[] alreadyNotifieds = new int[16];
    protected MBeanServer server = null;
    protected static final int RESET_FLAGS_ALREADY_NOTIFIED = 0;
    protected static final int OBSERVED_OBJECT_ERROR_NOTIFIED = 1;
    protected static final int OBSERVED_ATTRIBUTE_ERROR_NOTIFIED = 2;
    protected static final int OBSERVED_ATTRIBUTE_TYPE_ERROR_NOTIFIED = 4;
    protected static final int RUNTIME_ERROR_NOTIFIED = 8;
    protected String dbgTag = "Monitor";
    transient boolean isActive = false;
    transient long sequenceNumber = 0L;

    boolean isTraceOn() {
        return Trace.isSelected((int)1, (int)4);
    }

    void trace(String string, String string2, String string3) {
        Trace.send((int)1, (int)4, (String)string, (String)string2, (String)string3);
    }

    void trace(String string, String string2) {
        this.trace(this.dbgTag, string, string2);
    }

    boolean isDebugOn() {
        return Trace.isSelected((int)2, (int)4);
    }

    void debug(String string, String string2, String string3) {
        Trace.send((int)2, (int)4, (String)string, (String)string2, (String)string3);
    }

    void debug(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        if (this.isTraceOn()) {
            this.trace("preRegister", "initialize the reference on the MBean server");
        }
        this.server = mBeanServer;
        return objectName;
    }

    public void postRegister(Boolean bl) {
    }

    public void preDeregister() throws Exception {
        if (this.isTraceOn()) {
            this.trace("preDeregister", "stop the monitor");
        }
        this.stop();
    }

    public void postDeregister() {
    }

    public abstract void start();

    public abstract void stop();

    public synchronized ObjectName getObservedObject() {
        return (ObjectName)this.observedObjects.get(0);
    }

    public synchronized void setObservedObject(ObjectName objectName) throws IllegalArgumentException {
        while (!this.observedObjects.isEmpty()) {
            this.removeObservedObject((ObjectName)this.observedObjects.get(0));
        }
        this.addObservedObject(objectName);
    }

    public void addObservedObject(ObjectName objectName) throws IllegalArgumentException {
        if (objectName == null) {
            throw new IllegalArgumentException("The object to observe cannot be null.");
        }
        if (this.observedObjects.contains(objectName)) {
            return;
        }
        this.observedObjects.add(objectName);
        int n = 0;
        n &= 0xFFFFFFFE;
        n &= 0xFFFFFFFD;
        this.insertintElementAt(this.alreadyNotifieds, n &= 0xFFFFFFFB, this.elementCount);
        this.updateDeprecatedAlreadyNotified();
        this.insertSpecificElementAt(this.elementCount);
        ++this.elementCount;
    }

    public void removeObservedObject(ObjectName objectName) {
        if (this.observedObjects.contains(objectName)) {
            int n = this.observedObjects.indexOf(objectName);
            this.observedObjects.remove(objectName);
            this.removeintElementAt(this.alreadyNotifieds, n);
            this.updateDeprecatedAlreadyNotified();
            this.removeSpecificElementAt(n);
            --this.elementCount;
        }
    }

    public boolean containsObservedObject(ObjectName objectName) {
        return this.observedObjects.contains(objectName);
    }

    public ObjectName[] getObservedObjects() {
        ObjectName[] objectNameArray = new ObjectName[this.elementCount];
        int n = 0;
        while (n < this.elementCount) {
            objectNameArray[n] = (ObjectName)this.observedObjects.get(n);
            ++n;
        }
        return objectNameArray;
    }

    public synchronized String getObservedAttribute() {
        return this.observedAttribute;
    }

    public synchronized void setObservedAttribute(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("The attribute to observe cannot be null.");
        }
        this.observedAttribute = string;
        int n = 0;
        while (n < this.elementCount) {
            this.resetAlreadyNotified(n, 6);
            ++n;
        }
    }

    public synchronized long getGranularityPeriod() {
        return this.granularityPeriod;
    }

    public synchronized void setGranularityPeriod(long l) throws IllegalArgumentException {
        if (l <= 0L) {
            throw new IllegalArgumentException("The granularity period must be greater than zero.");
        }
        this.granularityPeriod = l;
    }

    public synchronized boolean isActive() {
        return this.isActive;
    }

    ObjectName getObservedObject(int n) throws ArrayIndexOutOfBoundsException {
        return (ObjectName)this.observedObjects.get(n);
    }

    void updateDeprecatedAlreadyNotified() {
        this.alreadyNotified = this.elementCount > 0 ? this.alreadyNotifieds[0] : 0;
    }

    void setAlreadyNotified(int n, int n2) {
        int n3 = n;
        this.alreadyNotifieds[n3] = this.alreadyNotifieds[n3] | n2;
        if (n == 0) {
            this.updateDeprecatedAlreadyNotified();
        }
    }

    void resetAlreadyNotified(int n, int n2) {
        int n3 = n;
        this.alreadyNotifieds[n3] = this.alreadyNotifieds[n3] & ~n2;
        if (n == 0) {
            this.updateDeprecatedAlreadyNotified();
        }
    }

    void resetAllAlreadyNotified(int n) {
        this.alreadyNotifieds[n] = 0;
        if (n == 0) {
            this.updateDeprecatedAlreadyNotified();
        }
    }

    void insertintElementAt(int[] nArray, int n, int n2) {
        this.ensureintCapacity(nArray, this.elementCount + 1);
        System.arraycopy(nArray, n2, nArray, n2 + 1, this.elementCount - n2);
        nArray[n2] = n;
    }

    void insertlongElementAt(long[] lArray, long l, int n) {
        this.ensurelongCapacity(lArray, this.elementCount + 1);
        System.arraycopy(lArray, n, lArray, n + 1, this.elementCount - n);
        lArray[n] = l;
    }

    void insertbooleanElementAt(boolean[] blArray, boolean bl, int n) {
        this.ensurebooleanCapacity(blArray, this.elementCount + 1);
        System.arraycopy(blArray, n, blArray, n + 1, this.elementCount - n);
        blArray[n] = bl;
    }

    void insertNumberElementAt(Number[] numberArray, Number number, int n) {
        this.ensureNumberCapacity(numberArray, this.elementCount + 1);
        System.arraycopy(numberArray, n, numberArray, n + 1, this.elementCount - n);
        numberArray[n] = number;
    }

    void insertStringElementAt(String[] stringArray, String string, int n) {
        this.ensureStringCapacity(stringArray, this.elementCount + 1);
        System.arraycopy(stringArray, n, stringArray, n + 1, this.elementCount - n);
        stringArray[n] = string;
    }

    void removeintElementAt(int[] nArray, int n) {
        if (n < 0 || n >= this.elementCount) {
            return;
        }
        int n2 = this.elementCount - n - 1;
        if (n2 > 0) {
            System.arraycopy(nArray, n + 1, nArray, n, n2);
        }
    }

    void removelongElementAt(long[] lArray, int n) {
        if (n < 0 || n >= this.elementCount) {
            return;
        }
        int n2 = this.elementCount - n - 1;
        if (n2 > 0) {
            System.arraycopy(lArray, n + 1, lArray, n, n2);
        }
    }

    void removebooleanElementAt(boolean[] blArray, int n) {
        if (n < 0 || n >= this.elementCount) {
            return;
        }
        int n2 = this.elementCount - n - 1;
        if (n2 > 0) {
            System.arraycopy(blArray, n + 1, blArray, n, n2);
        }
    }

    void removeNumberElementAt(Number[] numberArray, int n) {
        if (n < 0 || n >= this.elementCount) {
            return;
        }
        int n2 = this.elementCount - n - 1;
        if (n2 > 0) {
            System.arraycopy(numberArray, n + 1, numberArray, n, n2);
        }
    }

    void removeStringElementAt(String[] stringArray, int n) {
        if (n < 0 || n >= this.elementCount) {
            return;
        }
        int n2 = this.elementCount - n - 1;
        if (n2 > 0) {
            System.arraycopy(stringArray, n + 1, stringArray, n, n2);
        }
    }

    void ensureintCapacity(int[] nArray, int n) {
        int n2 = nArray.length;
        if (n > n2) {
            int[] nArray2 = nArray;
            int n3 = n2 + 16;
            if (n3 < n) {
                n3 = n;
            }
            nArray = new int[n3];
            System.arraycopy(nArray2, 0, nArray, 0, this.elementCount);
        }
    }

    void ensurelongCapacity(long[] lArray, int n) {
        int n2 = lArray.length;
        if (n > n2) {
            long[] lArray2 = lArray;
            int n3 = n2 + 16;
            if (n3 < n) {
                n3 = n;
            }
            lArray = new long[n3];
            System.arraycopy(lArray2, 0, lArray, 0, this.elementCount);
        }
    }

    void ensurebooleanCapacity(boolean[] blArray, int n) {
        int n2 = blArray.length;
        if (n > n2) {
            boolean[] blArray2 = blArray;
            int n3 = n2 + 16;
            if (n3 < n) {
                n3 = n;
            }
            blArray = new boolean[n3];
            System.arraycopy(blArray2, 0, blArray, 0, this.elementCount);
        }
    }

    void ensureNumberCapacity(Number[] numberArray, int n) {
        int n2 = numberArray.length;
        if (n > n2) {
            Number[] numberArray2 = numberArray;
            int n3 = n2 + 16;
            if (n3 < n) {
                n3 = n;
            }
            numberArray = new Number[n3];
            System.arraycopy(numberArray2, 0, numberArray, 0, this.elementCount);
        }
    }

    void ensureStringCapacity(String[] stringArray, int n) {
        int n2 = stringArray.length;
        if (n > n2) {
            String[] stringArray2 = stringArray;
            int n3 = n2 + 16;
            if (n3 < n) {
                n3 = n;
            }
            stringArray = new String[n3];
            System.arraycopy(stringArray2, 0, stringArray, 0, this.elementCount);
        }
    }

    int indexOf(ObjectName objectName) {
        return this.observedObjects.indexOf(objectName);
    }

    abstract void insertSpecificElementAt(int var1);

    abstract void removeSpecificElementAt(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendNotification(String string, long l, String string2, Object object, Object object2, int n) {
        MonitorNotification monitorNotification = null;
        Monitor monitor = this;
        synchronized (monitor) {
            ++this.sequenceNumber;
            if (this.isTraceOn()) {
                this.trace("sendNotification", "send notification:\n\tNotification observed object = " + this.getObservedObject(n) + "\n\tNotification observed attribute = " + this.observedAttribute + "\n\tNotification derived gauge = " + object);
            }
            monitorNotification = new MonitorNotification(string, this, this.sequenceNumber, l, string2, this.getObservedObject(n), this.observedAttribute, object, object2);
        }
        this.sendNotification(monitorNotification);
    }
}

