/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.monitor.Monitor;
import javax.management.monitor.MonitorNotification;
import javax.management.monitor.MonitorSettingException;
import javax.management.monitor.StringMonitorMBean;

public class StringMonitor
extends Monitor
implements StringMonitorMBean {
    private static final String[] types = new String[]{MonitorNotification.RUNTIME_ERROR, MonitorNotification.OBSERVED_OBJECT_ERROR, MonitorNotification.OBSERVED_ATTRIBUTE_ERROR, MonitorNotification.OBSERVED_ATTRIBUTE_TYPE_ERROR, MonitorNotification.STRING_TO_COMPARE_VALUE_MATCHED, MonitorNotification.STRING_TO_COMPARE_VALUE_DIFFERED};
    private static final MBeanNotificationInfo[] notifsInfo = new MBeanNotificationInfo[]{new MBeanNotificationInfo(types, "javax.management.monitor.MonitorNotification", "Notifications sent by the StringMonitor MBean")};
    private String stringToCompare = "";
    private boolean notifyMatch = false;
    private boolean notifyDiffer = false;
    private transient String[] derivedGauge = new String[16];
    private transient long[] derivedGaugeTimestamp = new long[16];
    private transient int[] status = new int[16];
    private static final int MATCHING = 0;
    private static final int DIFFERING = 1;
    private static final int MATCHING_OR_DIFFERING = 2;
    private transient Timer timer = null;

    String makeDebugTag() {
        return "StringMonitor";
    }

    public StringMonitor() {
        this.dbgTag = this.makeDebugTag();
    }

    public synchronized void start() {
        if (this.isTraceOn()) {
            this.trace("start", "start the string monitor");
        }
        if (!this.isActive()) {
            this.isActive = true;
            int n = 0;
            while (n < this.elementCount) {
                this.status[n] = 2;
                ++n;
            }
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new StringAlarmClock(this), this.getGranularityPeriod(), this.getGranularityPeriod());
        } else if (this.isTraceOn()) {
            this.trace("start", "the string monitor is already activated");
        }
    }

    public void stop() {
        if (this.isTraceOn()) {
            this.trace("stop", "stop the string monitor");
        }
        if (this.isActive()) {
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
            this.isActive = false;
        } else if (this.isTraceOn()) {
            this.trace("stop", "the string monitor is already deactivated");
        }
    }

    public synchronized void setGranularityPeriod(long l) throws IllegalArgumentException {
        super.setGranularityPeriod(l);
        if (this.isActive()) {
            this.timer.cancel();
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new StringAlarmClock(this), this.getGranularityPeriod(), this.getGranularityPeriod());
        }
    }

    public String getDerivedGauge(ObjectName objectName) {
        int n = this.indexOf(objectName);
        if (n != -1) {
            return this.derivedGauge[n];
        }
        return null;
    }

    public long getDerivedGaugeTimeStamp(ObjectName objectName) {
        int n = this.indexOf(objectName);
        if (n != -1) {
            return this.derivedGaugeTimestamp[n];
        }
        return 0L;
    }

    public synchronized String getDerivedGauge() {
        return this.derivedGauge[0];
    }

    public synchronized long getDerivedGaugeTimeStamp() {
        return this.derivedGaugeTimestamp[0];
    }

    public synchronized String getStringToCompare() {
        return this.stringToCompare;
    }

    public synchronized void setStringToCompare(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("The string to compare cannot be null.");
        }
        this.stringToCompare = string;
        int n = 0;
        while (n < this.elementCount) {
            this.status[n] = 2;
            ++n;
        }
    }

    public synchronized boolean getNotifyMatch() {
        return this.notifyMatch;
    }

    public synchronized void setNotifyMatch(boolean bl) {
        this.notifyMatch = bl;
    }

    public synchronized boolean getNotifyDiffer() {
        return this.notifyDiffer;
    }

    public synchronized void setNotifyDiffer(boolean bl) {
        this.notifyDiffer = bl;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return notifsInfo;
    }

    private void updateDerivedGauge(Object object, int n) {
        this.derivedGaugeTimestamp[n] = new Date().getTime();
        this.derivedGauge[n] = (String)object;
    }

    private void updateNotifications(int n) {
        if (this.status[n] == 2) {
            if (this.derivedGauge[n].equals(this.stringToCompare)) {
                if (this.notifyMatch) {
                    this.sendNotification(MonitorNotification.STRING_TO_COMPARE_VALUE_MATCHED, this.derivedGaugeTimestamp[n], "", this.derivedGauge[n], this.stringToCompare, n);
                }
                this.status[n] = 1;
            } else {
                if (this.notifyDiffer) {
                    this.sendNotification(MonitorNotification.STRING_TO_COMPARE_VALUE_DIFFERED, this.derivedGaugeTimestamp[n], "", this.derivedGauge[n], this.stringToCompare, n);
                }
                this.status[n] = 0;
            }
        } else if (this.status[n] == 0) {
            if (this.derivedGauge[n].equals(this.stringToCompare)) {
                if (this.notifyMatch) {
                    this.sendNotification(MonitorNotification.STRING_TO_COMPARE_VALUE_MATCHED, this.derivedGaugeTimestamp[n], "", this.derivedGauge[n], this.stringToCompare, n);
                }
                this.status[n] = 1;
            }
        } else if (this.status[n] == 1 && !this.derivedGauge[n].equals(this.stringToCompare)) {
            if (this.notifyDiffer) {
                this.sendNotification(MonitorNotification.STRING_TO_COMPARE_VALUE_DIFFERED, this.derivedGaugeTimestamp[n], "", this.derivedGauge[n], this.stringToCompare, n);
            }
            this.status[n] = 0;
        }
    }

    void notifyAlarmClock(int n) {
        block17: {
            Object object = null;
            String string = null;
            try {
                if (!this.isActive()) break block17;
                if (this.getObservedObject(n) == null || this.getObservedAttribute() == null) {
                    return;
                }
                try {
                    object = this.server.getAttribute(this.getObservedObject(n), this.getObservedAttribute());
                    if (object == null) {
                        return;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    if ((this.alreadyNotifieds[n] & 8) != 0) {
                        return;
                    }
                    string = MonitorNotification.RUNTIME_ERROR;
                    this.setAlreadyNotified(n, 8);
                    throw new MonitorSettingException("The string monitor must be registered in the MBean server.");
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    if ((this.alreadyNotifieds[n] & 1) != 0) {
                        return;
                    }
                    string = MonitorNotification.OBSERVED_OBJECT_ERROR;
                    this.setAlreadyNotified(n, 1);
                    throw new MonitorSettingException("The observed object must be registered in the MBean server.");
                }
                catch (AttributeNotFoundException attributeNotFoundException) {
                    if ((this.alreadyNotifieds[n] & 2) != 0) {
                        return;
                    }
                    string = MonitorNotification.OBSERVED_ATTRIBUTE_ERROR;
                    this.setAlreadyNotified(n, 2);
                    throw new MonitorSettingException("The observed attribute must be accessible in the observed object.");
                }
                catch (MBeanException mBeanException) {
                    if ((this.alreadyNotifieds[n] & 8) != 0) {
                        return;
                    }
                    string = MonitorNotification.RUNTIME_ERROR;
                    this.setAlreadyNotified(n, 8);
                    throw new MonitorSettingException(mBeanException.getMessage());
                }
                catch (ReflectionException reflectionException) {
                    if ((this.alreadyNotifieds[n] & 2) != 0) {
                        return;
                    }
                    string = MonitorNotification.OBSERVED_ATTRIBUTE_ERROR;
                    this.setAlreadyNotified(n, 2);
                    throw new MonitorSettingException(reflectionException.getMessage());
                }
                if (!(object instanceof String)) {
                    if ((this.alreadyNotifieds[n] & 4) != 0) {
                        return;
                    }
                    string = MonitorNotification.OBSERVED_ATTRIBUTE_TYPE_ERROR;
                    this.setAlreadyNotified(n, 4);
                    throw new MonitorSettingException("The observed attribute type must be a string type.");
                }
                this.resetAllAlreadyNotified(n);
                this.updateDerivedGauge(object, n);
                this.updateNotifications(n);
            }
            catch (MonitorSettingException monitorSettingException) {
                this.sendNotification(string, this.derivedGaugeTimestamp[n], monitorSettingException.getMessage(), this.derivedGauge[n], null, n);
                this.status[n] = 2;
            }
        }
    }

    void insertSpecificElementAt(int n) {
        this.insertStringElementAt(this.derivedGauge, "", n);
        this.insertlongElementAt(this.derivedGaugeTimestamp, new Date().getTime(), n);
        this.insertintElementAt(this.status, 2, n);
    }

    void removeSpecificElementAt(int n) {
        this.removeStringElementAt(this.derivedGauge, n);
        this.removelongElementAt(this.derivedGaugeTimestamp, n);
        this.removeintElementAt(this.status, n);
    }

    private static class StringAlarmClock
    extends TimerTask {
        StringMonitor listener = null;

        public StringAlarmClock(StringMonitor stringMonitor) {
            this.listener = stringMonitor;
        }

        public void run() {
            if (this.listener.isActive()) {
                int n = 0;
                while (n < this.listener.elementCount) {
                    this.listener.notifyAlarmClock(n);
                    ++n;
                }
            }
        }
    }
}

