/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import com.sun.jmx.trace.Trace;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.relation.InvalidRoleValueException;
import javax.management.relation.RelationNotFoundException;
import javax.management.relation.RelationService;
import javax.management.relation.RelationServiceNotRegisteredException;
import javax.management.relation.RelationSupportMBean;
import javax.management.relation.RelationTypeNotFoundException;
import javax.management.relation.Role;
import javax.management.relation.RoleList;
import javax.management.relation.RoleNotFoundException;
import javax.management.relation.RoleResult;
import javax.management.relation.RoleUnresolved;
import javax.management.relation.RoleUnresolvedList;

public class RelationSupport
implements RelationSupportMBean,
MBeanRegistration {
    private String myRelId = null;
    private ObjectName myRelServiceName = null;
    private MBeanServer myRelServiceMBeanServer = null;
    private String myRelTypeName = null;
    private HashMap myRoleName2ValueMap = new HashMap();
    private Boolean myInRelServFlg = null;
    private static String localClassName = "RelationSupport";

    public RelationSupport(String string, ObjectName objectName, String string2, RoleList roleList) throws InvalidRoleValueException, IllegalArgumentException {
        if (this.isTraceOn()) {
            this.trace("Constructor: entering", null);
        }
        this.initMembers(string, objectName, null, string2, roleList);
        if (this.isTraceOn()) {
            this.trace("Constructor: exiting", null);
        }
    }

    public RelationSupport(String string, ObjectName objectName, MBeanServer mBeanServer, String string2, RoleList roleList) throws InvalidRoleValueException, IllegalArgumentException {
        if (mBeanServer == null) {
            String string3 = "Invalid parameter.";
            throw new IllegalArgumentException(string3);
        }
        if (this.isTraceOn()) {
            this.trace("Constructor: entering", null);
        }
        this.initMembers(string, objectName, mBeanServer, string2, roleList);
        if (this.isTraceOn()) {
            this.trace("Constructor: exiting", null);
        }
    }

    public List getRole(String string) throws IllegalArgumentException, RoleNotFoundException, RelationServiceNotRegisteredException {
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isTraceOn()) {
            this.trace("getRole: entering", string);
        }
        ArrayList arrayList = (ArrayList)this.getRoleInt(string, false, null, false);
        if (this.isTraceOn()) {
            this.trace("getRole: exiting", null);
        }
        return arrayList;
    }

    public RoleResult getRoles(String[] stringArray) throws IllegalArgumentException, RelationServiceNotRegisteredException {
        if (stringArray == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        if (this.isTraceOn()) {
            this.trace("getRoles: entering", null);
        }
        RoleResult roleResult = this.getRolesInt(stringArray, false, null);
        if (this.isTraceOn()) {
            this.trace("getRoles: exiting", null);
        }
        return roleResult;
    }

    public RoleResult getAllRoles() throws RelationServiceNotRegisteredException {
        if (this.isTraceOn()) {
            this.trace("getAllRoles: entering", null);
        }
        RoleResult roleResult = null;
        try {
            roleResult = this.getAllRolesInt(false, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (this.isTraceOn()) {
            this.trace("getAllRoles: exiting", null);
        }
        return roleResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RoleList retrieveAllRoles() {
        if (this.isTraceOn()) {
            this.trace("retrieveAllRoles: entering", null);
        }
        RoleList roleList = null;
        HashMap hashMap = this.myRoleName2ValueMap;
        synchronized (hashMap) {
            roleList = new RoleList(new ArrayList(this.myRoleName2ValueMap.values()));
        }
        if (this.isTraceOn()) {
            this.trace("retrieveAllRoles: exiting", null);
        }
        return roleList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getRoleCardinality(String string) throws IllegalArgumentException, RoleNotFoundException {
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isTraceOn()) {
            this.trace("getRoleCardinality: entering", string);
        }
        Role role = null;
        HashMap hashMap = this.myRoleName2ValueMap;
        synchronized (hashMap) {
            role = (Role)this.myRoleName2ValueMap.get(string);
        }
        if (role == null) {
            int n = 1;
            try {
                RelationService.throwRoleProblemException(n, string);
            }
            catch (InvalidRoleValueException invalidRoleValueException) {
                // empty catch block
            }
        }
        ArrayList arrayList = (ArrayList)role.getRoleValue();
        if (this.isTraceOn()) {
            this.trace("getRoleCardinality: exiting", null);
        }
        return new Integer(arrayList.size());
    }

    public void setRole(Role role) throws IllegalArgumentException, RoleNotFoundException, RelationTypeNotFoundException, InvalidRoleValueException, RelationServiceNotRegisteredException, RelationNotFoundException {
        if (role == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        if (this.isTraceOn()) {
            this.trace("setRole: entering", role.toString());
        }
        Object object = this.setRoleInt(role, false, null, false);
        if (this.isTraceOn()) {
            this.trace("setRole: exiting", null);
        }
    }

    public RoleResult setRoles(RoleList roleList) throws IllegalArgumentException, RelationServiceNotRegisteredException, RelationTypeNotFoundException, RelationNotFoundException {
        if (roleList == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        if (this.isTraceOn()) {
            this.trace("setRoles: entering", roleList.toString());
        }
        RoleResult roleResult = this.setRolesInt(roleList, false, null);
        if (this.isTraceOn()) {
            this.trace("setRoles: exiting", null);
        }
        return roleResult;
    }

    public void handleMBeanUnregistration(ObjectName objectName, String string) throws IllegalArgumentException, RoleNotFoundException, InvalidRoleValueException, RelationServiceNotRegisteredException, RelationTypeNotFoundException, RelationNotFoundException {
        if (objectName == null || string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isTraceOn()) {
            this.trace("handleMBeanUnregistration: entering", "theObjName " + objectName + ", theRoleName " + string);
        }
        this.handleMBeanUnregistrationInt(objectName, string, false, null);
        if (this.isTraceOn()) {
            this.trace("handleMBeanUnregistration: exiting", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getReferencedMBeans() {
        if (this.isTraceOn()) {
            this.trace("getReferencedMBeans: entering", null);
        }
        HashMap<ObjectName, ArrayList<String>> hashMap = new HashMap<ObjectName, ArrayList<String>>();
        HashMap hashMap2 = this.myRoleName2ValueMap;
        synchronized (hashMap2) {
            Iterator iterator = this.myRoleName2ValueMap.values().iterator();
            while (iterator.hasNext()) {
                Role role = (Role)iterator.next();
                String string = role.getRoleName();
                ArrayList arrayList = (ArrayList)role.getRoleValue();
                Iterator iterator2 = arrayList.iterator();
                while (iterator2.hasNext()) {
                    ObjectName objectName = (ObjectName)iterator2.next();
                    ArrayList<String> arrayList2 = (ArrayList<String>)hashMap.get(objectName);
                    boolean bl = false;
                    if (arrayList2 == null) {
                        bl = true;
                        arrayList2 = new ArrayList<String>();
                    }
                    arrayList2.add(string);
                    if (!bl) continue;
                    hashMap.put(objectName, arrayList2);
                }
            }
        }
        if (this.isTraceOn()) {
            this.trace("getReferencedMBeans: exiting", null);
        }
        return hashMap;
    }

    public String getRelationTypeName() {
        return this.myRelTypeName;
    }

    public ObjectName getRelationServiceName() {
        return this.myRelServiceName;
    }

    public String getRelationId() {
        return this.myRelId;
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        this.myRelServiceMBeanServer = mBeanServer;
        return objectName;
    }

    public void postRegister(Boolean bl) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean isInRelationService() {
        Boolean bl = null;
        Boolean bl2 = this.myInRelServFlg;
        synchronized (bl2) {
            bl = new Boolean(this.myInRelServFlg);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRelationServiceManagementFlag(Boolean bl) throws IllegalArgumentException {
        if (bl == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        Boolean bl2 = this.myInRelServFlg;
        synchronized (bl2) {
            this.myInRelServFlg = new Boolean(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getRoleInt(String string, boolean bl, RelationService relationService, boolean bl2) throws IllegalArgumentException, RoleNotFoundException, RelationServiceNotRegisteredException {
        Serializable serializable;
        if (string == null || bl && relationService == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isDebugOn()) {
            String string3 = "theRoleName " + string;
            this.debug("getRoleInt: entering", string3);
        }
        int n = 0;
        Role role = null;
        HashMap hashMap = this.myRoleName2ValueMap;
        synchronized (hashMap) {
            role = (Role)this.myRoleName2ValueMap.get(string);
        }
        if (role == null) {
            n = 1;
        } else {
            serializable = null;
            if (bl) {
                try {
                    serializable = relationService.checkRoleReading(string, this.myRelTypeName);
                }
                catch (RelationTypeNotFoundException relationTypeNotFoundException) {
                    throw new RuntimeException(relationTypeNotFoundException.getMessage());
                }
            }
            Object[] objectArray = new Object[]{string, this.myRelTypeName};
            String[] stringArray = new String[]{"java.lang.String", "java.lang.String"};
            try {
                serializable = (Integer)this.myRelServiceMBeanServer.invoke(this.myRelServiceName, "checkRoleReading", objectArray, stringArray);
            }
            catch (MBeanException mBeanException) {
                throw new RuntimeException("incorrect relation type");
            }
            catch (ReflectionException reflectionException) {
                throw new RuntimeException(reflectionException.getMessage());
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                throw new RelationServiceNotRegisteredException(instanceNotFoundException.getMessage());
            }
            n = (Integer)serializable;
        }
        serializable = null;
        if (n == 0) {
            serializable = !bl2 ? (ArrayList)((ArrayList)role.getRoleValue()).clone() : (Role)role.clone();
        } else {
            if (!bl2) {
                try {
                    RelationService.throwRoleProblemException(n, string);
                    return null;
                }
                catch (InvalidRoleValueException invalidRoleValueException) {
                    throw new RuntimeException(invalidRoleValueException.getMessage());
                }
            }
            serializable = new RoleUnresolved(string, null, n);
        }
        if (this.isDebugOn()) {
            this.debug("getRoleInt: exiting", null);
        }
        return serializable;
    }

    RoleResult getRolesInt(String[] stringArray, boolean bl, RelationService relationService) throws IllegalArgumentException, RelationServiceNotRegisteredException {
        Object object;
        if (stringArray == null || bl && relationService == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        if (this.isDebugOn()) {
            this.debug("getRolesInt: entering", null);
        }
        RoleList roleList = new RoleList();
        RoleUnresolvedList roleUnresolvedList = new RoleUnresolvedList();
        int n = 0;
        while (n < stringArray.length) {
            object = stringArray[n];
            Object object2 = null;
            try {
                object2 = this.getRoleInt((String)object, bl, relationService, true);
            }
            catch (RoleNotFoundException roleNotFoundException) {
                return null;
            }
            if (object2 instanceof Role) {
                try {
                    roleList.add((Role)object2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new RuntimeException(illegalArgumentException.getMessage());
                }
            }
            if (object2 instanceof RoleUnresolved) {
                try {
                    roleUnresolvedList.add((RoleUnresolved)object2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new RuntimeException(illegalArgumentException.getMessage());
                }
            }
            ++n;
        }
        object = new RoleResult(roleList, roleUnresolvedList);
        if (this.isDebugOn()) {
            this.debug("getRolesInt: exiting", null);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RoleResult getAllRolesInt(boolean bl, RelationService relationService) throws IllegalArgumentException, RelationServiceNotRegisteredException {
        Object object;
        if (bl && relationService == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        if (this.isDebugOn()) {
            this.debug("getAllRolesInt: entering", null);
        }
        ArrayList arrayList = null;
        HashMap hashMap = this.myRoleName2ValueMap;
        synchronized (hashMap) {
            arrayList = new ArrayList(this.myRoleName2ValueMap.keySet());
        }
        String[] stringArray = new String[arrayList.size()];
        int n = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            stringArray[n] = object = (String)iterator.next();
            ++n;
        }
        object = this.getRolesInt(stringArray, bl, relationService);
        if (this.isDebugOn()) {
            this.debug("getAllRolesInt: exiting", null);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object setRoleInt(Role role, boolean bl, RelationService relationService, boolean bl2) throws IllegalArgumentException, RoleNotFoundException, InvalidRoleValueException, RelationServiceNotRegisteredException, RelationTypeNotFoundException, RelationNotFoundException {
        Object[] objectArray;
        Serializable serializable;
        String string;
        if (role == null || bl && relationService == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isDebugOn()) {
            string = "theRole " + role + ", theRelServCallFlg " + bl + ", theMultiRoleFlg " + bl2;
            this.debug("setRoleInt: entering", string);
        }
        string = role.getRoleName();
        int n = 0;
        Role role2 = null;
        HashMap hashMap = this.myRoleName2ValueMap;
        synchronized (hashMap) {
            role2 = (Role)this.myRoleName2ValueMap.get(string);
        }
        ArrayList arrayList = null;
        Boolean bl3 = null;
        if (role2 == null) {
            bl3 = new Boolean(true);
            arrayList = new ArrayList();
        } else {
            bl3 = new Boolean(false);
            arrayList = (ArrayList)role2.getRoleValue();
        }
        try {
            serializable = null;
            if (bl) {
                serializable = relationService.checkRoleWriting(role, this.myRelTypeName, bl3);
            } else {
                objectArray = new Object[]{role, this.myRelTypeName, bl3};
                String[] stringArray = new String[]{"javax.management.relation.Role", "java.lang.String", "java.lang.Boolean"};
                serializable = (Integer)this.myRelServiceMBeanServer.invoke(this.myRelServiceName, "checkRoleWriting", objectArray, stringArray);
            }
            n = serializable;
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof RelationTypeNotFoundException) {
                throw (RelationTypeNotFoundException)exception;
            }
            throw new RuntimeException(exception.getMessage());
        }
        catch (ReflectionException reflectionException) {
            throw new RuntimeException(reflectionException.getMessage());
        }
        catch (RelationTypeNotFoundException relationTypeNotFoundException) {
            throw new RuntimeException(relationTypeNotFoundException.getMessage());
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new RelationServiceNotRegisteredException(instanceNotFoundException.getMessage());
        }
        serializable = null;
        if (n == 0) {
            if (!bl3.booleanValue()) {
                this.sendRoleUpdateNotification(role, arrayList, bl, relationService);
                this.updateRelationServiceMap(role, arrayList, bl, relationService);
            }
            objectArray = this.myRoleName2ValueMap;
            synchronized (objectArray) {
                this.myRoleName2ValueMap.put(string, (Role)role.clone());
            }
            if (bl2) {
                serializable = role;
            }
        } else {
            if (!bl2) {
                RelationService.throwRoleProblemException(n, string);
                return null;
            }
            serializable = new RoleUnresolved(string, role.getRoleValue(), n);
        }
        if (this.isDebugOn()) {
            this.debug("setRoleInt: exiting", null);
        }
        return serializable;
    }

    private void sendRoleUpdateNotification(Role role, List list, boolean bl, RelationService relationService) throws IllegalArgumentException, RelationServiceNotRegisteredException, RelationNotFoundException {
        Object[] objectArray;
        if (role == null || list == null || bl && relationService == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        if (this.isDebugOn()) {
            objectArray = "theNewRole " + role + ", theOldRoleValue " + list + ", theRelServCallFlg " + bl;
            this.debug("sendRoleUpdateNotification: entering", (String)objectArray);
        }
        if (bl) {
            try {
                relationService.sendRoleUpdateNotification(this.myRelId, role, list);
            }
            catch (RelationNotFoundException relationNotFoundException) {
                throw new RuntimeException(relationNotFoundException.getMessage());
            }
        }
        objectArray = new Object[]{this.myRelId, role, (ArrayList)list};
        String[] stringArray = new String[]{"java.lang.String", "javax.management.relation.Role", "java.util.List"};
        try {
            this.myRelServiceMBeanServer.invoke(this.myRelServiceName, "sendRoleUpdateNotification", objectArray, stringArray);
        }
        catch (ReflectionException reflectionException) {
            throw new RuntimeException(reflectionException.getMessage());
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new RelationServiceNotRegisteredException(instanceNotFoundException.getMessage());
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof RelationNotFoundException) {
                throw (RelationNotFoundException)exception;
            }
            throw new RuntimeException(exception.getMessage());
        }
        if (this.isDebugOn()) {
            this.debug("sendRoleUpdateNotification: exiting", null);
        }
    }

    private void updateRelationServiceMap(Role role, List list, boolean bl, RelationService relationService) throws IllegalArgumentException, RelationServiceNotRegisteredException, RelationNotFoundException {
        Object[] objectArray;
        if (role == null || list == null || bl && relationService == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        if (this.isDebugOn()) {
            objectArray = "theNewRole " + role + ", theOldRoleValue " + list + ", theRelServCallFlg " + bl;
            this.debug("updateRelationServiceMap: entering", (String)objectArray);
        }
        if (bl) {
            try {
                relationService.updateRoleMap(this.myRelId, role, list);
            }
            catch (RelationNotFoundException relationNotFoundException) {
                throw new RuntimeException(relationNotFoundException.getMessage());
            }
        }
        objectArray = new Object[]{this.myRelId, role, list};
        String[] stringArray = new String[]{"java.lang.String", "javax.management.relation.Role", "java.util.List"};
        try {
            this.myRelServiceMBeanServer.invoke(this.myRelServiceName, "updateRoleMap", objectArray, stringArray);
        }
        catch (ReflectionException reflectionException) {
            throw new RuntimeException(reflectionException.getMessage());
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new RelationServiceNotRegisteredException(instanceNotFoundException.getMessage());
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof RelationNotFoundException) {
                throw (RelationNotFoundException)exception;
            }
            throw new RuntimeException(exception.getMessage());
        }
        if (this.isDebugOn()) {
            this.debug("updateRelationServiceMap: exiting", null);
        }
    }

    RoleResult setRolesInt(RoleList roleList, boolean bl, RelationService relationService) throws IllegalArgumentException, RelationServiceNotRegisteredException, RelationTypeNotFoundException, RelationNotFoundException {
        Serializable serializable;
        Object object;
        if (roleList == null || bl && relationService == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        if (this.isDebugOn()) {
            object = "theRoleList " + roleList + ", theRelServCallFlg " + bl;
            this.debug("setRolesInt: entering", (String)object);
        }
        object = new RoleList();
        RoleUnresolvedList roleUnresolvedList = new RoleUnresolvedList();
        Iterator iterator = roleList.iterator();
        while (iterator.hasNext()) {
            serializable = (Role)iterator.next();
            Object object2 = null;
            try {
                object2 = this.setRoleInt((Role)serializable, bl, relationService, true);
            }
            catch (RoleNotFoundException roleNotFoundException) {
            }
            catch (InvalidRoleValueException invalidRoleValueException) {
                // empty catch block
            }
            if (object2 instanceof Role) {
                try {
                    ((RoleList)object).add((Role)object2);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new RuntimeException(illegalArgumentException.getMessage());
                }
            }
            if (!(object2 instanceof RoleUnresolved)) continue;
            try {
                roleUnresolvedList.add((RoleUnresolved)object2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException(illegalArgumentException.getMessage());
            }
        }
        serializable = new RoleResult((RoleList)object, roleUnresolvedList);
        if (this.isDebugOn()) {
            this.debug("setRolesInt: exiting", null);
        }
        return serializable;
    }

    private void initMembers(String string, ObjectName objectName, MBeanServer mBeanServer, String string2, RoleList roleList) throws InvalidRoleValueException, IllegalArgumentException {
        if (string == null || objectName == null || string2 == null) {
            String string3 = "Invalid parameter.";
            throw new IllegalArgumentException(string3);
        }
        if (this.isDebugOn()) {
            StringBuffer stringBuffer = new StringBuffer("theRelId " + string + ", theRelServiceName " + objectName.toString() + ", theRelTypeName " + string2);
            if (roleList != null) {
                stringBuffer.append(", theRoleList " + roleList.toString());
            }
            this.debug("initMembers: entering", stringBuffer.toString());
        }
        this.myRelId = string;
        this.myRelServiceName = objectName;
        this.myRelServiceMBeanServer = mBeanServer;
        this.myRelTypeName = string2;
        this.initRoleMap(roleList);
        this.myInRelServFlg = new Boolean(false);
        if (this.isDebugOn()) {
            this.debug("initMembers: exiting", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRoleMap(RoleList roleList) throws InvalidRoleValueException {
        if (roleList == null) {
            return;
        }
        if (this.isDebugOn()) {
            this.debug("initRoleMap: entering", roleList.toString());
        }
        HashMap hashMap = this.myRoleName2ValueMap;
        synchronized (hashMap) {
            Iterator iterator = roleList.iterator();
            while (iterator.hasNext()) {
                Role role = (Role)iterator.next();
                String string = role.getRoleName();
                if (this.myRoleName2ValueMap.containsKey(string)) {
                    StringBuffer stringBuffer = new StringBuffer("Role name ");
                    stringBuffer.append(string);
                    stringBuffer.append(" used for two roles.");
                    throw new InvalidRoleValueException(stringBuffer.toString());
                }
                this.myRoleName2ValueMap.put(string, (Role)role.clone());
            }
        }
        if (this.isDebugOn()) {
            this.debug("initRoleMap: exiting", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleMBeanUnregistrationInt(ObjectName objectName, String string, boolean bl, RelationService relationService) throws IllegalArgumentException, RoleNotFoundException, InvalidRoleValueException, RelationServiceNotRegisteredException, RelationTypeNotFoundException, RelationNotFoundException {
        Object object;
        if (objectName == null || string == null || bl && relationService == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (this.isDebugOn()) {
            object = "theObjName " + objectName + ", theRoleName " + string + ", theRelServCallFlg " + bl;
            this.debug("handleMBeanUnregistrationInt: entering", (String)object);
        }
        object = null;
        HashMap hashMap = this.myRoleName2ValueMap;
        synchronized (hashMap) {
            object = (Role)this.myRoleName2ValueMap.get(string);
        }
        if (object == null) {
            StringBuffer stringBuffer = new StringBuffer();
            String string3 = "No role with name ";
            stringBuffer.append(string3);
            stringBuffer.append(string);
            throw new RoleNotFoundException(stringBuffer.toString());
        }
        ArrayList arrayList = (ArrayList)((Role)object).getRoleValue();
        ArrayList arrayList2 = (ArrayList)arrayList.clone();
        arrayList2.remove(objectName);
        Role role = new Role(string, arrayList2);
        Object object2 = this.setRoleInt(role, bl, relationService, false);
        if (this.isDebugOn()) {
            this.debug("handleMBeanUnregistrationInt: exiting", null);
        }
    }

    private boolean isTraceOn() {
        return Trace.isSelected((int)1, (int)64);
    }

    private void trace(String string, String string2) {
        Trace.send((int)1, (int)64, (String)localClassName, (String)string, (String)string2);
        Trace.send((int)1, (int)64, (String)"", (String)"", (String)"\n");
    }

    private boolean isDebugOn() {
        return Trace.isSelected((int)2, (int)64);
    }

    private void debug(String string, String string2) {
        Trace.send((int)2, (int)64, (String)localClassName, (String)string, (String)string2);
        Trace.send((int)2, (int)64, (String)"", (String)"", (String)"\n");
    }
}

