/*
 * Decompiled with CFR 0.152.
 */
package javax.security.jacc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.Permission;
import java.util.HashMap;

public final class EJBMethodPermission
extends Permission
implements Serializable {
    private static final String[] interfaceKeys = new String[]{"Local", "LocalHome", "Remote", "Home", "ServiceEndpoint"};
    private static HashMap interfaceHash = new HashMap();
    private transient int methodInterface;
    private transient String methodName;
    private transient String methodParams;
    private transient String actions;
    private transient int hashCodeValue = 0;
    private static final long serialVersionUID = 1L;
    private static final ObjectStreamField[] serialPersistentFields;
    static /* synthetic */ Class class$java$lang$String;

    public EJBMethodPermission(String name, String actions2) {
        super(name);
        this.setMethodSpec(actions2);
    }

    public EJBMethodPermission(String EJBName, String methodName, String methodInterface, String[] methodParams) {
        super(EJBName);
        this.setMethodSpec(methodName, methodInterface, methodParams);
    }

    public EJBMethodPermission(String EJBName, String methodInterface, Method method) {
        super(EJBName);
        this.setMethodSpec(methodInterface, method);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof EJBMethodPermission)) {
            return false;
        }
        EJBMethodPermission that = (EJBMethodPermission)o;
        if (!this.getName().equals(that.getName())) {
            return false;
        }
        if (this.methodName != null ? that.methodName == null || !this.methodName.equals(that.methodName) : that.methodName != null) {
            return false;
        }
        if (this.methodInterface != that.methodInterface) {
            return false;
        }
        return !(this.methodParams != null ? that.methodParams == null || !this.methodParams.equals(that.methodParams) : that.methodParams != null);
    }

    public String getActions() {
        if (this.actions == null) {
            if (this.methodName == null) {
                if (this.methodInterface < 0) {
                    if (this.methodParams != null) {
                        this.actions = "," + this.methodParams;
                    }
                } else {
                    this.actions = this.methodParams == null ? "," + interfaceKeys[this.methodInterface] : "," + interfaceKeys[this.methodInterface] + this.methodParams;
                }
            } else {
                this.actions = this.methodInterface < 0 ? (this.methodParams == null ? this.methodName : this.methodName + "," + this.methodParams) : (this.methodParams == null ? this.methodName + "," + interfaceKeys[this.methodInterface] : this.methodName + "," + interfaceKeys[this.methodInterface] + this.methodParams);
            }
        }
        return this.actions;
    }

    public int hashCode() {
        if (this.hashCodeValue == 0) {
            String actions2 = this.getActions();
            String hashInput = actions2 == null ? this.getName() : new String(this.getName() + " " + actions2);
            this.hashCodeValue = hashInput.hashCode();
        }
        return this.hashCodeValue;
    }

    public boolean implies(Permission permission) {
        if (permission == null || !(permission instanceof EJBMethodPermission)) {
            return false;
        }
        EJBMethodPermission that = (EJBMethodPermission)permission;
        if (!this.getName().equals(that.getName())) {
            return false;
        }
        if (!(this.methodName == null || that.methodName != null && this.methodName.equals(that.methodName))) {
            return false;
        }
        if (this.methodInterface != -1 && (that.methodInterface == -1 || this.methodInterface != that.methodInterface)) {
            return false;
        }
        return this.methodParams == null || that.methodParams != null && this.methodParams.equals(that.methodParams);
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.setMethodSpec((String)s.readFields().get("actions", null));
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.putFields().put("actions", this.getActions());
        s.writeFields();
    }

    private void setMethodSpec(String actions2) {
        String mInterface = null;
        if (actions2 != null) {
            int i = actions2.indexOf(44);
            if (i < 0) {
                this.methodName = actions2;
            } else if (i > 0) {
                this.methodName = actions2.substring(0, i);
                int j = actions2.substring(i + 1).indexOf(44);
                if (j < 0) {
                    mInterface = actions2.substring(i + 1);
                } else {
                    if (j > 0) {
                        mInterface = actions2.substring(i + 1, i + j + 1);
                    }
                    this.methodParams = actions2.substring(i + j + 2);
                    if (this.methodParams.length() > 1 && this.methodParams.endsWith(",")) {
                        throw new IllegalArgumentException("illegal methodParam");
                    }
                }
            }
        }
        this.methodInterface = EJBMethodPermission.validateInterface(mInterface);
        this.actions = actions2;
    }

    private void setMethodSpec(String methodName, String methodInterface, String[] methodParams) {
        if (methodName != null && methodName.indexOf(44) >= 0) {
            throw new IllegalArgumentException("illegal methodName");
        }
        this.methodInterface = EJBMethodPermission.validateInterface(methodInterface);
        if (methodParams != null) {
            StringBuffer mParams = new StringBuffer(",");
            int i = 0;
            while (i < methodParams.length) {
                if (methodParams[i] == null || methodParams[i].indexOf(44) >= 0) {
                    throw new IllegalArgumentException("illegal methodParam");
                }
                if (i == 0) {
                    mParams.append(methodParams[i]);
                } else {
                    mParams.append("," + methodParams[i]);
                }
                ++i;
            }
            this.methodParams = mParams.toString();
        }
        this.methodName = methodName;
    }

    private void setMethodSpec(String methodInterface, Method method) {
        this.methodInterface = EJBMethodPermission.validateInterface(methodInterface);
        this.methodName = method.getName();
        Class<?>[] params = method.getParameterTypes();
        StringBuffer mParams = new StringBuffer(",");
        int i = 0;
        while (i < params.length) {
            if (i == 0) {
                mParams.append(params[i].getName());
            }
            mParams.append("," + params[i].getName());
            ++i;
        }
        this.methodParams = mParams.toString();
    }

    private static int validateInterface(String methodInterface) {
        int result = -1;
        if (methodInterface != null) {
            Integer i = (Integer)interfaceHash.get(methodInterface);
            if (i != null) {
                result = i;
            } else {
                throw new IllegalArgumentException("illegal methodInterface");
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        int i = 0;
        while (i < interfaceKeys.length) {
            interfaceHash.put(interfaceKeys[i], new Integer(i));
            ++i;
        }
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("actions", class$java$lang$String == null ? (class$java$lang$String = EJBMethodPermission.class$("java.lang.String")) : class$java$lang$String)};
    }
}

