/*
 * Decompiled with CFR 0.152.
 */
package javax.security.jacc;

import java.util.HashMap;

final class HttpMethodSpec {
    private static Object[] methodKeys = new Object[]{"DELETE", "GET", "HEAD", "OPTIONS", "POST", "PUT", "TRACE"};
    private static int mapSize = methodKeys.length;
    private static HashMap methodHash = new HashMap();
    private static String allActions;
    private static int allSet;
    private static String[] methodSetArray;

    private HttpMethodSpec() {
    }

    static int getMethodSet(String actions2) {
        if (actions2 == null || actions2.equals("")) {
            return allSet;
        }
        return HttpMethodSpec.makeMethodSet(actions2);
    }

    static int getMethodSet(String[] methods) {
        if (methods == null || methods.length == 0) {
            return allSet;
        }
        return HttpMethodSpec.makeMethodSet(methods);
    }

    private static int makeMethodSet(String actions2) {
        int i = 0;
        int mSet = 0;
        int comma = 0;
        while (comma >= 0 && i < actions2.length()) {
            comma = actions2.indexOf(",", i);
            if (comma != 0) {
                Integer bit = comma < 0 ? (Integer)methodHash.get(actions2.substring(i)) : (Integer)methodHash.get(actions2.substring(i, comma));
                if (bit == null) {
                    throw new IllegalArgumentException("illegal HTTP method");
                }
                mSet |= bit.intValue();
                i = comma + 1;
                continue;
            }
            throw new IllegalArgumentException("illegal HTTP method Spec");
        }
        return mSet;
    }

    private static int makeMethodSet(String[] methods) {
        int mSet = 0;
        int i = 0;
        while (i < methods.length) {
            Integer bit = (Integer)methodHash.get(methods[i]);
            if (bit == null) {
                throw new IllegalArgumentException("illegal HTTP method");
            }
            mSet |= bit.intValue();
            ++i;
        }
        return mSet;
    }

    static String getActions(int methodSet) {
        if (methodSet == allSet) {
            return null;
        }
        if (methodSetArray[methodSet] == null) {
            int bitValue = 1;
            StringBuffer actions2 = null;
            int i = 0;
            while (i < mapSize) {
                if ((methodSet & bitValue) == bitValue) {
                    if (actions2 == null) {
                        actions2 = new StringBuffer("");
                    } else {
                        actions2.append(",");
                    }
                    actions2.append((String)methodKeys[i]);
                }
                bitValue *= 2;
                ++i;
            }
            if (actions2 != null) {
                HttpMethodSpec.methodSetArray[methodSet] = actions2.toString();
            } else {
                throw new IllegalArgumentException("invalid methodSet");
            }
        }
        return methodSetArray[methodSet];
    }

    static boolean implies(int thisMethodSet, int thatMethodSet) {
        return (thisMethodSet & thatMethodSet) == thatMethodSet;
    }

    static {
        int b = 1;
        int i = 0;
        while (i < mapSize) {
            methodHash.put(methodKeys[i], new Integer(b));
            b <<= 1;
            ++i;
        }
        StringBuffer allBuffer = new StringBuffer();
        i = 0;
        while (i < mapSize) {
            if (i == 0) {
                allBuffer.append(methodKeys[i]);
            } else {
                allBuffer.append("," + methodKeys[i]);
            }
            ++i;
        }
        allActions = allBuffer.toString();
        allSet = 0;
        int i2 = 0;
        while (i2 < mapSize) {
            allSet <<= 1;
            ++allSet;
            ++i2;
        }
        methodSetArray = new String[allSet + 1];
    }
}

