/*
 * Decompiled with CFR 0.152.
 */
package javax.security.jacc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.Permission;
import javax.security.jacc.HttpMethodSpec;
import javax.security.jacc.URLPatternSpec;
import javax.servlet.http.HttpServletRequest;

public final class WebResourcePermission
extends Permission
implements Serializable {
    private transient int methodSet;
    private transient URLPatternSpec urlPatternSpec = null;
    private transient int hashCodeValue = 0;
    private static final long serialVersionUID = 1L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("actions", class$java$lang$String == null ? (class$java$lang$String = WebResourcePermission.class$("java.lang.String")) : class$java$lang$String)};
    static /* synthetic */ Class class$java$lang$String;

    public WebResourcePermission(String name, String actions2) {
        super(name);
        this.urlPatternSpec = new URLPatternSpec(name);
        this.methodSet = HttpMethodSpec.getMethodSet(actions2);
    }

    public WebResourcePermission(String urlPatternSpec, String[] HTTPMethods) {
        super(urlPatternSpec);
        this.urlPatternSpec = new URLPatternSpec(urlPatternSpec);
        this.methodSet = HttpMethodSpec.getMethodSet(HTTPMethods);
    }

    public WebResourcePermission(HttpServletRequest request) {
        super(request.getServletPath());
        this.urlPatternSpec = new URLPatternSpec(super.getName());
        this.methodSet = HttpMethodSpec.getMethodSet(request.getMethod());
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof WebResourcePermission)) {
            return false;
        }
        WebResourcePermission that = (WebResourcePermission)o;
        if (this.methodSet != that.methodSet) {
            return false;
        }
        return this.urlPatternSpec.equals(that.urlPatternSpec);
    }

    public String getActions() {
        return HttpMethodSpec.getActions(this.methodSet);
    }

    public int hashCode() {
        if (this.hashCodeValue == 0) {
            String hashInput = new String(this.urlPatternSpec.toString() + " " + this.methodSet);
            this.hashCodeValue = hashInput.hashCode();
        }
        return this.hashCodeValue;
    }

    public boolean implies(Permission permission) {
        if (permission == null || !(permission instanceof WebResourcePermission)) {
            return false;
        }
        WebResourcePermission that = (WebResourcePermission)permission;
        if (!HttpMethodSpec.implies(this.methodSet, that.methodSet)) {
            return false;
        }
        return this.urlPatternSpec.implies(that.urlPatternSpec);
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.methodSet = HttpMethodSpec.getMethodSet((String)s.readFields().get("actions", null));
        this.urlPatternSpec = new URLPatternSpec(super.getName());
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.putFields().put("actions", this.getActions());
        s.writeFields();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

